/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.plaf.UIResource;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.violetlib.aqua.AquaHighlighter;

public class AquaCaret
extends DefaultCaret
implements UIResource,
PropertyChangeListener {
    final boolean isMultiLineEditor;
    final JTextComponent c;
    boolean mFocused = false;
    private boolean shouldSelectAllOnFocus = true;

    public AquaCaret(Window inParentWindow, JTextComponent inComponent) {
        this.c = inComponent;
        this.isMultiLineEditor = this.c instanceof JTextArea || this.c instanceof JEditorPane;
        inComponent.addPropertyChangeListener(this);
    }

    @Override
    protected Highlighter.HighlightPainter getSelectionPainter() {
        return AquaHighlighter.getInstance();
    }

    @Override
    public void setVisible(boolean e) {
        if (e) {
            e = this.getDot() == this.getMark();
        }
        super.setVisible(e);
    }

    @Override
    protected void fireStateChanged() {
        if (this.mFocused) {
            this.setVisible(this.getComponent().isEditable());
        }
        super.fireStateChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("Frame.active".equals(propertyName)) {
            JTextComponent comp = (JTextComponent)evt.getSource();
            if (evt.getNewValue() == Boolean.TRUE) {
                this.setVisible(comp.hasFocus());
            } else {
                this.setVisible(false);
            }
            if (this.getDot() != this.getMark()) {
                comp.getUI().damageRange(comp, this.getDot(), this.getMark());
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        int mark;
        JTextComponent component = this.getComponent();
        if (!component.isEnabled() || !component.isEditable()) {
            super.focusGained(e);
            return;
        }
        this.mFocused = true;
        if (!this.shouldSelectAllOnFocus) {
            this.shouldSelectAllOnFocus = true;
            super.focusGained(e);
            return;
        }
        if (this.isMultiLineEditor) {
            super.focusGained(e);
            return;
        }
        int end = component.getDocument().getLength();
        int dot = this.getDot();
        if (dot == (mark = this.getMark())) {
            if (dot == 0) {
                component.setCaretPosition(end);
                component.moveCaretPosition(0);
            } else if (dot == end) {
                component.setCaretPosition(0);
                component.moveCaretPosition(end);
            }
        }
        super.focusGained(e);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.mFocused = false;
        this.shouldSelectAllOnFocus = true;
        if (this.isMultiLineEditor) {
            this.setVisible(false);
            this.c.repaint();
        } else {
            super.focusLost(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            super.mousePressed(e);
            this.shouldSelectAllOnFocus = false;
        }
    }
}

