/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.event.CellEditorListener;

public class AquaCellEditorPolicy {
    public static final String IS_COMBO_BOX_CELL_EDITOR_PROPERTY = "JComboBox.isTableCellEditor";
    public static final String IS_CELL_EDITOR_PROPERTY = "JComponent.isCellEditor";
    public static final String IS_CELL_CONTAINER_PROPERTY = "JComponent.isCellContainer";
    private static AquaCellEditorPolicy INSTANCE = new AquaCellEditorPolicy();

    public static AquaCellEditorPolicy getInstance() {
        return INSTANCE;
    }

    public static boolean isCellEditorProperty(String name) {
        return IS_COMBO_BOX_CELL_EDITOR_PROPERTY.equals(name) || IS_CELL_EDITOR_PROPERTY.equals(name);
    }

    public boolean isCellEditor(JComponent c) {
        Object isSpecifiedCellEditor = c.getClientProperty(IS_CELL_EDITOR_PROPERTY);
        if (Boolean.TRUE.equals(isSpecifiedCellEditor)) {
            return true;
        }
        if (Boolean.FALSE.equals(isSpecifiedCellEditor)) {
            return false;
        }
        if (Boolean.TRUE.equals(c.getClientProperty(IS_COMBO_BOX_CELL_EDITOR_PROPERTY))) {
            return true;
        }
        return this.isContainedInCellContainer(c);
    }

    protected boolean isContainedInCellContainer(Component c) {
        Container parent;
        while ((parent = c.getParent()) != null) {
            if (this.isCellContainer(parent)) {
                return true;
            }
            c = parent;
        }
        return false;
    }

    protected boolean isCellContainer(Container c) {
        Object isSpecifiedCellContainer;
        JComponent jc = c instanceof JComponent ? (JComponent)c : null;
        Object object = isSpecifiedCellContainer = jc != null ? jc.getClientProperty(IS_CELL_CONTAINER_PROPERTY) : null;
        if (Boolean.TRUE.equals(isSpecifiedCellContainer)) {
            return true;
        }
        if (c instanceof CellEditorListener && !Boolean.FALSE.equals(isSpecifiedCellContainer)) {
            return true;
        }
        return jc != null && Boolean.TRUE.equals(jc.getClientProperty(IS_COMBO_BOX_CELL_EDITOR_PROPERTY));
    }
}

