/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class AquaColorChooserDialog
extends JDialog {
    private Color initialColor;
    private JColorChooser chooserPane;

    public AquaColorChooserDialog(Dialog owner, String title, boolean modal, Component c, JColorChooser chooserPane) throws HeadlessException {
        super(owner, title, modal);
        this.initColorChooserDialog(c, chooserPane);
    }

    public AquaColorChooserDialog(Frame owner, String title, boolean modal, Component c, JColorChooser chooserPane) throws HeadlessException {
        super(owner, title, modal);
        this.initColorChooserDialog(c, chooserPane);
    }

    protected void initColorChooserDialog(Component c, JColorChooser chooserPane) {
        this.setResizable(false);
        this.chooserPane = chooserPane;
        Locale locale = this.getLocale();
        String resetString = UIManager.getString((Object)"ColorChooser.resetText", locale);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)chooserPane, "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        AbstractAction hideAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AquaColorChooserDialog.this.setVisible(false);
            }
        };
        KeyStroke cancelKeyStroke = KeyStroke.getKeyStroke(27, 0);
        InputMap inputMap = chooserPane.getInputMap(2);
        ActionMap actionMap = chooserPane.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(cancelKeyStroke, "cancel");
            actionMap.put("cancel", hideAction);
        }
        JButton resetButton = new JButton(resetString);
        resetButton.getAccessibleContext().setAccessibleDescription(resetString);
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AquaColorChooserDialog.this.reset();
            }
        });
        int mnemonic = AquaColorChooserDialog.getUIDefaultsInt("ColorChooser.resetMnemonic", locale, -1);
        if (mnemonic != -1) {
            resetButton.setMnemonic(mnemonic);
        }
        buttonPane.add(resetButton);
        contentPane.add((Component)buttonPane, "South");
        JRootPane jRootPane = this.getRootPane();
        jRootPane.putClientProperty("Window.style", "small");
        this.applyComponentOrientation((c == null ? jRootPane : c).getComponentOrientation());
        this.pack();
        this.setLocationRelativeTo(c);
    }

    @Override
    public void show() {
        this.initialColor = this.chooserPane.getColor();
        super.show();
    }

    public void reset() {
        this.chooserPane.setColor(this.initialColor);
    }

    private static int getUIDefaultsInt(Object key, Locale l, int defaultValue) {
        Object value = UIManager.get(key, l);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

