/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaButtonExtendedTypes;
import org.violetlib.aqua.AquaCellEditorPolicy;
import org.violetlib.aqua.AquaComboBoxUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaIcon;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.ImageIconUIResource;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.aqua.AbstractComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.ComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;

class AquaComboBoxButton
extends JButton {
    public static final String BUTTON_TYPE = "JButton.buttonType";
    public static final String LAYOUT_CONFIGURATION_PROPERTY = "Aqua.ComboBox.LayoutConfiguration";
    private static AquaCellEditorPolicy cellEditorPolicy = AquaCellEditorPolicy.getInstance();
    private static AquaComboBoxHierarchyListener hierarchyListener = new AquaComboBoxHierarchyListener();
    protected final JComboBox<Object> comboBox;
    protected final JList<?> list;
    protected final CellRendererPane rendererPane;
    protected final AquaComboBoxUI ui;
    protected final AquaButtonExtendedTypes.ColorDefaults colorDefaults;
    protected final AquaUIPainter painter = AquaPainting.create();
    protected boolean isPopDown;
    protected String style;
    protected AquaUIPainter.Size sizeVariant;
    protected boolean isRollover;
    protected ImageIcon lastTestedIcon;
    protected boolean lastTestedIconIsTemplate;

    protected AquaComboBoxButton(AquaComboBoxUI ui, JComboBox<Object> comboBox, CellRendererPane rendererPane, JList<?> list) {
        super("");
        this.putClientProperty(BUTTON_TYPE, "comboboxInternal");
        this.ui = ui;
        this.comboBox = comboBox;
        this.rendererPane = rendererPane;
        this.list = list;
        this.colorDefaults = new AquaButtonExtendedTypes.ColorDefaults();
        this.colorDefaults.disabledTextColor = UIManager.getColor("ComboBox.disabledForeground");
        this.colorDefaults.enabledTextColor = UIManager.getColor("ComboBox.foreground");
        this.setModel(new DefaultButtonModel(){

            @Override
            public void setArmed(boolean armed) {
                super.setArmed(this.isPressed() ? true : armed);
            }
        });
        this.setEnabled(comboBox.isEnabled());
        this.addMouseListener(new RolloverMouseListener());
        this.addHierarchyListener(hierarchyListener);
    }

    @Override
    public boolean isEnabled() {
        return this.comboBox == null ? true : this.comboBox.isEnabled();
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    public void configure(AquaUIPainter.Size size) {
        AbstractComboBoxLayoutConfiguration layoutConfiguration;
        Enum widget;
        Object o = this.comboBox.getClientProperty("JComboBox.isPopDown");
        this.isPopDown = Boolean.TRUE.equals(o);
        String style = null;
        Object o2 = this.comboBox.getClientProperty("JComboBox.style");
        if (o2 instanceof String) {
            style = (String)o2;
        } else {
            o2 = this.comboBox.getClientProperty("JComboBox.isSquare");
            if (Boolean.TRUE.equals(o2)) {
                style = "old_square";
            }
        }
        if ("textured".equals(style) && AquaComboBoxButton.isOnToolbar(this.comboBox)) {
            style = "textured-onToolbar";
        }
        this.style = style;
        if (size != null) {
            this.sizeVariant = size;
        }
        if (this.sizeVariant == null) {
            this.sizeVariant = AquaUIPainter.Size.REGULAR;
        }
        boolean isEditable = this.comboBox.isEditable();
        AquaUIPainter.UILayoutDirection ld = AquaUtils.getLayoutDirection(this.comboBox);
        if (isEditable) {
            widget = this.getComboBoxWidget();
            layoutConfiguration = new ComboBoxLayoutConfiguration((AquaUIPainter.ComboBoxWidget)widget, this.sizeVariant, ld);
            ComboBoxEditor editor = this.comboBox.getEditor();
            if (editor instanceof AquaComboBoxUI.AquaComboBoxEditor) {
                AquaComboBoxUI.AquaComboBoxEditor e = (AquaComboBoxUI.AquaComboBoxEditor)editor;
                e.configure((AquaUIPainter.ComboBoxWidget)widget);
            }
        } else {
            widget = this.getPopupButtonWidget();
            this.sizeVariant = this.canonicalize(this.sizeVariant, (AquaUIPainter.PopupButtonWidget)widget);
            layoutConfiguration = new PopupButtonLayoutConfiguration((AquaUIPainter.PopupButtonWidget)widget, this.sizeVariant, ld);
        }
        this.comboBox.putClientProperty(LAYOUT_CONFIGURATION_PROPERTY, layoutConfiguration);
        if (AquaUtilControlSize.isOKToInstallDefaultFont(this.comboBox)) {
            Font df = this.getDefaultFont(layoutConfiguration);
            AquaUtilControlSize.installDefaultFont(this.comboBox, df);
        }
        this.comboBox.revalidate();
        this.comboBox.repaint();
    }

    public AbstractComboBoxLayoutConfiguration getLayoutConfiguration() {
        return (AbstractComboBoxLayoutConfiguration)this.comboBox.getClientProperty(LAYOUT_CONFIGURATION_PROPERTY);
    }

    protected AquaUIPainter.Size canonicalize(AquaUIPainter.Size size, AquaUIPainter.PopupButtonWidget widget) {
        switch (widget) {
            case BUTTON_POP_UP_BEVEL: 
            case BUTTON_POP_DOWN_BEVEL: 
            case BUTTON_POP_UP_SQUARE: 
            case BUTTON_POP_DOWN_SQUARE: 
            case BUTTON_POP_UP_GRADIENT: 
            case BUTTON_POP_DOWN_GRADIENT: {
                return AquaUIPainter.Size.REGULAR;
            }
        }
        return size;
    }

    protected Font getDefaultFont(LayoutConfiguration g) {
        Font font = this.comboBox.getFont();
        Object widget = this.getWidget(g);
        if (widget != null) {
            return AquaButtonExtendedTypes.getFont(font, widget, this.sizeVariant);
        }
        return font;
    }

    protected Object getWidget(LayoutConfiguration g) {
        if (g instanceof ComboBoxLayoutConfiguration) {
            ComboBoxLayoutConfiguration bg = (ComboBoxLayoutConfiguration)g;
            return bg.getWidget();
        }
        if (g instanceof PopupButtonLayoutConfiguration) {
            PopupButtonLayoutConfiguration bg = (PopupButtonLayoutConfiguration)g;
            return bg.getPopupButtonWidget();
        }
        return null;
    }

    protected AquaUIPainter.ComboBoxWidget getComboBoxWidget() {
        if (cellEditorPolicy.isCellEditor(this.comboBox)) {
            return AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL;
        }
        if (this.style != null) {
            switch (this.style) {
                case "tableHeader": 
                case "cell": 
                case "borderless": {
                    return AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL;
                }
                case "textured": {
                    return AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED;
                }
                case "textured-onToolbar": {
                    return AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR;
                }
            }
        }
        if (AquaComboBoxButton.isOnToolbar(this.comboBox)) {
            return AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR;
        }
        return AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX;
    }

    protected AquaUIPainter.PopupButtonWidget getPopupButtonWidget() {
        if (cellEditorPolicy.isCellEditor(this.comboBox)) {
            return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL;
        }
        if (this.style != null) {
            switch (this.style) {
                case "tableHeader": 
                case "cell": 
                case "borderless": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL;
                }
                case "square": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_GRADIENT : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_GRADIENT;
                }
                case "old_square": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_SQUARE : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_SQUARE;
                }
                case "bevel": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_BEVEL : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_BEVEL;
                }
                case "roundRect": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_ROUND_RECT : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_ROUND_RECT;
                }
                case "recessed": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_RECESSED : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_RECESSED;
                }
                case "textured": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED;
                }
                case "textured-onToolbar": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED_TOOLBAR : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED_TOOLBAR;
                }
                case "gradient": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_GRADIENT : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_GRADIENT;
                }
            }
        }
        if (AquaComboBoxButton.isOnToolbar(this.comboBox)) {
            return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED_TOOLBAR : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED_TOOLBAR;
        }
        return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP;
    }

    public static boolean isOnToolbar(JComboBox b) {
        for (Container parent = b.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JToolBar)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Color getForeground() {
        return this.getForeground(false);
    }

    protected Color getForeground(boolean isIcon) {
        AquaUIPainter.State state;
        Object widget;
        AquaButtonExtendedTypes.WidgetInfo info;
        Color c;
        if (this.comboBox == null) {
            return super.getForeground();
        }
        Color existingColor = this.comboBox.getForeground();
        if ((existingColor == null || existingColor instanceof UIResource) && (c = (info = AquaButtonExtendedTypes.getWidgetInfo(widget = this.getWidget(this.getLayoutConfiguration()))).getForeground(state = this.getState(), AquaUIPainter.ButtonState.STATELESS, this.colorDefaults, false, isIcon)) != null) {
            return c;
        }
        return existingColor;
    }

    public Icon getIcon(Icon icon) {
        Color color;
        ImageIcon ii;
        AquaUIPainter.State st = this.getState();
        if (icon instanceof ImageIcon && this.isTemplateIconEnabled(ii = (ImageIcon)icon) && (color = this.getForeground(true)) != null) {
            Image im = ii.getImage();
            if ((im = AquaImageFactory.createImageFromTemplate(im, color)) != null) {
                return new ImageIconUIResource(im);
            }
        }
        if (st == AquaUIPainter.State.PRESSED) {
            return AquaIcon.createPressedDarkIcon(icon);
        }
        if (st == AquaUIPainter.State.DISABLED || st == AquaUIPainter.State.DISABLED_INACTIVE) {
            return AquaIcon.createDisabledLightIcon(icon);
        }
        return icon;
    }

    private boolean isTemplateIconEnabled(ImageIcon ii) {
        if (ii == this.lastTestedIcon) {
            return this.lastTestedIconIsTemplate;
        }
        this.lastTestedIcon = ii;
        this.lastTestedIconIsTemplate = AquaImageFactory.isTemplateImage(ii.getImage());
        return this.lastTestedIconIsTemplate;
    }

    protected AquaUIPainter.State getState() {
        boolean isActive = AquaFocusHandler.isActive(this.comboBox);
        if (!this.comboBox.isEnabled()) {
            return isActive ? AquaUIPainter.State.DISABLED : AquaUIPainter.State.DISABLED_INACTIVE;
        }
        if (!isActive) {
            return AquaUIPainter.State.INACTIVE;
        }
        ButtonModel model = this.getModel();
        if (model.isArmed() && model.isPressed()) {
            return AquaUIPainter.State.PRESSED;
        }
        if (this.isRollover) {
            return AquaUIPainter.State.ROLLOVER;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    @Override
    public void paintComponent(Graphics g) {
        Configuration bg;
        boolean isCell = AquaCellEditorPolicy.getInstance().isCellEditor(this.comboBox);
        boolean isEditable = this.comboBox.isEditable();
        if (isEditable && !isCell) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        if (height <= 0 || width <= 0) {
            return;
        }
        if (this.comboBox.isOpaque() || isCell && !isEditable && !(this.comboBox.getParent() instanceof CellRendererPane)) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
        }
        if ((bg = this.getConfiguration()) != null) {
            this.painter.configure(width, height);
            Painter p = this.painter.getPainter(bg);
            p.paint(g, 0.0f, 0.0f);
            if (!isEditable) {
                this.ui.paintValue(g);
            }
        }
    }

    public Configuration getConfiguration() {
        AquaUIPainter.State state = this.getState();
        AbstractComboBoxLayoutConfiguration g = this.getLayoutConfiguration();
        if (g instanceof PopupButtonLayoutConfiguration) {
            PopupButtonLayoutConfiguration bg = (PopupButtonLayoutConfiguration)g;
            return new PopupButtonConfiguration(bg, state);
        }
        if (g instanceof ComboBoxLayoutConfiguration) {
            ComboBoxLayoutConfiguration bg = (ComboBoxLayoutConfiguration)g;
            boolean isFocused = false;
            return new ComboBoxConfiguration(bg, state, isFocused);
        }
        return null;
    }

    private class RolloverMouseListener
    extends MouseAdapter {
        private RolloverMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            AquaComboBoxButton.this.isRollover = true;
            AquaComboBoxButton.this.comboBox.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AquaComboBoxButton.this.isRollover = false;
            AquaComboBoxButton.this.comboBox.repaint();
        }
    }

    static class AquaComboBoxHierarchyListener
    implements HierarchyListener {
        AquaComboBoxHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent ev) {
            Object o;
            if ((ev.getChangeFlags() & 1L) != 0L && (o = ev.getSource()) instanceof AquaComboBoxButton) {
                AquaComboBoxButton b = (AquaComboBoxButton)o;
                b.configure(null);
            }
        }
    }
}

