/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicComboPopup;
import org.violetlib.aqua.AquaCellEditorPolicy;
import org.violetlib.aqua.AquaComboBoxType;
import org.violetlib.aqua.AquaComboBoxUI;
import org.violetlib.aqua.AquaContextualPopup;
import org.violetlib.aqua.AquaExtendedPopup;
import org.violetlib.aqua.AquaUtils;

class AquaComboBoxPopup
extends BasicComboPopup
implements AquaExtendedPopup {
    protected static final String uiClassID = "ComboBoxPopupMenuUI";
    protected static AquaCellEditorPolicy cellEditorPolicy = AquaCellEditorPolicy.getInstance();
    protected PopupDisplayType currentDisplayType;
    protected static MouseWheelListener mouseWheelEventConsumer = new MouseWheelListener(){

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            e.consume();
        }
    };

    public AquaComboBoxPopup(JComboBox<Object> cBox) {
        super(cBox);
    }

    public AquaComboBoxType getComboBoxType() {
        return this.comboBox != null ? AquaComboBoxUI.getComboBoxType(this.comboBox) : null;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        this.setFocusable(false);
        this.updateContents(false);
        this.putClientProperty("apple.awt._windowFadeOut", new Integer(150));
    }

    public void updateContents(boolean remove) {
        if (this.list != null) {
            if (this.currentDisplayType == PopupDisplayType.EDITABLE_SCROLL) {
                this.remove(this.list);
                if (remove) {
                    this.remove(this.scroller);
                }
                this.add(this.scroller);
                this.scroller.setViewportView(this.list);
                this.list.setOpaque(true);
                this.setOpaque(true);
            } else {
                this.remove(this.scroller);
                if (remove) {
                    this.remove(this.list);
                }
                this.add(this.list);
                this.list.setOpaque(false);
                this.setOpaque(false);
            }
            this.list.removeMouseWheelListener(mouseWheelEventConsumer);
            if (this.currentDisplayType == PopupDisplayType.EDITABLE_NO_SCROLL) {
                this.list.addMouseWheelListener(mouseWheelEventConsumer);
            }
            if (this.currentDisplayType == PopupDisplayType.EDITABLE_SCROLL || this.currentDisplayType == PopupDisplayType.EDITABLE_NO_SCROLL) {
                this.list.setSelectionBackground(UIManager.getColor("ComboBox.selectionBackground"));
                this.list.setSelectionForeground(UIManager.getColor("ComboBox.selectionForeground"));
                this.list.setBackground(UIManager.getColor("ComboBox.background"));
                this.list.setForeground(UIManager.getColor("ComboBox.foreground"));
            } else {
                this.list.setSelectionBackground(UIManager.getColor("PopupMenu.selectionBackground"));
                this.list.setSelectionForeground(UIManager.getColor("PopupMenu.selectionForeground"));
                this.list.setBackground(UIManager.getColor("PopupMenu.background"));
                this.list.setForeground(UIManager.getColor("PopupMenu.foreground"));
            }
        }
        this.setBorder(null);
    }

    protected Dimension getBestPopupSizeForRowCount(int maxRowCount) {
        int currentElementCount = this.comboBox.getModel().getSize();
        int rowCount = this.currentDisplayType == PopupDisplayType.EDITABLE_SCROLL ? Math.min(maxRowCount, currentElementCount) : currentElementCount;
        Dimension popupSize = new Dimension();
        ListCellRenderer renderer = this.list.getCellRenderer();
        for (int i = 0; i < rowCount; ++i) {
            Object value = this.list.getModel().getElementAt(i);
            Component c = renderer.getListCellRendererComponent(this.list, value, i, false, false);
            Dimension prefSize = c.getPreferredSize();
            popupSize.height += prefSize.height;
            popupSize.width = Math.max(prefSize.width, popupSize.width);
        }
        popupSize.width += 10;
        return popupSize;
    }

    protected PopupDisplayType getPopupDisplayType() {
        if (this.comboBox.isEditable()) {
            return this.comboBox.getItemCount() > this.comboBox.getMaximumRowCount() ? PopupDisplayType.EDITABLE_SCROLL : PopupDisplayType.EDITABLE_NO_SCROLL;
        }
        return PopupDisplayType.CONTEXTUAL;
    }

    @Override
    public void show() {
        int startItemCount = this.comboBox.getItemCount();
        Rectangle popupBounds = this.adjustPopupAndGetBounds();
        if (popupBounds == null) {
            return;
        }
        this.comboBox.firePopupMenuWillBecomeVisible();
        this.show(this.comboBox, popupBounds.x, popupBounds.y);
        int afterShowItemCount = this.comboBox.getItemCount();
        if (afterShowItemCount == 0) {
            this.hide();
            return;
        }
        if (startItemCount != afterShowItemCount) {
            Rectangle newBounds = this.adjustPopupAndGetBounds();
            this.list.setSize(newBounds.width, newBounds.height);
            this.pack();
            Point newLoc = this.comboBox.getLocationOnScreen();
            this.setLocation(newLoc.x + newBounds.x, newLoc.y + newBounds.y);
        }
        this.list.requestFocusInWindow();
    }

    @Override
    protected JList<Object> createList() {
        return new AquaPopupMenuList(this.comboBox.getModel());
    }

    protected Rectangle adjustPopupAndGetBounds() {
        if (this.currentDisplayType != this.getPopupDisplayType()) {
            this.currentDisplayType = this.getPopupDisplayType();
            this.updateContents(true);
        }
        Dimension popupSize = this.getBestPopupSizeForRowCount(this.comboBox.getMaximumRowCount());
        Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
        Dimension realPopupSize = popupBounds.getSize();
        if (this.currentDisplayType == PopupDisplayType.EDITABLE_SCROLL) {
            this.scroller.setMaximumSize(realPopupSize);
            this.scroller.setPreferredSize(realPopupSize);
            this.scroller.setMinimumSize(realPopupSize);
            this.list.setMaximumSize(null);
            this.list.setPreferredSize(null);
            this.list.setMinimumSize(null);
        } else {
            this.list.setMaximumSize(realPopupSize);
            this.list.setPreferredSize(realPopupSize);
            this.list.setMinimumSize(realPopupSize);
        }
        this.list.invalidate();
        this.initializeListSelection();
        int selectedIndex = this.comboBox.getSelectedIndex();
        if (selectedIndex >= 0 && this.currentDisplayType == PopupDisplayType.EDITABLE_SCROLL) {
            Rectangle cellBounds = this.list.getCellBounds(selectedIndex, selectedIndex);
            this.scroller.getViewport().setViewPosition(cellBounds.getLocation());
        }
        return popupBounds;
    }

    protected void initializeListSelection() {
        AquaComboBoxUI ui = AquaUtils.getUI(this.comboBox, AquaComboBoxUI.class);
        if (ui != null && ui.updateListSelectionFromEditor()) {
            return;
        }
        int selectedIndex = this.comboBox.getSelectedIndex();
        if (selectedIndex == -1 || this.getComboBoxType() == AquaComboBoxType.PULL_DOWN_MENU_BUTTON) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(selectedIndex);
        }
    }

    @Override
    protected Rectangle computePopupBounds(int xx, int yy, int pw, int ph) {
        int selectedIndex;
        Point labelOffset;
        AquaComboBoxUI ui;
        Point p = AquaUtils.getScreenLocation(this.comboBox);
        Rectangle scrBounds = AquaUtils.getScreenBounds(p, this.comboBox);
        if (this.currentDisplayType == PopupDisplayType.EDITABLE_SCROLL) {
            pw += 15;
        }
        Insets comboBoxInsets = this.comboBox.getInsets();
        Dimension comboBoxSize = this.comboBox.getSize();
        int minWidth = comboBoxSize.width - (comboBoxInsets.left + comboBoxInsets.right);
        pw = Math.max(minWidth, pw);
        int x = p.x + comboBoxInsets.left;
        if (!AquaUtils.isLeftToRight(this.comboBox)) {
            x = p.x + comboBoxSize.width - comboBoxInsets.right - pw;
        }
        AquaComboBoxType type = this.getComboBoxType();
        int yOffset = this.getNominalPopupYOffset(type, comboBoxSize.height);
        int y = p.y + yOffset;
        int labelYOffset = 0;
        if (type == AquaComboBoxType.POP_UP_MENU_BUTTON && (ui = AquaUtils.getUI(this.comboBox, AquaComboBoxUI.class)) != null && (labelOffset = ui.getPopupButtonLabelOffset()) != null) {
            x += labelOffset.x;
            labelYOffset = labelOffset.y;
        }
        y += labelYOffset;
        this.putClientProperty("Aqua.PopupMenu.SelectedRegion", null);
        this.putClientProperty("Aqua.PopupMenu.SelectedRegionLocation", null);
        int popupHeight = 0;
        int roomBelow = scrBounds.y + scrBounds.height - p.y;
        if (roomBelow < 100) {
            int gap = 4;
            int ybottom = p.y - gap;
            y = Math.max(scrBounds.y, ybottom - ph);
            popupHeight = ybottom - y;
        }
        if (this.list != null && type == AquaComboBoxType.POP_UP_MENU_BUTTON && (selectedIndex = this.comboBox.getSelectedIndex()) >= 0) {
            Rectangle cellBounds = this.list.getCellBounds(selectedIndex, selectedIndex);
            cellBounds = new Rectangle(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height + 2);
            Point regionScreenLocation = new Point(x, p.y + labelYOffset);
            this.putClientProperty("Aqua.PopupMenu.SelectedRegion", cellBounds);
            this.putClientProperty("Aqua.PopupMenu.SelectedRegionLocation", regionScreenLocation);
        }
        if (this.list != null && type == AquaComboBoxType.PULL_DOWN_MENU_BUTTON) {
            this.list.clearSelection();
        }
        this.putClientProperty("Aqua.PopupMenu.ScreenBounds", new Rectangle(x, y, 0, popupHeight));
        return new Rectangle(x - p.x, y - p.y, pw, ph);
    }

    protected int getNominalPopupYOffset(AquaComboBoxType type, int comboBoxHeight) {
        int selectedIndex;
        boolean isTableCellEditor = cellEditorPolicy.isCellEditor(this.comboBox);
        switch (type) {
            case EDITABLE_COMBO_BOX: {
                return isTableCellEditor ? comboBoxHeight : comboBoxHeight + 4;
            }
            case PULL_DOWN_MENU_BUTTON: {
                return isTableCellEditor ? comboBoxHeight : comboBoxHeight;
            }
        }
        if (this.list != null && (selectedIndex = this.comboBox.getSelectedIndex()) >= 0) {
            Rectangle cellBounds = this.list.getCellBounds(selectedIndex, selectedIndex);
            Border border = AquaContextualPopup.getContextualMenuBorder();
            Insets s = border.getBorderInsets(this);
            return -(cellBounds.y + s.top);
        }
        return 0;
    }

    @Override
    public void startArrowScroll() {
        if (this.list != null) {
            this.list.clearSelection();
        }
    }

    @Override
    public void stopArrowScroll() {
        Point p;
        if (this.list != null && (p = MouseInfo.getPointerInfo().getLocation()) != null) {
            SwingUtilities.convertPointFromScreen(p, this.list);
            int index = this.list.locationToIndex(p);
            if (index >= 0 && this.list.getSelectedIndex() != index) {
                this.list.setSelectedIndex(index);
            }
        }
    }

    @Override
    public void updateSelection(MouseEvent e) {
        this.updateListBoxSelectionForEvent(e, false);
    }

    @Override
    protected void updateListBoxSelectionForEvent(MouseEvent e, boolean shouldScroll) {
        AquaComboBoxType type = this.getComboBoxType();
        if (type != AquaComboBoxType.EDITABLE_COMBO_BOX || e.getID() == 506) {
            super.updateListBoxSelectionForEvent(e, shouldScroll);
        }
    }

    protected class AquaPopupMenuList
    extends JList<Object> {
        public AquaPopupMenuList(ListModel<Object> dataModel) {
            super(dataModel);
            this.setOpaque(false);
        }

        @Override
        public void processMouseEvent(MouseEvent e) {
            if (e.isMetaDown()) {
                e = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers() ^ 4, e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), 0);
            }
            super.processMouseEvent(e);
        }
    }

    public static enum PopupDisplayType {
        EDITABLE_NO_SCROLL,
        EDITABLE_SCROLL,
        CONTEXTUAL;

    }
}

