/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.violetlib.aqua.AquaComboBoxUI;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;

public class AquaComboBoxRendererInternal<E>
extends JLabel
implements ListCellRenderer<E> {
    final JComboBox<?> fComboBox;
    protected boolean fSelected;
    protected boolean fChecked;
    protected boolean fInList;
    protected boolean fEditable;
    protected boolean fDrawCheckedItem = true;
    protected static int checkMarkLeftInset = 5;
    protected static int checkMarkTopInset = 3;
    protected static int menuLabelLeftInset = 21;
    protected static int buttonLabelLeftInset = 0;
    protected static int menuLabelTopInset = 0;
    protected static int menuLabelBottomInset = 1;
    protected static int buttonLabelTopInset = 0;
    protected static int buttonLabelBottomInset = 0;
    protected static int buttonLabelRightInset = 0;
    protected static int miniMenuLabelTopInset = 1;
    protected static int miniMenuLabelBottomInset = 0;

    public AquaComboBoxRendererInternal(JComboBox<?> comboBox) {
        this.fComboBox = comboBox;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size;
        String text = this.getText();
        if (text == null || text.isEmpty()) {
            this.setText(" ");
            size = super.getPreferredSize();
            this.setText("");
        } else {
            size = super.getPreferredSize();
        }
        return size;
    }

    @Override
    protected void paintBorder(Graphics g) {
    }

    @Override
    public int getBaseline(int width, int height) {
        return super.getBaseline(width, height) - 1;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends E> list, E value, int index, boolean isSelected, boolean cellHasFocus) {
        this.fInList = index >= 0;
        this.fSelected = isSelected;
        if (index < 0) {
            index = this.fComboBox.getSelectedIndex();
        }
        if (index >= 0) {
            Object item = this.fComboBox.getItemAt(index);
            this.fChecked = this.fInList && item != null && item.equals(this.fComboBox.getSelectedItem()) && !this.isPullDown(this.fComboBox);
        } else {
            this.fChecked = false;
        }
        this.fEditable = this.fComboBox.isEditable();
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setFont(list.getFont());
        if (value instanceof Icon) {
            this.setIcon((Icon)value);
            this.setText(null);
        } else {
            this.setIcon(null);
            this.setText(value == null ? " " : value.toString());
        }
        return this;
    }

    @Override
    public Insets getInsets(Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        AquaUIPainter.Size size = this.getComboBoxSizeVariant();
        if (this.fInList && !this.fEditable) {
            insets.top = size == AquaUIPainter.Size.MINI ? miniMenuLabelTopInset : menuLabelTopInset;
            insets.bottom = size == AquaUIPainter.Size.MINI ? miniMenuLabelBottomInset : menuLabelBottomInset;
            insets.right = 5;
            insets.left = menuLabelLeftInset;
        } else {
            insets.top = buttonLabelTopInset;
            insets.bottom = buttonLabelBottomInset;
            insets.right = buttonLabelRightInset;
            insets.left = buttonLabelLeftInset;
        }
        return insets;
    }

    protected void setDrawCheckedItem(boolean drawCheckedItem) {
        this.fDrawCheckedItem = drawCheckedItem;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.fInList) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.fChecked && !this.fEditable && this.fDrawCheckedItem) {
                AquaUIPainter.Size size = this.getComboBoxSizeVariant();
                Icon checkMark = AquaImageFactory.getPopupMenuItemCheckIcon(size);
                if (this.fSelected && checkMark instanceof AquaImageFactory.InvertableImageIcon) {
                    AquaImageFactory.InvertableImageIcon ic = (AquaImageFactory.InvertableImageIcon)checkMark;
                    checkMark = ic.getInvertedIcon();
                }
                int height = this.getHeight();
                int left = checkMarkLeftInset;
                int top = Math.max(checkMarkTopInset, (height - checkMark.getIconHeight() - 1) / 2);
                checkMark.paintIcon(this.fComboBox, g, left, top);
            }
        }
        super.paintComponent(g);
    }

    protected AquaUIPainter.Size getComboBoxSizeVariant() {
        AquaComboBoxUI ui = AquaUtils.getUI(this.fComboBox, AquaComboBoxUI.class);
        if (ui != null) {
            return ui.getSizeVariant();
        }
        return AquaUIPainter.Size.REGULAR;
    }

    protected boolean isPullDown(JComboBox comboBox) {
        AquaComboBoxUI ui;
        if (!comboBox.isEditable() && (ui = AquaUtils.getUI(comboBox, AquaComboBoxUI.class)) != null) {
            PopupButtonLayoutConfiguration g = (PopupButtonLayoutConfiguration)ui.getLayoutConfiguration();
            return g != null && !g.isPopUp();
        }
        return false;
    }
}

