/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.RoundRectangle2D;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import org.violetlib.aqua.AquaCellEditorPolicy;
import org.violetlib.aqua.AquaComboBoxButton;
import org.violetlib.aqua.AquaComboBoxPopup;
import org.violetlib.aqua.AquaComboBoxRenderer;
import org.violetlib.aqua.AquaComboBoxType;
import org.violetlib.aqua.AquaFullKeyboardFocusableHandler;
import org.violetlib.aqua.AquaListUI;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaTextFieldUI;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.ClientPropertyApplicator;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.OptionallyFocusableComponentHandler;
import org.violetlib.geom.ExpandableOutline;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AbstractComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.ComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;

public class AquaComboBoxUI
extends BasicComboBoxUI
implements AquaUtilControlSize.Sizeable,
FocusRingOutlineProvider {
    public static final String POPDOWN_CLIENT_PROPERTY_KEY = "JComboBox.isPopDown";
    public static final String ISSQUARE_CLIENT_PROPERTY_KEY = "JComboBox.isSquare";
    public static final String STYLE_CLIENT_PROPERTY_KEY = "JComboBox.style";
    public static final String TITLE_CLIENT_PROPERTY_KEY = "JComboBox.title";
    private static AquaUIPainter painter = AquaPainting.create();
    private static AquaCellEditorPolicy cellEditorPolicy = AquaCellEditorPolicy.getInstance();
    private static OptionallyFocusableComponentHandler focusHandler = new MyOptionalFocusHandler();
    private int oldMaximumRowCount;
    protected AquaUIPainter.Size sizeVariant;
    protected Dimension cachedPreferredSize = new Dimension(0, 0);
    protected AquaComboBoxButton arrowButton;
    protected HierarchyListener hierarchyListener;
    private Action highlightNextAction = new ComboBoxAction(){

        @Override
        public void performComboBoxAction(AquaComboBoxUI ui) {
            int si = AquaComboBoxUI.this.listBox.getSelectedIndex();
            if (si < AquaComboBoxUI.this.comboBox.getModel().getSize() - 1) {
                AquaComboBoxUI.this.listBox.setSelectedIndex(si + 1);
                AquaComboBoxUI.this.listBox.ensureIndexIsVisible(si + 1);
            }
            AquaComboBoxUI.this.comboBox.repaint();
        }
    };
    private Action highlightPreviousAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(AquaComboBoxUI ui) {
            int si = AquaComboBoxUI.this.listBox.getSelectedIndex();
            if (si > 0) {
                AquaComboBoxUI.this.listBox.setSelectedIndex(si - 1);
                AquaComboBoxUI.this.listBox.ensureIndexIsVisible(si - 1);
            }
            AquaComboBoxUI.this.comboBox.repaint();
        }
    };
    private Action highlightFirstAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(AquaComboBoxUI ui) {
            AquaComboBoxUI.this.listBox.setSelectedIndex(0);
            AquaComboBoxUI.this.listBox.ensureIndexIsVisible(0);
        }
    };
    private Action highlightLastAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(AquaComboBoxUI ui) {
            int size = AquaComboBoxUI.this.listBox.getModel().getSize();
            AquaComboBoxUI.this.listBox.setSelectedIndex(size - 1);
            AquaComboBoxUI.this.listBox.ensureIndexIsVisible(size - 1);
        }
    };
    private Action highlightPageUpAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(AquaComboBoxUI ui) {
            int first;
            int current = AquaComboBoxUI.this.listBox.getSelectedIndex();
            if (current != (first = AquaComboBoxUI.this.listBox.getFirstVisibleIndex())) {
                AquaComboBoxUI.this.listBox.setSelectedIndex(first);
                return;
            }
            int page = ((AquaComboBoxUI)AquaComboBoxUI.this).listBox.getVisibleRect().height / ((AquaComboBoxUI)AquaComboBoxUI.this).listBox.getCellBounds((int)0, (int)0).height;
            int target = first - page;
            if (target < 0) {
                target = 0;
            }
            AquaComboBoxUI.this.listBox.ensureIndexIsVisible(target);
            AquaComboBoxUI.this.listBox.setSelectedIndex(target);
        }
    };
    private Action highlightPageDownAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(AquaComboBoxUI ui) {
            int last;
            int current = AquaComboBoxUI.this.listBox.getSelectedIndex();
            if (current != (last = AquaComboBoxUI.this.listBox.getLastVisibleIndex())) {
                AquaComboBoxUI.this.listBox.setSelectedIndex(last);
                return;
            }
            int page = ((AquaComboBoxUI)AquaComboBoxUI.this).listBox.getVisibleRect().height / ((AquaComboBoxUI)AquaComboBoxUI.this).listBox.getCellBounds((int)0, (int)0).height;
            int target = last + page;
            int end = AquaComboBoxUI.this.listBox.getModel().getSize() - 1;
            if (target > end) {
                target = end;
            }
            AquaComboBoxUI.this.listBox.ensureIndexIsVisible(target);
            AquaComboBoxUI.this.listBox.setSelectedIndex(target);
        }
    };
    private final Action triggerSelectionAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AquaComboBoxUI.triggerSelectionEvent((JComboBox)e.getSource(), e);
        }

        @Override
        public boolean isEnabled() {
            return AquaComboBoxUI.this.comboBox.isPopupVisible() && super.isEnabled();
        }
    };
    private static final Action toggleSelectionAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            if (!comboBox.isEnabled()) {
                return;
            }
            if (comboBox.isEditable()) {
                return;
            }
            AquaComboBoxUI aquaUi = (AquaComboBoxUI)comboBox.getUI();
            if (comboBox.isPopupVisible()) {
                comboBox.setSelectedIndex(aquaUi.getPopup().getList().getSelectedIndex());
                comboBox.setPopupVisible(false);
                return;
            }
            comboBox.setPopupVisible(true);
        }
    };
    private final Action hideAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            comboBox.firePopupMenuCanceled();
            comboBox.setPopupVisible(false);
        }

        @Override
        public boolean isEnabled() {
            return AquaComboBoxUI.this.comboBox.isPopupVisible() && super.isEnabled();
        }
    };
    static final AquaUtils.RecyclableSingleton<ClientPropertyApplicator<JComboBox<?>, AquaComboBoxUI>> APPLICATOR = new AquaUtils.RecyclableSingleton<ClientPropertyApplicator<JComboBox<?>, AquaComboBoxUI>>(){

        @Override
        protected ClientPropertyApplicator<JComboBox<?>, AquaComboBoxUI> getInstance() {
            return new ClientPropertyApplicator<JComboBox<?>, AquaComboBoxUI>(new ClientPropertyApplicator.Property[]{new ClientPropertyApplicator.Property<AquaComboBoxUI>("Frame.active"){

                @Override
                public void applyProperty(AquaComboBoxUI target, Object value) {
                    if (Boolean.FALSE.equals(value) && target.comboBox != null) {
                        target.comboBox.hidePopup();
                    }
                    if (target.listBox != null) {
                        target.listBox.repaint();
                    }
                    if (target.comboBox != null) {
                        target.comboBox.repaint();
                    }
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>("editable"){

                @Override
                public void applyProperty(AquaComboBoxUI target, Object value) {
                    target.configure(null);
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>("background"){

                @Override
                public void applyProperty(AquaComboBoxUI target, Object value) {
                    Color color = (Color)value;
                    if (target.arrowButton != null) {
                        target.arrowButton.setBackground(color);
                    }
                    if (target.listBox != null) {
                        target.listBox.setBackground(color);
                    }
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>("foreground"){

                @Override
                public void applyProperty(AquaComboBoxUI target, Object value) {
                    Color color = (Color)value;
                    if (target.arrowButton != null) {
                        target.arrowButton.setForeground(color);
                    }
                    if (target.listBox != null) {
                        target.listBox.setForeground(color);
                    }
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>(AquaComboBoxUI.POPDOWN_CLIENT_PROPERTY_KEY){

                @Override
                public void applyProperty(AquaComboBoxUI target, Object value) {
                    target.configure(null);
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>(AquaComboBoxUI.ISSQUARE_CLIENT_PROPERTY_KEY){

                @Override
                public void applyProperty(AquaComboBoxUI target, Object value) {
                    target.configure(null);
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>(AquaComboBoxUI.STYLE_CLIENT_PROPERTY_KEY){

                @Override
                public void applyProperty(AquaComboBoxUI target, Object value) {
                    target.configure(null);
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>(AquaComboBoxUI.TITLE_CLIENT_PROPERTY_KEY){

                @Override
                public void applyProperty(AquaComboBoxUI target, Object value) {
                    AquaComboBoxType type;
                    if (target.comboBox != null && (type = AquaComboBoxUI.getComboBoxType(target.comboBox)) == AquaComboBoxType.PULL_DOWN_MENU_BUTTON) {
                        target.comboBox.setPrototypeDisplayValue(value);
                        target.comboBox.repaint();
                    }
                }
            }}){

                @Override
                public AquaComboBoxUI convertJComponentToTarget(JComboBox<?> combo) {
                    ComboBoxUI comboUI = combo.getUI();
                    if (comboUI instanceof AquaComboBoxUI) {
                        return (AquaComboBoxUI)comboUI;
                    }
                    return null;
                }
            };
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new AquaComboBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        LookAndFeel.installProperty(c, "opaque", false);
        this.oldMaximumRowCount = this.comboBox.getMaximumRowCount();
        int maximumRows = UIManager.getInt("ComboBox.maximumRowCount");
        if (maximumRows > 0) {
            this.comboBox.setMaximumRowCount(maximumRows);
        }
        this.comboBox.setRequestFocusEnabled(false);
        this.configure(null);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.comboBox.setMaximumRowCount(this.oldMaximumRowCount);
        super.uninstallUI(c);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        AquaUtilControlSize.addSizePropertyListener(this.comboBox);
        this.comboBox.putClientProperty("Aqua.optionalFocusabilityHandler", focusHandler);
        AquaFullKeyboardFocusableHandler.addListener(this.comboBox);
        this.hierarchyListener = new MyHierarchyListener();
        this.comboBox.addHierarchyListener(this.hierarchyListener);
    }

    @Override
    protected void uninstallListeners() {
        this.comboBox.removeHierarchyListener(this.hierarchyListener);
        this.hierarchyListener = null;
        AquaUtilControlSize.removeSizePropertyListener(this.comboBox);
        AquaFullKeyboardFocusableHandler.removeListener(this.comboBox);
        super.uninstallListeners();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        AquaComboBoxUI.getApplicator().attachAndApplyClientProperties(this.comboBox);
    }

    @Override
    protected void uninstallComponents() {
        AquaComboBoxUI.getApplicator().removeFrom(this.comboBox);
        super.uninstallComponents();
    }

    @Override
    protected ItemListener createItemListener() {
        return new ItemListener(){
            long lastBlink = 0L;

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (!AquaComboBoxUI.this.popup.isVisible()) {
                    return;
                }
                long now = System.currentTimeMillis();
                if (now - 1000L < this.lastBlink) {
                    return;
                }
                this.lastBlink = now;
                JList<Object> itemList = AquaComboBoxUI.this.popup.getList();
                ListUI listUI = itemList.getUI();
                if (!(listUI instanceof AquaListUI)) {
                    return;
                }
                final AquaListUI aquaListUI = (AquaListUI)listUI;
                final int selectedIndex = AquaComboBoxUI.this.comboBox.getSelectedIndex();
                ListModel<Object> dataModel = itemList.getModel();
                if (dataModel == null) {
                    return;
                }
                final Object value = dataModel.getElementAt(selectedIndex);
                AquaUtils.blinkMenu(new AquaUtils.Selectable(){

                    @Override
                    public void paintSelected(boolean selected) {
                        aquaListUI.repaintCell(value, selectedIndex, selected);
                    }
                });
            }
        };
    }

    @Override
    public void addEditor() {
        super.addEditor();
        this.isMinimumSizeDirty = true;
    }

    @Override
    public void removeEditor() {
        super.removeEditor();
        this.isMinimumSizeDirty = true;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean editable = this.comboBox.isEditable();
        boolean isCell = cellEditorPolicy.isCellEditor(this.comboBox);
        if (isCell) {
            Component ed = this.comboBox.getEditor().getEditorComponent();
            ed.setForeground(c.getForeground());
        } else if (editable && this.arrowButton != null) {
            Configuration bg = this.arrowButton.getConfiguration();
            painter.configure(c.getWidth(), c.getHeight());
            painter.getPainter(bg).paint(g, 0.0f, 0.0f);
        }
    }

    protected AbstractComboBoxLayoutConfiguration getLayoutConfiguration() {
        return this.arrowButton != null ? this.arrowButton.getLayoutConfiguration() : null;
    }

    @Override
    public Shape getFocusRingOutline(JComponent c) {
        AbstractComboBoxLayoutConfiguration g = this.getLayoutConfiguration();
        if (g != null) {
            painter.configure(c.getWidth(), c.getHeight());
            return painter.getOutline(g);
        }
        return null;
    }

    public void paintValue(Graphics g) {
        Rectangle bounds;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        Object displayedItem = null;
        AquaComboBoxType type = AquaComboBoxUI.getComboBoxType(this.comboBox);
        if (type == AquaComboBoxType.PULL_DOWN_MENU_BUTTON) {
            Object value = this.comboBox.getClientProperty(TITLE_CLIENT_PROPERTY_KEY);
            if (value != null) {
                if (value instanceof Icon) {
                    value = this.arrowButton.getIcon((Icon)value);
                }
                displayedItem = value;
            }
        } else {
            displayedItem = this.comboBox.getSelectedItem();
        }
        int top = 0;
        int left = 0;
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        AbstractComboBoxLayoutConfiguration bg = this.getLayoutConfiguration();
        if (bg != null && (bounds = this.getContentBounds(bg)) != null) {
            left = bounds.x;
            top = bounds.y;
            width = bounds.width;
            height = bounds.height;
        }
        if (this.padding != null) {
            left += this.padding.left;
            top += this.padding.top;
            width -= this.padding.left;
            height -= this.padding.top;
        }
        Component c = renderer.getListCellRendererComponent(this.listBox, displayedItem, -1, false, false);
        c.setFont(this.currentValuePane.getFont());
        Color foreground = this.arrowButton.getForeground();
        c.setForeground(foreground);
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        Color background = c.getBackground();
        c.setBackground(new Color(0, 0, 0, 0));
        this.currentValuePane.paintComponent(g, c, this.comboBox, left, top, width, height, shouldValidate);
        c.setBackground(background);
    }

    protected Rectangle getContentBounds(LayoutConfiguration g) {
        painter.configure(this.comboBox.getWidth(), this.comboBox.getHeight());
        if (g instanceof ComboBoxLayoutConfiguration) {
            return AquaUtils.toMinimumRectangle(painter.getComboBoxEditorBounds((ComboBoxLayoutConfiguration)g));
        }
        if (g instanceof PopupButtonLayoutConfiguration) {
            return AquaUtils.toMinimumRectangle(painter.getPopupButtonContentBounds((PopupButtonLayoutConfiguration)g));
        }
        return null;
    }

    protected Insetter getContentInsets(LayoutConfiguration g) {
        if (g instanceof ComboBoxLayoutConfiguration) {
            return painter.getLayoutInfo().getComboBoxEditorInsets((ComboBoxLayoutConfiguration)g);
        }
        if (g instanceof PopupButtonLayoutConfiguration) {
            return painter.getLayoutInfo().getPopupButtonContentInsets((PopupButtonLayoutConfiguration)g);
        }
        return null;
    }

    @Override
    protected ListCellRenderer<Object> createRenderer() {
        return new AquaComboBoxRenderer(this.comboBox);
    }

    @Override
    protected ComboPopup createPopup() {
        return new AquaComboBoxPopup(this.comboBox);
    }

    @Override
    protected JButton createArrowButton() {
        this.arrowButton = new AquaComboBoxButton(this, this.comboBox, this.currentValuePane, this.listBox);
        return this.arrowButton;
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new AquaComboBoxEditor();
    }

    @Override
    protected void configureEditor() {
        super.configureEditor();
        this.comboBox.setFocusable(true);
        if (this.editor instanceof JTextField && !(this.editor instanceof AquaCustomComboTextField)) {
            JTextField tf = (JTextField)this.editor;
            tf.setUI(new AquaComboBoxEditorUI());
            tf.setBorder(null);
        }
    }

    @Override
    protected void unconfigureEditor() {
        super.unconfigureEditor();
        if (!this.comboBox.isEditable()) {
            this.comboBox.setFocusable(OSXSystemProperties.isFullKeyboardAccessEnabled());
        }
    }

    public boolean updateListSelectionFromEditor() {
        if (this.editor instanceof JTextField) {
            JTextField tf = (JTextField)this.editor;
            this.updateListSelectionFromEditor(tf);
            return true;
        }
        return false;
    }

    protected void updateListSelectionFromEditor(JTextField editor) {
        String text = editor.getText();
        ListModel model = this.listBox.getModel();
        int items = model.getSize();
        for (int i = 0; i < items; ++i) {
            String asString;
            Object element = model.getElementAt(i);
            if (element == null || (asString = element.toString()) == null || !asString.equals(text)) continue;
            this.popup.getList().setSelectedIndex(i);
            return;
        }
        this.popup.getList().clearSelection();
    }

    @Override
    protected FocusListener createFocusListener() {
        return new BasicComboBoxUI.FocusHandler(){

            @Override
            public void focusLost(FocusEvent e) {
                AquaComboBoxUI.this.hasFocus = false;
                if (!e.isTemporary()) {
                    AquaComboBoxUI.this.setPopupVisible(AquaComboBoxUI.this.comboBox, false);
                }
                AquaComboBoxUI.this.comboBox.repaint();
                AccessibleContext ac = AquaComboBoxUI.this.comboBox.getAccessibleContext();
                if (ac != null) {
                    ac.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                }
            }
        };
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMapUIResource actionMap = new ActionMapUIResource();
        actionMap.put("aquaSelectNext", this.highlightNextAction);
        actionMap.put("aquaSelectPrevious", this.highlightPreviousAction);
        actionMap.put("enterPressed", this.triggerSelectionAction);
        actionMap.put("aquaSpacePressed", toggleSelectionAction);
        actionMap.put("aquaSelectHome", this.highlightFirstAction);
        actionMap.put("aquaSelectEnd", this.highlightLastAction);
        actionMap.put("aquaSelectPageUp", this.highlightPageUpAction);
        actionMap.put("aquaSelectPageDown", this.highlightPageDownAction);
        actionMap.put("aquaHidePopup", this.hideAction);
        SwingUtilities.replaceUIActionMap(this.comboBox, actionMap);
    }

    public ComboPopup getPopup() {
        return this.popup;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new AquaComboBoxLayoutManager();
    }

    public static AquaComboBoxType getComboBoxType(JComboBox<?> c) {
        if (c.isEditable()) {
            return AquaComboBoxType.EDITABLE_COMBO_BOX;
        }
        if (Boolean.TRUE.equals(c.getClientProperty(POPDOWN_CLIENT_PROPERTY_KEY))) {
            return AquaComboBoxType.PULL_DOWN_MENU_BUTTON;
        }
        return AquaComboBoxType.POP_UP_MENU_BUTTON;
    }

    protected static void triggerSelectionEvent(JComboBox<?> comboBox, ActionEvent e) {
        if (!comboBox.isEnabled()) {
            return;
        }
        AquaComboBoxUI aquaUi = (AquaComboBoxUI)comboBox.getUI();
        if (aquaUi.getPopup().getList().getSelectedIndex() < 0) {
            comboBox.setPopupVisible(false);
        }
        if (cellEditorPolicy.isCellEditor(comboBox)) {
            comboBox.setSelectedItem(comboBox.getSelectedItem());
            return;
        }
        if (comboBox.isPopupVisible()) {
            comboBox.setSelectedIndex(aquaUi.getPopup().getList().getSelectedIndex());
            comboBox.setPopupVisible(false);
            return;
        }
        JRootPane root = SwingUtilities.getRootPane(comboBox);
        if (root == null) {
            return;
        }
        InputMap im = root.getInputMap(2);
        ActionMap am = root.getActionMap();
        if (im == null || am == null) {
            return;
        }
        Object obj = im.get(KeyStroke.getKeyStroke(10, 0));
        if (obj == null) {
            return;
        }
        Action action = am.get(obj);
        if (action == null) {
            return;
        }
        action.actionPerformed(new ActionEvent(root, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
    }

    @Override
    public void applySizeFor(JComponent c, AquaUIPainter.Size size, boolean isDefaultSize) {
        this.sizeVariant = size;
        if (isDefaultSize) {
            size = this.determineDefaultSize(size);
        }
        this.configure(size);
    }

    public AquaUIPainter.Size getSizeVariant() {
        AbstractComboBoxLayoutConfiguration g;
        if (this.sizeVariant == null) {
            return AquaUIPainter.Size.REGULAR;
        }
        if (this.sizeVariant != AquaUIPainter.Size.REGULAR && (g = this.getLayoutConfiguration()) != null) {
            AquaUIPainter.PopupButtonWidget w;
            AquaUIPainter.Size size = g.getSize();
            if (size == AquaUIPainter.Size.MINI && ((w = this.getPopupButtonWidget()) == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_SQUARE || w == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_SQUARE || w == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL || w == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL)) {
                size = AquaUIPainter.Size.SMALL;
            }
            return size;
        }
        return this.sizeVariant;
    }

    protected AquaUIPainter.Size determineDefaultSize(AquaUIPainter.Size size) {
        if (size == AquaUIPainter.Size.REGULAR && cellEditorPolicy.isCellEditor(this.comboBox) && this.comboBox.getHeight() < 16) {
            return AquaUIPainter.Size.SMALL;
        }
        return size;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (this.isMinimumSizeDirty) {
            this.calculateLayoutSizes();
        }
        return new Dimension(this.cachedMinimumSize);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.isMinimumSizeDirty) {
            this.calculateLayoutSizes();
        }
        return new Dimension(this.cachedPreferredSize);
    }

    protected void calculateLayoutSizes() {
        int fixedRenderingHeight;
        AbstractComboBoxLayoutConfiguration g = this.getLayoutConfiguration();
        LayoutInfo layoutInfo = painter.getLayoutInfo().getLayoutInfo(g);
        int minimumHeight = fixedRenderingHeight = (int)layoutInfo.getFixedVisualHeight();
        int preferredHeight = fixedRenderingHeight;
        Dimension size = null;
        if (this.arrowButton != null) {
            Insetter s;
            if (g.isCell()) {
                preferredHeight += 6;
            }
            if ((s = this.getContentInsets(g)) != null) {
                Dimension displaySize = this.getDisplaySize();
                size = s.expand(displaySize);
            }
        }
        if (size == null) {
            boolean editable = this.comboBox.isEditable();
            if (editable && this.arrowButton != null && this.editor != null) {
                size = super.getMinimumSize(this.comboBox);
                Insets margin = this.arrowButton.getMargin();
                size.height += margin.top + margin.bottom;
            } else {
                size = super.getMinimumSize(this.comboBox);
            }
        }
        if (size.height > minimumHeight) {
            minimumHeight = size.height;
        }
        if (size.height > preferredHeight) {
            preferredHeight = size.height;
        }
        this.cachedMinimumSize.setSize(size.width, minimumHeight);
        this.cachedPreferredSize.setSize(size.width, preferredHeight);
        this.isMinimumSizeDirty = false;
    }

    @Override
    protected Dimension getDefaultSize() {
        DefaultListCellRenderer r = this.comboBox.getRenderer();
        if (r == null) {
            r = new DefaultListCellRenderer();
        }
        Dimension d = this.getSizeForComponent(r.getListCellRendererComponent(this.listBox, " ", -1, false, false));
        return new Dimension(d.width, d.height);
    }

    protected void configure(AquaUIPainter.Size size) {
        if (this.arrowButton != null) {
            this.arrowButton.configure(size);
        } else if (this.comboBox != null) {
            this.comboBox.repaint();
        }
    }

    public Point getPopupButtonLabelOffset() {
        int labelXOffset = 0;
        int labelYOffset = 0;
        AquaComboBoxType type = AquaComboBoxUI.getComboBoxType(this.comboBox);
        if (type == AquaComboBoxType.POP_UP_MENU_BUTTON) {
            labelXOffset -= 8;
            labelYOffset = 1;
            AquaUIPainter.PopupButtonWidget w = this.getPopupButtonWidget();
            if (w != AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP) {
                labelXOffset -= 2;
                labelYOffset = 2;
            }
        }
        return labelXOffset != 0 || labelYOffset != 0 ? new Point(labelXOffset, labelYOffset) : null;
    }

    public AquaUIPainter.PopupButtonWidget getPopupButtonWidget() {
        AbstractComboBoxLayoutConfiguration g = this.getLayoutConfiguration();
        if (g instanceof PopupButtonLayoutConfiguration) {
            PopupButtonLayoutConfiguration pg = (PopupButtonLayoutConfiguration)g;
            return pg.getPopupButtonWidget();
        }
        return null;
    }

    static ClientPropertyApplicator<JComboBox<?>, AquaComboBoxUI> getApplicator() {
        return APPLICATOR.get();
    }

    class AquaComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        AquaComboBoxLayoutManager() {
            super(AquaComboBoxUI.this);
        }

        @Override
        public void layoutContainer(Container parent) {
            int width = AquaComboBoxUI.this.comboBox.getWidth();
            int height = AquaComboBoxUI.this.comboBox.getHeight();
            if (AquaComboBoxUI.this.comboBox.isEditable()) {
                ComboBoxConfiguration g = (ComboBoxConfiguration)AquaComboBoxUI.this.arrowButton.getConfiguration();
                painter.configure(width, height);
                if (AquaComboBoxUI.this.editor != null) {
                    Rectangle editorBounds = AquaUtils.toMinimumRectangle(painter.getComboBoxEditorBounds(g));
                    AquaComboBoxUI.this.editor.setBounds(editorBounds);
                }
                if (AquaComboBoxUI.this.arrowButton != null) {
                    Rectangle arrowBounds = AquaUtils.toMinimumRectangle(painter.getComboBoxIndicatorBounds(g));
                    AquaComboBoxUI.this.arrowButton.setBounds(arrowBounds);
                }
            } else {
                AquaComboBoxUI.this.arrowButton.setBounds(0, 0, width, height);
            }
        }
    }

    private abstract class ComboBoxAction
    extends AbstractAction {
        private ComboBoxAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!AquaComboBoxUI.this.comboBox.isEnabled() || !AquaComboBoxUI.this.comboBox.isShowing()) {
                return;
            }
            if (AquaComboBoxUI.this.comboBox.isPopupVisible()) {
                AquaComboBoxUI ui = (AquaComboBoxUI)AquaComboBoxUI.this.comboBox.getUI();
                this.performComboBoxAction(ui);
            } else {
                AquaComboBoxUI.this.comboBox.setPopupVisible(true);
            }
        }

        abstract void performComboBoxAction(AquaComboBoxUI var1);
    }

    class AquaCustomComboTextField
    extends JTextField {
        public AquaCustomComboTextField() {
            this.setUI(new AquaComboBoxEditorUI());
            this.setBorder(null);
            InputMap inputMap = this.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke("DOWN"), AquaComboBoxUI.this.highlightNextAction);
            inputMap.put(KeyStroke.getKeyStroke("KP_DOWN"), AquaComboBoxUI.this.highlightNextAction);
            inputMap.put(KeyStroke.getKeyStroke("UP"), AquaComboBoxUI.this.highlightPreviousAction);
            inputMap.put(KeyStroke.getKeyStroke("KP_UP"), AquaComboBoxUI.this.highlightPreviousAction);
            inputMap.put(KeyStroke.getKeyStroke("HOME"), AquaComboBoxUI.this.highlightFirstAction);
            inputMap.put(KeyStroke.getKeyStroke("END"), AquaComboBoxUI.this.highlightLastAction);
            inputMap.put(KeyStroke.getKeyStroke("PAGE_UP"), AquaComboBoxUI.this.highlightPageUpAction);
            inputMap.put(KeyStroke.getKeyStroke("PAGE_DOWN"), AquaComboBoxUI.this.highlightPageDownAction);
            final Action action = this.getActionMap().get("notify-field-accept");
            inputMap.put(KeyStroke.getKeyStroke("ENTER"), new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AquaComboBoxUI.this.popup.isVisible()) {
                        AquaComboBoxUI.triggerSelectionEvent(AquaComboBoxUI.this.comboBox, e);
                        if (AquaComboBoxUI.this.editor instanceof AquaCustomComboTextField) {
                            ((AquaCustomComboTextField)AquaComboBoxUI.this.editor).selectAll();
                        }
                    } else {
                        action.actionPerformed(e);
                    }
                }
            });
        }

        public void configure(AquaUIPainter.ComboBoxWidget widget) {
            if (widget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
                this.setBackground(Color.WHITE);
                this.setOpaque(true);
            } else {
                this.setBackground(new Color(0, 0, 0, 0));
                this.setOpaque(false);
            }
        }

        @Override
        public void setText(String s) {
            if (this.getText().equals(s)) {
                return;
            }
            super.setText(s);
        }
    }

    final class AquaComboBoxEditor
    extends BasicComboBoxEditor
    implements UIResource,
    DocumentListener {
        AquaComboBoxEditor() {
            this.editor.addFocusListener(this);
            this.editor.getDocument().addDocumentListener(this);
        }

        public void configure(AquaUIPainter.ComboBoxWidget widget) {
            if (this.editor instanceof AquaCustomComboTextField) {
                AquaCustomComboTextField f = (AquaCustomComboTextField)this.editor;
                f.configure(widget);
            }
        }

        @Override
        protected JTextField createEditorComponent() {
            return new AquaCustomComboTextField();
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (AquaComboBoxUI.this.arrowButton != null) {
                AquaComboBoxUI.this.arrowButton.repaint();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (AquaComboBoxUI.this.arrowButton != null) {
                AquaComboBoxUI.this.arrowButton.repaint();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.editorTextChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.editorTextChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.editorTextChanged();
        }

        private void editorTextChanged() {
            if (AquaComboBoxUI.this.popup.isVisible()) {
                AquaComboBoxUI.this.updateListSelectionFromEditor(this.editor);
            }
        }
    }

    final class AquaComboBoxEditorUI
    extends AquaTextFieldUI
    implements FocusRingOutlineProvider {
        AquaComboBoxEditorUI() {
        }

        @Override
        protected void installDefaults() {
            super.installDefaults();
            JTextComponent c = this.getComponent();
            LookAndFeel.installProperty(c, "opaque", true);
            Border b = c.getBorder();
            if (b == null || b instanceof UIDefaults) {
                c.setBorder(null);
            }
        }

        @Override
        protected void paintBackgroundSafely(Graphics g) {
            AquaUIPainter.ComboBoxWidget w;
            ComboBoxConfiguration bg;
            if (AquaComboBoxUI.this.comboBox.getParent() instanceof CellRendererPane) {
                return;
            }
            if (AquaComboBoxUI.this.arrowButton != null && (bg = (ComboBoxConfiguration)AquaComboBoxUI.this.arrowButton.getConfiguration()).getState() == AquaUIPainter.State.INACTIVE && ((w = bg.getWidget()) == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED || w == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR)) {
                int width = this.editor.getWidth();
                int height = this.editor.getHeight();
                Color c = new Color(245, 245, 245);
                g.setColor(c);
                g.fillRect(0, 0, width, height);
                return;
            }
            super.paintBackgroundSafely(g);
        }

        @Override
        public Shape getFocusRingOutline(JComponent c) {
            Container parent = c.getParent();
            if (parent instanceof JComboBox) {
                JComboBox cb = (JComboBox)parent;
                AquaComboBoxUI ui = AquaUtils.getUI(cb, AquaComboBoxUI.class);
                if (ui != null) {
                    Shape s = ui.getFocusRingOutline(cb);
                    Rectangle textFieldBounds = c.getBounds();
                    return ExpandableOutline.createTranslatedShape(s, -textFieldBounds.x, -textFieldBounds.y);
                }
                int width = cb.getWidth();
                int height = cb.getHeight();
                Rectangle textFieldBounds = c.getBounds();
                int x = -textFieldBounds.x;
                int y = -textFieldBounds.y;
                return new RoundRectangle2D.Double((float)x + 0.0f, (float)y + 0.0f, (float)width - 0.0f, (float)height - 0.0f, 9.0, 9.0);
            }
            return null;
        }
    }

    private static class MyOptionalFocusHandler
    implements OptionallyFocusableComponentHandler {
        private MyOptionalFocusHandler() {
        }

        @Override
        public void updateFocusability(JComponent c, boolean isFocusable) {
            JComboBox cb = (JComboBox)c;
            if (!cb.isEditable()) {
                cb.setFocusable(isFocusable);
            }
        }
    }

    private class MyHierarchyListener
    implements HierarchyListener {
        private MyHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            AquaComboBoxUI ui = AquaUtils.getUI(AquaComboBoxUI.this.comboBox, AquaComboBoxUI.class);
            if (ui != null) {
                ui.configure(null);
            }
        }
    }
}

