/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaBasicPopupMenuWrapper;
import org.violetlib.aqua.AquaExtendedPopup;
import org.violetlib.aqua.AquaPopupMenuUI;
import org.violetlib.aqua.AquaScrollingPopupMenuWrapper;
import org.violetlib.aqua.AquaUtils;

public class AquaContextualPopup {
    private JComponent wrapper;
    private Popup p;

    public AquaContextualPopup(JComponent content, Component owner, Rectangle selectedRegion, Point selectedRegionLocation, int x, int y, int width, int height) {
        int availableHeight;
        int availableWidth;
        Border border = AquaContextualPopup.getContextualMenuBorder();
        Insets s = border.getBorderInsets(null);
        Dimension ps = content.getPreferredSize();
        if (width <= 0) {
            width = ps.width + s.left + s.right;
        }
        if (height <= 0) {
            height = ps.height + s.top + s.bottom;
        }
        Rectangle screen = AquaUtils.getScreenBounds(new Point(x, y), owner);
        if (y < screen.y) {
            int delta = screen.y - y;
            y = screen.y;
            height -= delta;
        }
        int screenWidth = screen.width;
        int screenHeight = screen.height;
        if (width > screenWidth) {
            width = screenWidth;
        }
        if (width > (availableWidth = screen.x + screen.width - x)) {
            x = screen.x + screen.width - width;
        }
        if (height > screenHeight) {
            height = screenHeight;
        }
        if (height > (availableHeight = screen.y + screen.height - y)) {
            height = availableHeight;
        }
        if (width < ps.width + s.left + s.right || height < ps.height + s.top + s.bottom) {
            if (selectedRegionLocation != null) {
                selectedRegionLocation = new Point(selectedRegionLocation.x - x, selectedRegionLocation.y - y);
            }
            this.wrapper = new MyScrollingWrapper(content, selectedRegion, selectedRegionLocation, width, height, border);
        } else {
            this.wrapper = new AquaBasicPopupMenuWrapper(content, border);
        }
        Border existingBorder = content.getBorder();
        if (existingBorder == null || existingBorder instanceof UIResource) {
            content.setBorder(null);
        }
        this.wrapper.putClientProperty("AquaPopup.backgroundStyle", "vibrantMenu");
        this.wrapper.putClientProperty("AquaPopup.cornerRadius", 6);
        PopupFactory f = PopupFactory.getSharedInstance();
        this.p = f.getPopup(owner, this.wrapper, x, y);
    }

    public Popup getPopup() {
        return this.p;
    }

    public final void dispatchEvent(AWTEvent e) {
        this.wrapper.dispatchEvent(e);
    }

    public static Border getContextualMenuBorder() {
        return new EmptyBorder(5, 0, 5, 0);
    }

    protected class MyScrollingWrapper
    extends AquaScrollingPopupMenuWrapper {
        public MyScrollingWrapper(JComponent originalView, Rectangle selectedRegion, Point selectedRegionLocation, int width, int height, Border border) {
            super(originalView, selectedRegion, selectedRegionLocation, width, height, border);
            if (originalView instanceof JPopupMenu) {
                Object magicValue = AquaPopupMenuUI.getHidePopupKey();
                this.putClientProperty("doNotCancelPopup", magicValue);
                int count = this.getComponentCount();
                for (int i = 0; i < count; ++i) {
                    JComponent cc = (JComponent)this.getComponent(i);
                    cc.putClientProperty("doNotCancelPopup", magicValue);
                }
            }
        }

        @Override
        protected void scroll(MouseEvent e, int delta) {
            Point loc = AquaUtils.getScreenLocation(AquaContextualPopup.this.wrapper);
            Rectangle screen = AquaUtils.getScreenBounds(loc, AquaContextualPopup.this.wrapper);
            Window w = SwingUtilities.getWindowAncestor(AquaContextualPopup.this.wrapper);
            if (w != null) {
                int availableExtension;
                if (delta > 0) {
                    availableExtension = w.getY() - screen.y;
                    if (availableExtension > 0) {
                        int extension = Math.min(delta, availableExtension);
                        w.setBounds(w.getX(), w.getY() - extension, w.getWidth(), w.getHeight() + extension);
                        w.invalidate();
                        w.validate();
                        this.height += extension;
                        delta -= extension;
                        this.configure(true);
                    }
                } else {
                    availableExtension = screen.y + screen.height - (w.getY() + w.getHeight());
                    if (availableExtension > 0) {
                        int extension = Math.min(-delta, availableExtension);
                        w.setBounds(w.getX(), w.getY(), w.getWidth(), w.getHeight() + extension);
                        w.invalidate();
                        w.validate();
                        delta += extension;
                        this.height += extension;
                        Point vp = this.viewport.getViewPosition();
                        this.viewport.setViewPosition(new Point(vp.x, vp.y - extension));
                        this.configure(true);
                    }
                }
                if (delta != 0) {
                    super.scroll(e, delta);
                }
                if (e != null && this.originalContent instanceof AquaExtendedPopup) {
                    AquaExtendedPopup cbp = (AquaExtendedPopup)((Object)this.originalContent);
                    cbp.updateSelection(e);
                }
            }
        }
    }
}

