/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaToolBarUI;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.WindowDraggingMouseListener;

public class AquaCustomStyledWindow {
    public static final int STYLE_NORMAL = 0;
    public static final int STYLE_TRANSPARENT = 1;
    public static final int STYLE_HIDDEN = 2;
    public static final int STYLE_UNIFIED = 3;
    public static final int STYLE_TEXTURED_HIDDEN = 4;
    public static final int STYLE_COMBINED = 5;
    protected final int TITLE_BAR_HEIGHT = 22;
    protected final int TITLE_BAR_BUTTONS_WIDTH = 78;
    protected Window w;
    protected JRootPane rp;
    protected final int style;
    protected final int titleBarStyle;
    protected final boolean isUnifiedStyle;
    protected JComponent contentPane;
    protected JToolBar windowToolBar;
    protected WindowPropertyChangeListener propertyChangeListener;
    protected WindowDraggingMouseListener windowDraggingMouseListener;
    protected HierarchyListener toolbarHierarchyListener;

    public AquaCustomStyledWindow(Window w, int style) throws IllegalArgumentException {
        if (w instanceof JFrame) {
            JFrame fr = (JFrame)w;
            if (fr.isUndecorated()) {
                throw new IllegalArgumentException("Window is not decorated");
            }
            this.w = w;
            this.rp = fr.getRootPane();
        } else if (w instanceof JDialog) {
            JDialog d = (JDialog)w;
            if (d.isUndecorated()) {
                throw new IllegalArgumentException("Window is not decorated");
            }
            this.w = w;
            this.rp = d.getRootPane();
        } else {
            throw new IllegalArgumentException("Window is not decorated");
        }
        switch (style) {
            case 0: {
                this.titleBarStyle = 4;
                this.isUnifiedStyle = false;
                break;
            }
            case 1: {
                this.titleBarStyle = 2;
                this.isUnifiedStyle = false;
                break;
            }
            case 2: {
                this.titleBarStyle = 3;
                this.isUnifiedStyle = false;
                break;
            }
            case 3: {
                this.titleBarStyle = 2;
                this.isUnifiedStyle = true;
                break;
            }
            case 4: {
                this.titleBarStyle = 3;
                this.isUnifiedStyle = true;
                break;
            }
            case 5: {
                this.titleBarStyle = 2;
                this.isUnifiedStyle = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid style");
            }
        }
        this.style = style;
        this.contentPane = this.getContentPane();
        if (this.contentPane == null) {
            throw new IllegalArgumentException("Window content pane is not a Swing component");
        }
        if (this.isUnifiedStyle) {
            this.windowToolBar = this.getWindowToolbar();
            if (this.windowToolBar == null) {
                throw new IllegalArgumentException("Window content pane must contain a non-floatable JToolBar");
            }
            this.setupToolbar(this.windowToolBar);
        }
        this.setupContentPane(this.contentPane);
        if (this.isUnifiedStyle) {
            this.propertyChangeListener = new WindowPropertyChangeListener();
            this.rp.addPropertyChangeListener("Frame.active", this.propertyChangeListener);
        }
        if (style == 5) {
            AquaUtils.setWindowTitle(w, "");
        }
        AquaUtils.setTitleBarStyle(w, this.titleBarStyle);
    }

    public void refreshWindowStyleMask() {
        AquaUtils.setTitleBarStyle(this.w, this.titleBarStyle);
    }

    public void dispose() {
        if (this.w != null) {
            this.rp.removePropertyChangeListener("Frame.active", this.propertyChangeListener);
            this.propertyChangeListener = null;
            this.rp = null;
            AquaUtils.setTitleBarStyle(this.w, 1);
            if (this.windowToolBar != null) {
                this.resetBorder(this.windowToolBar);
                if (this.toolbarHierarchyListener != null) {
                    this.windowToolBar.removeHierarchyListener(this.toolbarHierarchyListener);
                    this.toolbarHierarchyListener = null;
                }
                if (this.windowDraggingMouseListener != null) {
                    this.windowDraggingMouseListener.detach(this.windowToolBar);
                    this.windowDraggingMouseListener = null;
                }
                this.windowToolBar = null;
            }
            this.resetBorder(this.contentPane);
            this.w = null;
            this.contentPane = null;
        }
    }

    protected void setupContentPane(JComponent cp) {
        if (this.style == 0 || this.style == 1) {
            this.installBorder(cp, 22, 0, 0, 0);
        } else {
            this.installBorder(cp, 0, 0, 0, 0);
        }
        if (this.isUnifiedStyle) {
            cp.setOpaque(false);
        }
    }

    protected void setupToolbar(JToolBar tb) {
        tb.setOpaque(false);
        Container p = tb;
        while ((p = p.getParent()) != this.contentPane && p != null) {
            if (!(p instanceof JComponent)) continue;
            ((JComponent)p).setOpaque(false);
        }
        this.installToolbarBorder(tb);
        this.attachWindowDraggingMouseListener(tb);
        this.attachHierarchyListener(tb);
    }

    protected void installToolbarBorder(JToolBar tb) {
        Border b = tb.getBorder();
        if (b == null || b instanceof UIResource) {
            int bottom;
            boolean isTall = AquaToolBarUI.isTallFormat(tb);
            int left = 4;
            int top = 4;
            int n = bottom = isTall ? 0 : 4;
            if (this.style == 3) {
                tb.setBorder(new CustomToolbarBorder(left, 22, bottom, true));
            } else if (this.style == 5) {
                tb.setBorder(new CustomToolbarBorder(78, top, bottom, true));
            } else if (this.style == 4) {
                tb.setBorder(new CustomToolbarBorder(left, top, bottom, true));
            }
        }
    }

    protected void installBorder(JComponent c, int top, int left, int bottom, int right) {
        Border b = c.getBorder();
        if (b == null || b instanceof UIResource) {
            c.setBorder(new BorderUIResource.EmptyBorderUIResource(top, left, bottom, right));
        }
    }

    protected void resetBorder(JComponent c) {
        Border b = c.getBorder();
        if (b == null || b instanceof UIResource) {
            if (c instanceof JToolBar) {
                c.setBorder(AquaToolBarUI.getToolBarBorder());
            } else {
                c.setBorder(null);
            }
        }
    }

    protected void attachWindowDraggingMouseListener(JComponent c) {
        if (c != null && this.windowDraggingMouseListener == null) {
            this.windowDraggingMouseListener = new WindowDraggingMouseListener();
            this.windowDraggingMouseListener.attach(c);
        }
    }

    protected void attachHierarchyListener(JToolBar tb) {
        if (this.toolbarHierarchyListener == null) {
            this.toolbarHierarchyListener = new ToolbarHierarchyListener();
        }
        tb.addHierarchyListener(this.toolbarHierarchyListener);
    }

    public void paintBackground(Graphics g) {
        if (this.rp != null && this.isUnifiedStyle) {
            this.paintUnifiedBackground(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintUnifiedBackground(Graphics g) {
        Graphics2D gg = (Graphics2D)g.create();
        try {
            int y = this.getTopGradientHeight();
            boolean isActive = AquaFocusHandler.isActive(this.rp);
            if (isActive) {
                Color c1 = new Color(230, 230, 230);
                Color c2 = new Color(210, 210, 210);
                GradientPaint gp = new GradientPaint(0.0f, 0.0f, c1, 0.0f, y, c2);
                gg.setPaint(gp);
            } else {
                gg.setColor(new Color(246, 246, 246));
            }
            gg.fillRect(0, 0, this.rp.getWidth(), this.rp.getHeight());
        }
        finally {
            gg.dispose();
        }
    }

    protected int getTopGradientHeight() {
        int toolbarHeight = this.windowToolBar.getHeight();
        switch (this.style) {
            case 3: {
                return toolbarHeight + 22;
            }
            case 5: {
                return Math.max(toolbarHeight, 22);
            }
        }
        return toolbarHeight;
    }

    protected JComponent getContentPane() {
        Container c = this.rp.getContentPane();
        return c instanceof JComponent ? (JComponent)c : null;
    }

    protected JToolBar getWindowToolbar() {
        Container c = this.rp.getContentPane();
        return this.getWindowToolbar(c);
    }

    protected JToolBar getWindowToolbar(Container c) {
        JToolBar tb;
        Component m;
        int i;
        int count = c.getComponentCount();
        for (i = 0; i < count; ++i) {
            m = c.getComponent(i);
            if (!(m instanceof JToolBar) || (tb = (JToolBar)m).isFloatable()) continue;
            return tb;
        }
        for (i = 0; i < count; ++i) {
            m = c.getComponent(i);
            if (!(m instanceof Container) || (tb = this.getWindowToolbar((Container)m)) == null) continue;
            return tb;
        }
        return null;
    }

    protected class CustomToolbarBorder
    extends AbstractBorder
    implements UIResource {
        protected int extraTop;
        protected int extraLeft;
        protected int extraBottom;
        protected boolean includeBottomLine;

        public CustomToolbarBorder(int extraLeft, int extraTop, int extraBottom, boolean includeBottomLine) {
            this.extraLeft = extraLeft;
            this.extraTop = extraTop;
            this.extraBottom = extraBottom;
            this.includeBottomLine = includeBottomLine;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            JToolBar tb = (JToolBar)c;
            Insets margin = tb.getMargin();
            insets.left = margin.left + this.extraLeft;
            insets.top = margin.top + this.extraTop;
            insets.right = margin.right;
            insets.bottom = margin.bottom + this.extraBottom + (this.includeBottomLine ? 1 : 0);
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (this.includeBottomLine) {
                g.setColor(new Color(186, 186, 186));
                g.fillRect(x, y + height - 1, width, 1);
            }
        }
    }

    protected class ToolbarHierarchyListener
    implements HierarchyListener {
        protected ToolbarHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            JToolBar tb;
            if (e.getChangeFlags() == 1L && SwingUtilities.getWindowAncestor(tb = (JToolBar)e.getComponent()) != AquaCustomStyledWindow.this.w) {
                AquaCustomStyledWindow.this.resetBorder(tb);
                if (tb == AquaCustomStyledWindow.this.windowToolBar) {
                    AquaCustomStyledWindow.this.windowToolBar = null;
                }
                tb.removeHierarchyListener(AquaCustomStyledWindow.this.toolbarHierarchyListener);
                if (AquaCustomStyledWindow.this.windowDraggingMouseListener != null) {
                    AquaCustomStyledWindow.this.windowDraggingMouseListener.detach(tb);
                }
            }
        }
    }

    protected class WindowPropertyChangeListener
    implements PropertyChangeListener {
        protected WindowPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AquaCustomStyledWindow.this.rp.repaint();
        }
    }
}

