/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class AquaDragRecognitionSupport {
    private int motionThreshold;
    private MouseEvent dndArmedEvent;
    private JComponent component;
    private static AquaDragRecognitionSupport instance;

    private static AquaDragRecognitionSupport getDragRecognitionSupport() {
        if (instance == null) {
            instance = new AquaDragRecognitionSupport();
        }
        return instance;
    }

    public static boolean mousePressed(MouseEvent me) {
        return AquaDragRecognitionSupport.getDragRecognitionSupport().mousePressedImpl(me);
    }

    public static MouseEvent mouseReleased(MouseEvent me) {
        return AquaDragRecognitionSupport.getDragRecognitionSupport().mouseReleasedImpl(me);
    }

    public static boolean mouseDragged(MouseEvent me, BeforeDrag bd) {
        return AquaDragRecognitionSupport.getDragRecognitionSupport().mouseDraggedImpl(me, bd);
    }

    private void clearState() {
        this.dndArmedEvent = null;
        this.component = null;
    }

    public static int mapDragOperationFromModifiers(MouseEvent me, TransferHandler th) {
        if (th == null || !SwingUtilities.isLeftMouseButton(me)) {
            return 0;
        }
        return AquaDragRecognitionSupport.convertModifiersToDropAction(me.getModifiersEx(), th.getSourceActions((JComponent)me.getSource()));
    }

    private boolean mousePressedImpl(MouseEvent me) {
        this.component = (JComponent)me.getSource();
        if (AquaDragRecognitionSupport.mapDragOperationFromModifiers(me, this.component.getTransferHandler()) != 0) {
            this.motionThreshold = DragSource.getDragThreshold();
            this.dndArmedEvent = me;
            return true;
        }
        this.clearState();
        return false;
    }

    private MouseEvent mouseReleasedImpl(MouseEvent me) {
        if (this.dndArmedEvent == null) {
            return null;
        }
        MouseEvent retEvent = null;
        if (me.getSource() == this.component) {
            retEvent = this.dndArmedEvent;
        }
        this.clearState();
        return retEvent;
    }

    private boolean mouseDraggedImpl(MouseEvent me, BeforeDrag bd) {
        TransferHandler th;
        int action;
        int dy;
        if (this.dndArmedEvent == null) {
            return false;
        }
        if (me.getSource() != this.component) {
            this.clearState();
            return false;
        }
        int dx = Math.abs(me.getX() - this.dndArmedEvent.getX());
        if (Math.sqrt(dx * dx + (dy = Math.abs(me.getY() - this.dndArmedEvent.getY())) * dy) > (double)this.motionThreshold && (action = AquaDragRecognitionSupport.mapDragOperationFromModifiers(me, th = this.component.getTransferHandler())) != 0) {
            if (bd != null) {
                bd.dragStarting(this.dndArmedEvent);
            }
            th.exportAsDrag(this.component, this.dndArmedEvent, action);
            this.clearState();
        }
        return true;
    }

    private static int convertModifiersToDropAction(int modifiersEx, int sourceActions) {
        int dropAction;
        if (0 != (modifiersEx & 0x2200)) {
            dropAction = 1 & sourceActions;
            if (dropAction == 0) {
                dropAction = 2 & sourceActions;
            }
        } else if (0 != (modifiersEx & 0x2200) && 0 != (modifiersEx & 0x100)) {
            dropAction = 0x40000000 & sourceActions;
            if (dropAction == 0) {
                dropAction = 2 & sourceActions;
            }
        } else {
            dropAction = 2 & sourceActions;
            if (dropAction == 0) {
                dropAction = 1 & sourceActions;
            }
        }
        return dropAction;
    }

    public static interface BeforeDrag {
        public void dragStarting(MouseEvent var1);
    }
}

