/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.Caret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.violetlib.aqua.AquaCaret;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaHighlighter;
import org.violetlib.aqua.AquaKeyBindings;
import org.violetlib.aqua.FocusRingOutlineProvider;

public class AquaEditorPaneUI
extends BasicEditorPaneUI
implements FocusRingOutlineProvider {
    boolean oldDragState = false;
    FocusListener focusListener;

    public static ComponentUI createUI(JComponent c) {
        return new AquaEditorPaneUI();
    }

    @Override
    public Shape getFocusRingOutline(JComponent c) {
        return null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (!GraphicsEnvironment.isHeadless()) {
            this.oldDragState = this.getComponent().getDragEnabled();
            this.getComponent().setDragEnabled(true);
        }
    }

    @Override
    protected void uninstallDefaults() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.getComponent().setDragEnabled(this.oldDragState);
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.focusListener = this.createFocusListener();
        this.getComponent().addFocusListener(this.focusListener);
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        AquaKeyBindings bindings = AquaKeyBindings.instance();
        bindings.setDefaultAction(this.getKeymapName());
        JTextComponent c = this.getComponent();
        bindings.installAquaUpDownActions(c);
    }

    @Override
    protected void uninstallListeners() {
        this.getComponent().removeFocusListener(this.focusListener);
        super.uninstallListeners();
    }

    protected FocusListener createFocusListener() {
        return new AquaFocusHandler();
    }

    @Override
    protected Caret createCaret() {
        Window owningWindow = SwingUtilities.getWindowAncestor(this.getComponent());
        AquaCaret returnValue = new AquaCaret(owningWindow, this.getComponent());
        return returnValue;
    }

    @Override
    protected Highlighter createHighlighter() {
        return new AquaHighlighter();
    }
}

