/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.ViewFactory;
import org.violetlib.aqua.AquaUtils;

public class AquaFieldView
extends FieldView {
    public AquaFieldView(Element elem) {
        super(elem);
    }

    @Override
    protected Shape adjustAllocation(Shape a) {
        if (a != null) {
            Container c;
            Rectangle bounds = a.getBounds();
            int vspan = (int)this.getPreferredSpan(1);
            int hspan = (int)this.getPreferredSpan(0);
            if (bounds.height != vspan) {
                int slop = bounds.height - vspan;
                bounds.y += (slop + 1) / 2;
                bounds.height -= slop;
            }
            if ((c = this.getContainer()) instanceof JTextField) {
                JTextField field = (JTextField)c;
                if (hspan < bounds.width) {
                    int slop = bounds.width - 1 - hspan;
                    int align = field.getHorizontalAlignment();
                    if (AquaUtils.isLeftToRight(field)) {
                        if (align == 10) {
                            align = 2;
                        } else if (align == 11) {
                            align = 4;
                        }
                    } else if (align == 10) {
                        align = 4;
                    } else if (align == 11) {
                        align = 2;
                    }
                    switch (align) {
                        case 0: {
                            bounds.x += slop / 2;
                            bounds.width -= slop;
                            break;
                        }
                        case 4: {
                            bounds.x += slop;
                            bounds.width -= slop;
                        }
                    }
                } else {
                    bounds.width = hspan;
                }
            }
            return bounds;
        }
        return null;
    }

    @Override
    public void insertUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateDamage(changes, this.adjustAllocation(a), f);
    }

    @Override
    public void removeUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateDamage(changes, this.adjustAllocation(a), f);
    }
}

