/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.violetlib.aqua.AquaFocusRingPainter;

public class AquaFocusRingManager {
    private static AquaFocusRingManager INSTANCE = new AquaFocusRingManager();
    private Component currentOwner;
    private final String FOCUS_OWNER_PROPERTY = "permanentFocusOwner";
    private final PropertyChangeListener myFocusChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            String name = ev.getPropertyName();
            if (!"permanentFocusOwner".equals(name)) {
                return;
            }
            Object o = ev.getNewValue();
            if (o instanceof Component) {
                Component c = (Component)o;
                AquaFocusRingManager.this.update(c);
            } else {
                AquaFocusRingManager.this.update(null);
            }
        }
    };
    private boolean isInstalled;
    private final AquaFocusRingPainter painter = new AquaFocusRingPainter();

    public static AquaFocusRingManager getInstance() {
        return INSTANCE;
    }

    protected AquaFocusRingManager() {
    }

    public void install() {
        if (!this.isInstalled) {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            fm.addPropertyChangeListener("permanentFocusOwner", this.myFocusChangeListener);
            Component c = fm.getPermanentFocusOwner();
            this.update(c);
            this.isInstalled = true;
        }
    }

    public void uninstall() {
        if (this.isInstalled) {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            fm.removePropertyChangeListener("permanentFocusOwner", this.myFocusChangeListener);
            if (this.currentOwner != null) {
                this.painter.setFocusOwner(null);
                this.currentOwner = null;
            }
            this.isInstalled = false;
        }
    }

    private void update(Component newFocusOwner) {
        if (newFocusOwner == this.currentOwner) {
            return;
        }
        this.currentOwner = newFocusOwner;
        Component displayableComponent = this.currentOwner instanceof JComponent && this.isValid(this.currentOwner) ? this.currentOwner : null;
        this.painter.setFocusOwner((JComponent)displayableComponent);
    }

    private boolean isValid(Component c) {
        return c.isVisible();
    }

    private void updateFocusRing(JComponent c) {
        if (c == this.currentOwner && this.isValid(c)) {
            this.painter.update();
        }
    }

    public static void focusRingOutlineChanged(JComponent c) {
        AquaFocusRingManager m = AquaFocusRingManager.getInstance();
        m.updateFocusRing(c);
    }
}

