/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.violetlib.aqua.AnimationController;
import org.violetlib.aqua.AquaCellEditorPolicy;
import org.violetlib.aqua.AquaDefaultFocusRingProvider;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.aqua.FocusRingPainter;
import org.violetlib.aqua.OutlineFocusRingPainter;
import org.violetlib.aqua.OverlayPainterComponent;
import org.violetlib.geom.ExpandableOutline;
import org.violetlib.geom.GeneralRoundRectangle;

public class AquaFocusRingPainter {
    protected static final int ANIMATION_DURATION = 100;
    protected static final float DEFAULT_CORNER = 6.0f;
    private JComponent currentDisplayedFocusOwner;
    private FocusRingOutlineProvider currentFocusRingProvider;
    private float animationState;
    private OverlayPainterComponent painterComponent = new MyFocusRingPainterComponent();
    private AnimationController animationController = new AnimationController(new MyAnimation(), 100);
    private FocusRingOutlineProvider defaultFocusRingProvider = new AquaDefaultFocusRingProvider();
    private AquaCellEditorPolicy cellEditorPolicy = AquaCellEditorPolicy.getInstance();
    private final PropertyChangeListener myActiveChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            String name = ev.getPropertyName();
            if ("Frame.active".equals(name)) {
                AquaFocusRingPainter.this.painterComponent.repaint();
            }
        }
    };

    public void setFocusOwner(JComponent c) {
        if (c == null) {
            this.clear();
        } else {
            FocusRingOutlineProvider provider = this.getFocusRingProvider(c);
            if (provider == null) {
                this.clear();
            } else {
                this.currentDisplayedFocusOwner = c;
                this.currentDisplayedFocusOwner.addPropertyChangeListener(this.myActiveChangeListener);
                this.currentFocusRingProvider = provider;
                this.painterComponent.attach(c);
                this.animationState = 0.0f;
                this.animationController.start();
            }
        }
    }

    public void update() {
        if (this.currentDisplayedFocusOwner != null) {
            this.painterComponent.repaint();
        }
    }

    protected void clear() {
        if (this.currentDisplayedFocusOwner != null) {
            this.currentDisplayedFocusOwner.removePropertyChangeListener(this.myActiveChangeListener);
            this.currentDisplayedFocusOwner = null;
            this.currentFocusRingProvider = null;
            this.animationState = 0.0f;
            this.animationController.stop();
            this.painterComponent.attach(null);
        }
    }

    protected FocusRingOutlineProvider getFocusRingProvider(JComponent c) {
        FocusRingOutlineProvider p = AquaUtils.getUI(c, FocusRingOutlineProvider.class);
        return p;
    }

    protected FocusRingPainter getFocusRingPainter(Shape s) {
        Shape outerShape;
        Shape innerShape;
        boolean useSmallRing = this.isCellEditor(this.currentDisplayedFocusOwner);
        float outerOffset = useSmallRing ? 2.0f : 3.0f;
        float innerOffset = useSmallRing ? 0.0f : -0.5f;
        ExpandableOutline outline = ExpandableOutline.fromShape(s);
        float currentOuterOffset = outerOffset + (1.0f - this.animationState) * 10.0f;
        boolean createRoundRectOuter = false;
        if (s instanceof Rectangle2D) {
            createRoundRectOuter = !useSmallRing;
        } else if (s instanceof GeneralRoundRectangle) {
            createRoundRectOuter = true;
        }
        if (createRoundRectOuter) {
            innerShape = s;
            Rectangle2D r = s.getBounds2D();
            RoundRectangle2D.Double ss = new RoundRectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight(), 6.0, 6.0);
            outline = ExpandableOutline.fromShape(ss);
            outerShape = outline.getShape(currentOuterOffset);
        } else {
            outerShape = outline.getShape(currentOuterOffset);
            innerShape = outline.getShape(innerOffset);
        }
        return new OutlineFocusRingPainter(innerShape, outerShape);
    }

    protected boolean isCellEditor(JComponent c) {
        return this.cellEditorPolicy.isCellEditor(c);
    }

    private class MyAnimation
    implements AnimationController.Animation {
        private MyAnimation() {
        }

        @Override
        public void setAnimationState(float a) {
            AquaFocusRingPainter.this.animationState = a;
            AquaFocusRingPainter.this.painterComponent.repaint();
        }
    }

    protected class MyFocusRingPainterComponent
    extends OverlayPainterComponent {
        public MyFocusRingPainterComponent() {
            super(new Insets(100, 100, 100, 100), 1);
        }

        @Override
        protected void internalPaint(Graphics2D g) {
            Shape s;
            if (AquaFocusRingPainter.this.currentDisplayedFocusOwner != null && AquaFocusHandler.isActive(AquaFocusRingPainter.this.currentDisplayedFocusOwner) && AquaFocusRingPainter.this.currentFocusRingProvider != null && (s = AquaFocusRingPainter.this.currentFocusRingProvider.getFocusRingOutline(AquaFocusRingPainter.this.currentDisplayedFocusOwner)) != null) {
                Color focusColor = UIManager.getColor("Focus.color");
                FocusRingPainter p = AquaFocusRingPainter.this.getFocusRingPainter(s);
                p.paint(g, focusColor);
            }
        }
    }
}

