/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.OptionallyFocusableComponentHandler;

public class AquaFullKeyboardFocusableHandler
implements ChangeListener {
    public static final String OPTIONAL_FOCUSABILITY_HANDLER_KEY = "Aqua.optionalFocusabilityHandler";
    private static final String CLIENT_PROPERTY_KEY = "FullKeyboardFocusListener";
    private final JComponent c;

    public AquaFullKeyboardFocusableHandler(JComponent c) {
        this.c = c;
        this.update();
        OSXSystemProperties.addChangeListener(this);
    }

    public void dispose() {
        OSXSystemProperties.removeChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.update();
    }

    private void update() {
        boolean isFocusable = OSXSystemProperties.isFullKeyboardAccessEnabled();
        Object o = this.c.getClientProperty(OPTIONAL_FOCUSABILITY_HANDLER_KEY);
        if (o instanceof OptionallyFocusableComponentHandler) {
            OptionallyFocusableComponentHandler h = (OptionallyFocusableComponentHandler)o;
            h.updateFocusability(this.c, isFocusable);
        } else {
            this.c.setFocusable(isFocusable);
        }
    }

    public static void addListener(JComponent c) {
        AquaFullKeyboardFocusableHandler h = new AquaFullKeyboardFocusableHandler(c);
        c.putClientProperty(CLIENT_PROPERTY_KEY, h);
    }

    public static void removeListener(JComponent c) {
        AquaFullKeyboardFocusableHandler h = (AquaFullKeyboardFocusableHandler)c.getClientProperty(CLIENT_PROPERTY_KEY);
        if (h != null) {
            c.putClientProperty(CLIENT_PROPERTY_KEY, null);
            h.dispose();
        }
    }
}

