/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import com.apple.eio.FileManager;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaMultiResolutionImage;
import org.violetlib.aqua.AquaNativeSupport;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.Painter;

public class AquaIcon {
    public static final IconImageCreator alertCautionImageCreator = new IconImageCreator("caut", 64);
    public static final IconImageCreator alertStopImageCreator = new IconImageCreator("stop", 64);
    public static final IconImageCreator openFolderImageCreator = new IconImageCreator("ofld", 20);
    private static final RecyclableIconImageSingleton cautionIcon = new RecyclableIconImageSingleton(alertCautionImageCreator);
    private static final RecyclableIconImageSingleton stopIcon = new RecyclableIconImageSingleton(alertStopImageCreator);
    private static final RecyclableIconImageSingleton openFolderIcon = new RecyclableIconImageSingleton(openFolderImageCreator);

    public static Icon loadResource(String resource) {
        Image im = AquaImageFactory.loadResource(resource);
        return new ImageIcon(im);
    }

    public static Image getImageForIcon(Icon i) {
        if (i == null) {
            return null;
        }
        if (i instanceof ImageIcon) {
            return ((ImageIcon)i).getImage();
        }
        int w = i.getIconWidth();
        int h = i.getIconHeight();
        if (w <= 0 || h <= 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(w, h, 3);
        Graphics g = image.getGraphics();
        i.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static Icon createPressedDarkIcon(Icon ic) {
        Image im = AquaIcon.getImageForIcon(ic);
        if (im != null) {
            Image pressedImage = AquaImageFactory.generatePressedDarkImage(im);
            return new ImageIcon(pressedImage);
        }
        return ic;
    }

    public static Icon createDisabledLightIcon(Icon ic) {
        Image im = AquaIcon.getImageForIcon(ic);
        if (im != null) {
            Image disabledImage = AquaImageFactory.generateDisabledLightImage(im);
            return new ImageIcon(disabledImage);
        }
        return ic;
    }

    public static Image getStopIconImage() {
        return stopIcon.getInstance();
    }

    public static Image getCautionIconImage() {
        return cautionIcon.getInstance();
    }

    public static IconUIResource getOpenFolderIcon() {
        return new IconUIResource(new ImageIcon(openFolderIcon.getInstance()));
    }

    private static native boolean nativeRenderIcon(int var0, int[][] var1, int var2);

    private static class IconImageCreator {
        private final String osTypeName;
        private final int osType;
        private final int size;
        private Image result;

        public IconImageCreator(String osTypeName, int size) {
            this.osTypeName = osTypeName;
            this.osType = FileManager.OSTypeToInt((String)osTypeName);
            this.size = size;
        }

        public Image getImage() {
            if (this.result == null) {
                AquaNativeSupport.load();
                int[][] buffers = new int[2][];
                if (!AquaIcon.nativeRenderIcon(this.osType, buffers, this.size)) {
                    if (AquaImageFactory.debugNativeRendering) {
                        System.err.println("Failed to render image for icon " + this.osTypeName);
                    }
                    throw new UnsupportedOperationException();
                }
                if (AquaImageFactory.debugNativeRendering) {
                    System.err.println("Rendered image for icon " + this.osTypeName);
                }
                this.result = AquaMultiResolutionImage.createImage(this.size, this.size, buffers[0], buffers[1]);
            }
            return this.result;
        }
    }

    public static abstract class ScalingNativeRenderedIcon
    implements Icon,
    UIResource {
        final int width;
        final int height;

        public ScalingNativeRenderedIcon(int width, int height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            if ((g = g.create()) instanceof Graphics2D) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            Painter painter = this.getPainter(this.width, this.height);
            g.clipRect(x, y, this.width, this.height);
            painter.paint(g, x, y);
            g.dispose();
        }

        public abstract Painter getPainter(int var1, int var2);

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    public static abstract class CachingScalingIcon
    implements Icon,
    UIResource {
        int width;
        int height;
        Image image;

        public CachingScalingIcon(int width, int height) {
            this.width = width;
            this.height = height;
        }

        void setSize(int width, int height) {
            this.width = width;
            this.height = height;
            this.image = null;
        }

        Image getImage() {
            if (this.image != null) {
                return this.image;
            }
            if (!GraphicsEnvironment.isHeadless()) {
                this.image = this.createImage();
            }
            return this.image;
        }

        abstract Image createImage();

        public boolean hasIconRef() {
            return this.getImage() != null;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Image myImage;
            if ((g = g.create()) instanceof Graphics2D) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            if ((myImage = this.getImage()) != null) {
                g.drawImage(myImage, x, y, this.getIconWidth(), this.getIconHeight(), null);
            }
            g.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private static class RecyclableIconImageSingleton
    extends AquaUtils.RecyclableSingleton<Image> {
        final IconImageCreator imageCreator;

        public RecyclableIconImageSingleton(IconImageCreator imageCreator) {
            this.imageCreator = imageCreator;
        }

        @Override
        protected Image getInstance() {
            return this.imageCreator.getImage();
        }
    }

    static interface InvertableIcon
    extends Icon {
        public Icon getInvertedIcon();
    }
}

