/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import com.apple.eawt.Application;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.Aqua8MultiResolutionImage;
import org.violetlib.aqua.AquaIcon;
import org.violetlib.aqua.AquaMultiResolutionImage;
import org.violetlib.aqua.AquaNativeSupport;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.fc.OSXFile;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaImageFactory {
    public static boolean debugNativeRendering = false;
    private static final int kAlertIconSize = 64;
    private static InvertableImageIcon regularPopupMenuCheckIcon;
    private static InvertableImageIcon smallPopupMenuCheckIcon;
    private static InvertableImageIcon miniPopupMenuCheckIcon;
    private static final AppIconCompositor appIconCompositor;
    private static final TreeFolderIconUIResourceSingleton treeFolderIconResource;
    private static final TreeOpenFolderIconUIResourceSingleton treeOpenFolderIconResource;
    private static final TreeDocumentIconUIResourceSingleton treeDocumentIconResource;
    protected static final NamedImageSingleton northArrow;
    protected static final IconUIResourceSingleton northArrowIcon;
    protected static final NamedImageSingleton southArrow;
    protected static final IconUIResourceSingleton southArrowIcon;
    protected static final NamedImageSingleton westArrow;
    protected static final IconUIResourceSingleton westArrowIcon;
    protected static final NamedImageSingleton eastArrow;
    protected static final IconUIResourceSingleton eastArrowIcon;
    private static Color windowBackgroundColor;
    private static Color desktopBackgroundColor;
    private static Color textSelectionBackgroundColor;
    private static Color textSelectionForegroundColor;
    private static Color selectionBackgroundColor;
    private static Color selctionForegroundColor;
    private static Color comboBoxSelectionBackgroundColor;
    private static Color comboBoxSelectionForegroundColor;
    private static Color focusRingColor;
    private static Color selectionInactiveBackgroundColor;
    private static Color selectionInactiveForegroundColor;

    public static IconUIResource getComputerIcon() {
        return new IconUIResource(new AquaIcon.CachingScalingIcon(16, 16){

            @Override
            Image createImage() {
                return AquaImageFactory.getNSIcon("NSComputer");
            }
        });
    }

    public static IconUIResource getConfirmImageIcon() {
        return new IconUIResource(new AquaIcon.CachingScalingIcon(64, 64){

            @Override
            Image createImage() {
                return AquaImageFactory.getGenericJavaIcon();
            }
        });
    }

    public static IconUIResource getCautionImageIcon() {
        return AquaImageFactory.getAppIconCompositedOn(AquaIcon.getCautionIconImage());
    }

    public static IconUIResource getStopImageIcon() {
        return AquaImageFactory.getAppIconCompositedOn(AquaIcon.getStopIconImage());
    }

    public static IconUIResource getLockImageIcon() {
        Image lockIcon = Toolkit.getDefaultToolkit().getImage("NSImage://NSSecurity");
        return AquaImageFactory.getAppIconCompositedOn(lockIcon);
    }

    static Image getGenericJavaIcon() {
        return AccessController.doPrivileged(new PrivilegedAction<Image>(){

            @Override
            public Image run() {
                return Application.getApplication().getDockIconImage();
            }
        });
    }

    protected static IconUIResource getAppIconCompositedOn(Image background) {
        return new IconUIResource(new ImageIcon(AquaImageFactory.applyMapper(background, appIconCompositor)));
    }

    public static Image applyMapper(Image source, AquaMultiResolutionImage.Mapper mapper) {
        return AquaMultiResolutionImage.apply(source, mapper);
    }

    static BufferedImage getAppIconImageCompositedOn(Image background, int scaleFactor) {
        int scaledAlertIconSize = background.getWidth(null) * scaleFactor;
        int kAlertSubIconSize = (int)((double)scaledAlertIconSize * 0.5);
        int kAlertSubIconInset = scaledAlertIconSize - kAlertSubIconSize;
        AquaIcon.CachingScalingIcon smallAppIconScaled = new AquaIcon.CachingScalingIcon(kAlertSubIconSize, kAlertSubIconSize){

            @Override
            Image createImage() {
                return AquaImageFactory.getGenericJavaIcon();
            }
        };
        BufferedImage image = new BufferedImage(scaledAlertIconSize, scaledAlertIconSize, 3);
        Graphics g = image.getGraphics();
        g.drawImage(background, 0, 0, scaledAlertIconSize, scaledAlertIconSize, null);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        smallAppIconScaled.paintIcon(null, g, kAlertSubIconInset, kAlertSubIconInset);
        g.dispose();
        return image;
    }

    public static Image loadResource(String resource) {
        URL u = AquaImageFactory.class.getResource(resource);
        return u != null ? Toolkit.getDefaultToolkit().createImage(u) : null;
    }

    public static Image getImage(File file, int size) {
        if (file != null) {
            ImageFileIconCreator r = new ImageFileIconCreator(file, size, size);
            return r.getImage();
        }
        return null;
    }

    public static IconUIResource getTreeFolderIcon() {
        return treeFolderIconResource.getInstance();
    }

    public static IconUIResource getTreeOpenFolderIcon() {
        return treeOpenFolderIconResource.getInstance();
    }

    public static IconUIResource getTreeDocumentIcon() {
        return treeDocumentIconResource.getInstance();
    }

    static Image getArrowImageForDirection(int direction) {
        switch (direction) {
            case 1: {
                return (Image)northArrow.get();
            }
            case 5: {
                return (Image)southArrow.get();
            }
            case 3: {
                return (Image)eastArrow.get();
            }
            case 7: {
                return (Image)westArrow.get();
            }
        }
        return null;
    }

    static Icon getArrowIconForDirection(int direction) {
        switch (direction) {
            case 1: {
                return (Icon)northArrowIcon.get();
            }
            case 5: {
                return (Icon)southArrowIcon.get();
            }
            case 3: {
                return (Icon)eastArrowIcon.get();
            }
            case 7: {
                return (Icon)westArrowIcon.get();
            }
        }
        return null;
    }

    public static Icon getMenuUpArrowIcon() {
        return (Icon)northArrowIcon.get();
    }

    public static Icon getMenuDownArrowIcon() {
        return (Icon)southArrowIcon.get();
    }

    public static Icon getMenuArrowIcon() {
        return new InvertableImageIcon(AquaImageFactory.generateLightenedImage((Image)eastArrow.get(), 25));
    }

    public static Icon getPopupMenuItemCheckIcon(AquaUIPainter.Size sizeVariant) {
        if (sizeVariant == AquaUIPainter.Size.SMALL) {
            return AquaImageFactory.getSmallPopupMenuItemCheckIcon();
        }
        if (sizeVariant == AquaUIPainter.Size.MINI) {
            return AquaImageFactory.getMiniPopupMenuItemCheckIcon();
        }
        return AquaImageFactory.getRegularPopupMenuItemCheckIcon();
    }

    private static Icon getRegularPopupMenuItemCheckIcon() {
        if (regularPopupMenuCheckIcon == null) {
            regularPopupMenuCheckIcon = AquaImageFactory.getPopupMenuItemCheckIcon(10);
        }
        return regularPopupMenuCheckIcon;
    }

    private static Icon getSmallPopupMenuItemCheckIcon() {
        if (smallPopupMenuCheckIcon == null) {
            smallPopupMenuCheckIcon = AquaImageFactory.getPopupMenuItemCheckIcon(8);
        }
        return smallPopupMenuCheckIcon;
    }

    private static Icon getMiniPopupMenuItemCheckIcon() {
        if (miniPopupMenuCheckIcon == null) {
            miniPopupMenuCheckIcon = AquaImageFactory.getPopupMenuItemCheckIcon(6);
        }
        return miniPopupMenuCheckIcon;
    }

    private static InvertableImageIcon getPopupMenuItemCheckIcon(int size) {
        Image im = AquaImageFactory.getNSImage("NSMenuCheckmark", size, size);
        return new InvertableImageIcon(im);
    }

    public static Icon getMenuItemCheckIcon() {
        return new InvertableImageIcon(AquaImageFactory.generateLightenedImage(AquaImageFactory.getNSIcon("NSMenuCheckmark"), 25));
    }

    public static Icon getMenuItemDashIcon() {
        return new InvertableImageIcon(AquaImageFactory.generateLightenedImage(AquaImageFactory.getNSIcon("NSMenuMixedState"), 25));
    }

    private static Image getNSImage(String imageName, int width, int height) {
        return AquaImageFactory.getNativeImage(imageName, width, height);
    }

    private static Image getNSIcon(String imageName) {
        Image icon = Toolkit.getDefaultToolkit().getImage("NSImage://" + imageName);
        return icon;
    }

    public static Color getWindowBackgroundColorUIResource() {
        return windowBackgroundColor;
    }

    public static Color getDesktopBackgroundColorUIResource() {
        return desktopBackgroundColor;
    }

    public static Color getTextSelectionBackgroundColorUIResource() {
        return textSelectionBackgroundColor;
    }

    public static Color getTextSelectionForegroundColorUIResource() {
        return textSelectionForegroundColor;
    }

    public static Color getSelectionBackgroundColorUIResource() {
        return selectionBackgroundColor;
    }

    public static Color getSelectionForegroundColorUIResource() {
        return selctionForegroundColor;
    }

    public static Color getComboBoxSelectionBackgroundColorUIResource() {
        return comboBoxSelectionBackgroundColor;
    }

    public static Color getComboBoxSelectionForegroundColorUIResource() {
        return comboBoxSelectionForegroundColor;
    }

    public static Color getFocusRingColorUIResource() {
        return focusRingColor;
    }

    public static Color getSelectionInactiveBackgroundColorUIResource() {
        return selectionInactiveBackgroundColor;
    }

    public static Color getSelectionInactiveForegroundColorUIResource() {
        return selectionInactiveForegroundColor;
    }

    private static native Image getNativeImage(String var0, int var1, int var2);

    private static native boolean nativeRenderImageFile(String var0, int[][] var1, int var2, int var3);

    public static Image generateSelectedDarkImage(Image image) {
        return AquaImageFactory.applyFilter(image, new GenerateSelectedDarkFilter());
    }

    public static Image generatePressedDarkImage(Image image) {
        return AquaImageFactory.applyFilter(image, new GeneratePressedDarkFilter());
    }

    public static Image generateDisabledLightImage(Image image) {
        return AquaImageFactory.applyFilter(image, new GenerateDisabledLightFilter());
    }

    public static Image generateLightenedImage(Image image, int percent) {
        GrayFilter filter = new GrayFilter(true, percent);
        return AquaMultiResolutionImage.apply(image, filter);
    }

    public static boolean isTemplateImage(Image image) {
        TemplateFilter filter = new TemplateFilter(Color.BLACK, true);
        Image im = AquaImageFactory.applyFilter(image, filter);
        new ImageIcon(im);
        return filter.isTemplate();
    }

    public static Image createImageFromTemplate(Image image, Color replacementColor) {
        return AquaImageFactory.applyFilter(image, new TemplateFilter(replacementColor, false));
    }

    public static Image applyFilter(Image image, ImageFilter filter) {
        return Aqua8MultiResolutionImage.apply(image, filter);
    }

    static {
        appIconCompositor = new AppIconCompositor();
        treeFolderIconResource = new TreeFolderIconUIResourceSingleton();
        treeOpenFolderIconResource = new TreeOpenFolderIconUIResourceSingleton();
        treeDocumentIconResource = new TreeDocumentIconUIResourceSingleton();
        northArrow = new NamedImageSingleton("NSMenuScrollUp");
        northArrowIcon = new IconUIResourceSingleton(northArrow);
        southArrow = new NamedImageSingleton("NSMenuScrollDown");
        southArrowIcon = new IconUIResourceSingleton(southArrow);
        westArrow = new NamedImageSingleton("NSMenuSubmenuLeft");
        westArrowIcon = new IconUIResourceSingleton(westArrow);
        eastArrow = new NamedImageSingleton("NSMenuSubmenu");
        eastArrowIcon = new IconUIResourceSingleton(eastArrow);
        windowBackgroundColor = new ColorUIResource(236, 236, 236);
        desktopBackgroundColor = new ColorUIResource(65, 105, 170);
        textSelectionBackgroundColor = new ColorUIResource(179, 215, 255);
        textSelectionForegroundColor = new ColorUIResource(0, 0, 0);
        selectionBackgroundColor = new ColorUIResource(0, 104, 217);
        selctionForegroundColor = new ColorUIResource(255, 255, 255);
        comboBoxSelectionBackgroundColor = new ColorUIResource(0, 104, 217);
        comboBoxSelectionForegroundColor = new ColorUIResource(217, 233, 250);
        focusRingColor = new Color(62, 156, 246, 128);
        selectionInactiveBackgroundColor = new ColorUIResource(220, 220, 220);
        selectionInactiveForegroundColor = new ColorUIResource(0, 0, 0);
    }

    private static class TemplateFilter
    extends RGBImageFilter {
        private final int replacementAlpha;
        private final int replacementRGB;
        private final boolean isForTesting;
        private boolean isTemplate;

        public TemplateFilter(Color replacementColor, boolean isForTesting) {
            this.replacementRGB = replacementColor.getRGB() & 0xFFFFFF;
            this.replacementAlpha = replacementColor.getAlpha();
            this.isForTesting = isForTesting;
            this.canFilterIndexColorModel = true;
            this.isTemplate = true;
        }

        @Override
        public Object clone() {
            if (this.isForTesting) {
                return this;
            }
            return super.clone();
        }

        public boolean isTemplate() {
            return this.isTemplate;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int alpha = rgb >> 24 & 0xFF;
            int color = rgb & 0xFFFFFF;
            if (alpha != 0 && color != 0) {
                this.isTemplate = false;
            }
            alpha = alpha * this.replacementAlpha / 255;
            return alpha << 24 | this.replacementRGB;
        }
    }

    private static abstract class IconImageFilter
    extends RGBImageFilter {
        IconImageFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public final int filterRGB(int x, int y, int rgb) {
            int red = rgb >> 16 & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb & 0xFF;
            int gray = this.getGreyFor((int)((0.3 * (double)red + 0.59 * (double)green + 0.11 * (double)blue) / 3.0));
            return rgb & 0xFF000000 | IconImageFilter.grayTransform(red, gray) << 16 | IconImageFilter.grayTransform(green, gray) << 8 | IconImageFilter.grayTransform(blue, gray) << 0;
        }

        private static int grayTransform(int color, int gray) {
            int result = color - gray;
            if (result < 0) {
                result = 0;
            }
            if (result > 255) {
                result = 255;
            }
            return result;
        }

        abstract int getGreyFor(int var1);
    }

    private static class GenerateDisabledLightFilter
    extends RGBImageFilter {
        public GenerateDisabledLightFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int red = rgb >> 16 & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb & 0xFF;
            return rgb & 0xFF000000 | this.transform(red) << 16 | this.transform(green) << 8 | this.transform(blue) << 0;
        }

        protected int transform(int c) {
            int result = 255 - (255 - c) * 50 / 100;
            if (result < 0) {
                result = 0;
            }
            if (result > 255) {
                result = 255;
            }
            return result;
        }
    }

    private static class GeneratePressedDarkFilter
    extends RGBImageFilter {
        public GeneratePressedDarkFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int red = rgb >> 16 & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb & 0xFF;
            return rgb & 0xFF000000 | this.transform(red) << 16 | this.transform(green) << 8 | this.transform(blue) << 0;
        }

        protected int transform(int c) {
            int result = c * 40 / 100;
            if (result < 0) {
                result = 0;
            }
            if (result > 255) {
                result = 255;
            }
            return result;
        }
    }

    private static class GenerateSelectedDarkFilter
    extends IconImageFilter {
        private GenerateSelectedDarkFilter() {
        }

        @Override
        int getGreyFor(int gray) {
            return gray * 75 / 100;
        }
    }

    public static class SlicedImageControl {
        final BufferedImage NW;
        final BufferedImage N;
        final BufferedImage NE;
        final BufferedImage W;
        final BufferedImage C;
        final BufferedImage E;
        final BufferedImage SW;
        final BufferedImage S;
        final BufferedImage SE;
        final NineSliceMetrics metrics;
        final int totalWidth;
        final int totalHeight;
        final int centerColWidth;
        final int centerRowHeight;

        public SlicedImageControl(Image img, int westCut, int eastCut, int northCut, int southCut) {
            this(img, westCut, eastCut, northCut, southCut, true);
        }

        public SlicedImageControl(Image img, int westCut, int eastCut, int northCut, int southCut, boolean useMiddle) {
            this(img, westCut, eastCut, northCut, southCut, useMiddle, true, true);
        }

        public SlicedImageControl(Image img, int westCut, int eastCut, int northCut, int southCut, boolean useMiddle, boolean stretchHorizontally, boolean stretchVertically) {
            this(img, new NineSliceMetrics(img.getWidth(null), img.getHeight(null), westCut, eastCut, northCut, southCut, useMiddle, stretchHorizontally, stretchVertically));
        }

        public SlicedImageControl(Image img, NineSliceMetrics metrics) {
            this.metrics = metrics;
            if (img.getWidth(null) != metrics.minW || img.getHeight(null) != metrics.minH) {
                throw new IllegalArgumentException("SlicedImageControl: template image and NineSliceMetrics don't agree on minimum dimensions");
            }
            this.totalWidth = metrics.minW;
            this.totalHeight = metrics.minH;
            this.centerColWidth = this.totalWidth - metrics.wCut - metrics.eCut;
            this.centerRowHeight = this.totalHeight - metrics.nCut - metrics.sCut;
            this.NW = SlicedImageControl.createSlice(img, 0, 0, metrics.wCut, metrics.nCut);
            this.N = SlicedImageControl.createSlice(img, metrics.wCut, 0, this.centerColWidth, metrics.nCut);
            this.NE = SlicedImageControl.createSlice(img, this.totalWidth - metrics.eCut, 0, metrics.eCut, metrics.nCut);
            this.W = SlicedImageControl.createSlice(img, 0, metrics.nCut, metrics.wCut, this.centerRowHeight);
            this.C = metrics.showMiddle ? SlicedImageControl.createSlice(img, metrics.wCut, metrics.nCut, this.centerColWidth, this.centerRowHeight) : null;
            this.E = SlicedImageControl.createSlice(img, this.totalWidth - metrics.eCut, metrics.nCut, metrics.eCut, this.centerRowHeight);
            this.SW = SlicedImageControl.createSlice(img, 0, this.totalHeight - metrics.sCut, metrics.wCut, metrics.sCut);
            this.S = SlicedImageControl.createSlice(img, metrics.wCut, this.totalHeight - metrics.sCut, this.centerColWidth, metrics.sCut);
            this.SE = SlicedImageControl.createSlice(img, this.totalWidth - metrics.eCut, this.totalHeight - metrics.sCut, metrics.eCut, metrics.sCut);
        }

        static BufferedImage createSlice(Image img, int x, int y, int w, int h) {
            if (w == 0 || h == 0) {
                return null;
            }
            BufferedImage slice = new BufferedImage(w, h, 3);
            Graphics2D g2d = slice.createGraphics();
            g2d.drawImage(img, 0, 0, w, h, x, y, x + w, y + h, null);
            g2d.dispose();
            return slice;
        }

        public void paint(Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            if (w < this.totalWidth || h < this.totalHeight) {
                this.paintCompressed(g, w, h);
            } else {
                this.paintStretchedMiddles(g, w, h);
            }
            g.translate(-x, -y);
        }

        void paintStretchedMiddles(Graphics g, int w, int h) {
            int adjustedHeight;
            int baseX = this.metrics.stretchH ? 0 : w / 2 - this.totalWidth / 2;
            int baseY = this.metrics.stretchV ? 0 : h / 2 - this.totalHeight / 2;
            int adjustedWidth = this.metrics.stretchH ? w : this.totalWidth;
            int n = adjustedHeight = this.metrics.stretchV ? h : this.totalHeight;
            if (this.NW != null) {
                g.drawImage(this.NW, baseX, baseY, null);
            }
            if (this.N != null) {
                g.drawImage(this.N, baseX + this.metrics.wCut, baseY, adjustedWidth - this.metrics.eCut - this.metrics.wCut, this.metrics.nCut, null);
            }
            if (this.NE != null) {
                g.drawImage(this.NE, baseX + adjustedWidth - this.metrics.eCut, baseY, null);
            }
            if (this.W != null) {
                g.drawImage(this.W, baseX, baseY + this.metrics.nCut, this.metrics.wCut, adjustedHeight - this.metrics.nCut - this.metrics.sCut, null);
            }
            if (this.C != null) {
                g.drawImage(this.C, baseX + this.metrics.wCut, baseY + this.metrics.nCut, adjustedWidth - this.metrics.eCut - this.metrics.wCut, adjustedHeight - this.metrics.nCut - this.metrics.sCut, null);
            }
            if (this.E != null) {
                g.drawImage(this.E, baseX + adjustedWidth - this.metrics.eCut, baseY + this.metrics.nCut, this.metrics.eCut, adjustedHeight - this.metrics.nCut - this.metrics.sCut, null);
            }
            if (this.SW != null) {
                g.drawImage(this.SW, baseX, baseY + adjustedHeight - this.metrics.sCut, null);
            }
            if (this.S != null) {
                g.drawImage(this.S, baseX + this.metrics.wCut, baseY + adjustedHeight - this.metrics.sCut, adjustedWidth - this.metrics.eCut - this.metrics.wCut, this.metrics.sCut, null);
            }
            if (this.SE != null) {
                g.drawImage(this.SE, baseX + adjustedWidth - this.metrics.eCut, baseY + adjustedHeight - this.metrics.sCut, null);
            }
        }

        void paintCompressed(Graphics g, int w, int h) {
            double heightRatio = h > this.totalHeight ? 1.0 : (double)h / (double)this.totalHeight;
            double widthRatio = w > this.totalWidth ? 1.0 : (double)w / (double)this.totalWidth;
            int northHeight = (int)((double)this.metrics.nCut * heightRatio);
            int southHeight = (int)((double)this.metrics.sCut * heightRatio);
            int centerHeight = h - northHeight - southHeight;
            int westWidth = (int)((double)this.metrics.wCut * widthRatio);
            int eastWidth = (int)((double)this.metrics.eCut * widthRatio);
            int centerWidth = w - westWidth - eastWidth;
            if (this.NW != null) {
                g.drawImage(this.NW, 0, 0, westWidth, northHeight, null);
            }
            if (this.N != null) {
                g.drawImage(this.N, westWidth, 0, centerWidth, northHeight, null);
            }
            if (this.NE != null) {
                g.drawImage(this.NE, w - eastWidth, 0, eastWidth, northHeight, null);
            }
            if (this.W != null) {
                g.drawImage(this.W, 0, northHeight, westWidth, centerHeight, null);
            }
            if (this.C != null) {
                g.drawImage(this.C, westWidth, northHeight, centerWidth, centerHeight, null);
            }
            if (this.E != null) {
                g.drawImage(this.E, w - eastWidth, northHeight, eastWidth, centerHeight, null);
            }
            if (this.SW != null) {
                g.drawImage(this.SW, 0, h - southHeight, westWidth, southHeight, null);
            }
            if (this.S != null) {
                g.drawImage(this.S, westWidth, h - southHeight, centerWidth, southHeight, null);
            }
            if (this.SE != null) {
                g.drawImage(this.SE, w - eastWidth, h - southHeight, eastWidth, southHeight, null);
            }
        }
    }

    public static class NineSliceMetrics {
        public final int wCut;
        public final int eCut;
        public final int nCut;
        public final int sCut;
        public final int minW;
        public final int minH;
        public final boolean showMiddle;
        public final boolean stretchH;
        public final boolean stretchV;

        public NineSliceMetrics(int minWidth, int minHeight, int westCut, int eastCut, int northCut, int southCut) {
            this(minWidth, minHeight, westCut, eastCut, northCut, southCut, true);
        }

        public NineSliceMetrics(int minWidth, int minHeight, int westCut, int eastCut, int northCut, int southCut, boolean showMiddle) {
            this(minWidth, minHeight, westCut, eastCut, northCut, southCut, showMiddle, true, true);
        }

        public NineSliceMetrics(int minWidth, int minHeight, int westCut, int eastCut, int northCut, int southCut, boolean showMiddle, boolean stretchHorizontally, boolean stretchVertically) {
            this.wCut = westCut;
            this.eCut = eastCut;
            this.nCut = northCut;
            this.sCut = southCut;
            this.minW = minWidth;
            this.minH = minHeight;
            this.showMiddle = showMiddle;
            this.stretchH = stretchHorizontally;
            this.stretchV = stretchVertically;
        }
    }

    static class InvertableImageIcon
    extends ImageIcon
    implements AquaIcon.InvertableIcon,
    UIResource {
        Icon invertedImage;

        public InvertableImageIcon(Image image) {
            super(image);
        }

        @Override
        public Icon getInvertedIcon() {
            if (this.invertedImage != null) {
                return this.invertedImage;
            }
            this.invertedImage = new IconUIResource(new ImageIcon(AquaImageFactory.generateLightenedImage(this.getImage(), 100)));
            return this.invertedImage;
        }
    }

    static class IconUIResourceSingleton
    extends AquaUtils.RecyclableSingleton<IconUIResource> {
        final NamedImageSingleton holder;

        public IconUIResourceSingleton(NamedImageSingleton holder) {
            this.holder = holder;
        }

        @Override
        protected IconUIResource getInstance() {
            return new IconUIResource(new ImageIcon((Image)this.holder.get()));
        }
    }

    static class NamedImageSingleton
    extends AquaUtils.RecyclableSingleton<Image> {
        final String namedImage;

        NamedImageSingleton(String namedImage) {
            this.namedImage = namedImage;
        }

        @Override
        protected Image getInstance() {
            return AquaImageFactory.getNSIcon(this.namedImage);
        }
    }

    private static class TreeDocumentIconUIResourceSingleton
    extends AquaUtils.RecyclableSingleton<IconUIResource> {
        private TreeDocumentIconUIResourceSingleton() {
        }

        @Override
        protected IconUIResource getInstance() {
            Image im = OSXFile.getFileIconImage(20);
            return new IconUIResource(new ImageIcon(im));
        }
    }

    private static class TreeOpenFolderIconUIResourceSingleton
    extends AquaUtils.RecyclableSingleton<IconUIResource> {
        private TreeOpenFolderIconUIResourceSingleton() {
        }

        @Override
        protected IconUIResource getInstance() {
            return AquaIcon.getOpenFolderIcon();
        }
    }

    private static class TreeFolderIconUIResourceSingleton
    extends AquaUtils.RecyclableSingleton<IconUIResource> {
        private TreeFolderIconUIResourceSingleton() {
        }

        @Override
        protected IconUIResource getInstance() {
            Image im = OSXFile.getDirectoryIconImage(20);
            return new IconUIResource(new ImageIcon(im));
        }
    }

    private static class ImageFileIconCreator {
        private String path;
        private int width;
        private int height;
        private Image result;

        public ImageFileIconCreator(File file, int width, int height) {
            this.path = file.getAbsolutePath();
            this.width = width;
            this.height = height;
        }

        public Image getImage() {
            if (this.result == null) {
                AquaNativeSupport.load();
                int[][] buffers = new int[2][];
                if (!AquaImageFactory.nativeRenderImageFile(this.path, buffers, this.width, this.height)) {
                    if (debugNativeRendering) {
                        System.err.println("Failed to render image file " + this.path);
                    }
                    throw new UnsupportedOperationException();
                }
                if (debugNativeRendering) {
                    System.err.println("Rendered image file " + this.path);
                }
                this.result = AquaMultiResolutionImage.createImage(this.width, this.height, buffers[0], buffers[1]);
            }
            return this.result;
        }
    }

    private static class AppIconCompositor
    implements AquaMultiResolutionImage.Mapper {
        private AppIconCompositor() {
        }

        @Override
        public BufferedImage map(Image source, int scaleFactor) {
            return AquaImageFactory.getAppIconImageCompositedOn(source, scaleFactor);
        }
    }
}

