/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import javax.swing.TransferHandler;
import javax.swing.event.MouseInputAdapter;
import org.violetlib.aqua.AquaDragRecognitionSupport;
import org.violetlib.aqua.GenericList;

public class AquaListMouseBehavior
extends MouseInputAdapter {
    protected GenericList list;
    protected final int OP_SELECT = 1;
    protected final int OP_INTERVAL = 2;
    protected final int OP_TOGGLE = 3;
    protected int targetIndex;
    protected boolean dragWouldTransfer;
    protected int mouseReleaseOp;
    protected int mouseDragOp;
    protected boolean isMultipleSelection;
    protected int mouseDragOpPreviousIndex;
    protected MouseEvent armedEvent;
    protected int dragThreshold;
    protected boolean isDragging;

    public AquaListMouseBehavior(GenericList list) {
        this.list = list;
    }

    public void processMouseEvent(MouseEvent e) {
        int id = e.getID();
        if (id == 501) {
            this.mousePressed(e);
        } else if (id == 502) {
            this.mouseReleased(e);
        } else if (id == 506) {
            this.mouseDragged(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.armedEvent = e;
        this.dragThreshold = DragSource.getDragThreshold();
        this.list.requestFocus();
        this.mouseReleaseOp = 0;
        this.mouseDragOp = 0;
        this.targetIndex = -1;
        this.dragWouldTransfer = false;
        this.isDragging = false;
        if (!this.list.isEnabled() || e.isPopupTrigger()) {
            return;
        }
        this.isMultipleSelection = this.list.isMultipleSelection();
        this.interpretLocation(e);
        int op = this.getSelectionOperation(e);
        if (this.targetIndex < 0) {
            this.mousePressedOutsideCell(op);
        }
        this.mouseDragOpPreviousIndex = this.targetIndex;
        if (op != 0) {
            if (this.isMousePressedOperation(op)) {
                this.performSelectionOperation(op);
            } else {
                this.mouseReleaseOp = op;
            }
            if (!this.dragWouldTransfer) {
                this.mouseDragOp = op;
            }
        }
        this.list.setValueIsAdjusting(this.mouseDragOp != 0);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        TransferHandler th;
        int action;
        if (this.armedEvent == null) {
            return;
        }
        if (this.list.isDragEnabled() && (action = AquaDragRecognitionSupport.mapDragOperationFromModifiers(e, th = this.list.getTransferHandler())) != 0 && !this.list.isRowSelected(this.targetIndex)) {
            this.setSelectionInterval(this.targetIndex, this.targetIndex);
        }
        if (!this.isDragging) {
            int dy;
            int dx = Math.abs(e.getX() - this.armedEvent.getX());
            boolean bl = this.isDragging = Math.sqrt(dx * dx + (dy = Math.abs(e.getY() - this.armedEvent.getY())) * dy) > (double)this.dragThreshold;
        }
        if (this.isDragging) {
            this.mouseReleaseOp = 0;
            if (this.mouseDragOp != 0) {
                this.targetIndex = this.getIndex(e);
                if (this.targetIndex != -1 && this.targetIndex != this.mouseDragOpPreviousIndex) {
                    this.list.scrollToViewRows(this.targetIndex, this.targetIndex);
                    if (!this.isMultipleSelection) {
                        this.performSelectionOperation(1);
                    } else {
                        int anchorIndex = this.getAnchor();
                        if (this.targetIndex > anchorIndex && this.targetIndex > this.mouseDragOpPreviousIndex) {
                            this.performDragSelectionOperation(this.mouseDragOp, this.mouseDragOpPreviousIndex + 1, this.targetIndex, true);
                        } else if (this.targetIndex < anchorIndex && this.targetIndex < this.mouseDragOpPreviousIndex) {
                            this.performDragSelectionOperation(this.mouseDragOp, this.mouseDragOpPreviousIndex - 1, this.targetIndex, true);
                        } else if (this.targetIndex >= anchorIndex && this.targetIndex < this.mouseDragOpPreviousIndex) {
                            this.performDragSelectionOperation(this.mouseDragOp, this.targetIndex + 1, this.mouseDragOpPreviousIndex, false);
                        } else if (this.targetIndex <= anchorIndex && this.targetIndex > this.mouseDragOpPreviousIndex) {
                            this.performDragSelectionOperation(this.mouseDragOp, this.targetIndex - 1, this.mouseDragOpPreviousIndex, false);
                        }
                    }
                    this.mouseDragOpPreviousIndex = this.targetIndex;
                }
            } else if (this.list.isDragEnabled() && (action = AquaDragRecognitionSupport.mapDragOperationFromModifiers(e, th = this.list.getTransferHandler())) != 0) {
                th.exportAsDrag(this.list.getComponent(), this.armedEvent, action);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.mouseReleaseOp != 0) {
            this.performSelectionOperation(this.mouseReleaseOp);
            this.mouseReleaseOp = 0;
        }
        this.list.setValueIsAdjusting(false);
    }

    protected int getSelectionOperation(MouseEvent e) {
        int mods = e.getModifiersEx();
        if ((mods & 0x1900) == 256) {
            return 3;
        }
        if ((mods & 0x1840) == 64) {
            return 2;
        }
        if ((e.getModifiersEx() & 0x140) == 0) {
            return 1;
        }
        return 0;
    }

    protected boolean isMousePressedOperation(int op) {
        if (op == 1) {
            return !this.dragWouldTransfer;
        }
        if (op == 2) {
            return true;
        }
        if (op == 3) {
            return !this.list.isRowSelected(this.targetIndex) || !this.dragWouldTransfer;
        }
        return true;
    }

    protected void interpretLocation(MouseEvent e) {
        this.targetIndex = this.getIndex(e);
        this.dragWouldTransfer = this.list.isDragEnabled();
    }

    protected int getIndex(MouseEvent e) {
        return this.list.identifyRowAtLocation(e.getPoint());
    }

    protected void mousePressedOutsideCell(int op) {
        this.list.clearSelection();
        if (op == 3) {
            op = 1;
        }
        if (op == 1) {
            int lastIndex = this.list.getRowCount() - 1;
            this.list.setAnchorSelectionIndex(lastIndex);
        } else {
            this.list.setAnchorSelectionIndex(0);
        }
        this.dragWouldTransfer = false;
    }

    protected void performSelectionOperation(int op) {
        if (this.targetIndex < 0) {
            return;
        }
        if (op == 2 && !this.isMultipleSelection) {
            op = 1;
        }
        if (op == 3) {
            this.toggleSelection(this.targetIndex);
        } else if (op == 2) {
            int anchorIndex = this.getAnchor();
            this.selectInterval(anchorIndex, this.targetIndex);
        } else if (op == 1) {
            this.setSelectionInterval(this.targetIndex, this.targetIndex);
        }
    }

    protected void performDragSelectionOperation(int op, int index1, int index2, boolean isExtending) {
        if (!this.isMultipleSelection) {
            this.setSelectionInterval(this.targetIndex, this.targetIndex);
            return;
        }
        if (op == 3) {
            int anchorIndex = this.getAnchor();
            this.toggleSelectionInterval(index1, index2);
            this.list.setAnchorSelectionIndex(anchorIndex);
        } else if (op == 2 || op == 1) {
            int anchorIndex = this.getAnchor();
            this.setSelectionInterval(anchorIndex, this.targetIndex);
        }
    }

    protected void toggleSelection(int index) {
        if (this.list.isRowSelected(index)) {
            int anchorIndex = this.getAnchor();
            this.removeSelectionInterval(index, index);
            if (index == anchorIndex) {
                this.updateAnchor(anchorIndex);
            } else {
                this.list.setAnchorSelectionIndex(anchorIndex);
            }
        } else {
            this.addSelectionInterval(index, index);
            this.list.setAnchorSelectionIndex(index);
        }
    }

    protected void selectInterval(int anchorIndex, int targetIndex) {
        this.list.setValueIsAdjusting(true);
        int direction = targetIndex - anchorIndex;
        this.trimSelectedInterval(anchorIndex, -direction);
        if (this.list.isRowSelected(targetIndex)) {
            this.trimSelectedInterval(targetIndex, direction);
        } else {
            this.addSelectionInterval(anchorIndex, targetIndex);
        }
        this.list.setAnchorSelectionIndex(anchorIndex);
        this.list.setValueIsAdjusting(false);
    }

    protected int getAnchor() {
        int anchorIndex = this.list.getAnchorSelectionIndex();
        return Math.max(0, anchorIndex);
    }

    protected void updateAnchor(int oldAnchor) {
        int i;
        int count = this.list.getRowCount();
        for (i = oldAnchor + 1; i < count; ++i) {
            if (!this.list.isRowSelected(i)) continue;
            this.list.setAnchorSelectionIndex(i);
            return;
        }
        for (i = oldAnchor - 1; i >= 0; --i) {
            if (!this.list.isRowSelected(i)) continue;
            this.list.setAnchorSelectionIndex(i);
            return;
        }
        this.list.setAnchorSelectionIndex(0);
    }

    protected void trimSelectedInterval(int index, int direction) {
        block3: {
            block2: {
                if (direction <= 0) break block2;
                int count = this.list.getRowCount();
                while (++index < count && this.list.isRowSelected(index)) {
                    this.list.removeSelectionInterval(index, index);
                }
                break block3;
            }
            if (direction >= 0) break block3;
            while (--index >= 0 && this.list.isRowSelected(index)) {
                this.list.removeSelectionInterval(index, index);
            }
        }
    }

    protected void setSelectionInterval(int index1, int index2) {
        this.list.setSelectionInterval(index1, index2);
    }

    protected void addSelectionInterval(int index1, int index2) {
        this.list.addSelectionInterval(index1, index2);
    }

    protected void removeSelectionInterval(int index1, int index2) {
        this.list.removeSelectionInterval(index1, index2);
    }

    protected void toggleSelectionInterval(int index1, int index2) {
        int delta = index1 > index2 ? -1 : 1;
        int index = index1;
        while (true) {
            if (!this.list.isRowSelected(index)) {
                this.list.addSelectionInterval(index, index);
            } else {
                this.list.removeSelectionInterval(index, index);
            }
            if (index == index2) {
                return;
            }
            index += delta;
        }
    }
}

