/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import org.violetlib.aqua.AquaBorder;
import org.violetlib.aqua.AquaComboBoxRenderer;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaListMouseBehavior;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.JListModel;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.GradientConfiguration;

public class AquaListUI
extends BasicListUI {
    public static final String LIST_STYLE_KEY = "JList.style";
    public static final String QUAQUA_LIST_STYLE_KEY = "Quaqua.List.style";
    private boolean isStriped = false;
    protected Color[] stripes = new Color[]{UIManager.getColor("List.evenRowBackground"), UIManager.getColor("List.oddRowBackground")};

    public static ComponentUI createUI(JComponent c) {
        return new AquaListUI();
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new AquaListMouseBehavior(new JListModel(this.list));
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.list.putClientProperty("JComponent.isCellContainer", true);
        this.updateStriped();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.list.getActionMap().put("aquaHome", new AquaHomeEndAction(true));
        this.list.getActionMap().put("aquaEnd", new AquaHomeEndAction(false));
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new AquaPropertyChangeHandler();
    }

    protected boolean isStyleProperty(String prop) {
        return AquaUtils.isProperty(prop, LIST_STYLE_KEY, QUAQUA_LIST_STYLE_KEY);
    }

    protected String getStyleProperty() {
        return AquaUtils.getProperty(this.list, LIST_STYLE_KEY, QUAQUA_LIST_STYLE_KEY);
    }

    protected void repaintSelection() {
        Rectangle r;
        AquaFocusHandler.swapSelectionColors("List", this.list, (Object)AquaFocusHandler.hasFocus(this.list));
        List cells = this.list.getSelectedValuesList();
        if (cells.size() > 1) {
            this.list.repaint();
            return;
        }
        int leadIndex = this.list.getLeadSelectionIndex();
        if (leadIndex != -1 && (r = this.getCellBounds(this.list, leadIndex, leadIndex)) != null) {
            this.list.repaint(r.x, r.y, r.width, r.height);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.paintStripes(g, c);
        super.paint(g, c);
    }

    protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        Object value = dataModel.getElementAt(row);
        boolean isEnabled = this.list.isEnabled();
        boolean isFocused = isEnabled && AquaFocusHandler.hasFocus(this.list);
        boolean cellHasFocus = isFocused && row == leadIndex;
        boolean isSelected = selModel.isSelectedIndex(row);
        int cx = rowBounds.x;
        int cy = rowBounds.y;
        int cw = rowBounds.width;
        int ch = rowBounds.height;
        if (this.list.isOpaque() || isSelected) {
            Color c = isSelected ? this.list.getSelectionBackground() : (this.isStriped ? this.getAlternateColor(row % 2) : this.list.getBackground());
            g.setColor(c);
            g.fillRect(cx, cy, cw, ch);
        }
        Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, row, isSelected, cellHasFocus);
        Color bc = this.getOverrideCellBackground(row, isSelected);
        if (bc != null) {
            rendererComponent.setBackground(bc);
        }
        this.rendererPane.paintComponent(g, rendererComponent, this.list, cx, cy, cw, ch, true);
    }

    protected Color getOverrideCellBackground(int index, boolean isSelected) {
        if (!this.isStriped) {
            return null;
        }
        if (isSelected) {
            return null;
        }
        JList.DropLocation dropLocation = this.list.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
            return null;
        }
        return this.getAlternateColor(index % 2);
    }

    public void paintStripes(Graphics g, JComponent c) {
        if (this.isStriped && this.list.getModel() != null) {
            int y;
            Dimension vs = c.getSize();
            Dimension ts = this.list.getSize();
            Point p = this.list.getLocation();
            int rh = this.list.getFixedCellHeight();
            int n = this.list.getModel().getSize();
            if (rh <= 0) {
                rh = n == 0 ? 12 : this.getCellBounds(this.list, (int)0, (int)0).height;
            }
            int row = Math.abs(p.y / rh);
            int th = n * rh - row * rh;
            g.setColor(this.getAlternateColor(1));
            g.fillRect(0, 0, ts.width, ts.height);
            g.setColor(this.getAlternateColor(0));
            if (ts.width < vs.width) {
                y = p.y + row * rh;
                while (y < th) {
                    if (row % 2 == 0) {
                        g.fillRect(0, y, vs.width, rh);
                    }
                    y += rh;
                    ++row;
                }
            }
            if (th < vs.height) {
                row = n;
                y = th;
                while (y < vs.height) {
                    if (row % 2 == 0) {
                        g.fillRect(0, y, vs.width, rh);
                    }
                    y += rh;
                    ++row;
                }
            }
        }
    }

    private Color getAlternateColor(int modulo) {
        return this.stripes[modulo];
    }

    private void updateStriped() {
        String value = this.getStyleProperty();
        this.isStriped = value != null && value.equals("striped") && this.list.getLayoutOrientation() == 0;
    }

    protected void repaintCell(Object value, int selectedIndex, boolean selected) {
        AquaComboBoxRenderer aquaRenderer;
        Rectangle rowBounds = this.getCellBounds(this.list, selectedIndex, selectedIndex);
        if (rowBounds == null) {
            return;
        }
        ListCellRenderer<Object> renderer = this.list.getCellRenderer();
        if (renderer == null) {
            return;
        }
        Component rendererComponent = renderer.getListCellRendererComponent(this.list, value, selectedIndex, selected, true);
        if (rendererComponent == null) {
            return;
        }
        AquaComboBoxRenderer aquaComboBoxRenderer = aquaRenderer = renderer instanceof AquaComboBoxRenderer ? (AquaComboBoxRenderer)renderer : null;
        if (aquaRenderer != null) {
            aquaRenderer.setDrawCheckedItem(false);
        }
        this.rendererPane.paintComponent(this.list.getGraphics().create(), rendererComponent, this.list, rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height, true);
        if (aquaRenderer != null) {
            aquaRenderer.setDrawCheckedItem(true);
        }
    }

    public static Border getSourceListBackgroundPainter() {
        return new GradientPainter(AquaUIPainter.GradientWidget.GRADIENT_SIDE_BAR);
    }

    public static Border getSourceListSelectionBackgroundPainter() {
        return new GradientPainter(AquaUIPainter.GradientWidget.GRADIENT_SIDE_BAR_SELECTION);
    }

    public static Border getSourceListFocusedSelectionBackgroundPainter() {
        return new GradientPainter(AquaUIPainter.GradientWidget.GRADIENT_SIDE_BAR_SELECTION);
    }

    public static Border getListEvenBackgroundPainter() {
        return new GradientPainter(AquaUIPainter.GradientWidget.GRADIENT_LIST_BACKGROUND_EVEN);
    }

    public static Border getListOddBackgroundPainter() {
        return new GradientPainter(AquaUIPainter.GradientWidget.GRADIENT_LIST_BACKGROUND_ODD);
    }

    static class GradientPainter
    extends AquaBorder {
        protected final AquaUIPainter.GradientWidget gw;

        public GradientPainter(AquaUIPainter.GradientWidget gw) {
            this.gw = gw;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JComponent jc = c instanceof JComponent ? (JComponent)c : null;
            AquaUIPainter.State state = jc != null && !AquaFocusHandler.isActive(jc) ? AquaUIPainter.State.ACTIVE : AquaUIPainter.State.INACTIVE;
            this.painter.configure(w, h);
            GradientConfiguration bg = new GradientConfiguration(this.gw, state);
            this.painter.getPainter(bg).paint(g, x, y);
        }
    }

    class AquaPropertyChangeHandler
    extends BasicListUI.PropertyChangeHandler {
        AquaPropertyChangeHandler() {
            super(AquaListUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if ("Frame.active".equals(prop) || "enabled".equals(prop)) {
                AquaListUI.this.repaintSelection();
            } else {
                if (AquaListUI.this.isStyleProperty(prop)) {
                    AquaListUI.this.updateStriped();
                } else if ("layoutOrientation".equals(prop)) {
                    AquaListUI.this.updateStriped();
                }
                super.propertyChange(e);
            }
        }
    }

    protected class FocusHandler
    implements FocusListener {
        protected FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent event) {
            AquaListUI.this.repaintSelection();
        }

        @Override
        public void focusLost(FocusEvent event) {
            AquaListUI.this.repaintSelection();
        }
    }

    static class AquaHomeEndAction
    extends AbstractAction {
        private boolean fHomeAction = false;

        protected AquaHomeEndAction(boolean isHomeAction) {
            this.fHomeAction = isHomeAction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JList list = (JList)e.getSource();
            if (this.fHomeAction) {
                list.ensureIndexIsVisible(0);
            } else {
                int size = list.getModel().getSize();
                list.ensureIndexIsVisible(size - 1);
            }
        }
    }
}

