/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicLookAndFeel;
import org.violetlib.aqua.AquaButtonBorder;
import org.violetlib.aqua.AquaButtonUI;
import org.violetlib.aqua.AquaFocusRingManager;
import org.violetlib.aqua.AquaFonts;
import org.violetlib.aqua.AquaGroupBorder;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaKeyBindings;
import org.violetlib.aqua.AquaListUI;
import org.violetlib.aqua.AquaMenuBarBorder;
import org.violetlib.aqua.AquaMenuItemBorder;
import org.violetlib.aqua.AquaMenuPainter;
import org.violetlib.aqua.AquaMnemonicHandler;
import org.violetlib.aqua.AquaNativeSupport;
import org.violetlib.aqua.AquaPopupFactory;
import org.violetlib.aqua.AquaRootPaneUI;
import org.violetlib.aqua.AquaSheetSupport;
import org.violetlib.aqua.AquaTableHeaderBorder;
import org.violetlib.aqua.AquaTableScrollPaneCorner;
import org.violetlib.aqua.AquaTextFieldBorder;
import org.violetlib.aqua.AquaToolBarUI;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.fc.AquaBrowserSizeHandleIcon;
import org.violetlib.aqua.fc.OSXFile;
import org.violetlib.jnr.aqua.AquaNativeRendering;

public class AquaLookAndFeel
extends BasicLookAndFeel {
    private static final String PKG_PREFIX = "org.violetlib.aqua.";
    private AquaFocusRingManager focusRingManager;
    private PropertyChangeListener uiChangeListener;
    private AquaPopupFactory popupFactory;
    public static boolean suppressCreationOfDisabledButtonIcons;

    @Override
    public String getName() {
        return "VAqua";
    }

    @Override
    public String getID() {
        return "VAqua";
    }

    @Override
    public String getDescription() {
        return "VAqua Look and Feel for Mac OS X";
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return false;
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return true;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return AquaNativeSupport.load();
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.popupFactory == null) {
            this.popupFactory = new AquaPopupFactory();
            PopupFactory.setSharedInstance(this.popupFactory);
        }
        this.popupFactory.setActive(true);
        this.focusRingManager = AquaFocusRingManager.getInstance();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(AquaMnemonicHandler.getInstance());
        if (this.uiChangeListener == null) {
            this.uiChangeListener = new MyUIChangeListener();
        }
        UIManager.addPropertyChangeListener(this.uiChangeListener);
    }

    @Override
    public void uninitialize() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(AquaMnemonicHandler.getInstance());
        UIManager.removePropertyChangeListener(this.uiChangeListener);
        if (this.focusRingManager != null) {
            this.focusRingManager.uninstall();
            this.focusRingManager = null;
        }
        this.popupFactory.setActive(false);
        super.uninitialize();
    }

    @Override
    public Icon getDisabledIcon(JComponent component, Icon icon) {
        if (!suppressCreationOfDisabledButtonIcons) {
            AquaButtonUI ui;
            if (icon instanceof ImageIcon && component instanceof AbstractButton && (ui = AquaUtils.getUI(component, AquaButtonUI.class)) != null) {
                return ui.createDisabledIcon((AbstractButton)component, (ImageIcon)icon);
            }
            return super.getDisabledIcon(component, icon);
        }
        return null;
    }

    @Override
    public Icon getDisabledSelectedIcon(JComponent component, Icon icon) {
        if (!suppressCreationOfDisabledButtonIcons) {
            AquaButtonUI ui;
            if (icon instanceof ImageIcon && component instanceof AbstractButton && (ui = AquaUtils.getUI(component, AquaButtonUI.class)) != null) {
                return ui.createDisabledSelectedIcon((AbstractButton)component, (ImageIcon)icon);
            }
            return super.getDisabledSelectedIcon(component, icon);
        }
        return null;
    }

    public void displayAsSheet(Window w, Runnable closeHandler) throws UnsupportedOperationException {
        AquaSheetSupport.displayAsSheet(w, closeHandler);
    }

    public void showOptionPaneAsSheet(JDialog d, JOptionPane pane, Consumer<Integer> resultConsumer) {
        AquaSheetSupport.showOptionPaneAsSheet(d, pane, resultConsumer);
    }

    public void showFileChooserAsSheet(Window owner, JFileChooser fc, Consumer<Integer> resultConsumer) {
        AquaSheetSupport.showFileChooserAsSheet(owner, fc, resultConsumer);
    }

    public void setForceActiveWindowDisplay(boolean b) {
        AquaRootPaneUI.setForceActiveWindowDisplay(b);
    }

    @Override
    protected ActionMap getAudioActionMap() {
        ActionMap audioActionMap = (ActionMap)UIManager.get("AuditoryCues.actionMap");
        if (audioActionMap != null) {
            return audioActionMap;
        }
        Object[] acList = (Object[])UIManager.get("AuditoryCues.cueList");
        if (acList != null) {
            audioActionMap = new ActionMapUIResource();
            for (int counter = acList.length - 1; counter >= 0; --counter) {
                audioActionMap.put(acList[counter], this.createAudioAction(acList[counter]));
            }
        }
        UIManager.getLookAndFeelDefaults().put("AuditoryCues.actionMap", audioActionMap);
        return audioActionMap;
    }

    protected static Object makeIcon(String location) {
        return new UIDefaults.ProxyLazyValue("org.violetlib.aqua.AquaIcon", "loadResource", new Object[]{location});
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults table = new UIDefaults();
        table.put("ClassLoader", this.getClass().getClassLoader());
        try {
            this.initClassDefaults(table);
            super.initSystemColorDefaults(table);
            super.initComponentDefaults(table);
            this.initSystemColorDefaults(table);
            this.initComponentDefaults(table);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return table;
    }

    private void initResourceBundle(UIDefaults table) {
        table.setDefaultLocale(Locale.getDefault());
        this.addResourceBundle(table, "org.violetlib.aqua.resources.aqua");
        this.addResourceBundle(table, "org.violetlib.aqua.Labels");
    }

    private void addResourceBundle(UIDefaults table, String name) {
        table.addResourceBundle(name);
        try {
            ResourceBundle aquaProperties = ResourceBundle.getBundle(name);
            Enumeration<String> propertyKeys = aquaProperties.getKeys();
            while (propertyKeys.hasMoreElements()) {
                String key = propertyKeys.nextElement();
                table.put(key, aquaProperties.getString(key));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        Color windowBackgroundColor;
        InsetsUIResource zeroInsets;
        this.initResourceBundle(table);
        InsetsUIResource menuItemMargin = zeroInsets = new InsetsUIResource(0, 0, 0, 0);
        UIDefaults.ActiveValue listCellRendererActiveValue = new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults defaultsTable) {
                return new DefaultListCellRenderer.UIResource();
            }
        };
        BorderUIResource.EmptyBorderUIResource toolTipBorder = new BorderUIResource.EmptyBorderUIResource(2, 0, 2, 0);
        ColorUIResource toolTipBackground = new ColorUIResource(255, 255, 204);
        ColorUIResource black = new ColorUIResource(Color.black);
        ColorUIResource white = new ColorUIResource(Color.white);
        ColorUIResource smokyGlass = new ColorUIResource(new Color(0, 0, 0, 152));
        ColorUIResource dockIconRim = new ColorUIResource(new Color(192, 192, 192, 192));
        ColorUIResource mediumTranslucentBlack = new ColorUIResource(new Color(0, 0, 0, 100));
        ColorUIResource disabled = new ColorUIResource(192, 192, 192);
        ColorUIResource disabledShadow = new ColorUIResource(0.25f, 0.25f, 0.25f);
        ColorUIResource selected = new ColorUIResource(1.0f, 0.4f, 0.4f);
        ColorUIResource alternateBackground = new ColorUIResource(245, 245, 245);
        ColorUIResource separator = new ColorUIResource(new Color(0, 0, 0, 25));
        ColorUIResource selectedTabTitlePressedColor = white;
        ColorUIResource selectedTabTitleDisabledColor = disabled;
        ColorUIResource selectedTabTitleNormalColor = white;
        ColorUIResource selectedTabTitleInactiveColor = black;
        ColorUIResource nonSelectedTabTitlePressedColor = black;
        ColorUIResource nonSelectedTabTitleDisabledColor = disabled;
        ColorUIResource nonSelectedTabTitleNormalColor = black;
        ColorUIResource nonSelectedTabTitleInactiveColor = black;
        ColorUIResource toolbarDragHandleColor = new ColorUIResource(140, 140, 140);
        UIDefaults.LazyValue marginBorder = t -> new BasicBorders.MarginBorder();
        boolean zero = false;
        InsetsUIResource editorMargin = zeroInsets;
        int textCaretBlinkRate = 500;
        UIDefaults.LazyValue textFieldBorder = t -> AquaTextFieldBorder.getTextFieldBorder();
        UIDefaults.LazyValue textAreaBorder = marginBorder;
        UIDefaults.LazyValue aquaTitledBorder = t -> AquaGroupBorder.getBorderForTitledBorder();
        UIDefaults.LazyValue aquaInsetBorder = t -> AquaGroupBorder.getTitlelessBorder();
        AquaTableHeaderBorder listHeaderBorder = AquaTableHeaderBorder.getListHeaderBorder();
        BorderUIResource.EmptyBorderUIResource zeroBorder = new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0);
        BorderUIResource.LineBorderUIResource scrollListBorder = new BorderUIResource.LineBorderUIResource(new Color(200, 200, 200), 1);
        BorderUIResource.CompoundBorderUIResource browserCellBorder = new BorderUIResource.CompoundBorderUIResource(new BorderUIResource.MatteBorderUIResource(0, 0, 1, 0, new ColorUIResource(0xFFFFFF)), new BorderUIResource.EmptyBorderUIResource(0, 4, 1, 0));
        Color listSelectionBackground = AquaImageFactory.getSelectionBackgroundColorUIResource();
        Color listSelectionForeground = AquaImageFactory.getSelectionForegroundColorUIResource();
        Color listSelectionInactiveBackground = AquaImageFactory.getSelectionInactiveBackgroundColorUIResource();
        Color listSelectionInactiveForeground = AquaImageFactory.getSelectionInactiveForegroundColorUIResource();
        Color comboBoxSelectionBackground = AquaImageFactory.getComboBoxSelectionBackgroundColorUIResource();
        Color comboBoxSelectionForeground = AquaImageFactory.getComboBoxSelectionForegroundColorUIResource();
        ColorUIResource toolBarTitleBackground = new ColorUIResource(211, 211, 211);
        Color textHighlightText = AquaImageFactory.getTextSelectionForegroundColorUIResource();
        Color textHighlight = AquaImageFactory.getTextSelectionBackgroundColorUIResource();
        ColorUIResource textHighlightInactive = new ColorUIResource(212, 212, 212);
        ColorUIResource gridColor = new ColorUIResource(200, 200, 200);
        ColorUIResource textInactiveText = disabled;
        ColorUIResource textForeground = black;
        ColorUIResource textBackground = white;
        ColorUIResource textInactiveBackground = white;
        ColorUIResource textPasswordFieldCapsLockIconColor = mediumTranslucentBlack;
        UIDefaults.LazyValue internalFrameBorder = t -> BasicBorders.getInternalFrameBorder();
        BorderUIResource.EmptyBorderUIResource cellBorder = new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1);
        Color desktopBackgroundColor = AquaImageFactory.getDesktopBackgroundColorUIResource();
        Color focusRingColor = AquaImageFactory.getFocusRingColorUIResource();
        Color panelBackgroundColor = windowBackgroundColor = AquaImageFactory.getWindowBackgroundColorUIResource();
        Color tabBackgroundColor = windowBackgroundColor;
        Color controlBackgroundColor = windowBackgroundColor;
        ColorUIResource texturedButtonUnselectedColor = new ColorUIResource(new Color(0, 0, 0, 170));
        ColorUIResource texturedButtonDisabledUnselectedColor = new ColorUIResource(new Color(0, 0, 0, 75));
        ColorUIResource texturedButtonSelectedColor = new ColorUIResource(Color.WHITE);
        ColorUIResource texturedButtonDisabledSelectedColor = new ColorUIResource(new Color(255, 255, 255, 155));
        ColorUIResource texturedButtonNonexclusiveSelectedColor = OSXSystemProperties.OSVersion >= 1011 ? new ColorUIResource(37, 125, 252) : new ColorUIResource(0, 122, 255);
        ColorUIResource texturedButtonDisabledNonexclusiveSelectedColor = OSXSystemProperties.OSVersion >= 1011 ? new ColorUIResource(new Color(37, 125, 252, 120)) : new ColorUIResource(new Color(0, 122, 255, 120));
        UIDefaults.LazyValue controlFont = t -> AquaFonts.getControlTextFont();
        UIDefaults.LazyValue controlSmallFont = t -> AquaFonts.getControlTextSmallFont();
        UIDefaults.LazyValue controlMiniFont = t -> AquaFonts.getControlTextMiniFont();
        UIDefaults.LazyValue iconButtonFont = t -> AquaFonts.getIconButtonFont();
        UIDefaults.LazyValue iconButtonSmallFont = t -> AquaFonts.getIconButtonSmallFont();
        UIDefaults.LazyValue alertHeaderFont = t -> AquaFonts.getAlertHeaderFont();
        UIDefaults.LazyValue menuFont = t -> AquaFonts.getMenuFont();
        UIDefaults.LazyValue viewFont = t -> AquaFonts.getViewFont();
        UIDefaults.LazyValue sideBarFont = t -> AquaFonts.getSideBarFont();
        UIDefaults.LazyValue sideBarSelectionFont = t -> AquaFonts.getSideBarSelectionFont();
        UIDefaults.LazyValue sideBarCategoryFont = t -> AquaFonts.getSideBarCategoryFont();
        UIDefaults.LazyValue sideBarCategorySelectionFont = t -> AquaFonts.getSideBarCategorySelectionFont();
        UIDefaults.LazyValue previewLabelFont = t -> AquaFonts.getPreviewLabelFont();
        UIDefaults.LazyValue previewValueFont = t -> AquaFonts.getPreviewValueFont();
        UIDefaults.LazyValue previewNameFont = t -> AquaFonts.getPreviewNameFont();
        UIDefaults.LazyValue previewTypeSizeFont = t -> AquaFonts.getPreviewTypeSizeFont();
        UIDefaults.LazyValue recessedFont = t -> AquaFonts.getRecessedButtonFont();
        UIDefaults.LazyValue inlineFont = t -> AquaFonts.getInlineButtonFont();
        ColorUIResource clearColor = new ColorUIResource(new Color(0, 0, 0, 0));
        ColorUIResource sideBarSelectionBackgroundColor = new ColorUIResource(new Color(0, 0, 0, 67));
        ColorUIResource sideBarSelectionInactiveBackgroundColor = new ColorUIResource(205, 205, 205);
        ColorUIResource sideBarForegroundColor = new ColorUIResource(new Color(31, 31, 31, 217));
        ColorUIResource sideBarInactiveForegroundColor = new ColorUIResource(68, 68, 68);
        ColorUIResource sideBarSelectionForegroundColor = new ColorUIResource(30, 30, 30);
        ColorUIResource sideBarSelectionInactiveForegroundColor = new ColorUIResource(0, 0, 0);
        ColorUIResource sideBarCategoryForegroundColor = new ColorUIResource(new Color(85, 85, 85, 217));
        ColorUIResource sideBarCategorySelectionForegroundColor = new ColorUIResource(0, 0, 0);
        ColorUIResource menuBorderColor = new ColorUIResource(209, 209, 209);
        ColorUIResource menuBarBackgroundColor = new ColorUIResource(new Color(246, 246, 246));
        ColorUIResource menuBackgroundColor = clearColor;
        ColorUIResource menuForegroundColor = black;
        ColorUIResource menuSelectedForegroundColor = white;
        ColorUIResource menuSelectedBackgroundColor = new ColorUIResource(new Color(59, 152, 253));
        ColorUIResource menuDisabledBackgroundColor = menuBackgroundColor;
        ColorUIResource menuDisabledForegroundColor = disabled;
        ColorUIResource menuBarDisabledBackgroundColor = menuBarBackgroundColor;
        ColorUIResource menuAccelForegroundColor = black;
        ColorUIResource menuAccelSelectionForegroundColor = black;
        AquaMenuItemBorder menuItemBorder = new AquaMenuItemBorder();
        BorderUIResource.EmptyBorderUIResource popupMenuBorder = new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0);
        UIDefaults.LazyInputMap controlFocusInputMap = new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"});
        UIDefaults.LazyInputMap fileChooserInputMap = new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "meta PERIOD", "cancelSelection", "F5", "refresh"});
        UIDefaults.LazyValue confirmIcon = t -> AquaImageFactory.getConfirmImageIcon();
        UIDefaults.LazyValue cautionIcon = t -> AquaImageFactory.getCautionImageIcon();
        UIDefaults.LazyValue stopIcon = t -> AquaImageFactory.getStopImageIcon();
        UIDefaults.LazyValue securityIcon = t -> AquaImageFactory.getLockImageIcon();
        AquaKeyBindings aquaKeyBindings = AquaKeyBindings.instance();
        Object[] defaults = new Object[]{"control", windowBackgroundColor, "Browser.selectionBackground", listSelectionBackground, "Browser.selectionForeground", listSelectionForeground, "Browser.inactiveSelectionBackground", listSelectionInactiveBackground, "Browser.inactiveSelectionForeground", listSelectionInactiveForeground, "Browser.expandedIcon", AquaLookAndFeel.makeIcon("fc/Unselected.png"), "Browser.expandingIcon", AquaLookAndFeel.makeIcon("fc/Unselected.png"), "Browser.focusedSelectedExpandedIcon", AquaLookAndFeel.makeIcon("fc/SelectedFocused.png"), "Browser.focusedSelectedExpandingIcon", AquaLookAndFeel.makeIcon("fc/SelectedFocused.png"), "Browser.selectedExpandedIcon", AquaLookAndFeel.makeIcon("fc/SelectedUnfocused.png"), "Browser.selectedExpandingIcon", AquaLookAndFeel.makeIcon("fc/SelectedUnfocused.png"), "Browser.sizeHandleIcon", t -> new AquaBrowserSizeHandleIcon(), "Button.background", controlBackgroundColor, "Button.foreground", black, "Button.disabledText", disabled, "Button.select", selected, "Button.border", t -> AquaButtonBorder.getPushButtonBorder(), "Button.font", controlFont, "Button.textIconGap", new Integer(4), "Button.textShiftOffset", 0, "Button.focusInputMap", controlFocusInputMap, "Button.margin", new InsetsUIResource(0, 0, 0, 0), "Button.opaque", false, "Button.recessed.font", recessedFont, "Button.recessed.rolloverText", white, "Button.inline.font", inlineFont, "Button.texturedSelectedColor", texturedButtonSelectedColor, "Button.texturedDisabledSelectedColor", texturedButtonDisabledSelectedColor, "Button.texturedUnselectedColor", texturedButtonUnselectedColor, "Button.texturedDisabledUnselectedColor", texturedButtonDisabledUnselectedColor, "Button.texturedNonexclusiveSelectedColor", texturedButtonNonexclusiveSelectedColor, "Button.texturedDisabledNonexclusiveSelectedColor", texturedButtonDisabledNonexclusiveSelectedColor, "CheckBox.background", controlBackgroundColor, "CheckBox.foreground", black, "CheckBox.disabledText", disabled, "CheckBox.select", selected, "CheckBox.font", controlFont, "CheckBox.margin", new InsetsUIResource(1, 1, 0, 1), "CheckBox.focusInputMap", controlFocusInputMap, "CheckBoxMenuItem.font", menuFont, "CheckBoxMenuItem.acceleratorFont", menuFont, "CheckBoxMenuItem.background", menuBackgroundColor, "CheckBoxMenuItem.foreground", menuForegroundColor, "CheckBoxMenuItem.selectionBackground", menuSelectedBackgroundColor, "CheckBoxMenuItem.selectionForeground", menuSelectedForegroundColor, "CheckBoxMenuItem.disabledBackground", menuDisabledBackgroundColor, "CheckBoxMenuItem.disabledForeground", menuDisabledForegroundColor, "CheckBoxMenuItem.acceleratorForeground", menuAccelForegroundColor, "CheckBoxMenuItem.acceleratorSelectionForeground", menuAccelSelectionForegroundColor, "CheckBoxMenuItem.acceleratorDelimiter", "", "CheckBoxMenuItem.border", menuItemBorder, "CheckBoxMenuItem.margin", menuItemMargin, "CheckBoxMenuItem.borderPainted", Boolean.TRUE, "CheckBoxMenuItem.checkIcon", t -> AquaImageFactory.getMenuItemCheckIcon(), "CheckBoxMenuItem.dashIcon", t -> AquaImageFactory.getMenuItemDashIcon(), "ColorChooser.background", panelBackgroundColor, "ComboBox.font", controlFont, "ComboBox.background", white, "ComboBox.foreground", black, "ComboBox.selectionBackground", comboBoxSelectionBackground, "ComboBox.selectionForeground", comboBoxSelectionForeground, "ComboBox.disabledBackground", menuDisabledBackgroundColor, "ComboBox.disabledForeground", menuDisabledForegroundColor, "ComboBox.ancestorInputMap", aquaKeyBindings.getComboBoxInputMap(), "ComboBox.padding", new InsetsUIResource(1, 4, 1, 4), "ComboBox.maximumRowCount", 5, "DesktopIcon.border", internalFrameBorder, "DesktopIcon.borderColor", smokyGlass, "DesktopIcon.borderRimColor", dockIconRim, "DesktopIcon.labelBackground", mediumTranslucentBlack, "Desktop.background", desktopBackgroundColor, "EditorPane.focusInputMap", aquaKeyBindings.getMultiLineTextInputMap(), "EditorPane.font", controlFont, "EditorPane.background", textBackground, "EditorPane.foreground", textForeground, "EditorPane.selectionBackground", textHighlight, "EditorPane.selectionForeground", textHighlightText, "EditorPane.caretForeground", textForeground, "EditorPane.caretBlinkRate", 500, "EditorPane.inactiveForeground", textInactiveText, "EditorPane.inactiveBackground", textInactiveBackground, "EditorPane.border", textAreaBorder, "EditorPane.margin", editorMargin, "FileChooser.ancestorInputMap", fileChooserInputMap, "FileChooser.cellTipOrigin", new Point(18, 1), "FileChooser.previewNameFont", previewNameFont, "FileChooser.previewTypeSizeFont", previewTypeSizeFont, "FileChooser.previewLabelFont", previewLabelFont, "FileChooser.previewValueFont", previewValueFont, "FileChooser.previewLabelForeground", new ColorUIResource(159, 159, 159), "FileChooser.previewValueForeground", new ColorUIResource(0, 0, 0), "FileChooser.previewLabelInsets", new InsetsUIResource(1, 0, 0, 4), "FileChooser.previewLabelDelimiter", "", "FileChooser.listView.extraColumnTextColor", new ColorUIResource(128, 128, 128), "FileChooser.listView.headerColor", new ColorUIResource(37, 37, 37), "FileChooser.listView.headerBackground", new ColorUIResource(240, 240, 240), "FileChooser.autovalidate", true, "FileChooser.quickLookEnabled", true, "FileChooser.orderByType", false, "FileChooser.speed", false, "FileChooser.browserCellBorder", browserCellBorder, "FileChooser.browserCellFocusBorder", browserCellBorder, "FileChooser.browserCellFocusBorderGrayed", browserCellBorder, "FileChooser.browserCellTextIconGap", 6, "FileChooser.browserCellTextArrowIconGap", 5, "FileChooser.cancelButtonMnemonic", 0, "FileChooser.saveButtonMnemonic", 0, "FileChooser.openButtonMnemonic", 0, "FileChooser.updateButtonMnemonic", 0, "FileChooser.helpButtonMnemonic", 0, "FileChooser.directoryOpenButtonMnemonic", 0, "FileChooser.lookInLabelMnemonic", 0, "FileChooser.fileNameLabelMnemonic", 0, "FileChooser.filesOfTypeLabelMnemonic", 0, "FileChooser.sideBarRowHeight", 24, "FileChooser.sideBarIcon.Applications", OSXFile.getApplicationsSidebarIcon(), "FileChooser.sideBarIcon.Desktop", OSXFile.getDesktopSidebarIcon(), "FileChooser.sideBarIcon.Documents", OSXFile.getDocumentsSidebarIcon(), "FileChooser.sideBarIcon.Downloads", OSXFile.getDownloadsSidebarIcon(), "FileChooser.sideBarIcon.GenericFile", OSXFile.getGenericFileSidebarIcon(), "FileChooser.sideBarIcon.GenericFolder", OSXFile.getGenericFolderSidebarIcon(), "FileChooser.sideBarIcon.GenericVolume", OSXFile.getGenericVolumeSidebarIcon(), "FileChooser.sideBarIcon.Home", OSXFile.getHomeSidebarIcon(), "FileChooser.sideBarIcon.Movies", OSXFile.getMoviesSidebarIcon(), "FileChooser.sideBarIcon.Music", OSXFile.getMusicSidebarIcon(), "FileChooser.sideBarIcon.Network", OSXFile.getNetworkSidebarIcon(), "FileChooser.sideBarIcon.Pictures", OSXFile.getPicturesSidebarIcon(), "FileChooser.sideBarIcon.Utilities", OSXFile.getUtilitiesSidebarIcon(), "FileChooser.sideBarIcon.SmartFolder", OSXFile.getSmartFolderSidebarIcon(), "FileChooser.sideBarIcon.TimeMachineVolume", OSXFile.getTimeMachineSidebarIcon(), "FileView.aliasBadgeIcon", OSXFile.getAliasBadgeIcon(), "FileView.computerIcon", AquaImageFactory.getComputerIcon(), "FileView.directoryIcon", OSXFile.getDirectoryIcon(), "FileView.fileIcon", OSXFile.getFileIcon(), "FileView.networkIcon", OSXFile.getNetworkIcon(), "Focus.color", focusRingColor, "FormattedTextField.focusInputMap", aquaKeyBindings.getFormattedTextFieldInputMap(), "FormattedTextField.font", controlFont, "FormattedTextField.background", textBackground, "FormattedTextField.foreground", textForeground, "FormattedTextField.inactiveForeground", textInactiveText, "FormattedTextField.inactiveBackground", textInactiveBackground, "FormattedTextField.selectionBackground", textHighlight, "FormattedTextField.selectionForeground", textHighlightText, "FormattedTextField.caretForeground", textForeground, "FormattedTextField.caretBlinkRate", 500, "FormattedTextField.border", textFieldBorder, "FormattedTextField.margin", zeroInsets, "IconButton.font", iconButtonFont, "IconButton.smallFont", iconButtonSmallFont, "InternalFrame.titleFont", controlFont, "InternalFrame.background", windowBackgroundColor, "InternalFrame.borderColor", windowBackgroundColor, "InternalFrame.borderShadow", Color.red, "InternalFrame.borderDarkShadow", Color.green, "InternalFrame.borderHighlight", Color.blue, "InternalFrame.borderLight", Color.yellow, "InternalFrame.opaque", Boolean.FALSE, "InternalFrame.border", null, "InternalFrame.icon", null, "InternalFrame.paletteBorder", null, "InternalFrame.paletteTitleFont", controlSmallFont, "InternalFrame.paletteBackground", windowBackgroundColor, "InternalFrame.optionDialogBorder", null, "InternalFrame.optionDialogTitleFont", menuFont, "InternalFrame.optionDialogBackground", windowBackgroundColor, "InternalFrame.closeSound", null, "InternalFrame.maximizeSound", null, "InternalFrame.minimizeSound", null, "InternalFrame.restoreDownSound", null, "InternalFrame.restoreUpSound", null, "InternalFrame.activeTitleBackground", windowBackgroundColor, "InternalFrame.activeTitleForeground", textForeground, "InternalFrame.inactiveTitleBackground", windowBackgroundColor, "InternalFrame.inactiveTitleForeground", textInactiveText, "InternalFrame.windowBindings", new Object[]{"shift ESCAPE", "showSystemMenu", "ctrl SPACE", "showSystemMenu", "ESCAPE", "hideSystemMenu"}, "TitledBorder.font", controlSmallFont, "TitledBorder.titleColor", black, "TitledBorder.aquaVariant", aquaTitledBorder, "InsetBorder.aquaVariant", aquaInsetBorder, "Label.font", controlFont, "Label.background", controlBackgroundColor, "Label.foreground", black, "Label.disabledForeground", disabled, "Label.disabledShadow", disabledShadow, "Label.border", null, "List.font", viewFont, "List.background", white, "List.foreground", black, "List.selectionBackground", listSelectionBackground, "List.selectionForeground", listSelectionForeground, "List.selectionInactiveBackground", listSelectionInactiveBackground, "List.selectionInactiveForeground", listSelectionInactiveForeground, "List.focusCellHighlightBorder", cellBorder, "List.focusSelectedCellHighlightBorder", cellBorder, "List.cellNoFocusBorder", cellBorder, "List.border", null, "List.cellRenderer", listCellRendererActiveValue, "List.sourceListBackgroundPainter", t -> AquaListUI.getSourceListBackgroundPainter(), "List.sourceListSelectionBackgroundPainter", t -> AquaListUI.getSourceListSelectionBackgroundPainter(), "List.sourceListFocusedSelectionBackgroundPainter", t -> AquaListUI.getSourceListFocusedSelectionBackgroundPainter(), "List.evenRowBackgroundPainter", t -> AquaListUI.getListEvenBackgroundPainter(), "List.oddRowBackgroundPainter", t -> AquaListUI.getListOddBackgroundPainter(), "List.evenRowBackground", white, "List.oddRowBackground", alternateBackground, "List.focusInputMap", aquaKeyBindings.getListInputMap(), "Menu.font", menuFont, "Menu.acceleratorFont", menuFont, "Menu.background", menuBackgroundColor, "Menu.foreground", menuForegroundColor, "Menu.selectionBackground", menuSelectedBackgroundColor, "Menu.selectionForeground", menuSelectedForegroundColor, "Menu.disabledBackground", menuDisabledBackgroundColor, "Menu.disabledForeground", menuDisabledForegroundColor, "Menu.acceleratorForeground", menuAccelForegroundColor, "Menu.acceleratorSelectionForeground", menuAccelSelectionForegroundColor, "Menu.border", menuItemBorder, "Menu.borderPainted", Boolean.FALSE, "Menu.borderColor", menuBorderColor, "Menu.margin", menuItemMargin, "Menu.arrowIcon", t -> AquaImageFactory.getMenuArrowIcon(), "Menu.consumesTabs", Boolean.TRUE, "Menu.menuPopupOffsetY", new Integer(1), "Menu.submenuPopupOffsetY", new Integer(-4), "MenuBar.font", menuFont, "MenuBar.background", menuBarBackgroundColor, "MenuBar.foreground", menuForegroundColor, "MenuBar.border", new AquaMenuBarBorder(), "MenuBar.margin", new InsetsUIResource(0, 8, 0, 8), "MenuBar.selectionBackground", menuSelectedBackgroundColor, "MenuBar.selectionForeground", menuSelectedForegroundColor, "MenuBar.disabledBackground", menuBarDisabledBackgroundColor, "MenuBar.disabledForeground", menuDisabledForegroundColor, "MenuBar.backgroundPainter", t -> AquaMenuPainter.getMenuBarPainter(), "MenuBar.selectedBackgroundPainter", t -> AquaMenuPainter.getSelectedMenuBarItemPainter(), "MenuItem.font", menuFont, "MenuItem.acceleratorFont", menuFont, "MenuItem.background", menuBackgroundColor, "MenuItem.foreground", menuForegroundColor, "MenuItem.selectionBackground", menuSelectedBackgroundColor, "MenuItem.selectionForeground", menuSelectedForegroundColor, "MenuItem.disabledBackground", menuDisabledBackgroundColor, "MenuItem.disabledForeground", menuDisabledForegroundColor, "MenuItem.acceleratorForeground", menuAccelForegroundColor, "MenuItem.acceleratorSelectionForeground", menuAccelSelectionForegroundColor, "MenuItem.acceleratorDelimiter", "", "MenuItem.border", menuItemBorder, "MenuItem.margin", menuItemMargin, "MenuItem.borderPainted", Boolean.TRUE, "MenuItem.selectedBackgroundPainter", t -> AquaMenuPainter.getSelectedMenuItemPainter(), "OptionPane.font", alertHeaderFont, "OptionPane.messageFont", controlFont, "OptionPane.buttonFont", controlFont, "OptionPane.background", windowBackgroundColor, "OptionPane.foreground", black, "OptionPane.messageForeground", black, "OptionPane.border", new BorderUIResource.EmptyBorderUIResource(12, 21, 17, 21), "OptionPane.messageAreaBorder", zeroBorder, "OptionPane.buttonAreaBorder", new BorderUIResource.EmptyBorderUIResource(13, 0, 0, 0), "OptionPane.minimumSize", new DimensionUIResource(262, 90), "OptionPane.errorIcon", stopIcon, "OptionPane.informationIcon", confirmIcon, "OptionPane.warningIcon", cautionIcon, "OptionPane.questionIcon", confirmIcon, "_SecurityDecisionIcon", securityIcon, "OptionPane.windowBindings", new Object[]{"ESCAPE", "close"}, "OptionPane.errorSound", null, "OptionPane.informationSound", null, "OptionPane.questionSound", null, "OptionPane.warningSound", null, "OptionPane.buttonClickThreshhold", new Integer(500), "OptionPane.yesButtonMnemonic", "", "OptionPane.noButtonMnemonic", "", "OptionPane.okButtonMnemonic", "", "OptionPane.cancelButtonMnemonic", "", "Panel.font", controlFont, "Panel.background", panelBackgroundColor, "Panel.foreground", black, "PasswordField.focusInputMap", aquaKeyBindings.getPasswordFieldInputMap(), "PasswordField.font", controlFont, "PasswordField.background", textBackground, "PasswordField.foreground", textForeground, "PasswordField.inactiveForeground", textInactiveText, "PasswordField.inactiveBackground", textInactiveBackground, "PasswordField.selectionBackground", textHighlight, "PasswordField.selectionForeground", textHighlightText, "PasswordField.caretForeground", textForeground, "PasswordField.caretBlinkRate", 500, "PasswordField.border", textFieldBorder, "PasswordField.margin", zeroInsets, "PasswordField.echoChar", new Character('\u25cf'), "PasswordField.capsLockIconColor", textPasswordFieldCapsLockIconColor, "PopupMenu.font", menuFont, "PopupMenu.background", clearColor, "PopupMenu.translucentBackground", white, "PopupMenu.foreground", menuForegroundColor, "PopupMenu.selectionBackground", menuSelectedBackgroundColor, "PopupMenu.selectionForeground", menuSelectedForegroundColor, "PopupMenu.border", popupMenuBorder, "ProgressBar.font", controlFont, "ProgressBar.foreground", black, "ProgressBar.background", controlBackgroundColor, "ProgressBar.selectionForeground", black, "ProgressBar.selectionBackground", white, "ProgressBar.border", new BorderUIResource(BorderFactory.createEmptyBorder()), "ProgressBar.repaintInterval", 30, "ProgressBar.circularRepaintInterval", 70, "RadioButton.background", controlBackgroundColor, "RadioButton.foreground", black, "RadioButton.disabledText", disabled, "RadioButton.select", selected, "RadioButton.font", controlFont, "RadioButton.margin", new InsetsUIResource(1, 1, 0, 1), "RadioButton.focusInputMap", controlFocusInputMap, "RadioButtonMenuItem.font", menuFont, "RadioButtonMenuItem.acceleratorFont", menuFont, "RadioButtonMenuItem.background", menuBackgroundColor, "RadioButtonMenuItem.foreground", menuForegroundColor, "RadioButtonMenuItem.selectionBackground", menuSelectedBackgroundColor, "RadioButtonMenuItem.selectionForeground", menuSelectedForegroundColor, "RadioButtonMenuItem.disabledBackground", menuDisabledBackgroundColor, "RadioButtonMenuItem.disabledForeground", menuDisabledForegroundColor, "RadioButtonMenuItem.acceleratorForeground", menuAccelForegroundColor, "RadioButtonMenuItem.acceleratorSelectionForeground", menuAccelSelectionForegroundColor, "RadioButtonMenuItem.acceleratorDelimiter", "", "RadioButtonMenuItem.border", menuItemBorder, "RadioButtonMenuItem.margin", menuItemMargin, "RadioButtonMenuItem.borderPainted", Boolean.TRUE, "RadioButtonMenuItem.checkIcon", t -> AquaImageFactory.getMenuItemCheckIcon(), "RadioButtonMenuItem.dashIcon", t -> AquaImageFactory.getMenuItemDashIcon(), "Separator.background", null, "Separator.foreground", separator, "Separator.width", 1, "ScrollBar.border", null, "ScrollBar.focusInputMap", aquaKeyBindings.getScrollBarInputMap(), "ScrollBar.focusInputMap.RightToLeft", aquaKeyBindings.getScrollBarRightToLeftInputMap(), "ScrollBar.width", new Integer(16), "ScrollBar.background", white, "ScrollBar.foreground", black, "ScrollPane.font", controlFont, "ScrollPane.background", white, "ScrollPane.foreground", black, "ScrollPane.border", scrollListBorder, "ScrollPane.viewportBorder", null, "ScrollPane.ancestorInputMap", aquaKeyBindings.getScrollPaneInputMap(), "ScrollPane.ancestorInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[0]), "Viewport.font", controlFont, "Viewport.background", white, "Viewport.foreground", black, "Slider.foreground", black, "Slider.background", controlBackgroundColor, "Slider.font", controlSmallFont, "Slider.tickColor", new ColorUIResource(Color.GRAY), "Slider.border", null, "Slider.focusInsets", new InsetsUIResource(0, 0, 0, 0), "Slider.focusInputMap", aquaKeyBindings.getSliderInputMap(), "Slider.focusInputMap.RightToLeft", aquaKeyBindings.getSliderRightToLeftInputMap(), "Spinner.font", controlFont, "Spinner.background", controlBackgroundColor, "Spinner.foreground", black, "Spinner.border", null, "Spinner.arrowButtonSize", new Dimension(16, 5), "Spinner.ancestorInputMap", aquaKeyBindings.getSpinnerInputMap(), "Spinner.editorBorderPainted", Boolean.TRUE, "Spinner.editorAlignment", 11, "SplitPane.background", panelBackgroundColor, "SplitPane.border", null, "SplitPane.continuousLayout", Boolean.TRUE, "SplitPane.dividerSize", 9, "SplitPane.dividerColor", new ColorUIResource(Color.GRAY), "SplitPaneDivider.border", null, "TabbedPane.font", controlFont, "TabbedPane.smallFont", controlSmallFont, "TabbedPane.useSmallLayout", Boolean.FALSE, "TabbedPane.background", tabBackgroundColor, "TabbedPane.foreground", black, "TabbedPane.textIconGap", new Integer(4), "TabbedPane.tabInsets", new InsetsUIResource(0, 10, 3, 10), "TabbedPane.tabAreaInsets", new InsetsUIResource(3, 9, -1, 9), "TabbedPane.contentBorderInsets", new InsetsUIResource(8, 0, 0, 0), "TabbedPane.selectedTabPadInsets", new InsetsUIResource(0, 0, 0, 0), "TabbedPane.tabsOverlapBorder", Boolean.TRUE, "TabbedPane.selectedTabTitlePressedColor", selectedTabTitlePressedColor, "TabbedPane.selectedTabTitleDisabledColor", selectedTabTitleDisabledColor, "TabbedPane.selectedTabTitleNormalColor", selectedTabTitleNormalColor, "TabbedPane.selectedTabTitleInactiveColor", selectedTabTitleInactiveColor, "TabbedPane.nonSelectedTabTitlePressedColor", nonSelectedTabTitlePressedColor, "TabbedPane.nonSelectedTabTitleDisabledColor", nonSelectedTabTitleDisabledColor, "TabbedPane.nonSelectedTabTitleNormalColor", nonSelectedTabTitleNormalColor, "TabbedPane.nonSelectedTabTitleInactiveColor", nonSelectedTabTitleInactiveColor, "TabbedPane.selectedLabelShift", -1, "TabbedPane.labelShift", 1, "TabbedPane.selectionFollowsFocus", true, "Table.font", viewFont, "Table.foreground", black, "Table.background", white, "Table.selectionForeground", listSelectionForeground, "Table.selectionBackground", listSelectionBackground, "Table.selectionInactiveBackground", listSelectionInactiveBackground, "Table.selectionInactiveForeground", listSelectionInactiveForeground, "Table.gridColor", gridColor, "Table.focusCellHighlightBorder", cellBorder, "Table.focusSelectedCellHighlightBorder", cellBorder, "Table.cellFocusNoBorder", cellBorder, "Table.scrollPaneBorder", scrollListBorder, "Table.evenRowBackground", white, "Table.oddRowBackground", alternateBackground, "Table.scrollPaneCornerComponent", new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new AquaTableScrollPaneCorner();
            }
        }, "Table.ancestorInputMap", aquaKeyBindings.getTableInputMap(), "Table.ancestorInputMap.RightToLeft", aquaKeyBindings.getTableRightToLeftInputMap(), "TableHeader.font", controlSmallFont, "TableHeader.foreground", black, "TableHeader.background", white, "TableHeader.cellBorder", listHeaderBorder, "TableHeader.borderHeight", 1, "TableHeader.borderColor", gridColor, "TextArea.focusInputMap", aquaKeyBindings.getMultiLineTextInputMap(), "TextArea.font", controlFont, "TextArea.background", textBackground, "TextArea.foreground", textForeground, "TextArea.inactiveForeground", textInactiveText, "TextArea.inactiveBackground", textInactiveBackground, "TextArea.selectionBackground", textHighlight, "TextArea.selectionForeground", textHighlightText, "TextArea.caretForeground", textForeground, "TextArea.caretBlinkRate", 500, "TextArea.border", textAreaBorder, "TextArea.margin", zeroInsets, "TextComponent.selectionBackgroundInactive", textHighlightInactive, "TextField.focusInputMap", aquaKeyBindings.getTextFieldInputMap(), "TextField.font", controlFont, "TextField.background", textBackground, "TextField.foreground", textForeground, "TextField.inactiveForeground", textInactiveText, "TextField.inactiveBackground", textInactiveBackground, "TextField.selectionBackground", textHighlight, "TextField.selectionForeground", textHighlightText, "TextField.caretForeground", textForeground, "TextField.caretBlinkRate", 500, "TextField.border", textFieldBorder, "TextField.margin", zeroInsets, "TextPane.focusInputMap", aquaKeyBindings.getMultiLineTextInputMap(), "TextPane.font", controlFont, "TextPane.background", textBackground, "TextPane.foreground", textForeground, "TextPane.selectionBackground", textHighlight, "TextPane.selectionForeground", textHighlightText, "TextPane.caretForeground", textForeground, "TextPane.caretBlinkRate", 500, "TextPane.inactiveForeground", textInactiveText, "TextPane.inactiveBackground", textInactiveBackground, "TextPane.border", textAreaBorder, "TextPane.margin", editorMargin, "ToggleButton.background", controlBackgroundColor, "ToggleButton.foreground", black, "ToggleButton.disabledText", disabled, "ToggleButton.selectedText", Color.WHITE, "ToggleButton.border", t -> AquaButtonBorder.getToggleButtonBorder(), "ToggleButton.font", controlFont, "ToggleButton.textIconGap", new Integer(4), "ToggleButton.textShiftOffset", 0, "ToggleButton.focusInputMap", controlFocusInputMap, "ToggleButton.margin", new InsetsUIResource(0, 0, 0, 0), "ToggleButton.opaque", false, "ToolBar.font", controlFont, "ToolBar.background", panelBackgroundColor, "ToolBar.foreground", new ColorUIResource(Color.gray), "ToolBar.dockingBackground", panelBackgroundColor, "ToolBar.dockingForeground", listSelectionBackground, "ToolBar.floatingBackground", panelBackgroundColor, "ToolBar.floatingForeground", new ColorUIResource(Color.darkGray), "ToolBar.border", t -> AquaToolBarUI.getToolBarBorder(), "ToolBar.borderHandleColor", toolbarDragHandleColor, "ToolBar.separatorSize", null, "ToolBar.title.background", toolBarTitleBackground, "ToolTip.font", controlSmallFont, "ToolTip.background", toolTipBackground, "ToolTip.foreground", black, "ToolTip.border", toolTipBorder, "Tree.font", viewFont, "Tree.background", white, "Tree.foreground", black, "Tree.hash", white, "Tree.line", white, "Tree.textForeground", black, "Tree.textBackground", white, "Tree.selectionForeground", listSelectionForeground, "Tree.selectionBackground", listSelectionBackground, "Tree.selectionInactiveBackground", listSelectionInactiveBackground, "Tree.selectionInactiveForeground", listSelectionInactiveForeground, "Tree.selectionBorderColor", listSelectionBackground, "Tree.editorBorderSelectionColor", null, "Tree.editorBorder", zeroBorder, "Tree.leftChildIndent", 8, "Tree.rightChildIndent", 12, "Tree.rowHeight", 19, "Tree.scrollsOnExpand", Boolean.FALSE, "Tree.openIcon", t -> AquaImageFactory.getTreeOpenFolderIcon(), "Tree.closedIcon", t -> AquaImageFactory.getTreeFolderIcon(), "Tree.leafIcon", t -> AquaImageFactory.getTreeDocumentIcon(), "Tree.changeSelectionWithFocus", Boolean.TRUE, "Tree.drawsFocusBorderAroundIcon", Boolean.FALSE, "Tree.evenRowBackground", white, "Tree.oddRowBackground", alternateBackground, "Tree.sideBar.font", sideBarFont, "Tree.sideBar.selectionFont", sideBarSelectionFont, "Tree.sideBarCategory.font", sideBarCategoryFont, "Tree.sideBarCategory.selectionFont", sideBarCategorySelectionFont, "Tree.sideBar.selectionBackground", sideBarSelectionBackgroundColor, "Tree.sideBar.selectionInactiveBackground", sideBarSelectionInactiveBackgroundColor, "Tree.sideBar.foreground", sideBarForegroundColor, "Tree.sideBar.inactiveForeground", sideBarInactiveForegroundColor, "Tree.sideBar.selectionForeground", sideBarSelectionForegroundColor, "Tree.sideBar.selectionInactiveForeground", sideBarSelectionInactiveForegroundColor, "Tree.sideBarCategory.foreground", sideBarCategoryForegroundColor, "Tree.sideBarCategory.selectionForeground", sideBarCategorySelectionForegroundColor, "Tree.focusInputMap", aquaKeyBindings.getTreeInputMap(), "Tree.focusInputMap.RightToLeft", aquaKeyBindings.getTreeRightToLeftInputMap(), "Tree.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancel"})};
        table.putDefaults(defaults);
        AquaUtils.installAATextInfo(table);
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults table) {
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        String basicPackageName = "javax.swing.plaf.basic.";
        Object[] uiDefaults = new Object[]{"ButtonUI", "org.violetlib.aqua.AquaButtonUI", "CheckBoxUI", "org.violetlib.aqua.AquaButtonCheckBoxUI", "CheckBoxMenuItemUI", "com.apple.laf.AquaMenuItemUI", "LabelUI", "org.violetlib.aqua.AquaLabelUI", "ListUI", "org.violetlib.aqua.AquaListUI", "MenuUI", "org.violetlib.aqua.AquaMenuUI", "MenuItemUI", "com.apple.laf.AquaMenuItemUI", "OptionPaneUI", "org.violetlib.aqua.AquaOptionPaneUI", "PanelUI", "org.violetlib.aqua.AquaPanelUI", "RadioButtonMenuItemUI", "com.apple.laf.AquaMenuItemUI", "RadioButtonUI", "org.violetlib.aqua.AquaButtonRadioUI", "ProgressBarUI", "org.violetlib.aqua.AquaProgressBarUI", "RootPaneUI", "org.violetlib.aqua.AquaRootPaneUI", "SliderUI", "org.violetlib.aqua.AquaSliderUI", "ScrollBarUI", "org.violetlib.aqua.AquaScrollBarUI", "TabbedPaneUI", "org.violetlib.aqua.AquaTabbedPaneUI", "TableUI", "org.violetlib.aqua.AquaTableUI", "ToggleButtonUI", "org.violetlib.aqua.AquaButtonToggleUI", "ToolBarUI", "org.violetlib.aqua.AquaToolBarUI", "ToolTipUI", "org.violetlib.aqua.AquaToolTipUI", "TreeUI", "org.violetlib.aqua.AquaTreeUI", "InternalFrameUI", "org.violetlib.aqua.AquaInternalFrameUI", "DesktopIconUI", "org.violetlib.aqua.AquaInternalFrameDockIconUI", "DesktopPaneUI", "org.violetlib.aqua.AquaInternalFramePaneUI", "EditorPaneUI", "org.violetlib.aqua.AquaEditorPaneUI", "TextFieldUI", "org.violetlib.aqua.AquaTextFieldUI", "TextPaneUI", "org.violetlib.aqua.AquaTextPaneUI", "ComboBoxUI", "org.violetlib.aqua.AquaComboBoxUI", "ComboBoxPopupMenuUI", "org.violetlib.aqua.AquaComboBoxPopupMenuUI", "PopupMenuUI", "org.violetlib.aqua.AquaPopupMenuUI", "TextAreaUI", "org.violetlib.aqua.AquaTextAreaUI", "MenuBarUI", "com.apple.laf.AquaMenuBarUI", "FileChooserUI", "org.violetlib.aqua.fc.AquaFileChooserUI", "PasswordFieldUI", "org.violetlib.aqua.AquaTextPasswordFieldUI", "TableHeaderUI", "org.violetlib.aqua.AquaTableHeaderUI", "FormattedTextFieldUI", "org.violetlib.aqua.AquaTextFieldFormattedUI", "SpinnerUI", "org.violetlib.aqua.AquaSpinnerUI", "SplitPaneUI", "org.violetlib.aqua.AquaSplitPaneUI", "ScrollPaneUI", "org.violetlib.aqua.AquaScrollPaneUI", "PopupMenuSeparatorUI", "org.violetlib.aqua.AquaPopupMenuSeparatorUI", "SeparatorUI", "org.violetlib.aqua.AquaSeparatorUI", "ToolBarSeparatorUI", "org.violetlib.aqua.AquaToolBarSeparatorUI", "ColorChooserUI", "javax.swing.plaf.basic.BasicColorChooserUI", "ViewportUI", "org.violetlib.aqua.AquaViewportUI"};
        table.putDefaults(uiDefaults);
    }

    public String getLongDescription() {
        return "VAqua release " + AquaLookAndFeel.getReleaseName() + " (build " + AquaLookAndFeel.getBuildID() + ")";
    }

    @Override
    public String toString() {
        return this.getLongDescription();
    }

    public static String getReleaseName() {
        return AquaLookAndFeel.getStringResource("RELEASE.txt");
    }

    public static String getBuildID() {
        return AquaLookAndFeel.getStringResource("BUILD.txt");
    }

    public static String getVersion() {
        return "VAqua look and feel release " + AquaLookAndFeel.getReleaseName() + ", build " + AquaLookAndFeel.getBuildID() + " using VAquaRendering release " + AquaNativeRendering.getReleaseName() + ", build " + AquaNativeRendering.getBuildID();
    }

    public static void showVersion() {
        System.err.println("VAqua look and feel: release " + AquaLookAndFeel.getReleaseName() + ", build " + AquaLookAndFeel.getBuildID());
        System.err.println("  using VAquaRendering: release " + AquaNativeRendering.getReleaseName() + ", build " + AquaNativeRendering.getBuildID());
    }

    private static String getStringResource(String name) {
        InputStream s = AquaLookAndFeel.class.getResourceAsStream(name);
        if (s != null) {
            try {
                int ch;
                BufferedReader r = new BufferedReader(new InputStreamReader(s));
                StringBuilder sb = new StringBuilder();
                while ((ch = r.read()) >= 0) {
                    sb.append((char)ch);
                }
                return sb.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "Unknown";
    }

    protected class MyUIChangeListener
    implements PropertyChangeListener {
        protected MyUIChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object o;
            String prop = evt.getPropertyName();
            if ("lookAndFeel".equals(prop) && (o = evt.getNewValue()) == AquaLookAndFeel.this) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AquaLookAndFeel.this.focusRingManager.install();
                    }
                });
            }
        }
    }
}

