/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.BoundedRangeModel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class AquaMarginView
extends View {
    protected final View base;
    protected int margin;
    protected Rectangle tempRect;

    public AquaMarginView(View base, int margin) {
        super(base.getElement());
        this.base = base;
        this.margin = margin;
        this.tempRect = new Rectangle();
        base.setParent(this);
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    @Override
    public float getMinimumSpan(int axis) {
        return this.base.getMinimumSpan(axis) + (float)(axis == 0 ? this.margin * 2 : 0);
    }

    @Override
    public float getPreferredSpan(int axis) {
        return this.base.getPreferredSpan(axis) + (float)(axis == 0 ? this.margin * 2 : 0);
    }

    @Override
    public float getMaximumSpan(int axis) {
        return this.base.getMaximumSpan(axis) + (float)(axis == 0 ? this.margin * 2 : 0);
    }

    @Override
    public float getAlignment(int axis) {
        return this.base.getAlignment(axis);
    }

    @Override
    public void setSize(float width, float height) {
        this.base.setSize(width - (float)(2 * this.margin), height);
    }

    @Override
    public int getResizeWeight(int axis) {
        return this.base.getResizeWeight(axis);
    }

    @Override
    public int getStartOffset() {
        return this.base.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.base.getEndOffset();
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        g = g.create();
        Rectangle clipRegion = this.getClipRegion(allocation);
        g.clipRect(clipRegion.x, clipRegion.y, clipRegion.width, clipRegion.height);
        Rectangle baseAllocation = this.getBaseAllocation(allocation);
        this.base.paint(g, baseAllocation);
        g.dispose();
    }

    @Override
    public int getViewCount() {
        return this.base.getViewCount();
    }

    @Override
    public View getView(int n) {
        return this.base.getView(n);
    }

    @Override
    public void replace(int offset, int length, View[] views) {
        this.base.replace(offset, length, views);
    }

    @Override
    public int getViewIndex(float x, float y, Shape allocation) {
        return this.base.getViewIndex(x, y, allocation);
    }

    @Override
    public Shape getChildAllocation(int index, Shape a) {
        Rectangle baseAllocation = this.getBaseAllocation(a);
        return this.base.getChildAllocation(index, baseAllocation);
    }

    @Override
    public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        Rectangle baseAllocation = this.getBaseAllocation(a);
        return this.base.getNextVisualPositionFrom(pos, b, baseAllocation, direction, biasRet);
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        Rectangle baseAllocation = this.getBaseAllocation(a);
        return this.base.modelToView(pos, baseAllocation, b);
    }

    @Override
    public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
        Rectangle baseAllocation = this.getBaseAllocation(a);
        return this.base.modelToView(p0, b0, p1, b1, baseAllocation);
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        Rectangle baseAllocation = this.getBaseAllocation(a);
        return this.base.viewToModel(x, y, baseAllocation, biasReturn);
    }

    @Override
    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        Rectangle baseAllocation = this.getBaseAllocation(a);
        this.base.insertUpdate(e, baseAllocation, f);
        this.updateVisibilityModel();
    }

    @Override
    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        Rectangle baseAllocation = this.getBaseAllocation(a);
        this.base.removeUpdate(e, baseAllocation, f);
        this.updateVisibilityModel();
    }

    @Override
    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        Rectangle baseAllocation = this.getBaseAllocation(a);
        this.base.changedUpdate(e, baseAllocation, f);
    }

    protected Rectangle getBaseAllocation(Shape a) {
        if (a != null) {
            Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            this.tempRect.setBounds(alloc);
            this.tempRect.x += this.margin;
            this.tempRect.width -= 2 * this.margin;
            return this.adjustAllocation(this.tempRect);
        }
        return null;
    }

    protected Rectangle getClipRegion(Shape a) {
        return a instanceof Rectangle ? (Rectangle)a : a.getBounds();
    }

    protected Rectangle adjustAllocation(Rectangle bounds) {
        Container c = this.getContainer();
        if (c instanceof JTextField) {
            int extent;
            JTextField field = (JTextField)c;
            BoundedRangeModel vis = field.getHorizontalVisibility();
            int hspan = (int)this.getPreferredSpan(0) - 2 * this.margin;
            int max = Math.max(hspan, bounds.width);
            int value = vis.getValue();
            if (value + (extent = Math.min(max, bounds.width - 1)) > max) {
                value = max - extent;
            }
            if (value <= this.margin) {
                value = 0;
            }
            vis.setRangeProperties(value, extent, vis.getMinimum(), max, false);
            if (hspan >= bounds.width) {
                bounds.width = hspan;
                bounds.x -= vis.getValue();
            }
        }
        return bounds;
    }

    void updateVisibilityModel() {
        Container c = this.getContainer();
        if (c instanceof JTextField) {
            JTextField field = (JTextField)c;
            BoundedRangeModel vis = field.getHorizontalVisibility();
            int hspan = (int)this.getPreferredSpan(0) - 2 * this.margin;
            int extent = vis.getExtent();
            int maximum = Math.max(hspan, extent);
            extent = extent == 0 ? maximum : extent;
            int value = maximum - extent;
            int oldValue = vis.getValue();
            if (oldValue + extent > maximum) {
                oldValue = maximum - extent;
            }
            if ((value = Math.max(0, Math.min(value, oldValue))) <= this.margin) {
                value = 0;
            }
            vis.setRangeProperties(value, extent, 0, maximum, false);
        }
    }
}

