/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyEventPostProcessor;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.violetlib.aqua.AquaUtils;

public class AquaMnemonicHandler {
    static final AquaUtils.RecyclableSingleton<AltProcessor> altProcessor = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AltProcessor>(AltProcessor.class);
    protected static boolean isMnemonicHidden = true;

    public static KeyEventPostProcessor getInstance() {
        return altProcessor.get();
    }

    public static void setMnemonicHidden(boolean hide) {
        isMnemonicHidden = UIManager.getBoolean("Button.showMnemonics") ? false : hide;
    }

    public static boolean isMnemonicHidden() {
        if (UIManager.getBoolean("Button.showMnemonics")) {
            isMnemonicHidden = false;
        }
        return isMnemonicHidden;
    }

    static void repaintMnemonicsInWindow(Window w) {
        Window[] ownedWindows;
        if (w == null || !w.isShowing()) {
            return;
        }
        for (Window element : ownedWindows = w.getOwnedWindows()) {
            AquaMnemonicHandler.repaintMnemonicsInWindow(element);
        }
        AquaMnemonicHandler.repaintMnemonicsInContainer(w);
    }

    static void repaintMnemonicsInContainer(Container cont) {
        for (int i = 0; i < cont.getComponentCount(); ++i) {
            Component c = cont.getComponent(i);
            if (c == null || !c.isVisible()) continue;
            if (c instanceof AbstractButton && ((AbstractButton)c).getMnemonic() != 0) {
                c.repaint();
                continue;
            }
            if (c instanceof JLabel && ((JLabel)c).getDisplayedMnemonic() != 0) {
                c.repaint();
                continue;
            }
            if (!(c instanceof Container)) continue;
            AquaMnemonicHandler.repaintMnemonicsInContainer((Container)c);
        }
    }

    static class AltProcessor
    implements KeyEventPostProcessor {
        AltProcessor() {
        }

        @Override
        public boolean postProcessKeyEvent(KeyEvent ev) {
            if (ev.getKeyCode() != 18) {
                return false;
            }
            JRootPane root = SwingUtilities.getRootPane(ev.getComponent());
            Window winAncestor = root == null ? null : SwingUtilities.getWindowAncestor(root);
            switch (ev.getID()) {
                case 401: {
                    AquaMnemonicHandler.setMnemonicHidden(false);
                    break;
                }
                case 402: {
                    AquaMnemonicHandler.setMnemonicHidden(true);
                }
            }
            AquaMnemonicHandler.repaintMnemonicsInWindow(winAncestor);
            return false;
        }
    }
}

