/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.WritableRaster;
import java.util.function.Function;
import org.violetlib.aqua.Aqua8MultiResolutionImage;
import org.violetlib.aqua.Aqua8MultiResolutionImage2;
import sun.awt.image.SunWritableRaster;

public abstract class AquaMultiResolutionImage
extends Image {
    protected final Image baseImage;
    protected final int baseImageWidth;
    protected final int baseImageHeight;

    public static Image createImage(int width, int height, int[] data1x, int[] data2x) {
        BufferedImage im1x = AquaMultiResolutionImage.createImage(width, height, data1x);
        if (data2x != null) {
            BufferedImage im2x = AquaMultiResolutionImage.createImage(width * 2, height * 2, data2x);
            return new Aqua8MultiResolutionImage2(im1x, im2x);
        }
        return new Aqua8MultiResolutionImage(im1x);
    }

    private static BufferedImage createImage(int width, int height, int[] data) {
        BufferedImage b = new BufferedImage(width, height, 3);
        WritableRaster raster = b.getRaster();
        DataBufferInt buffer = (DataBufferInt)raster.getDataBuffer();
        int[] rasterdata = SunWritableRaster.stealData(buffer, 0);
        System.arraycopy(data, 0, rasterdata, 0, width * height);
        SunWritableRaster.markDirty(buffer);
        return b;
    }

    public static Image apply(Image source, Function<Image, Image> mapper) {
        return Aqua8MultiResolutionImage.apply(source, mapper);
    }

    public static Image apply(Image source, Mapper mapper) {
        return Aqua8MultiResolutionImage.apply(source, mapper);
    }

    public static Image apply(Image image, ImageFilter filter) {
        return Aqua8MultiResolutionImage.apply(image, filter);
    }

    protected AquaMultiResolutionImage(Image baseImage) {
        this.baseImage = baseImage;
        this.baseImageWidth = baseImage.getWidth(null);
        this.baseImageHeight = baseImage.getHeight(null);
    }

    protected AquaMultiResolutionImage(Image baseRepresentation, int width, int height) {
        this.baseImage = baseRepresentation;
        this.baseImageWidth = width;
        this.baseImageHeight = height;
    }

    public abstract AquaMultiResolutionImage map(Function<Image, Image> var1);

    public abstract AquaMultiResolutionImage map(Mapper var1);

    @Override
    public int getWidth(ImageObserver observer) {
        return this.baseImageWidth;
    }

    @Override
    public int getHeight(ImageObserver observer) {
        return this.baseImageHeight;
    }

    @Override
    public Object getProperty(String name, ImageObserver observer) {
        return this.baseImage.getProperty(name, observer);
    }

    @Override
    public ImageProducer getSource() {
        return this.baseImage.getSource();
    }

    @Override
    public Graphics getGraphics() {
        throw new UnsupportedOperationException();
    }

    public static interface Mapper {
        public BufferedImage map(Image var1, int var2);
    }
}

