/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.StringTokenizer;
import org.violetlib.aqua.AquaUtils;

public class AquaNativeSupport {
    private static final int EXPECTED_NATIVE_CODE_VERSION = 2;
    private static final String libraryName = "vaqua";
    private static boolean isAvailable;
    private static boolean isInitialized;

    public static synchronized boolean load() {
        if (!isInitialized) {
            isInitialized = true;
            AquaNativeSupport.loadNativeSupport();
        }
        return isAvailable;
    }

    private static void loadNativeSupport() {
        try {
            String fn = AquaNativeSupport.findNativeLibrary(AquaNativeSupport.class, libraryName);
            if (fn == null) {
                AquaNativeSupport.reportError("Library not found");
                return;
            }
            System.load(fn);
            int nativeCodeVersion = AquaNativeSupport.nativeGetNativeCodeVersion();
            if (nativeCodeVersion != 2) {
                AquaNativeSupport.reportError("Incorrect library version " + nativeCodeVersion + " instead of " + 2);
                return;
            }
            AquaNativeSupport.setup();
            isAvailable = true;
        }
        catch (UnsatisfiedLinkError e) {
            AquaNativeSupport.reportError(e.getMessage());
        }
        catch (AccessControlException e) {
            AquaNativeSupport.reportError("permission denied: " + e.getMessage());
        }
        catch (Throwable e) {
            AquaNativeSupport.reportError(e.toString());
            e.printStackTrace();
        }
    }

    private static void reportError(String msg) {
        String p = System.mapLibraryName(libraryName);
        String s = "AquaNativeSupport: Unable to load library " + p + ": " + msg;
        System.err.println(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findNativeLibrary(Class<?> root, String name) throws IllegalArgumentException {
        InputStream s;
        File lf = AquaNativeSupport.findNativeLibraryOnPath(name);
        if (lf != null) {
            return lf.getPath();
        }
        String prefix = "lib" + name;
        String suffix = ".dylib";
        String libfn = prefix + suffix;
        try {
            s = root.getClassLoader().getResourceAsStream(libfn);
        }
        catch (SecurityException ex) {
            return null;
        }
        if (s == null) {
            return null;
        }
        try {
            File f = File.createTempFile(prefix, suffix).getAbsoluteFile();
            try (FileOutputStream fs = new FileOutputStream(f);){
                AquaNativeSupport.internalInitializeFile(s, fs);
            }
            String string = f.getPath();
            return string;
        }
        catch (IOException ex) {
            System.err.println("Unable to extract native library resource: " + ex.getMessage());
            String string = null;
            return string;
        }
        finally {
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static File findNativeLibraryOnPath(String name) throws IllegalArgumentException {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Invalid library name: name is empty");
        }
        if (name.indexOf(32) >= 0 || name.indexOf(46) >= 0 || name.indexOf(File.pathSeparatorChar) >= 0) {
            throw new IllegalArgumentException("Invalid library name");
        }
        String libfn = "lib" + name + ".dylib";
        String lp = System.getProperty("java.library.path");
        if (lp != null) {
            StringTokenizer st = new StringTokenizer(lp, ":");
            while (st.hasMoreTokens()) {
                String prefix = st.nextToken();
                File f = new File(prefix + File.separator + libfn).getAbsoluteFile();
                if (!f.isFile()) continue;
                return f;
            }
        }
        return null;
    }

    private static void internalInitializeFile(InputStream sin, OutputStream sout) throws IOException {
        int count;
        byte[] buf = new byte[1024];
        while ((count = sin.read(buf)) > 0) {
            sout.write(buf, 0, count);
        }
    }

    private static void setup() {
        int javaVersion = AquaUtils.getJavaVersion();
        AquaNativeSupport.setup(javaVersion);
    }

    private static native void setup(int var0);

    private static native int nativeGetNativeCodeVersion();
}

