/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import javax.swing.text.Document;
import javax.swing.text.View;
import org.violetlib.aqua.AquaUtils;
import sun.swing.DefaultLookup;

public class AquaOptionPaneUI
extends BasicOptionPaneUI {
    private static final int kOKCancelButtonWidth = 79;
    private static final int kButtonHeight = 23;
    private static final int kDialogSmallPadding = 4;
    private static final int kDialogLargePadding = 23;
    public static final String TEXT_FIELD_DOCUMENT_KEY = "JOptionPane.textFieldDocument";
    private static String newline = System.lineSeparator();

    public static ComponentUI createUI(JComponent x) {
        return new AquaOptionPaneUI();
    }

    @Override
    public final void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            AquaUtils.fillRect(g, c, 2);
        }
        this.paint(g, c);
    }

    @Override
    protected Container createButtonArea() {
        Container bottom = super.createButtonArea();
        bottom.setLayout(new AquaButtonAreaLayout(true, 4));
        return bottom;
    }

    @Override
    protected Container createMessageArea() {
        JPanel top = new JPanel();
        top.setBorder(UIManager.getBorder("OptionPane.messageAreaBorder"));
        top.setLayout(new BorderLayout());
        JComponent iconPanel = this.createIconPanel();
        JComponent body = this.createBody();
        body.setName("OptionPane.body");
        if (iconPanel != null) {
            JPanel realBody = new JPanel(new BorderLayout());
            realBody.setName("OptionPane.realBody");
            realBody.add(Box.createHorizontalStrut(23), "Before");
            realBody.add((Component)body, "Center");
            top.add((Component)realBody, "Center");
            top.add((Component)iconPanel, "Before");
        } else {
            top.add((Component)body, "Center");
        }
        return top;
    }

    protected JComponent createIconPanel() {
        Icon sideIcon = this.getIcon();
        if (sideIcon != null) {
            JLabel iconLabel = new JLabel(sideIcon);
            iconLabel.setVerticalAlignment(1);
            JPanel iconPanel = new JPanel();
            iconPanel.add(iconLabel);
            return iconPanel;
        }
        return null;
    }

    protected JComponent createBody() {
        JPanel body = new JPanel();
        body.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = 0;
        cons.gridx = 0;
        cons.gridwidth = 0;
        cons.gridheight = 1;
        cons.anchor = 17;
        cons.insets = new Insets(0, 0, 3, 0);
        this.addMessageComponents(body, cons, this.getMessage(), this.getMaxCharactersPerLineCount(), false);
        return body;
    }

    @Override
    protected int getMaxCharactersPerLineCount() {
        return this.optionPane.getMaxCharactersPerLineCount();
    }

    @Override
    protected Object getMessage() {
        Object p;
        Object o = super.getMessage();
        if (o != null && this.inputComponent instanceof JTextField && (p = this.optionPane.getClientProperty(TEXT_FIELD_DOCUMENT_KEY)) instanceof Document) {
            Document d = (Document)p;
            JTextField tf = (JTextField)this.inputComponent;
            tf.setDocument(d);
        }
        return o;
    }

    @Override
    protected void addMessageComponents(Container container, GridBagConstraints cons, Object msg, int maxll, boolean internallyCreated) {
        if (msg == null) {
            return;
        }
        if (msg instanceof Component) {
            if (msg instanceof JScrollPane || msg instanceof JPanel) {
                cons.fill = 1;
                cons.weighty = 1.0;
            } else {
                cons.fill = 2;
            }
            cons.weightx = 1.0;
            container.add((Component)msg, cons);
            cons.weightx = 0.0;
            cons.weighty = 0.0;
            cons.fill = 0;
            ++cons.gridy;
            if (!internallyCreated) {
                this.hasCustomComponents = true;
            }
        } else if (msg instanceof Object[]) {
            Object[] msgs;
            for (Object o : msgs = (Object[])msg) {
                this.addMessageComponents(container, cons, o, maxll, false);
            }
        } else if (msg instanceof Icon) {
            JLabel label = new JLabel((Icon)msg, 0);
            this.configureMessageLabel(label);
            this.addMessageComponents(container, cons, label, maxll, true);
        } else {
            String s = msg.toString();
            int len = s.length();
            if (len <= 0) {
                return;
            }
            if (s.startsWith("<html>")) {
                JComponent c = this.createHTMLTextComponent(s, maxll);
                c.setName("OptionPane.label");
                this.configureMessageLabel(c);
                this.addMessageComponents(container, cons, c, maxll, true);
                return;
            }
            int nll = 0;
            int nl = s.indexOf(newline);
            if (nl >= 0) {
                nll = newline.length();
            } else {
                nl = s.indexOf("\r\n");
                if (nl >= 0) {
                    nll = 2;
                } else {
                    nl = s.indexOf(10);
                    if (nl >= 0) {
                        nll = 1;
                    }
                }
            }
            if (nl >= 0) {
                if (nl == 0) {
                    JPanel breakPanel = new JPanel(){

                        @Override
                        public Dimension getPreferredSize() {
                            Font f = this.getFont();
                            if (f != null) {
                                return new Dimension(1, f.getSize() + 2);
                            }
                            return new Dimension(0, 0);
                        }
                    };
                    breakPanel.setName("OptionPane.break");
                    this.addMessageComponents(container, cons, breakPanel, maxll, true);
                } else {
                    this.addMessageComponents(container, cons, s.substring(0, nl), maxll, false);
                }
                this.addMessageComponents(container, cons, s.substring(nl + nll), maxll, false);
            } else {
                JComponent c = this.createTextComponent(s, maxll);
                c.setName("OptionPane.label");
                this.configureMessageLabel(c);
                this.addMessageComponents(container, cons, c, maxll, true);
            }
        }
    }

    protected JComponent createHTMLTextComponent(String text, int maxll) {
        View view;
        if (maxll > 100000) {
            maxll = 80;
        }
        JLabel label = new JLabel(text, 10);
        Dimension preferredSize = label.getPreferredSize();
        int preferredWidth = preferredSize.width;
        int columnWidth = label.getFontMetrics(label.getFont()).charWidth('n');
        int width = columnWidth * maxll;
        if (preferredWidth > width && (view = (View)label.getClientProperty("html")) != null) {
            view.setSize(width, 0.0f);
            float w = view.getPreferredSpan(0);
            float h = view.getPreferredSpan(1);
            label.setPreferredSize(new Dimension((int)Math.ceil(w), (int)Math.ceil(h)));
        }
        return label;
    }

    protected JComponent createTextComponent(String text, int maxll) {
        if (maxll > 100000) {
            maxll = 80;
        }
        if (text.length() < maxll) {
            return new JLabel(text, 10);
        }
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        textArea.setBackground(UIManager.getColor("Label.background"));
        textArea.setFont(UIManager.getFont("Label.font"));
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setText(text);
        int columnWidth = textArea.getFontMetrics(textArea.getFont()).charWidth('n');
        textArea.setSize(maxll * columnWidth, 10000);
        return textArea;
    }

    protected void configureMessageLabel(JComponent label) {
        Font messageFont;
        Color color = (Color)DefaultLookup.get(this.optionPane, this, "OptionPane.messageForeground");
        if (color != null) {
            label.setForeground(color);
        }
        if ((messageFont = (Font)DefaultLookup.get(this.optionPane, this, "OptionPane.messageFont")) != null) {
            label.setFont(messageFont);
        }
    }

    static {
        if (newline == null) {
            newline = "\n";
        }
    }

    public static class AquaButtonAreaLayout
    extends BasicOptionPaneUI.ButtonAreaLayout {
        public AquaButtonAreaLayout(boolean syncAllWidths, int padding) {
            super(true, padding);
        }

        @Override
        public void layoutContainer(Container container) {
            Component[] children = container.getComponents();
            if (children == null || 0 >= children.length) {
                return;
            }
            int numChildren = children.length;
            int yLocation = container.getInsets().top;
            Dimension maxSize = new Dimension(79, 23);
            for (int i = 0; i < numChildren; ++i) {
                Dimension sizes = children[i].getPreferredSize();
                maxSize.width = Math.max(maxSize.width, sizes.width);
                maxSize.height = Math.max(maxSize.height, sizes.height);
            }
            int xLocation = container.getSize().width - (maxSize.width * numChildren + (numChildren - 1) * this.padding);
            int xOffset = maxSize.width + this.padding;
            for (int i = numChildren - 1; i >= 0; --i) {
                children[i].setBounds(xLocation, yLocation, maxSize.width, maxSize.height);
                xLocation += xOffset;
            }
        }
    }
}

