/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JScrollBar;
import javax.swing.Timer;
import org.violetlib.aqua.AnimationController;
import org.violetlib.aqua.AquaScrollBarUI;
import org.violetlib.aqua.AquaUtils;

public class AquaOverlayScrollPaneController {
    protected final Timer deactivationTimer = new Timer(750, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AquaOverlayScrollPaneController.this.fadeOutController.start();
        }
    });
    protected final AnimationController fadeOutController;
    protected JScrollBar vsb;
    protected JScrollBar hsb;
    protected JScrollBar activeScrollBar;
    protected boolean isMouseOverActiveScrollBar;
    protected final MouseListener scrollBarMouseListener;
    protected static final int FADE_OUT_TIME = 250;
    protected static final int DEACTIVATE_DELAY_TIME = 750;

    public AquaOverlayScrollPaneController() {
        this.deactivationTimer.setRepeats(false);
        this.fadeOutController = new AnimationController(new FadeOutAnimation(), 250);
        this.scrollBarMouseListener = new ScrollBarMouseListener();
    }

    public void dispose() {
        this.deactivationTimer.stop();
        if (this.hsb != null) {
            this.hsb.removeMouseListener(this.scrollBarMouseListener);
            this.hsb = null;
        }
        if (this.vsb != null) {
            this.vsb.removeMouseListener(this.scrollBarMouseListener);
            this.vsb = null;
        }
    }

    public int getActiveAxis() {
        if (this.activeScrollBar == this.vsb) {
            return 1;
        }
        if (this.activeScrollBar == this.hsb) {
            return 0;
        }
        return -1;
    }

    public void activateScrollBar(MouseEvent e, boolean isVertical) {
        boolean isNew;
        JScrollBar sb = isVertical ? this.vsb : this.hsb;
        boolean bl = isNew = sb != this.activeScrollBar;
        if (this.activeScrollBar != sb && this.activeScrollBar != null) {
            this.deactivateImmediately();
        }
        this.activeScrollBar = sb;
        if (this.activeScrollBar != null) {
            AquaScrollBarUI ui;
            this.activeScrollBar.setVisible(true);
            Rectangle scrollBarBounds = this.activeScrollBar.getBounds();
            this.isMouseOverActiveScrollBar = scrollBarBounds.contains(e.getX(), e.getY());
            if (isNew && (ui = AquaUtils.getUI(this.activeScrollBar, AquaScrollBarUI.class)) != null) {
                ui.setRolloverDisplayState(this.isMouseOverActiveScrollBar);
            }
            if (!this.isMouseOverActiveScrollBar) {
                this.scheduleOrPostponeDeactivation();
            }
        }
    }

    public void setVerticalScrollBar(JScrollBar sb) {
        if (sb != this.vsb) {
            if (this.vsb != null) {
                this.disconnect(this.vsb);
            }
            this.vsb = sb;
            this.disconnect(this.vsb);
            if (this.vsb != null) {
                this.initialize(this.vsb, "VERTICAL_SCROLLBAR");
            }
        }
    }

    public void setHorizontalScrollBar(JScrollBar sb) {
        if (sb != this.hsb) {
            if (this.hsb != null) {
                this.disconnect(this.hsb);
            }
            this.hsb = sb;
            if (this.hsb != null) {
                this.initialize(this.hsb, "HORIZONTAL_SCROLLBAR");
            }
        }
    }

    protected void disconnect(JScrollBar sb) {
        sb.removeMouseListener(this.scrollBarMouseListener);
        sb.setVisible(false);
        if (sb == this.activeScrollBar) {
            this.isMouseOverActiveScrollBar = false;
            this.activeScrollBar = null;
        }
    }

    protected void initialize(JScrollBar sb, String which) {
        this.reconfigure(sb, which);
        sb.addMouseListener(this.scrollBarMouseListener);
        sb.setVisible(false);
        AquaScrollBarUI ui = AquaUtils.getUI(sb, AquaScrollBarUI.class);
        if (ui != null) {
            ui.setRolloverDisplayState(false);
            ui.setAlpha(1.0f);
        }
    }

    protected void reconfigure(JScrollBar sb, String which) {
    }

    public void scheduleOrPostponeDeactivation() {
        this.deactivationTimer.stop();
        this.fadeOutController.stop();
        this.setAlpha(this.activeScrollBar, 1.0f);
        this.deactivationTimer.start();
    }

    public void cancelDeactivation() {
        this.deactivationTimer.stop();
        this.fadeOutController.stop();
        this.setAlpha(this.activeScrollBar, 1.0f);
    }

    public void deactivateImmediately() {
        this.deactivationTimer.stop();
        this.fadeOutController.stop();
        if (this.activeScrollBar != null) {
            this.activeScrollBar.setVisible(false);
            AquaScrollBarUI ui = AquaUtils.getUI(this.activeScrollBar, AquaScrollBarUI.class);
            if (ui != null) {
                ui.setRolloverDisplayState(false);
                ui.setAlpha(1.0f);
            }
            this.activeScrollBar = null;
        }
    }

    protected void setAlpha(JScrollBar sb, float alpha) {
        if (sb != null) {
            if (alpha == 0.0f) {
                this.deactivateImmediately();
            } else {
                AquaScrollBarUI ui = AquaUtils.getUI(sb, AquaScrollBarUI.class);
                if (ui != null) {
                    ui.setAlpha(alpha);
                }
            }
        }
    }

    protected class ScrollBarMouseListener
    extends MouseAdapter {
        protected ScrollBarMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JScrollBar sb = this.getScrollBar(e);
            if (sb == AquaOverlayScrollPaneController.this.activeScrollBar) {
                AquaOverlayScrollPaneController.this.cancelDeactivation();
                AquaOverlayScrollPaneController.this.isMouseOverActiveScrollBar = true;
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JScrollBar sb = this.getScrollBar(e);
            if (sb == AquaOverlayScrollPaneController.this.activeScrollBar) {
                AquaOverlayScrollPaneController.this.scheduleOrPostponeDeactivation();
                AquaOverlayScrollPaneController.this.isMouseOverActiveScrollBar = false;
            }
        }

        protected JScrollBar getScrollBar(MouseEvent e) {
            Component c = e.getComponent();
            if (c instanceof JScrollBar) {
                return (JScrollBar)c;
            }
            return null;
        }
    }

    protected class FadeOutAnimation
    implements AnimationController.Animation {
        protected FadeOutAnimation() {
        }

        @Override
        public void setAnimationState(float a) {
            AquaScrollBarUI ui;
            if (AquaOverlayScrollPaneController.this.activeScrollBar != null && (ui = AquaUtils.getUI(AquaOverlayScrollPaneController.this.activeScrollBar, AquaScrollBarUI.class)) != null) {
                if (ui.isDragging()) {
                    AquaOverlayScrollPaneController.this.scheduleOrPostponeDeactivation();
                    return;
                }
                AquaOverlayScrollPaneController.this.setAlpha(AquaOverlayScrollPaneController.this.activeScrollBar, 1.0f - a);
            }
        }
    }
}

