/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaScrollPaneUI;
import org.violetlib.aqua.AquaUtils;

public class AquaOverlayScrollPaneLayout
extends ScrollPaneLayout
implements UIResource {
    protected boolean isHorizontalScrollBarNeeded;
    protected boolean isVerticalScrollBarNeeded;

    public boolean isHorizontalScrollBarNeeded() {
        return this.isHorizontalScrollBarNeeded;
    }

    public boolean isVerticalScrollBarNeeded() {
        return this.isVerticalScrollBarNeeded;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        this.sync(parent);
        return super.preferredLayoutSize(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        this.sync(parent);
        return super.minimumLayoutSize(parent);
    }

    protected void sync(Container parent) {
        JScrollPane scrollPane = (JScrollPane)parent;
        this.vsbPolicy = scrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
        this.vsb = scrollPane.getVerticalScrollBar();
        this.hsb = scrollPane.getHorizontalScrollBar();
        this.viewport = scrollPane.getViewport();
    }

    @Override
    public void layoutContainer(Container parent) {
        boolean needCorner;
        Insets vpbInsets;
        Border viewportBorder;
        JScrollPane scrollPane = (JScrollPane)parent;
        this.sync(parent);
        ScrollPaneUI ui = scrollPane.getUI();
        if (ui instanceof AquaScrollPaneUI) {
            AquaScrollPaneUI a = (AquaScrollPaneUI)ui;
            a.syncOverlayScrollPaneViewportHolderSize();
        }
        Rectangle availR = scrollPane.getBounds();
        availR.y = 0;
        availR.x = 0;
        Insets insets = parent.getInsets();
        availR.x = insets.left;
        availR.y = insets.top;
        availR.width -= insets.left + insets.right;
        availR.height -= insets.top + insets.bottom;
        boolean isLeftToRight = !AquaScrollPaneUI.isRTLSupported || AquaUtils.isLeftToRight(scrollPane);
        Rectangle colHeadR = new Rectangle(0, availR.y, 0, 0);
        if (this.colHead != null && this.colHead.isVisible()) {
            int colHeadHeight;
            colHeadR.height = colHeadHeight = Math.min(availR.height, this.colHead.getPreferredSize().height);
            availR.y += colHeadHeight;
            availR.height -= colHeadHeight;
        }
        Rectangle rowHeadR = new Rectangle(0, 0, 0, 0);
        if (this.rowHead != null && this.rowHead.isVisible()) {
            int rowHeadWidth;
            rowHeadR.width = rowHeadWidth = Math.min(availR.width, this.rowHead.getPreferredSize().width);
            availR.width -= rowHeadWidth;
            if (isLeftToRight) {
                rowHeadR.x = availR.x;
                availR.x += rowHeadWidth;
            } else {
                rowHeadR.x = availR.x + availR.width;
            }
        }
        if ((viewportBorder = scrollPane.getViewportBorder()) != null) {
            vpbInsets = viewportBorder.getBorderInsets(parent);
            availR.x += vpbInsets.left;
            availR.y += vpbInsets.top;
            availR.width -= vpbInsets.left + vpbInsets.right;
            availR.height -= vpbInsets.top + vpbInsets.bottom;
        } else {
            vpbInsets = new Insets(0, 0, 0, 0);
        }
        this.determineScrollBarsNeeded(availR);
        if (this.viewport != null) {
            this.viewport.setBounds(availR);
        }
        rowHeadR.height = availR.height + vpbInsets.top + vpbInsets.bottom;
        rowHeadR.y = availR.y - vpbInsets.top;
        colHeadR.width = availR.width + vpbInsets.left + vpbInsets.right;
        colHeadR.x = availR.x - vpbInsets.left;
        if (this.rowHead != null) {
            this.rowHead.setBounds(rowHeadR);
        }
        if (this.colHead != null) {
            this.colHead.setBounds(colHeadR);
        }
        if (this.vsb != null) {
            if (this.isVerticalScrollBarNeeded) {
                int width = this.vsb.getPreferredSize().width;
                this.vsb.setBounds(isLeftToRight ? availR.x + availR.width - width : availR.x, availR.y, width, availR.height);
            } else {
                this.vsb.setBounds(0, 0, 0, 0);
            }
        }
        if (this.hsb != null) {
            if (this.isHorizontalScrollBarNeeded) {
                int height = this.hsb.getPreferredSize().height;
                this.hsb.setBounds(availR.x, availR.y + availR.height - height, availR.width, height);
            } else {
                this.hsb.setBounds(0, 0, 0, 0);
            }
        }
        boolean bl = needCorner = this.rowHead != null && this.colHead != null && this.rowHead.isVisible() && this.colHead.isVisible();
        if (this.lowerLeft != null) {
            this.lowerLeft.setBounds(0, 0, 0, 0);
        }
        if (this.lowerRight != null) {
            this.lowerRight.setBounds(0, 0, 0, 0);
        }
        if (this.upperLeft != null) {
            if (needCorner && isLeftToRight) {
                this.upperLeft.setBounds(rowHeadR.x, colHeadR.y, rowHeadR.width, colHeadR.height);
            } else {
                this.upperLeft.setBounds(0, 0, 0, 0);
            }
        }
        if (this.upperRight != null) {
            if (needCorner && !isLeftToRight) {
                this.upperRight.setBounds(rowHeadR.x, colHeadR.y, rowHeadR.width, colHeadR.height);
            } else {
                this.upperRight.setBounds(0, 0, 0, 0);
            }
        }
    }

    protected void determineScrollBarsNeeded(Rectangle availR) {
        boolean isEmpty;
        Component view = this.viewport != null ? SwingUtilities.getUnwrappedView(this.viewport) : null;
        Dimension viewPrefSize = view != null ? view.getPreferredSize() : new Dimension(0, 0);
        Dimension extentSize = this.viewport != null ? this.viewport.toViewCoordinates(availR.getSize()) : new Dimension(0, 0);
        boolean viewTracksViewportWidth = false;
        boolean viewTracksViewportHeight = false;
        boolean bl = isEmpty = availR.width < 0 || availR.height < 0;
        if (!isEmpty && view instanceof Scrollable) {
            Scrollable sv = (Scrollable)((Object)view);
            viewTracksViewportWidth = sv.getScrollableTracksViewportWidth();
            viewTracksViewportHeight = sv.getScrollableTracksViewportHeight();
        }
        this.isVerticalScrollBarNeeded = false;
        this.isHorizontalScrollBarNeeded = false;
        if (this.vsb != null && !isEmpty && this.vsbPolicy != 21) {
            boolean bl2 = this.isVerticalScrollBarNeeded = !viewTracksViewportHeight && viewPrefSize.height > extentSize.height;
        }
        if (this.hsb != null && !isEmpty && this.hsbPolicy != 31) {
            this.isHorizontalScrollBarNeeded = !viewTracksViewportWidth && viewPrefSize.width > extentSize.width;
        }
    }
}

