/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicPanelUI;
import org.violetlib.aqua.AquaBoxPainter;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.AquaVibrantSupport;
import org.violetlib.aqua.BackgroundPainter;

public class AquaPanelUI
extends BasicPanelUI {
    public static final String PANEL_STYLE_KEY = "JPanel.style";
    public static final String GROUP_BOX_STYLE = "groupBox";
    public static final String GROUP_BOX_TITLE_KEY = "Aqua.groupBoxTitle";
    static AquaUtils.RecyclableSingleton<AquaPanelUI> instance = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaPanelUI>(AquaPanelUI.class);
    public PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AquaPanelUI.this.propertyChange(evt);
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return instance.get();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        AquaVibrantSupport.updateVibrantStyle(c);
        c.addPropertyChangeListener(this.propertyChangeListener);
        this.updateStyle(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.propertyChangeListener);
        AquaVibrantSupport.uninstallVibrantStyle(c);
        Border b = c.getBorder();
        if (b instanceof UIResource) {
            c.setBorder(null);
        }
        super.uninstallUI(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        BackgroundPainter p = this.getBackgroundPainter(c);
        if (p != null) {
            p.paintBackground(c, g, 0, 0, c.getWidth(), c.getHeight());
        }
    }

    @Override
    public final void update(Graphics g, JComponent c) {
        if (c.isOpaque() || AquaVibrantSupport.isVibrant(c)) {
            AquaUtils.fillRect(g, c, 3);
        }
        this.paint(g, c);
    }

    protected void propertyChange(PropertyChangeEvent evt) {
        if (AquaVibrantSupport.processVibrantStyleChange(evt)) {
            return;
        }
        String prop = evt.getPropertyName();
        if (PANEL_STYLE_KEY.equals(prop) || GROUP_BOX_TITLE_KEY.equals(prop)) {
            JComponent c = (JComponent)evt.getSource();
            this.updateStyle(c);
        }
    }

    protected void updateStyle(JComponent c) {
        c.repaint();
        Border b = c.getBorder();
        if (b == null || b instanceof UIResource) {
            c.setBorder(this.getDefaultBorder(c));
        }
    }

    protected Border getDefaultBorder(JComponent c) {
        String style = this.getStyle(c);
        if (GROUP_BOX_STYLE.equals(style)) {
            String title = this.getGroupBoxTitle(c);
            if (title != null) {
                return AquaBoxPainter.getBorderForTitledBox();
            }
            return AquaBoxPainter.getTitlelessBorder();
        }
        return null;
    }

    protected String getStyle(JComponent c) {
        Object o = c.getClientProperty(PANEL_STYLE_KEY);
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    protected String getGroupBoxTitle(JComponent c) {
        Object o = c.getClientProperty(GROUP_BOX_TITLE_KEY);
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    protected BackgroundPainter getBackgroundPainter(JComponent c) {
        Object o = c.getClientProperty(PANEL_STYLE_KEY);
        if (GROUP_BOX_STYLE.equals(o)) {
            return AquaBoxPainter.getInstance();
        }
        return null;
    }
}

