/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.Method;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.violetlib.aqua.AquaPopup;
import org.violetlib.aqua.AquaRootPaneUI;
import org.violetlib.aqua.AquaUtils;

public class AquaPopupFactory
extends PopupFactory {
    private boolean isActive;

    @Override
    public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
        if (this.isActive) {
            try {
                Method m = PopupFactory.class.getDeclaredMethod("setPopupType", Integer.TYPE);
                m.setAccessible(true);
                m.invoke((Object)this, 2);
            }
            catch (Throwable e) {
                System.err.println("Unable to setPopupType: " + e);
                return new AquaPopup(owner, contents, x, y);
            }
            Popup p = super.getPopup(owner, contents, x, y);
            try {
                Method m = p.getClass().getDeclaredMethod("setCacheEnabled", Boolean.TYPE);
                m.setAccessible(true);
                m.invoke((Object)p, false);
            }
            catch (Exception ex) {
                System.err.println("Unable to prevent popup from being reused");
            }
            Window w = SwingUtilities.getWindowAncestor(contents);
            if (w.isDisplayable() && w.getWidth() > 0) {
                JRootPane rp;
                AquaRootPaneUI ui;
                w.setSize(w.getPreferredSize());
                w.invalidate();
                w.validate();
                if (w instanceof RootPaneContainer && (ui = AquaUtils.getUI(rp = ((RootPaneContainer)((Object)w)).getRootPane(), AquaRootPaneUI.class)) != null) {
                    ui.configure();
                }
            }
            return p;
        }
        return super.getPopup(owner, contents, x, y);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }
}

