/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import org.violetlib.aqua.AquaContextualPopup;

public class AquaPopupMenuUI
extends BasicPopupMenuUI {
    public static final String POP_UP_SCREEN_BOUNDS = "Aqua.PopupMenu.ScreenBounds";
    public static final String POP_UP_SELECTED_REGION = "Aqua.PopupMenu.SelectedRegion";
    public static final String POP_UP_SELECTED_REGION_LOCATION = "Aqua.PopupMenu.SelectedRegionLocation";
    private static Object HIDE_POPUP_KEY;
    private AquaContextualPopup cp;
    private ScrollingMouseListener scrollingMouseListener = new ScrollingMouseListener();

    public static ComponentUI createUI(JComponent x) {
        return new AquaPopupMenuUI();
    }

    @Override
    public boolean isPopupTrigger(MouseEvent e) {
        return e.isPopupTrigger();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.popupMenu, "opaque", Boolean.FALSE);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.popupMenu.addMouseListener(this.scrollingMouseListener);
        this.popupMenu.addMouseMotionListener(this.scrollingMouseListener);
        this.popupMenu.addMouseWheelListener(this.scrollingMouseListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.popupMenu.removeMouseListener(this.scrollingMouseListener);
        this.popupMenu.removeMouseMotionListener(this.scrollingMouseListener);
        this.popupMenu.removeMouseWheelListener(this.scrollingMouseListener);
    }

    @Override
    public Popup getPopup(JPopupMenu popup, int x, int y) {
        Component owner;
        int width = 0;
        int height = 0;
        Object o = popup.getClientProperty(POP_UP_SCREEN_BOUNDS);
        if (o instanceof Rectangle) {
            Rectangle r = (Rectangle)o;
            x = r.x;
            y = r.y;
            width = r.width;
            height = r.height;
        }
        if (this.isContextualMenuStyle(owner = popup.getInvoker())) {
            Rectangle selectedRegion = null;
            Point selectedRegionLocation = null;
            Object sr = popup.getClientProperty(POP_UP_SELECTED_REGION);
            if (sr instanceof Rectangle) {
                selectedRegion = (Rectangle)sr;
                Object loc = popup.getClientProperty(POP_UP_SELECTED_REGION_LOCATION);
                if (loc instanceof Point) {
                    selectedRegionLocation = (Point)loc;
                }
            }
            this.cp = new AquaContextualPopup(popup, owner, selectedRegion, selectedRegionLocation, x, y, width, height);
            return this.cp.getPopup();
        }
        PopupFactory f = PopupFactory.getSharedInstance();
        return f.getPopup(owner, popup, x, y);
    }

    protected boolean isContextualMenuStyle(Component c) {
        return true;
    }

    public static Object getHidePopupKey() {
        if (HIDE_POPUP_KEY == null) {
            JComboBox cb = new JComboBox();
            HIDE_POPUP_KEY = cb.getClientProperty("doNotCancelPopup");
        }
        return HIDE_POPUP_KEY;
    }

    private class ScrollingMouseListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private ScrollingMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (AquaPopupMenuUI.this.cp != null) {
                AquaPopupMenuUI.this.cp.dispatchEvent(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (AquaPopupMenuUI.this.cp != null) {
                AquaPopupMenuUI.this.cp.dispatchEvent(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (AquaPopupMenuUI.this.cp != null) {
                AquaPopupMenuUI.this.cp.dispatchEvent(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (AquaPopupMenuUI.this.cp != null) {
                AquaPopupMenuUI.this.cp.dispatchEvent(e);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (AquaPopupMenuUI.this.cp != null) {
                AquaPopupMenuUI.this.cp.dispatchEvent(e);
            }
        }
    }
}

