/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ProgressBarUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.IndeterminateProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorLayoutConfiguration;

public class AquaProgressBarUI
extends ProgressBarUI
implements ChangeListener,
PropertyChangeListener,
AncestorListener,
AquaUtilControlSize.Sizeable {
    public static final String PROGRESS_BAR_STYLE_KEY = "JProgressBar.style";
    private static final boolean ADJUSTTIMER = true;
    protected AquaUIPainter.Size sizeVariant = AquaUIPainter.Size.REGULAR;
    protected Color selectionForeground;
    private Animator animator;
    protected boolean isAnimating;
    protected boolean isCircular;
    protected int repaintInterval;
    protected final AquaUIPainter painter = AquaPainting.create();
    protected JProgressBar progressBar;

    public static ComponentUI createUI(JComponent x) {
        return new AquaProgressBarUI();
    }

    protected AquaProgressBarUI() {
    }

    @Override
    public void installUI(JComponent c) {
        this.progressBar = (JProgressBar)c;
        this.installDefaults();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.stopAnimationTimer();
        this.progressBar = null;
    }

    protected void installDefaults() {
        LookAndFeel.installProperty(this.progressBar, "opaque", false);
        LookAndFeel.installBorder(this.progressBar, "ProgressBar.border");
        LookAndFeel.installColorsAndFont(this.progressBar, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
        this.selectionForeground = UIManager.getColor("ProgressBar.selectionForeground");
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.progressBar);
    }

    protected void installListeners() {
        this.progressBar.addChangeListener(this);
        this.progressBar.addPropertyChangeListener(this);
        this.progressBar.addAncestorListener(this);
        AquaUtilControlSize.addSizePropertyListener(this.progressBar);
    }

    protected void uninstallListeners() {
        AquaUtilControlSize.removeSizePropertyListener(this.progressBar);
        this.progressBar.removeAncestorListener(this);
        this.progressBar.removePropertyChangeListener(this);
        this.progressBar.removeChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.progressBar.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if ("Frame.active".equals(prop)) {
            this.progressBar.repaint();
        } else if ("indeterminate".equals(prop)) {
            this.stopAnimationTimer();
            this.progressBar.repaint();
        } else if (this.isStyleProperty(prop)) {
            String style = this.getStyleProperty();
            this.isCircular = "circular".equalsIgnoreCase(style + "");
            this.repaintInterval = this.isCircular ? UIManager.getInt("ProgressBar.circularRepaintInterval") : UIManager.getInt("ProgressBar.repaintInterval");
            this.stopAnimationTimer();
            this.progressBar.revalidate();
            this.progressBar.repaint();
        } else if ("orientation".equals(prop)) {
            this.progressBar.revalidate();
            this.progressBar.repaint();
        }
    }

    protected boolean isStyleProperty(String prop) {
        return AquaUtils.isProperty(prop, PROGRESS_BAR_STYLE_KEY);
    }

    protected String getStyleProperty() {
        return AquaUtils.getProperty(this.progressBar, PROGRESS_BAR_STYLE_KEY);
    }

    @Override
    public void ancestorRemoved(AncestorEvent e) {
        this.stopAnimationTimer();
    }

    @Override
    public void ancestorAdded(AncestorEvent e) {
        if (!this.progressBar.isIndeterminate()) {
            return;
        }
        this.startAnimationTimer();
    }

    @Override
    public void ancestorMoved(AncestorEvent e) {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.revalidateAnimationTimers();
        Insets i = this.progressBar.getInsets();
        int width = this.progressBar.getWidth() - (i.right + i.left);
        int height = this.progressBar.getHeight() - (i.bottom + i.top);
        int x = i.left;
        int y = i.top;
        this.painter.configure(width, height);
        Configuration pg = this.getConfiguration();
        this.painter.getPainter(pg).paint(g, x, y);
        if (this.isCircular) {
            return;
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, i.left, i.top, width, height);
        }
    }

    protected ProgressIndicatorLayoutConfiguration getLayoutConfiguration() {
        AquaUIPainter.Orientation orientation;
        AquaUIPainter.Orientation orientation2 = orientation = this.isHorizontal() ? AquaUIPainter.Orientation.HORIZONTAL : AquaUIPainter.Orientation.VERTICAL;
        if (this.progressBar.isIndeterminate()) {
            AquaUIPainter.ProgressWidget w = this.isCircular ? AquaUIPainter.ProgressWidget.SPINNER : AquaUIPainter.ProgressWidget.INDETERMINATE_BAR;
            return new ProgressIndicatorLayoutConfiguration(w, this.sizeVariant, orientation);
        }
        return new ProgressIndicatorLayoutConfiguration(AquaUIPainter.ProgressWidget.BAR, this.sizeVariant, orientation);
    }

    protected Configuration getConfiguration() {
        AquaUIPainter.Orientation orientation;
        AquaUIPainter.State state = this.getState(this.progressBar);
        AquaUIPainter.Orientation orientation2 = orientation = this.isHorizontal() ? AquaUIPainter.Orientation.HORIZONTAL : AquaUIPainter.Orientation.VERTICAL;
        if (this.progressBar.isIndeterminate()) {
            int frameCount = this.isCircular ? 15 : 90;
            long intervals = System.currentTimeMillis() / (long)(this.repaintInterval > 0 ? this.repaintInterval : 100);
            int speed = this.isCircular ? 1 : 4;
            int animationFrame = (int)((long)speed * intervals % (long)frameCount);
            AquaUIPainter.ProgressWidget w = this.isCircular ? AquaUIPainter.ProgressWidget.SPINNER : AquaUIPainter.ProgressWidget.INDETERMINATE_BAR;
            return new IndeterminateProgressIndicatorConfiguration(w, this.sizeVariant, state, orientation, animationFrame);
        }
        double value = AquaProgressBarUI.checkValue(this.progressBar.getPercentComplete());
        AquaUIPainter.UILayoutDirection ld = AquaUtils.getLayoutDirection(this.progressBar);
        return new ProgressIndicatorConfiguration(AquaUIPainter.ProgressWidget.BAR, this.sizeVariant, state, orientation, value, ld);
    }

    static double checkValue(double value) {
        return Double.isNaN(value) ? 0.0 : value;
    }

    protected AquaUIPainter.State getState(JComponent c) {
        if (!c.isEnabled()) {
            return AquaUIPainter.State.INACTIVE;
        }
        if (!AquaFocusHandler.isActive(c)) {
            return AquaUIPainter.State.INACTIVE;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    protected void paintString(Graphics g, int x, int y, int width, int height) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        String progressString = this.progressBar.getString();
        g2.setFont(this.progressBar.getFont());
        Point renderLocation = this.getStringPlacement(g2, progressString, x, y, width, height);
        Rectangle oldClip = g2.getClipBounds();
        if (this.isHorizontal()) {
            g2.setColor(this.selectionForeground);
            AquaUtils.drawString(this.progressBar, g2, progressString, renderLocation.x, renderLocation.y);
        } else {
            AffineTransform savedAT = g2.getTransform();
            g2.transform(AffineTransform.getRotateInstance(-1.5707963267948966, 0.0, 0.0));
            g2.translate(-this.progressBar.getHeight(), 0);
            g2.setColor(this.selectionForeground);
            AquaUtils.drawString(this.progressBar, g2, progressString, renderLocation.x, renderLocation.y);
            g2.setTransform(savedAT);
        }
        g2.setClip(oldClip);
    }

    protected Point getStringPlacement(Graphics g, String progressString, int x, int y, int width, int height) {
        FontMetrics fontSizer = this.progressBar.getFontMetrics(this.progressBar.getFont());
        int stringWidth = fontSizer.stringWidth(progressString);
        if (!this.isHorizontal()) {
            int oldH = height;
            height = width;
            width = oldH;
            int oldX = x;
            x = y;
            y = oldX;
        }
        return new Point(x + Math.round(width / 2 - stringWidth / 2), y + (height + fontSizer.getAscent() - fontSizer.getLeading() - fontSizer.getDescent()) / 2 - 1);
    }

    protected Dimension getCircularPreferredSize() {
        ProgressIndicatorLayoutConfiguration g = this.getLayoutConfiguration();
        LayoutInfo layoutInfo = this.painter.getLayoutInfo().getLayoutInfo(g);
        int width = (int)layoutInfo.getFixedVisualWidth();
        int height = (int)layoutInfo.getFixedVisualHeight();
        if (width == 0) {
            width = 32;
        }
        if (height == 0) {
            height = 32;
        }
        return new Dimension(width, height);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.isCircular) {
            return this.getCircularPreferredSize();
        }
        FontMetrics metrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
        ProgressIndicatorLayoutConfiguration g = this.getLayoutConfiguration();
        LayoutInfo layoutInfo = this.painter.getLayoutInfo().getLayoutInfo(g);
        Dimension size = this.isHorizontal() ? this.getPreferredHorizontalSize(layoutInfo, metrics) : this.getPreferredVerticalSize(layoutInfo, metrics);
        Insets insets = this.progressBar.getInsets();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    protected Dimension getPreferredHorizontalSize(LayoutInfo layoutInfo, FontMetrics metrics) {
        int stringHeight;
        int width = this.sizeVariant == AquaUIPainter.Size.REGULAR ? 146 : 140;
        int height = this.sizeVariant == AquaUIPainter.Size.REGULAR ? 20 : 14;
        height = (int)Math.max((float)height, layoutInfo.getMinimumVisualHeight());
        Dimension size = new Dimension(width, height);
        if (!this.progressBar.isStringPainted()) {
            return size;
        }
        String progString = this.progressBar.getString();
        int stringWidth = metrics.stringWidth(progString);
        if (stringWidth > size.width) {
            size.width = stringWidth;
        }
        if ((stringHeight = metrics.getHeight() + metrics.getDescent()) > size.height) {
            size.height = stringHeight;
        }
        return size;
    }

    protected Dimension getPreferredVerticalSize(LayoutInfo layoutInfo, FontMetrics metrics) {
        int stringWidth;
        int width = this.sizeVariant == AquaUIPainter.Size.REGULAR ? 20 : 14;
        int height = this.sizeVariant == AquaUIPainter.Size.REGULAR ? 146 : 140;
        width = (int)Math.max((float)width, layoutInfo.getMinimumVisualWidth());
        Dimension size = new Dimension(width, height);
        if (!this.progressBar.isStringPainted()) {
            return size;
        }
        String progString = this.progressBar.getString();
        int stringHeight = metrics.getHeight() + metrics.getDescent();
        if (stringHeight > size.width) {
            size.width = stringHeight;
        }
        if ((stringWidth = metrics.stringWidth(progString)) > size.height) {
            size.height = stringWidth;
        }
        return size;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (this.isCircular) {
            return this.getCircularPreferredSize();
        }
        Dimension pref = this.getPreferredSize(this.progressBar);
        if (this.isHorizontal()) {
            pref.width = 10;
        } else {
            pref.height = 10;
        }
        return pref;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        if (this.isCircular) {
            return this.getCircularPreferredSize();
        }
        Dimension pref = this.getPreferredSize(this.progressBar);
        if (this.isHorizontal()) {
            pref.width = Short.MAX_VALUE;
        } else {
            pref.height = Short.MAX_VALUE;
        }
        return pref;
    }

    @Override
    public void applySizeFor(JComponent c, AquaUIPainter.Size size, boolean isDefaultSize) {
        this.sizeVariant = size;
        AquaUtilControlSize.configureFontFromSize(c, size);
        this.progressBar.revalidate();
        this.progressBar.repaint();
    }

    protected void startAnimationTimer() {
        if (this.animator == null) {
            this.animator = new Animator();
        }
        this.animator.start();
        this.isAnimating = true;
    }

    protected void stopAnimationTimer() {
        if (this.animator != null) {
            this.animator.stop();
        }
        this.isAnimating = false;
    }

    protected boolean isHorizontal() {
        return this.progressBar.getOrientation() == 0;
    }

    protected void revalidateAnimationTimers() {
        if (!this.progressBar.isIndeterminate() || this.getState(this.progressBar) == AquaUIPainter.State.INACTIVE) {
            this.stopAnimationTimer();
        } else if (!this.isAnimating) {
            this.startAnimationTimer();
        }
    }

    protected class Animator
    implements ActionListener {
        private static final int MINIMUM_DELAY = 5;
        private Timer timer;
        private long previousDelay;
        private long lastCall;
        private final int repaintInterval;

        public Animator() {
            this.repaintInterval = AquaProgressBarUI.this.repaintInterval > 0 ? AquaProgressBarUI.this.repaintInterval : 100;
        }

        protected void start() {
            this.previousDelay = this.repaintInterval;
            this.lastCall = 0L;
            if (this.timer == null) {
                this.timer = new Timer(this.repaintInterval, this);
            } else {
                this.timer.setDelay(this.repaintInterval);
            }
            this.timer.setRepeats(false);
            this.timer.setCoalesce(false);
            this.timer.start();
        }

        protected void stop() {
            this.timer.stop();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            long time = System.currentTimeMillis();
            if (this.lastCall > 0L) {
                int nextDelay = (int)(this.previousDelay - time + this.lastCall + (long)this.repaintInterval);
                if (nextDelay < 5) {
                    nextDelay = 5;
                }
                this.timer.setInitialDelay(nextDelay);
                this.previousDelay = nextDelay;
            }
            this.timer.start();
            this.lastCall = time;
            AquaProgressBarUI.this.progressBar.repaint();
        }
    }
}

