/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicRootPaneUI;
import org.violetlib.aqua.AquaCustomStyledWindow;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.AquaVibrantSupport;

public class AquaRootPaneUI
extends BasicRootPaneUI
implements AncestorListener,
WindowListener,
ContainerListener {
    public static final String AQUA_WINDOW_STYLE_KEY = "Aqua.windowStyle";
    private static boolean forceActiveWindowDisplay;
    protected JRootPane rootPane;
    protected WindowHierarchyListener hierarchyListener;
    protected AncestorChangeListener ancestorChangeListener;
    protected PropertyChangeListener windowStylePropertyChangeListener;
    protected boolean isInitialized;
    protected AquaCustomStyledWindow customStyledWindow;
    protected int vibrantStyle = -1;

    public static ComponentUI createUI(JComponent c) {
        return new AquaRootPaneUI();
    }

    public static void setForceActiveWindowDisplay(boolean b) {
        if (b != forceActiveWindowDisplay) {
            Window[] windows;
            forceActiveWindowDisplay = b;
            for (Window w : windows = Window.getWindows()) {
                boolean isActiveStyle;
                boolean shouldBeActive;
                RootPaneContainer rpc;
                JRootPane rp;
                AquaRootPaneUI ui;
                if (!(w instanceof RootPaneContainer) || (ui = AquaUtils.getUI(rp = (rpc = (RootPaneContainer)((Object)w)).getRootPane(), AquaRootPaneUI.class)) == null || (shouldBeActive = b || w.isActive()) == (isActiveStyle = Boolean.TRUE.equals(rp.getClientProperty("Frame.active")))) continue;
                rp.repaint();
                AquaRootPaneUI.updateComponentTreeUIActivation(rp, shouldBeActive);
            }
        }
    }

    @Override
    public void installUI(JComponent c) {
        JFrame frameParent;
        Color bg;
        Container parent;
        this.rootPane = (JRootPane)c;
        super.installUI(c);
        c.addAncestorListener(this);
        this.ancestorChangeListener = new AncestorChangeListener();
        if (c.isShowing() && c.isEnabled()) {
            this.updateDefaultButton(this.rootPane);
        }
        if ((parent = c.getParent()) != null && parent instanceof JFrame && ((bg = (frameParent = (JFrame)parent).getBackground()) == null || bg instanceof UIResource)) {
            frameParent.setBackground(UIManager.getColor("Panel.background"));
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removeAncestorListener(this);
        if (this.customStyledWindow != null) {
            this.customStyledWindow.dispose();
            this.customStyledWindow = null;
        }
        this.removeVisualEffectView();
        this.isInitialized = false;
        super.uninstallUI(c);
    }

    @Override
    protected void installListeners(JRootPane root) {
        super.installListeners(root);
        this.hierarchyListener = new WindowHierarchyListener();
        root.addHierarchyListener(this.hierarchyListener);
    }

    @Override
    protected void uninstallListeners(JRootPane root) {
        root.removeHierarchyListener(this.hierarchyListener);
        this.hierarchyListener = null;
        root.removePropertyChangeListener("ancestor", this.ancestorChangeListener);
        this.ancestorChangeListener = null;
        super.uninstallListeners(root);
        if (this.windowStylePropertyChangeListener != null) {
            root.removePropertyChangeListener(this.windowStylePropertyChangeListener);
            this.windowStylePropertyChangeListener = null;
        }
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        if (e.getContainer() instanceof JRootPane) {
            JRootPane root = (JRootPane)e.getContainer();
            if (e.getChild() == root.getLayeredPane()) {
                JLayeredPane layered = root.getLayeredPane();
                layered.addContainerListener(this);
            }
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        if (e.getContainer() instanceof JRootPane) {
            JRootPane root = (JRootPane)e.getContainer();
            if (e.getChild() == root.getLayeredPane()) {
                JLayeredPane layered = root.getLayeredPane();
                layered.removeContainerListener(this);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String prop = e.getPropertyName();
        if ("defaultButton".equals(prop) || "temporaryDefaultButton".equals(prop)) {
            JRootPane root = (JRootPane)e.getSource();
            if (root.isShowing() && root.isEnabled()) {
                this.updateDefaultButton(root);
            }
        } else if ("enabled".equals(prop) || "Frame.active".equals(prop)) {
            JRootPane root = (JRootPane)e.getSource();
            if (root.isShowing() && ((Boolean)e.getNewValue()).booleanValue()) {
                this.updateDefaultButton((JRootPane)e.getSource());
            }
        } else if ("Aqua.backgroundStyle".equals(prop)) {
            Object o = e.getNewValue();
            this.setupBackgroundStyle(o, true);
        }
    }

    protected void refreshWindowStyleMask() {
        if (this.customStyledWindow != null) {
            this.customStyledWindow.refreshWindowStyleMask();
        }
    }

    synchronized void updateDefaultButton(JRootPane root) {
        JButton button = root.getDefaultButton();
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        JRootPane rp;
        JComponent comp = event.getComponent();
        Window owningWindow = SwingUtilities.getWindowAncestor(comp);
        JRootPane jRootPane = rp = comp instanceof JRootPane ? (JRootPane)comp : null;
        if (owningWindow != null) {
            owningWindow.removeWindowListener(this);
            owningWindow.addWindowListener(this);
        }
        if (rp != null && rp.isEnabled() && rp.getDefaultButton() != null) {
            this.updateDefaultButton(rp);
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
        AquaRootPaneUI.updateWindowActivation(e, Boolean.TRUE);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        AquaRootPaneUI.updateWindowActivation(e, Boolean.FALSE);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        Window w = e.getWindow();
        w.removeWindowListener(this);
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    public void windowStateChanged(WindowEvent e) {
    }

    public void windowGainedFocus(WindowEvent e) {
    }

    public void windowLostFocus(WindowEvent e) {
    }

    private static void updateWindowActivation(WindowEvent e, Object active) {
        if (forceActiveWindowDisplay) {
            active = Boolean.TRUE;
        }
        Component c = (Component)e.getSource();
        c.repaint();
        AquaRootPaneUI.updateComponentTreeUIActivation(c, active);
    }

    private static void updateComponentTreeUIActivation(Component c, Object active) {
        if (c instanceof JInternalFrame) {
            Object object = active = ((JInternalFrame)c).isSelected() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (c instanceof JComponent) {
            ((JComponent)c).putClientProperty("Frame.active", active);
        }
        Component[] children = null;
        if (c instanceof JMenu) {
            children = ((JMenu)c).getMenuComponents();
        } else if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (children == null) {
            return;
        }
        for (Component element : children) {
            AquaRootPaneUI.updateComponentTreeUIActivation(element, active);
        }
    }

    @Override
    public final void update(Graphics g, JComponent c) {
        if (this.customStyledWindow != null) {
            this.customStyledWindow.paintBackground(g);
        } else if (c.isOpaque() || this.vibrantStyle >= 0) {
            AquaUtils.fillRect(g, c, 3);
        }
        this.paint(g, c);
    }

    public void configure() {
        if (this.rootPane.getParent() != null && this.rootPane.getParent().isDisplayable()) {
            this.isInitialized = true;
            this.updatePopupStyle(this.rootPane);
            this.installCustomWindowStyle();
            this.updateVisualEffectView();
        }
    }

    protected void updatePopupStyle(JRootPane rp) {
        Component c;
        int count;
        Container cp;
        Window w = SwingUtilities.getWindowAncestor(rp);
        if (w != null && w.getType() == Window.Type.POPUP && (cp = rp.getContentPane()) != null && (count = cp.getComponentCount()) == 1 && (c = cp.getComponent(0)) instanceof JComponent) {
            JComponent jc = (JComponent)c;
            Object o = jc.getClientProperty("AquaPopup.backgroundStyle");
            this.setupBackgroundStyle(o, false);
            o = jc.getClientProperty("AquaPopup.cornerRadius");
            this.setupCornerRadius(o);
        }
    }

    protected void setupBackgroundStyle(Object o, boolean update) {
        int style = AquaVibrantSupport.parseVibrantStyle(o, false);
        if (style != this.vibrantStyle) {
            this.vibrantStyle = style;
            this.rootPane.setBackground(this.vibrantStyle >= 0 ? new Color(0, 0, 0, 0) : null);
            if (this.isInitialized && update) {
                this.updateVisualEffectView();
            }
        }
    }

    protected void setupCornerRadius(Object o) {
        float radius = 0.0f;
        if (o != null) {
            if (o instanceof String) {
                String s = (String)o;
                if (s.equals("default")) {
                    radius = 6.0f;
                }
            } else if (o instanceof Number) {
                radius = ((Number)o).floatValue();
            }
            if (radius < 0.0f) {
                radius = 0.0f;
            }
        }
        Window w = SwingUtilities.getWindowAncestor(this.rootPane);
        AquaUtils.setCornerRadius(w, radius);
    }

    protected void updateVisualEffectView() {
        Window w = SwingUtilities.getWindowAncestor(this.rootPane);
        if (w != null) {
            if (this.vibrantStyle >= 0) {
                try {
                    AquaVibrantSupport.addFullWindowVibrantView(w, this.vibrantStyle);
                }
                catch (IllegalArgumentException ex) {
                    System.err.println("Unable to install visual effect view: " + ex.getMessage());
                }
            } else {
                AquaVibrantSupport.removeFullWindowVibrantView(w);
            }
        }
    }

    protected void removeVisualEffectView() {
        Window w = SwingUtilities.getWindowAncestor(this.rootPane);
        if (w != null) {
            AquaVibrantSupport.removeFullWindowVibrantView(w);
        }
    }

    protected void installCustomWindowStyle() {
        Window w;
        int style;
        if (this.customStyledWindow == null && (style = this.getCustomWindowStyle()) >= 0 && (w = SwingUtilities.getWindowAncestor(this.rootPane)) != null) {
            try {
                this.customStyledWindow = new AquaCustomStyledWindow(w, style);
            }
            catch (IllegalArgumentException ex) {
                AquaUtils.syslog("Unable to install custom window style: " + ex.getMessage());
            }
        }
    }

    protected int getCustomWindowStyle() {
        Object o = this.rootPane.getClientProperty(AQUA_WINDOW_STYLE_KEY);
        if (o instanceof String) {
            if ("unifiedToolBar".equals(o)) {
                return 3;
            }
            if ("texturedToolBar".equals(o)) {
                return 4;
            }
            if ("combinedToolBar".equals(o)) {
                return 5;
            }
            if ("overlayTitleBar".equals(o)) {
                return 0;
            }
            if ("transparentTitleBar".equals(o)) {
                return 1;
            }
            if ("noTitleBar".equals(o)) {
                return 2;
            }
        }
        return -1;
    }

    protected class WindowHierarchyListener
    implements HierarchyListener {
        protected WindowHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (!AquaRootPaneUI.this.isInitialized && e.getChangeFlags() == 2L) {
                AquaRootPaneUI.this.rootPane.addPropertyChangeListener("ancestor", AquaRootPaneUI.this.ancestorChangeListener);
                AquaRootPaneUI.this.configure();
            }
        }
    }

    protected class WindowStylePropertyChangeListener
    implements PropertyChangeListener {
        protected WindowStylePropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop != null && (prop.equals("Window.closeable") || prop.equals("Window.minimizable"))) {
                AquaRootPaneUI.this.refreshWindowStyleMask();
            }
        }
    }

    protected class AncestorChangeListener
    implements PropertyChangeListener {
        protected AncestorChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getNewValue() != null) {
                AquaRootPaneUI.this.refreshWindowStyleMask();
                if (AquaRootPaneUI.this.windowStylePropertyChangeListener == null) {
                    AquaRootPaneUI.this.windowStylePropertyChangeListener = new WindowStylePropertyChangeListener();
                    AquaRootPaneUI.this.rootPane.addPropertyChangeListener(AquaRootPaneUI.this.windowStylePropertyChangeListener);
                }
            }
        }
    }
}

