/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.AlphaComposite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollBarUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaScrollPaneUI;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.ScrollBarThumbConfiguration;
import org.violetlib.jnr.aqua.ScrollBarThumbLayoutConfiguration;

public class AquaScrollBarUI
extends ScrollBarUI {
    public static final String STYLE_CLIENT_PROPERTY_KEY = "JScrollBar.style";
    public static final String THUMB_STYLE_CLIENT_PROPERTY_KEY = "JScrollBar.thumbStyle";
    private static final int kInitialDelay = 300;
    private static final int kNormalDelay = 100;
    protected float currentThumbPosition;
    protected boolean fIsDragging;
    protected boolean fIsOverThumb;
    protected boolean fisRolloverDisplay;
    protected Timer fScrollTimer;
    protected ScrollListener fScrollListener;
    protected TrackListener fTrackListener;
    protected ScrollBarPart fTrackHighlight = ScrollBarPart.NONE;
    protected ScrollBarPart fMousePart = ScrollBarPart.NONE;
    protected JScrollBar fScrollBar;
    protected ModelListener fModelListener;
    protected PropertyChangeListener fPropertyChangeListener;
    protected float alpha = 1.0f;
    protected final AquaUIPainter painter = AquaPainting.create();

    public static ComponentUI createUI(JComponent c) {
        return new AquaScrollBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.fScrollBar = (JScrollBar)c;
        this.installListeners();
        this.configureScrollBarColors();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.fScrollBar = null;
    }

    protected void configureScrollBarColors() {
        LookAndFeel.installColors(this.fScrollBar, "ScrollBar.background", "ScrollBar.foreground");
    }

    protected TrackListener createTrackListener() {
        return new TrackListener();
    }

    protected ScrollListener createScrollListener() {
        return new ScrollListener();
    }

    protected void installListeners() {
        this.fTrackListener = this.createTrackListener();
        this.fModelListener = this.createModelListener();
        this.fPropertyChangeListener = this.createPropertyChangeListener();
        this.fScrollBar.addMouseListener(this.fTrackListener);
        this.fScrollBar.addMouseMotionListener(this.fTrackListener);
        this.fScrollBar.getModel().addChangeListener(this.fModelListener);
        this.fScrollBar.addPropertyChangeListener(this.fPropertyChangeListener);
        this.fScrollListener = this.createScrollListener();
        this.fScrollTimer = new Timer(100, this.fScrollListener);
        this.fScrollTimer.setInitialDelay(300);
    }

    protected void uninstallListeners() {
        this.fScrollTimer.stop();
        this.fScrollTimer = null;
        this.fScrollBar.getModel().removeChangeListener(this.fModelListener);
        this.fScrollBar.removeMouseListener(this.fTrackListener);
        this.fScrollBar.removeMouseMotionListener(this.fTrackListener);
        this.fScrollBar.removePropertyChangeListener(this.fPropertyChangeListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected ModelListener createModelListener() {
        return new ModelListener();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.alpha == 0.0f) {
            return;
        }
        Graphics2D gg = null;
        if (this.alpha < 1.0f) {
            gg = (Graphics2D)g.create();
            gg.setComposite(AlphaComposite.getInstance(3, this.alpha));
            g = gg;
        }
        int width = this.fScrollBar.getWidth();
        int height = this.fScrollBar.getHeight();
        ScrollBarConfiguration bg = this.getConfiguration(false);
        int x = 0;
        int y = 0;
        if (bg.getWidget() == AquaUIPainter.ScrollBarWidget.OVERLAY) {
            int thickness = this.getScrollBarThickness(bg);
            if (bg.getOrientation() == AquaUIPainter.Orientation.HORIZONTAL) {
                y = height - thickness;
                height = thickness;
            } else if (!AquaScrollPaneUI.isRTLSupported || AquaUtils.isLeftToRight(this.fScrollBar)) {
                x = width - thickness;
                width = thickness;
            } else {
                width = thickness;
            }
        }
        this.painter.configure(width, height);
        Painter p = this.painter.getPainter(bg);
        p.paint(g, x, y);
        if (gg != null) {
            gg.dispose();
        }
    }

    protected ScrollBarConfiguration getConfiguration(boolean isForLayoutSize) {
        AquaUIPainter.ScrollBarWidget sw = this.getScrollBarWidget(isForLayoutSize);
        AquaUIPainter.ScrollBarKnobWidget kw = this.getScrollBarKnobWidget(sw);
        AquaUIPainter.Size size = this.getScrollBarSize();
        AquaUIPainter.State state = this.getScrollBarState();
        AquaUIPainter.Orientation o = this.getScrollBarOrientation();
        float thumbPosition = this.getCurrentThumbPosition();
        float thumbExtent = this.getCurrentThumbExtent();
        if ((double)thumbExtent >= 0.999) {
            kw = AquaUIPainter.ScrollBarKnobWidget.NONE;
        }
        Object styleProperty = this.fScrollBar.getClientProperty(STYLE_CLIENT_PROPERTY_KEY);
        boolean noTrack = "sidebar".equals(styleProperty);
        return new ScrollBarConfiguration(sw, kw, size, state, o, thumbPosition, thumbExtent, noTrack);
    }

    protected float getCurrentThumbPosition() {
        float valueRange = Math.max(0, this.fScrollBar.getMaximum() - this.fScrollBar.getMinimum());
        float scrollingRange = valueRange - (float)this.fScrollBar.getModel().getExtent();
        this.currentThumbPosition = scrollingRange <= 0.0f ? 0.0f : (float)(this.fScrollBar.getValue() - this.fScrollBar.getMinimum()) / scrollingRange;
        return this.currentThumbPosition;
    }

    protected float getCurrentThumbExtent() {
        float valueRange = Math.max(0, this.fScrollBar.getMaximum() - this.fScrollBar.getMinimum());
        return valueRange <= 0.0f ? 0.0f : (float)this.fScrollBar.getModel().getExtent() / valueRange;
    }

    protected int getValueFromThumbPosition(float extendedThumbPosition) {
        int minimum = this.fScrollBar.getMinimum();
        int maximum = this.fScrollBar.getMaximum();
        int extent = this.fScrollBar.getModel().getExtent();
        if (extendedThumbPosition <= 0.0f) {
            return minimum;
        }
        if (extendedThumbPosition >= 1.0f) {
            return maximum - extent;
        }
        float valueRange = Math.max(0, maximum - minimum);
        float scrollingRange = valueRange - (float)extent;
        return Math.round((float)minimum + extendedThumbPosition * scrollingRange);
    }

    protected AquaUIPainter.ScrollBarWidget getScrollBarWidget(boolean isForLayoutSize) {
        if (this.isOverlayStyle()) {
            return this.fisRolloverDisplay || isForLayoutSize ? AquaUIPainter.ScrollBarWidget.OVERLAY_ROLLOVER : AquaUIPainter.ScrollBarWidget.OVERLAY;
        }
        return AquaUIPainter.ScrollBarWidget.LEGACY;
    }

    protected boolean isOverlayStyle() {
        Object o = this.fScrollBar.getClientProperty(THUMB_STYLE_CLIENT_PROPERTY_KEY);
        if (o instanceof String) {
            String style = (String)o;
            return style.equals("overlayDark") || style.equals("overlayLight");
        }
        return false;
    }

    public boolean isDragging() {
        return this.fIsDragging;
    }

    protected AquaUIPainter.ScrollBarKnobWidget getScrollBarKnobWidget(AquaUIPainter.ScrollBarWidget sw) {
        String style;
        if (sw == AquaUIPainter.ScrollBarWidget.LEGACY) {
            return AquaUIPainter.ScrollBarKnobWidget.DEFAULT;
        }
        Object o = this.fScrollBar.getClientProperty(THUMB_STYLE_CLIENT_PROPERTY_KEY);
        if (o instanceof String && (style = (String)o).equals("overlayLight")) {
            return AquaUIPainter.ScrollBarKnobWidget.LIGHT;
        }
        return AquaUIPainter.ScrollBarKnobWidget.DARK;
    }

    protected AquaUIPainter.Size getScrollBarSize() {
        AquaUIPainter.Size sz = AquaUtilControlSize.getUserSizeFrom(this.fScrollBar);
        return sz == AquaUIPainter.Size.REGULAR ? AquaUIPainter.Size.REGULAR : AquaUIPainter.Size.SMALL;
    }

    protected AquaUIPainter.State getScrollBarState() {
        if (!this.fScrollBar.isEnabled()) {
            return AquaUIPainter.State.DISABLED;
        }
        if (!AquaFocusHandler.isActive(this.fScrollBar)) {
            return AquaUIPainter.State.INACTIVE;
        }
        if (this.fIsDragging) {
            return AquaUIPainter.State.PRESSED;
        }
        if (this.fIsOverThumb) {
            return AquaUIPainter.State.ROLLOVER;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    protected AquaUIPainter.Orientation getScrollBarOrientation() {
        return this.isHorizontal() ? AquaUIPainter.Orientation.HORIZONTAL : AquaUIPainter.Orientation.VERTICAL;
    }

    protected int getThumbTrackPosition() {
        int width = this.fScrollBar.getWidth();
        int height = this.fScrollBar.getHeight();
        ScrollBarConfiguration g = this.getConfiguration(false);
        Rectangle bounds = new Rectangle(0, 0, width, height);
        AquaUILayoutInfo uiLayout = this.painter.getLayoutInfo();
        Rectangle2D thumbBounds = uiLayout.getScrollBarThumbBounds(bounds, g);
        return (int)(g.getOrientation() == AquaUIPainter.Orientation.VERTICAL ? thumbBounds.getY() : thumbBounds.getX());
    }

    protected ScrollBarPart getPartHit(int x, int y) {
        float value = this.getExtendedTrackPosition(x, y);
        if (value < 0.0f) {
            return ScrollBarPart.TRACK_MIN;
        }
        if (value > 1.0f) {
            return ScrollBarPart.TRACK_MAX;
        }
        int width = this.fScrollBar.getWidth();
        int height = this.fScrollBar.getHeight();
        this.painter.configure(width, height);
        ScrollBarConfiguration g = this.getConfiguration(false);
        boolean isHorizontal = this.isHorizontal();
        int c = isHorizontal ? x : y;
        ScrollBarThumbConfiguration tg = new ScrollBarThumbConfiguration(g, c);
        int pos = this.painter.getScrollBarThumbHit(tg);
        switch (pos) {
            case -1: {
                return ScrollBarPart.TRACK_MIN;
            }
            case 0: {
                return ScrollBarPart.THUMB;
            }
            case 1: {
                return ScrollBarPart.TRACK_MAX;
            }
        }
        return ScrollBarPart.NONE;
    }

    private float getExtendedTrackPosition(int x, int y) {
        int width = this.fScrollBar.getWidth();
        int height = this.fScrollBar.getHeight();
        boolean isHorizontal = this.isHorizontal();
        int c = isHorizontal ? x : y;
        AquaUIPainter.ScrollBarWidget sw = this.getScrollBarWidget(false);
        AquaUIPainter.Size size = this.getScrollBarSize();
        AquaUIPainter.Orientation o = this.getScrollBarOrientation();
        float extent = this.getCurrentThumbExtent();
        ScrollBarThumbLayoutConfiguration g = new ScrollBarThumbLayoutConfiguration(sw, size, o, extent, c);
        this.painter.configure(width, height);
        return this.painter.getScrollBarThumbPosition(g, false);
    }

    public void layoutContainer(Container fScrollBarContainer) {
        this.fScrollBar.repaint();
        this.fScrollBar.revalidate();
    }

    protected Rectangle getTrackBounds() {
        return new Rectangle(0, 0, this.fScrollBar.getWidth(), this.fScrollBar.getHeight());
    }

    protected void setOverThumb(boolean b) {
        if (b != this.fIsOverThumb) {
            this.fIsOverThumb = b;
            this.fScrollBar.repaint();
        }
    }

    protected void startTimer(boolean initial) {
        this.fScrollTimer.setInitialDelay(initial ? 300 : 100);
        this.fScrollTimer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scrollByBlock(int direction) {
        JScrollBar jScrollBar = this.fScrollBar;
        synchronized (jScrollBar) {
            int oldValue = this.fScrollBar.getValue();
            int blockIncrement = this.fScrollBar.getBlockIncrement(direction);
            int delta = blockIncrement * (direction > 0 ? 1 : -1);
            this.fScrollBar.setValue(oldValue + delta);
            this.fTrackHighlight = direction > 0 ? ScrollBarPart.TRACK_MAX : ScrollBarPart.TRACK_MIN;
            this.fScrollBar.repaint();
            this.fScrollListener.setDirection(direction);
            this.fScrollListener.setScrollByBlock(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scrollByUnit(int direction) {
        JScrollBar jScrollBar = this.fScrollBar;
        synchronized (jScrollBar) {
            int delta = this.fScrollBar.getUnitIncrement(direction);
            if (direction <= 0) {
                delta = -delta;
            }
            this.fScrollBar.setValue(delta + this.fScrollBar.getValue());
            this.fScrollBar.repaint();
            this.fScrollListener.setDirection(direction);
            this.fScrollListener.setScrollByBlock(false);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int t = this.getScrollBarThickness();
        return this.isHorizontal() ? new Dimension(96, t) : new Dimension(t, 96);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        int t = this.getScrollBarThickness();
        return this.isHorizontal() ? new Dimension(54, t) : new Dimension(t, 54);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        int t = this.getScrollBarThickness();
        return this.isHorizontal() ? new Dimension(100000, t) : new Dimension(t, 100000);
    }

    public int getScrollBarThickness() {
        ScrollBarConfiguration g = this.getConfiguration(true);
        return this.getScrollBarThickness(g);
    }

    protected int getScrollBarThickness(LayoutConfiguration g) {
        AquaUILayoutInfo uiLayout = this.painter.getLayoutInfo();
        LayoutInfo layoutInfo = uiLayout.getLayoutInfo(g);
        float f = this.isHorizontal() ? layoutInfo.getMinimumVisualHeight() : layoutInfo.getMinimumVisualWidth();
        return (int)Math.ceil(f);
    }

    public void setRolloverDisplayState(boolean b) {
        if (this.fisRolloverDisplay != b) {
            this.fisRolloverDisplay = b;
            this.fScrollBar.repaint();
        }
        this.fIsOverThumb = false;
    }

    public void setAlpha(float a) {
        if (a != this.alpha) {
            this.alpha = a;
            this.fScrollBar.repaint();
        }
    }

    protected boolean isHorizontal() {
        return this.fScrollBar.getOrientation() == 0;
    }

    static class HitUtil {
        HitUtil() {
        }

        static boolean isIncrement(ScrollBarPart hit) {
            return hit == ScrollBarPart.ARROW_MAX;
        }

        static boolean isDecrement(ScrollBarPart hit) {
            return hit == ScrollBarPart.ARROW_MIN;
        }

        static boolean isArrow(ScrollBarPart hit) {
            return HitUtil.isIncrement(hit) || HitUtil.isDecrement(hit);
        }

        static boolean isTrack(ScrollBarPart hit) {
            return hit == ScrollBarPart.TRACK_MAX || hit == ScrollBarPart.TRACK_MIN;
        }
    }

    protected class ScrollListener
    implements ActionListener {
        boolean fUseBlockIncrement;
        int fDirection = 1;

        protected ScrollListener() {
        }

        void setDirection(int direction) {
            this.fDirection = direction;
        }

        void setScrollByBlock(boolean block) {
            this.fUseBlockIncrement = block;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.fUseBlockIncrement) {
                ScrollBarPart newPart = AquaScrollBarUI.this.getPartHit(AquaScrollBarUI.this.fTrackListener.fCurrentMouseX, AquaScrollBarUI.this.fTrackListener.fCurrentMouseY);
                if (newPart == ScrollBarPart.TRACK_MIN || newPart == ScrollBarPart.TRACK_MAX) {
                    int newDirection;
                    int n = newDirection = newPart == ScrollBarPart.TRACK_MAX ? 1 : -1;
                    if (this.fDirection != newDirection) {
                        this.fDirection = newDirection;
                    }
                }
                AquaScrollBarUI.this.scrollByBlock(this.fDirection);
                newPart = AquaScrollBarUI.this.getPartHit(AquaScrollBarUI.this.fTrackListener.fCurrentMouseX, AquaScrollBarUI.this.fTrackListener.fCurrentMouseY);
                if (newPart == ScrollBarPart.THUMB) {
                    ((Timer)e.getSource()).stop();
                }
            } else {
                AquaScrollBarUI.this.scrollByUnit(this.fDirection);
            }
            if (this.fDirection > 0 && AquaScrollBarUI.this.fScrollBar.getValue() + AquaScrollBarUI.this.fScrollBar.getVisibleAmount() >= AquaScrollBarUI.this.fScrollBar.getMaximum()) {
                ((Timer)e.getSource()).stop();
            } else if (this.fDirection < 0 && AquaScrollBarUI.this.fScrollBar.getValue() <= AquaScrollBarUI.this.fScrollBar.getMinimum()) {
                ((Timer)e.getSource()).stop();
            }
        }
    }

    protected class TrackListener
    extends MouseAdapter
    implements MouseMotionListener {
        protected transient int fCurrentMouseX;
        protected transient int fCurrentMouseY;
        protected transient boolean fInArrows;
        protected transient boolean fStillInArrow = false;
        protected transient boolean fStillInTrack = false;
        protected transient int fFirstThumbTrackPosition;
        protected transient int fHitTrackPosition;

        protected TrackListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!AquaScrollBarUI.this.fScrollBar.isEnabled()) {
                return;
            }
            if (this.fInArrows) {
                this.mouseReleasedInArrows(e);
            } else {
                this.mouseReleasedInTrack(e);
            }
            this.fInArrows = false;
            this.fStillInArrow = false;
            this.fStillInTrack = false;
            AquaScrollBarUI.this.fScrollBar.repaint();
            AquaScrollBarUI.this.fScrollBar.revalidate();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            AquaScrollBarUI.this.fisRolloverDisplay = true;
            this.updateOverThumb(e);
            AquaScrollBarUI.this.fScrollBar.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AquaScrollBarUI.this.setOverThumb(false);
            AquaScrollBarUI.this.fScrollBar.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.updateOverThumb(e);
        }

        protected void updateOverThumb(MouseEvent e) {
            if (AquaScrollBarUI.this.fScrollBar.isEnabled()) {
                ScrollBarPart part = AquaScrollBarUI.this.getPartHit(e.getX(), e.getY());
                AquaScrollBarUI.this.setOverThumb(part == ScrollBarPart.THUMB);
            } else {
                AquaScrollBarUI.this.setOverThumb(false);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!AquaScrollBarUI.this.fScrollBar.isEnabled()) {
                return;
            }
            ScrollBarPart part = AquaScrollBarUI.this.getPartHit(e.getX(), e.getY());
            this.fInArrows = HitUtil.isArrow(part);
            if (this.fInArrows) {
                this.mousePressedInArrows(e, part);
            } else if (part == ScrollBarPart.NONE) {
                AquaScrollBarUI.this.fTrackHighlight = ScrollBarPart.NONE;
            } else {
                this.mousePressedInTrack(e, part);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!AquaScrollBarUI.this.fScrollBar.isEnabled()) {
                return;
            }
            if (this.fInArrows) {
                this.mouseDraggedInArrows(e);
            } else if (AquaScrollBarUI.this.fIsDragging) {
                this.mouseDraggedInTrack(e);
            } else {
                ScrollBarPart previousPart = AquaScrollBarUI.this.getPartHit(this.fCurrentMouseX, this.fCurrentMouseY);
                if (!HitUtil.isTrack(previousPart)) {
                    this.fStillInTrack = false;
                }
                this.fCurrentMouseX = e.getX();
                this.fCurrentMouseY = e.getY();
                ScrollBarPart part = AquaScrollBarUI.this.getPartHit(e.getX(), e.getY());
                boolean temp = HitUtil.isTrack(part);
                if (temp == this.fStillInTrack) {
                    return;
                }
                this.fStillInTrack = temp;
                if (!this.fStillInTrack) {
                    AquaScrollBarUI.this.fScrollTimer.stop();
                } else {
                    AquaScrollBarUI.this.fScrollListener.actionPerformed(new ActionEvent(AquaScrollBarUI.this.fScrollTimer, 0, ""));
                    AquaScrollBarUI.this.startTimer(false);
                }
            }
        }

        int getDragValue(int x, int y, boolean useExtent) {
            float valueRange = Math.max(0, AquaScrollBarUI.this.fScrollBar.getMaximum() - AquaScrollBarUI.this.fScrollBar.getMinimum());
            float scrollingRange = valueRange - (float)AquaScrollBarUI.this.fScrollBar.getModel().getExtent();
            if (scrollingRange <= 0.0f) {
                return AquaScrollBarUI.this.fScrollBar.getMinimum();
            }
            AquaUIPainter.ScrollBarWidget sw = AquaScrollBarUI.this.getScrollBarWidget(false);
            AquaUIPainter.Size size = AquaScrollBarUI.this.getScrollBarSize();
            float extent = AquaScrollBarUI.this.getCurrentThumbExtent();
            AquaUIPainter.Orientation o = AquaScrollBarUI.this.getScrollBarOrientation();
            boolean isHoriz = o == AquaUIPainter.Orientation.HORIZONTAL;
            int coordinate = isHoriz ? x : y;
            int deltaTrackPosition = coordinate - this.fHitTrackPosition;
            int newThumbTrackPosition = this.fFirstThumbTrackPosition + deltaTrackPosition;
            AquaScrollBarUI.this.painter.configure(AquaScrollBarUI.this.fScrollBar.getWidth(), AquaScrollBarUI.this.fScrollBar.getHeight());
            ScrollBarThumbLayoutConfiguration g = new ScrollBarThumbLayoutConfiguration(sw, size, o, extent, newThumbTrackPosition);
            float newExtendedThumbPosition = AquaScrollBarUI.this.painter.getScrollBarThumbPosition(g, useExtent);
            return AquaScrollBarUI.this.getValueFromThumbPosition(newExtendedThumbPosition);
        }

        void mousePressedInArrows(MouseEvent e, ScrollBarPart part) {
            int direction = HitUtil.isIncrement(part) ? 1 : -1;
            this.fStillInArrow = true;
            AquaScrollBarUI.this.scrollByUnit(direction);
            AquaScrollBarUI.this.fScrollTimer.stop();
            AquaScrollBarUI.this.fScrollListener.setDirection(direction);
            AquaScrollBarUI.this.fScrollListener.setScrollByBlock(false);
            AquaScrollBarUI.this.fMousePart = part;
            AquaScrollBarUI.this.startTimer(true);
        }

        void mouseReleasedInArrows(MouseEvent e) {
            AquaScrollBarUI.this.fScrollTimer.stop();
            AquaScrollBarUI.this.fMousePart = ScrollBarPart.NONE;
            AquaScrollBarUI.this.fScrollBar.setValueIsAdjusting(false);
        }

        void mouseDraggedInArrows(MouseEvent e) {
            ScrollBarPart whichPart = AquaScrollBarUI.this.getPartHit(e.getX(), e.getY());
            if (AquaScrollBarUI.this.fMousePart == whichPart && this.fStillInArrow) {
                return;
            }
            if (AquaScrollBarUI.this.fMousePart != whichPart && !HitUtil.isArrow(whichPart)) {
                AquaScrollBarUI.this.fScrollTimer.stop();
                this.fStillInArrow = false;
                AquaScrollBarUI.this.fScrollBar.repaint();
            } else {
                AquaScrollBarUI.this.fMousePart = whichPart;
                AquaScrollBarUI.this.fScrollListener.setDirection(HitUtil.isIncrement(whichPart) ? 1 : -1);
                this.fStillInArrow = true;
                AquaScrollBarUI.this.fScrollListener.actionPerformed(new ActionEvent(AquaScrollBarUI.this.fScrollTimer, 0, ""));
                AquaScrollBarUI.this.startTimer(false);
            }
            AquaScrollBarUI.this.fScrollBar.repaint();
        }

        void mouseReleasedInTrack(MouseEvent e) {
            if (AquaScrollBarUI.this.fTrackHighlight != ScrollBarPart.NONE) {
                AquaScrollBarUI.this.fScrollBar.repaint();
            }
            AquaScrollBarUI.this.fTrackHighlight = ScrollBarPart.NONE;
            AquaScrollBarUI.this.fIsDragging = false;
            AquaScrollBarUI.this.fScrollTimer.stop();
            AquaScrollBarUI.this.fScrollBar.setValueIsAdjusting(false);
        }

        void mousePressedInTrack(MouseEvent e, ScrollBarPart part) {
            boolean shouldScrollToHere;
            AquaScrollBarUI.this.fScrollBar.setValueIsAdjusting(true);
            boolean isHorizontal = AquaScrollBarUI.this.isHorizontal();
            boolean bl = shouldScrollToHere = part != ScrollBarPart.THUMB && OSXSystemProperties.isScrollToClick();
            if (e.isAltDown()) {
                boolean bl2 = shouldScrollToHere = !shouldScrollToHere;
            }
            if (shouldScrollToHere) {
                this.fFirstThumbTrackPosition = AquaScrollBarUI.this.getThumbTrackPosition();
                this.fHitTrackPosition = isHorizontal ? e.getX() : e.getY();
                this.moveToMouse(e, false);
                AquaScrollBarUI.this.fTrackHighlight = ScrollBarPart.THUMB;
                AquaScrollBarUI.this.fIsDragging = true;
                return;
            }
            this.fCurrentMouseX = e.getX();
            this.fCurrentMouseY = e.getY();
            int direction = 0;
            if (part == ScrollBarPart.TRACK_MIN) {
                AquaScrollBarUI.this.fTrackHighlight = ScrollBarPart.TRACK_MIN;
                direction = -1;
            } else if (part == ScrollBarPart.TRACK_MAX) {
                AquaScrollBarUI.this.fTrackHighlight = ScrollBarPart.TRACK_MAX;
                direction = 1;
            } else {
                this.fFirstThumbTrackPosition = AquaScrollBarUI.this.getThumbTrackPosition();
                this.fHitTrackPosition = isHorizontal ? e.getX() : e.getY();
                AquaScrollBarUI.this.fTrackHighlight = ScrollBarPart.THUMB;
                AquaScrollBarUI.this.fIsDragging = true;
                return;
            }
            AquaScrollBarUI.this.fIsDragging = false;
            this.fStillInTrack = true;
            AquaScrollBarUI.this.scrollByBlock(direction);
            ScrollBarPart newPart = AquaScrollBarUI.this.getPartHit(this.fCurrentMouseX, this.fCurrentMouseY);
            if (newPart == ScrollBarPart.TRACK_MIN || newPart == ScrollBarPart.TRACK_MAX) {
                AquaScrollBarUI.this.fScrollTimer.stop();
                AquaScrollBarUI.this.fScrollListener.setDirection(newPart == ScrollBarPart.TRACK_MAX ? 1 : -1);
                AquaScrollBarUI.this.fScrollListener.setScrollByBlock(true);
                AquaScrollBarUI.this.startTimer(true);
            }
        }

        void mouseDraggedInTrack(MouseEvent e) {
            this.moveToMouse(e, true);
        }

        void moveToMouse(MouseEvent e, boolean useExtent) {
            this.fCurrentMouseX = e.getX();
            this.fCurrentMouseY = e.getY();
            int oldValue = AquaScrollBarUI.this.fScrollBar.getValue();
            int newValue = this.getDragValue(this.fCurrentMouseX, this.fCurrentMouseY, useExtent);
            if (newValue == oldValue) {
                return;
            }
            AquaScrollBarUI.this.fScrollBar.setValue(newValue);
            Rectangle dirtyRect = AquaScrollBarUI.this.getTrackBounds();
            AquaScrollBarUI.this.fScrollBar.repaint(dirtyRect.x, dirtyRect.y, dirtyRect.width, dirtyRect.height);
        }
    }

    protected class ModelListener
    implements ChangeListener {
        protected ModelListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            AquaScrollBarUI.this.layoutContainer(AquaScrollBarUI.this.fScrollBar);
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ("model".equals(propertyName)) {
                BoundedRangeModel oldModel = (BoundedRangeModel)e.getOldValue();
                BoundedRangeModel newModel = (BoundedRangeModel)e.getNewValue();
                oldModel.removeChangeListener(AquaScrollBarUI.this.fModelListener);
                newModel.addChangeListener(AquaScrollBarUI.this.fModelListener);
                AquaScrollBarUI.this.fScrollBar.repaint();
                AquaScrollBarUI.this.fScrollBar.revalidate();
            } else if ("Frame.active".equals(propertyName)) {
                AquaScrollBarUI.this.fScrollBar.repaint();
            }
        }
    }

    public static enum ScrollBarPart {
        NONE,
        THUMB,
        TRACK_MIN,
        TRACK_MAX,
        ARROW_MIN,
        ARROW_MAX;

    }
}

