/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import org.violetlib.aqua.AquaOverlayScrollPaneController;
import org.violetlib.aqua.AquaOverlayScrollPaneLayout;
import org.violetlib.aqua.AquaTreeUI;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.OverlayScrollPaneHack;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaScrollPaneUI
extends BasicScrollPaneUI
implements AquaUtilControlSize.Sizeable {
    public static final String SCROLL_PANE_STYLE_KEY = "JScrollPane.style";
    public static final String SCROLL_PANE_THUMB_STYLE_KEY = "JScrollPane.thumbStyle";
    public static final String SCROLL_PANE_AQUA_OVERLAY_SCROLL_BARS_KEY = "AquaOverlayScrollBars";
    public static final String THUMB_STYLE_DARK = "dark";
    public static final String THUMB_STYLE_LIGHT = "light";
    public static final int WHEEL_CHANGE_DIRECTION_MINIMUM = 3;
    public static final boolean isRTLSupported = OSXSystemProperties.doScrollPanesSupportRTL();
    private static final boolean useViewportHack = true;
    protected AquaUIPainter.Size size;
    protected boolean isOverlayScrollBars;
    protected AquaOverlayScrollPaneController overlayController;
    protected int contraryScrollCount;
    protected OverlayScrollPaneHack overlayScrollPaneHack;
    protected LayoutManager legacyLayoutManager;
    protected PropertyChangeListener propertyChangeListener;
    protected ChangeListener preferenceChangeListener;
    protected ComponentListener componentListener;

    public static ComponentUI createUI(JComponent x) {
        return new AquaScrollPaneUI();
    }

    @Override
    protected MouseWheelListener createMouseWheelListener() {
        return new XYMouseWheelHandler();
    }

    @Override
    public void installUI(JComponent x) {
        super.installUI(x);
        this.legacyLayoutManager = this.scrollpane.getLayout();
        if (this.legacyLayoutManager == null) {
            this.legacyLayoutManager = new ScrollPaneLayout.UIResource();
        }
        this.setScrollBarStyle(this.shouldUseOverlayScrollBars());
        this.scrollpane.putClientProperty(SCROLL_PANE_AQUA_OVERLAY_SCROLL_BARS_KEY, this.isOverlayScrollBars);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.setScrollBarStyle(false);
        JScrollPane sp = this.scrollpane;
        super.uninstallUI(c);
        sp.putClientProperty(SCROLL_PANE_AQUA_OVERLAY_SCROLL_BARS_KEY, null);
    }

    @Override
    protected void installListeners(JScrollPane c) {
        super.installListeners(c);
        this.componentListener = new MyComponentListener();
        c.addComponentListener(this.componentListener);
        this.propertyChangeListener = new MyPropertyChangeListener();
        c.addPropertyChangeListener(this.propertyChangeListener);
        this.preferenceChangeListener = new PreferenceChangeListener();
        OSXSystemProperties.addChangeListener(this.preferenceChangeListener);
        AquaUtilControlSize.addSizePropertyListener(c);
    }

    @Override
    protected void uninstallListeners(JComponent c) {
        if (this.overlayController != null) {
            this.overlayController.dispose();
            this.overlayController = null;
        }
        if (this.overlayScrollPaneHack != null) {
            this.overlayScrollPaneHack.dispose();
            this.overlayScrollPaneHack = null;
        }
        AquaUtilControlSize.removeSizePropertyListener(c);
        OSXSystemProperties.removeChangeListener(this.preferenceChangeListener);
        this.preferenceChangeListener = null;
        c.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        c.removeComponentListener(this.componentListener);
        this.componentListener = null;
        super.uninstallListeners(c);
    }

    @Override
    public void applySizeFor(JComponent c, AquaUIPainter.Size size, boolean isDefaultSize) {
        this.size = size;
        if (c instanceof JScrollPane) {
            JScrollPane sp = (JScrollPane)c;
            this.updateScrollBar(sp.getHorizontalScrollBar());
            this.updateScrollBar(sp.getVerticalScrollBar());
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            if (this.isSideBar()) {
                AquaUtils.fillRect(g, null, 0, 0, c.getWidth(), c.getHeight());
            } else {
                AquaUtils.fillRect(g, c, 2);
            }
        }
        this.paint(g, c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean isSideBar;
        if (this.syncLayoutManager()) {
            this.scrollpane.validate();
        }
        if ((isSideBar = this.isSideBar()) && !this.isOverlayScrollBars) {
            this.setSidebarStyle(this.scrollpane.getHorizontalScrollBar(), true);
            this.setSidebarStyle(this.scrollpane.getVerticalScrollBar(), true);
        } else {
            this.setSidebarStyle(this.scrollpane.getHorizontalScrollBar(), false);
            this.setSidebarStyle(this.scrollpane.getVerticalScrollBar(), false);
        }
        super.paint(g, c);
        if (!this.isOverlayScrollBars && !isSideBar) {
            JScrollBar vb = this.scrollpane.getVerticalScrollBar();
            JScrollBar hb = this.scrollpane.getHorizontalScrollBar();
            if (vb != null && hb != null && vb.isVisible() && hb.isVisible()) {
                int x1 = vb.getX();
                int x2 = vb.getX() + vb.getWidth();
                int y1 = hb.getY();
                int y2 = hb.getY() + hb.getHeight();
                g.setColor(new Color(250, 250, 250));
                g.fillRect(x1, y1, x2 - x1, y2 - y1);
                g.setColor(new Color(237, 237, 237));
                g.fillRect(x1, y2 - 1, x2 - x1, 1);
                if (AquaUtils.isLeftToRight(this.scrollpane) || !isRTLSupported) {
                    g.fillRect(x2 - 1, y1, 1, y2 - y1);
                    g.fillRect(x1, y1, 1, 1);
                } else {
                    g.fillRect(x1, y1, 1, y2 - y1);
                    g.fillRect(x2 - 1, y1, 1, 1);
                }
            }
        }
    }

    protected boolean isSideBar() {
        AquaTreeUI treeUI;
        Component view;
        JViewport v = this.scrollpane.getViewport();
        return v != null && (view = SwingUtilities.getUnwrappedView(v)) instanceof JTree && (treeUI = AquaUtils.getUI((JTree)view, AquaTreeUI.class)) != null && treeUI.isSideBar();
    }

    protected void setSidebarStyle(JScrollBar sb, boolean b) {
        if (sb != null) {
            Object o = sb.getClientProperty("JScrollBar.style");
            if (o == null) {
                if (b) {
                    sb.putClientProperty("JScrollBar.style", "sidebar");
                }
            } else if (o.equals("sidebar") && !b) {
                sb.putClientProperty("JScrollBar.style", null);
            }
        }
    }

    public boolean isOverlayScrollBars() {
        return this.isOverlayScrollBars;
    }

    protected void updateStyle() {
        boolean b = this.shouldUseOverlayScrollBars();
        if (b != this.isOverlayScrollBars) {
            this.setScrollBarStyle(b);
            this.scrollpane.putClientProperty(SCROLL_PANE_AQUA_OVERLAY_SCROLL_BARS_KEY, b);
        }
    }

    protected void updateThumbStyle() {
        if (this.isOverlayScrollBars) {
            this.updateScrollBar(this.scrollpane.getHorizontalScrollBar());
            this.updateScrollBar(this.scrollpane.getVerticalScrollBar());
        }
    }

    protected boolean shouldUseOverlayScrollBars() {
        LayoutManager lm = this.scrollpane.getLayout();
        if (lm != null && !(lm instanceof UIResource)) {
            return false;
        }
        Object o = this.scrollpane.getClientProperty(SCROLL_PANE_STYLE_KEY);
        if ("overlay".equals(o)) {
            return true;
        }
        if ("legacy".equals(o)) {
            return false;
        }
        return OSXSystemProperties.useOverlayScrollBars();
    }

    protected void setScrollBarStyle(boolean isOverlay) {
        this.isOverlayScrollBars = isOverlay;
        this.syncLayoutManager();
        this.syncOverlayScrollPaneHack();
        if (this.isOverlayScrollBars) {
            if (this.overlayController == null) {
                this.overlayController = new AquaOverlayJScrollPaneController();
            }
        } else if (this.overlayController != null) {
            this.overlayController.dispose();
            this.overlayController = null;
        }
        this.updateScrollBar(this.scrollpane.getHorizontalScrollBar());
        this.updateScrollBar(this.scrollpane.getVerticalScrollBar());
        this.scrollpane.revalidate();
        this.scrollpane.repaint();
    }

    protected void syncOverlayScrollPaneHack() {
        if (this.isOverlayScrollBars && this.scrollpane.isOptimizedDrawingEnabled()) {
            if (this.overlayScrollPaneHack == null) {
                this.overlayScrollPaneHack = new OverlayScrollPaneHack(this.scrollpane);
            }
        } else if (this.overlayScrollPaneHack != null) {
            this.overlayScrollPaneHack.dispose();
            this.overlayScrollPaneHack = null;
        }
    }

    public void syncOverlayScrollPaneViewportHolderSize() {
        if (this.overlayScrollPaneHack != null) {
            this.overlayScrollPaneHack.syncScrollPaneSize();
        }
    }

    protected void updateScrollBar(JScrollBar bar) {
        if (bar != null) {
            bar.revalidate();
            bar.repaint();
            bar.putClientProperty("JComponent.sizeVariant", AquaUtilControlSize.getStringFromSize(this.size));
            if (this.isOverlayScrollBars) {
                Object o = this.scrollpane.getClientProperty(SCROLL_PANE_THUMB_STYLE_KEY);
                if (THUMB_STYLE_LIGHT.equals(o)) {
                    bar.putClientProperty("JScrollBar.thumbStyle", "overlayLight");
                } else {
                    bar.putClientProperty("JScrollBar.thumbStyle", "overlayDark");
                }
            } else {
                bar.putClientProperty("JScrollBar.thumbStyle", null);
            }
        }
    }

    protected boolean syncLayoutManager() {
        LayoutManager m = this.scrollpane.getLayout();
        if (m instanceof AquaOverlayScrollPaneLayout) {
            if (!this.isOverlayScrollBars) {
                this.scrollpane.setLayout(this.legacyLayoutManager);
                return true;
            }
        } else {
            this.legacyLayoutManager = m;
            if (this.isOverlayScrollBars) {
                if (m instanceof UIResource) {
                    this.scrollpane.setLayout(new AquaOverlayScrollPaneLayout());
                    this.hideScrollBar(this.scrollpane.getHorizontalScrollBar());
                    this.hideScrollBar(this.scrollpane.getVerticalScrollBar());
                    return true;
                }
                this.updateStyle();
            }
        }
        return false;
    }

    protected void hideScrollBar(JScrollBar sb) {
        if (sb != null) {
            sb.setVisible(false);
        }
    }

    protected boolean isAxisScrollable(boolean isHorizontal) {
        JScrollBar sb;
        JScrollBar jScrollBar = sb = isHorizontal ? this.scrollpane.getHorizontalScrollBar() : this.scrollpane.getVerticalScrollBar();
        if (sb == null) {
            return false;
        }
        int valueRange = Math.max(0, sb.getMaximum() - sb.getMinimum());
        int extent = sb.getModel().getExtent();
        return extent > 0 && extent < valueRange;
    }

    protected class XYMouseWheelHandler
    extends BasicScrollPaneUI.MouseWheelHandler {
        protected XYMouseWheelHandler() {
            super(AquaScrollPaneUI.this);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            JScrollBar vScrollBar;
            boolean isHorizontalScroll = e.isShiftDown();
            if (!AquaScrollPaneUI.this.isAxisScrollable(isHorizontalScroll)) {
                AquaScrollPaneUI.this.contraryScrollCount = 0;
                return;
            }
            if (AquaScrollPaneUI.this.overlayController != null) {
                int axis = AquaScrollPaneUI.this.overlayController.getActiveAxis();
                if (axis == 0 && !isHorizontalScroll || axis == 1 && isHorizontalScroll) {
                    AquaScrollPaneUI.this.contraryScrollCount += e.getUnitsToScroll();
                    if (Math.abs(AquaScrollPaneUI.this.contraryScrollCount) < 3) {
                        return;
                    }
                } else {
                    AquaScrollPaneUI.this.contraryScrollCount = 0;
                }
            }
            boolean vScrollBarWasVisible = (vScrollBar = AquaScrollPaneUI.this.scrollpane.getVerticalScrollBar()) != null && vScrollBar.isVisible();
            JScrollBar hScrollBar = AquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
            boolean hScrollBarWasVisible = hScrollBar != null && hScrollBar.isVisible();
            boolean overlayControlInvoked = false;
            if (vScrollBar != null) {
                vScrollBar.setVisible(!isHorizontalScroll);
                if (!isHorizontalScroll && AquaScrollPaneUI.this.overlayController != null) {
                    AquaScrollPaneUI.this.overlayController.activateScrollBar(e, true);
                    overlayControlInvoked = true;
                }
            }
            if (hScrollBar != null) {
                hScrollBar.setVisible(isHorizontalScroll);
                if (isHorizontalScroll && AquaScrollPaneUI.this.overlayController != null) {
                    AquaScrollPaneUI.this.overlayController.activateScrollBar(e, false);
                    overlayControlInvoked = true;
                }
            }
            super.mouseWheelMoved(e);
            if (!overlayControlInvoked) {
                if (vScrollBar != null) {
                    vScrollBar.setVisible(vScrollBarWasVisible);
                }
                if (hScrollBar != null) {
                    hScrollBar.setVisible(hScrollBarWasVisible);
                }
            }
            e.consume();
        }
    }

    protected class MyComponentListener
    extends ComponentAdapter {
        protected MyComponentListener() {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            AquaScrollPaneUI.this.syncLayoutManager();
        }
    }

    protected class AquaOverlayJScrollPaneController
    extends AquaOverlayScrollPaneController {
        public AquaOverlayJScrollPaneController() {
            this.setVerticalScrollBar(AquaScrollPaneUI.this.scrollpane.getVerticalScrollBar());
            this.setHorizontalScrollBar(AquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar());
        }

        @Override
        protected void reconfigure(JScrollBar sb, String which) {
            if (AquaScrollPaneUI.this.overlayScrollPaneHack != null) {
                AquaScrollPaneUI.this.overlayScrollPaneHack.reconfigure(sb, which);
            } else {
                AquaScrollPaneUI.this.scrollpane.remove(sb);
                AquaScrollPaneUI.this.scrollpane.add(sb, which, 0);
            }
        }
    }

    protected class MyPropertyChangeListener
    implements PropertyChangeListener {
        protected MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name != null) {
                if (name.equals(AquaScrollPaneUI.SCROLL_PANE_STYLE_KEY)) {
                    AquaScrollPaneUI.this.updateStyle();
                } else if (name.equals(AquaScrollPaneUI.SCROLL_PANE_THUMB_STYLE_KEY)) {
                    AquaScrollPaneUI.this.updateThumbStyle();
                } else if (name.equals("verticalScrollBar")) {
                    this.updateVerticalScrollBar();
                } else if (name.equals("horizontalScrollBar")) {
                    this.updateHorizontalScrollBar();
                }
            }
        }

        protected void updateVerticalScrollBar() {
            if (AquaScrollPaneUI.this.overlayController != null) {
                AquaScrollPaneUI.this.overlayController.setVerticalScrollBar(AquaScrollPaneUI.this.scrollpane.getVerticalScrollBar());
            }
            AquaScrollPaneUI.this.updateScrollBar(AquaScrollPaneUI.this.scrollpane.getVerticalScrollBar());
        }

        protected void updateHorizontalScrollBar() {
            if (AquaScrollPaneUI.this.overlayController != null) {
                AquaScrollPaneUI.this.overlayController.setHorizontalScrollBar(AquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar());
            }
            AquaScrollPaneUI.this.updateScrollBar(AquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar());
        }
    }

    protected class PreferenceChangeListener
    implements ChangeListener {
        protected PreferenceChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            AquaScrollPaneUI.this.updateStyle();
        }
    }
}

