/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.violetlib.aqua.AquaExtendedPopup;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.BackgroundPainter;

public class AquaScrollingPopupMenuWrapper
extends JPanel {
    private static final int kInitialDelay = 20;
    private static final int kNormalDelay = 20;
    protected final ArrowPane topArrowPane;
    protected final JComponent originalContent;
    protected final JComponent scrollableView;
    protected final ArrowPane bottomArrowPane;
    protected final JViewport viewport;
    protected int width;
    protected int height;
    protected boolean isTopArrowInstalled;
    protected boolean isBottomArrowInstalled;
    protected int topArrowHeight;
    protected int bottomArrowHeight;
    protected Timer fScrollTimer;
    protected ActionListener fScrollListener;

    public AquaScrollingPopupMenuWrapper(JComponent content, Rectangle selectedRegion, Point selectedRegionLocation, int width, int height, Border border) {
        super(null);
        this.originalContent = content;
        this.width = width;
        this.height = height;
        this.setOpaque(false);
        this.setBorder(border);
        this.setLayout(new MyLayoutManager());
        this.setPreferredSize(new Dimension(width, height));
        content.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getScrollType() == 0) {
                    AquaScrollingPopupMenuWrapper.this.mouseWheelScroll(e);
                }
                e.consume();
            }
        });
        if (content instanceof JPopupMenu) {
            JPanel wrap = new JPanel();
            wrap.setName("JPopUpMenuWrapper");
            wrap.setLayout(new BorderLayout());
            wrap.add(content);
            wrap.setOpaque(false);
            this.scrollableView = wrap;
        } else {
            this.scrollableView = content;
        }
        Dimension contentSize = this.scrollableView.getPreferredSize();
        this.scrollableView.setSize(contentSize);
        this.topArrowPane = this.createArrowPane(true);
        this.bottomArrowPane = this.createArrowPane(false);
        this.viewport = new JViewport();
        this.viewport.setView(this.scrollableView);
        this.viewport.setLayout(null);
        this.add(this.viewport);
        this.add(this.topArrowPane);
        this.add(this.bottomArrowPane);
        this.topArrowHeight = this.topArrowPane.getPreferredSize().height;
        this.bottomArrowHeight = this.bottomArrowPane.getPreferredSize().height;
        int initialViewPosition = 0;
        if (selectedRegion != null) {
            int y;
            int desiredY;
            Insets s = this.getInsets();
            boolean isTopArrowAllocated = false;
            boolean isBottomArrowAllocated = false;
            int availableHeight = height - s.top - s.bottom;
            if (contentSize.height > availableHeight) {
                isBottomArrowAllocated = true;
                availableHeight -= this.bottomArrowHeight;
            }
            int selectedRegionOrigin = selectedRegion.y;
            int selectedRegionHeight = selectedRegion.height;
            if (selectedRegionLocation != null && (initialViewPosition = Math.max(0, selectedRegionOrigin - (desiredY = selectedRegionLocation.y - s.top))) > 0) {
                isTopArrowAllocated = true;
                initialViewPosition += this.topArrowHeight;
                availableHeight -= this.topArrowHeight;
                if (isBottomArrowAllocated) {
                    isBottomArrowAllocated = false;
                    availableHeight += this.bottomArrowHeight;
                }
                if (contentSize.height - initialViewPosition > availableHeight) {
                    isBottomArrowAllocated = true;
                    availableHeight -= this.bottomArrowHeight;
                }
            }
            if ((y = selectedRegionOrigin - initialViewPosition) + selectedRegionHeight > availableHeight) {
                if (!isTopArrowAllocated) {
                    isTopArrowAllocated = true;
                    initialViewPosition += this.topArrowHeight;
                    availableHeight -= this.topArrowHeight;
                    if (isBottomArrowAllocated) {
                        isBottomArrowAllocated = false;
                        availableHeight += this.bottomArrowHeight;
                    }
                    if (contentSize.height - initialViewPosition > availableHeight) {
                        isBottomArrowAllocated = true;
                        availableHeight -= this.bottomArrowHeight;
                    }
                }
                int delta = y + selectedRegionHeight - availableHeight;
                if (isBottomArrowAllocated && contentSize.height - (initialViewPosition += delta) <= availableHeight + this.bottomArrowHeight) {
                    initialViewPosition -= this.bottomArrowHeight;
                }
            }
        }
        this.viewport.setBorder(null);
        this.viewport.setOpaque(false);
        this.viewport.setViewPosition(new Point(0, initialViewPosition));
        this.configure(true);
        this.fScrollListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AquaScrollingPopupMenuWrapper.this.topArrowPane.isActive) {
                    AquaScrollingPopupMenuWrapper.this.topArrowPane.actionPerformed(e);
                } else if (AquaScrollingPopupMenuWrapper.this.bottomArrowPane.isActive) {
                    AquaScrollingPopupMenuWrapper.this.bottomArrowPane.actionPerformed(e);
                } else {
                    AquaScrollingPopupMenuWrapper.this.stopTimer();
                }
            }
        };
        this.fScrollTimer = new Timer(20, this.fScrollListener);
        this.fScrollTimer.setInitialDelay(20);
    }

    protected final boolean scrollIfPossible(MouseEvent e, int delta) {
        int limit = Math.max(0, this.scrollableView.getHeight() - this.viewport.getExtentSize().height);
        Point vp = this.viewport.getViewPosition();
        int pos = vp.y + delta;
        if (pos < 0) {
            pos = 0;
        } else if (pos > limit) {
            pos = limit;
        }
        int actualDelta = pos - vp.y;
        if (actualDelta != 0) {
            this.scroll(e, actualDelta);
            return true;
        }
        return false;
    }

    protected void scroll(MouseEvent e, int delta) {
        Point vp = this.viewport.getViewPosition();
        this.viewport.setViewPosition(new Point(vp.x, vp.y + delta));
        this.configure(false);
        this.repaint();
    }

    protected void mouseWheelScroll(MouseWheelEvent e) {
        int units = e.getUnitsToScroll();
        this.scrollIfPossible(e, units);
    }

    protected void startTimer() {
        if (this.originalContent instanceof AquaExtendedPopup) {
            AquaExtendedPopup cbp = (AquaExtendedPopup)((Object)this.originalContent);
            cbp.startArrowScroll();
        }
        this.fScrollTimer.setInitialDelay(20);
        this.fScrollTimer.start();
    }

    protected void stopTimer() {
        this.fScrollTimer.stop();
        if (this.originalContent instanceof AquaExtendedPopup) {
            AquaExtendedPopup cbp = (AquaExtendedPopup)((Object)this.originalContent);
            cbp.stopArrowScroll();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        this.configure(false);
        Border b = this.getBorder();
        if (b instanceof BackgroundPainter) {
            BackgroundPainter bp = (BackgroundPainter)((Object)b);
            Rectangle bounds = this.getBounds();
            bp.paintBackground(this, g, bounds.x, bounds.y, bounds.width, bounds.height);
        }
        super.paintComponent(g);
    }

    protected void configure(boolean forceLayout) {
        int limit;
        int pos = this.viewport.getViewPosition().y;
        boolean showTopArrow = pos > 0;
        Insets s = this.getInsets();
        int availableHeight = this.height - s.top - s.bottom;
        if (showTopArrow) {
            availableHeight -= this.topArrowHeight;
        }
        boolean showBottomArrow = pos < (limit = this.scrollableView.getHeight() - availableHeight);
        this.configure(showTopArrow, showBottomArrow, forceLayout);
    }

    protected void configure(boolean showTopArrow, boolean showBottomArrow, boolean forceLayout) {
        boolean changed = false;
        if (showTopArrow != this.isTopArrowInstalled) {
            this.isTopArrowInstalled = showTopArrow;
            changed = true;
        }
        if (showBottomArrow != this.isBottomArrowInstalled) {
            this.isBottomArrowInstalled = showBottomArrow;
            changed = true;
        }
        if (changed || forceLayout) {
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    protected ArrowPane createArrowPane(boolean isTop) {
        return new ArrowPane(isTop);
    }

    protected Icon getArrowIcon(boolean isTop) {
        return isTop ? AquaImageFactory.getMenuUpArrowIcon() : AquaImageFactory.getMenuDownArrowIcon();
    }

    protected class MyLayoutManager
    implements LayoutManager {
        protected MyLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return null;
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return null;
        }

        @Override
        public void layoutContainer(Container c) {
            Point position = AquaScrollingPopupMenuWrapper.this.viewport.getViewPosition();
            Insets s = c.getInsets();
            int left = s.left;
            int right = s.right;
            int top = s.top;
            int bottom = s.bottom;
            int w = AquaScrollingPopupMenuWrapper.this.width - left - right;
            int h = AquaScrollingPopupMenuWrapper.this.height - top - bottom;
            int topArrowHeight = AquaScrollingPopupMenuWrapper.this.isTopArrowInstalled ? AquaScrollingPopupMenuWrapper.this.topArrowHeight : 0;
            int bottomArrowHeight = AquaScrollingPopupMenuWrapper.this.isBottomArrowInstalled ? AquaScrollingPopupMenuWrapper.this.bottomArrowHeight : 0;
            AquaScrollingPopupMenuWrapper.this.topArrowPane.setBounds(left, top, w, topArrowHeight);
            AquaScrollingPopupMenuWrapper.this.viewport.setBounds(left, top + topArrowHeight, w, h - topArrowHeight - bottomArrowHeight);
            AquaScrollingPopupMenuWrapper.this.bottomArrowPane.setBounds(left, top + h - bottomArrowHeight, w, bottomArrowHeight);
            AquaScrollingPopupMenuWrapper.this.viewport.setViewPosition(position);
        }
    }

    protected class ArrowPane
    extends JPanel
    implements ActionListener,
    MouseListener {
        private final boolean isTop;
        private final Icon icon;
        private boolean isActive;

        public ArrowPane(boolean isTop) {
            super(new BorderLayout());
            this.setOpaque(false);
            this.isTop = isTop;
            this.icon = AquaScrollingPopupMenuWrapper.this.getArrowIcon(isTop);
            this.add((Component)new JLabel(this.icon), "Center");
            this.setBorder(isTop ? new EmptyBorder(2, 0, 6, 0) : new EmptyBorder(6, 0, 2, 0));
            this.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.isActive = true;
            AquaScrollingPopupMenuWrapper.this.startTimer();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.isActive = false;
            AquaScrollingPopupMenuWrapper.this.stopTimer();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isActive) {
                AquaScrollingPopupMenuWrapper.this.stopTimer();
            } else {
                int delta;
                int unit = 12;
                int n = delta = this.isTop ? -unit : unit;
                if (!AquaScrollingPopupMenuWrapper.this.scrollIfPossible(null, delta)) {
                    this.isActive = false;
                    AquaScrollingPopupMenuWrapper.this.stopTimer();
                }
            }
        }
    }
}

