/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SeparatorUI;

public class AquaSeparatorUI
extends SeparatorUI {
    private static int thickness;

    public static ComponentUI createUI(JComponent c) {
        return new AquaSeparatorUI();
    }

    @Override
    public void installUI(JComponent c) {
        if (thickness == 0) {
            thickness = UIManager.getInt("Separator.width");
        }
        this.installDefaults((JSeparator)c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallDefaults((JSeparator)c);
    }

    protected void installDefaults(JSeparator s) {
        LookAndFeel.installColors(s, "Separator.background", "Separator.foreground");
        LookAndFeel.installProperty(s, "opaque", Boolean.FALSE);
    }

    protected void uninstallDefaults(JSeparator s) {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Dimension size = c.getSize();
        Insets s = c.getInsets();
        g.setColor(c.getForeground());
        int x = s.left;
        int y = s.top;
        int w = Math.max(0, size.width - s.left - s.right);
        int h = Math.max(0, size.height - s.top - s.bottom);
        if (((JSeparator)c).getOrientation() == 1) {
            int w1 = Math.min(w, thickness);
            w = w1 + (w - w1) / 2;
        } else {
            int h1 = Math.min(h, thickness);
            h = h1 + (h - h1) / 2;
        }
        g.fillRect(x, y, w, h);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Insets insets = c.getInsets();
        if (((JSeparator)c).getOrientation() == 1) {
            return new Dimension(thickness + insets.left + insets.right, insets.top + insets.bottom);
        }
        return new Dimension(insets.left + insets.right, thickness + insets.top + insets.bottom);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Dimension d = this.getPreferredSize(c);
        if (((JSeparator)c).getOrientation() == 1) {
            d.height = Integer.MAX_VALUE;
        } else {
            d.width = Integer.MAX_VALUE;
        }
        return d;
    }
}

