/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.violetlib.aqua.AquaColorChooserDialog;
import org.violetlib.aqua.AquaNativeColorChooser;
import org.violetlib.aqua.SharedColorChooserOwner;

public class AquaSharedColorChooser {
    private static boolean useNativeChooser = true;
    private static AquaSharedColorChooser INSTANCE;
    private boolean isInitialized;
    private JColorChooser sharedChooser;
    private JDialog sharedDialog;
    private WindowListener windowListener;
    private ComponentListener componentListener;
    private ChangeListener changeListener;
    private SharedColorChooserOwner currentOwner;

    public static boolean connect(SharedColorChooserOwner o) {
        AquaSharedColorChooser c = AquaSharedColorChooser.getInstance();
        return c.connectToOwner(o);
    }

    public static void disconnect(SharedColorChooserOwner o) {
        AquaSharedColorChooser c = AquaSharedColorChooser.getInstance();
        c.disconnectOwner(o);
    }

    private static AquaSharedColorChooser getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AquaSharedColorChooser();
        }
        return INSTANCE;
    }

    private AquaSharedColorChooser() {
    }

    public boolean connectToOwner(SharedColorChooserOwner o) {
        if (this.currentOwner == o) {
            return true;
        }
        if (this.currentOwner != null) {
            SharedColorChooserOwner old = this.currentOwner;
            this.currentOwner = null;
            old.disconnected();
        }
        if (!this.isInitialized) {
            this.isInitialized = true;
            if (useNativeChooser && AquaNativeColorChooser.display(o)) {
                this.currentOwner = o;
                return true;
            }
            this.windowListener = new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    AquaSharedColorChooser.this.dismiss();
                }

                @Override
                public void windowIconified(WindowEvent e) {
                    AquaSharedColorChooser.this.dismiss();
                }
            };
            this.componentListener = new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    super.componentHidden(e);
                    AquaSharedColorChooser.this.dismiss();
                }
            };
            this.changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    AquaSharedColorChooser.this.apply();
                }
            };
            this.sharedChooser = new JColorChooser();
            ColorSelectionModel model = this.sharedChooser.getSelectionModel();
            model.addChangeListener(this.changeListener);
            this.sharedDialog = new AquaColorChooserDialog((Frame)null, "", false, null, this.sharedChooser);
            this.sharedDialog.addWindowListener(this.windowListener);
            this.sharedDialog.addComponentListener(this.componentListener);
        }
        this.currentOwner = o;
        if (this.sharedDialog != null) {
            this.sharedDialog.setVisible(true);
            return true;
        }
        return AquaNativeColorChooser.display(o);
    }

    public void disconnectOwner(SharedColorChooserOwner o) {
        if (o == this.currentOwner) {
            this.currentOwner = null;
            if (useNativeChooser && this.isInitialized) {
                AquaNativeColorChooser.disconnect();
            }
        }
    }

    private void apply() {
        if (this.currentOwner != null) {
            this.currentOwner.applyColor(this.sharedChooser.getColor());
        }
    }

    private void dismiss() {
        if (this.currentOwner != null) {
            SharedColorChooserOwner old = this.currentOwner;
            this.currentOwner = null;
            old.disconnected();
        }
    }
}

