/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.function.Consumer;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.plaf.FileChooserUI;
import org.violetlib.aqua.AquaUtils;

public class AquaSheetSupport {
    public static void showOptionPaneAsSheet(JDialog d, final JOptionPane pane, final Consumer<Integer> resultConsumer) throws UnsupportedOperationException {
        Runnable closeHandler = null;
        if (resultConsumer != null) {
            closeHandler = new Runnable(){

                @Override
                public void run() {
                    resultConsumer.accept(AquaSheetSupport.getOption(pane));
                }
            };
        }
        AquaSheetSupport.displayAsSheet(d, closeHandler);
    }

    private static int getOption(JOptionPane pane) {
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        Object[] options = pane.getOptions();
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }

    public static void showFileChooserAsSheet(Window owner, final JFileChooser fc, final Consumer<Integer> resultConsumer) throws UnsupportedOperationException {
        FileChooserUI ui = fc.getUI();
        String title = ui.getDialogTitle(fc);
        fc.putClientProperty("AccessibleDescription", title);
        final JDialog dialog = owner instanceof Frame ? new JDialog((Window)((Frame)owner), title, Dialog.ModalityType.MODELESS) : new JDialog((Window)((Dialog)owner), title, Dialog.ModalityType.MODELESS);
        dialog.setComponentOrientation(fc.getComponentOrientation());
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)fc, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo(owner);
        final FileChooserActionListener listener = new FileChooserActionListener(dialog);
        fc.addActionListener(listener);
        fc.rescanCurrentDirectory();
        Runnable closeHandler = new Runnable(){

            @Override
            public void run() {
                int returnValue = listener.returnValue;
                fc.removeActionListener(listener);
                dialog.getContentPane().removeAll();
                dialog.dispose();
                if (resultConsumer != null) {
                    resultConsumer.accept(returnValue);
                }
            }
        };
        try {
            AquaSheetSupport.displayAsSheet(dialog, closeHandler);
        }
        catch (UnsupportedOperationException ex) {
            dialog.getContentPane().removeAll();
            dialog.dispose();
            throw ex;
        }
    }

    public static void displayAsSheet(Window w, Runnable closeHandler) throws UnsupportedOperationException {
        int result;
        Frame fr;
        Window owner = w.getOwner();
        if (owner == null) {
            throw new UnsupportedOperationException("Unable to display as sheet: no owner window");
        }
        if (!owner.isVisible()) {
            throw new UnsupportedOperationException("Unable to display as sheet: owner window is not visible");
        }
        if (w.isVisible()) {
            throw new UnsupportedOperationException("Unable to display as sheet: the window must not be visible");
        }
        if (w instanceof Dialog) {
            Dialog d = (Dialog)w;
            d.setModalityType(Dialog.ModalityType.MODELESS);
        }
        AquaUtils.ensureWindowPeer(w);
        boolean needToUndecorate = false;
        if (w instanceof Dialog) {
            Dialog d = (Dialog)w;
            if (!d.isUndecorated()) {
                needToUndecorate = true;
            }
        } else if (w instanceof Frame && !(fr = (Frame)w).isUndecorated()) {
            needToUndecorate = true;
        }
        int oldTop = 0;
        if (needToUndecorate) {
            oldTop = AquaUtils.unsetTitledWindowStyle(w);
        }
        JRootPane rp = null;
        if (w instanceof RootPaneContainer) {
            RootPaneContainer rpc = (RootPaneContainer)((Object)w);
            rp = rpc.getRootPane();
        }
        Object oldBackgroundStyle = null;
        if (rp != null) {
            oldBackgroundStyle = rp.getClientProperty("Aqua.backgroundStyle");
            rp.putClientProperty("Aqua.backgroundStyle", "vibrantSheet");
            w.validate();
            AquaUtils.paintImmediately(rp);
        }
        SheetCloser closer = new SheetCloser(w, closeHandler, oldBackgroundStyle);
        if ("true".equals(System.getProperty("VAqua.injectSheetDisplayFailure"))) {
            System.err.println("Injected failure to display sheet");
            result = -1;
        } else {
            result = AquaSheetSupport.nativeDisplayAsSheet(w);
        }
        if (result != 0) {
            closer.dispose();
            if (oldTop > 0) {
                AquaUtils.restoreTitledWindowStyle(w, oldTop);
                AquaUtils.syncAWTView(w);
            }
            throw new UnsupportedOperationException("Unable to display as sheet");
        }
        w.setVisible(true);
    }

    private static native int nativeDisplayAsSheet(Window var0);

    private static class SheetCloser
    extends WindowAdapter
    implements HierarchyListener {
        private final Window w;
        private final Runnable closeHandler;
        private final Object oldBackgroundStyle;
        private boolean hasClosed = false;

        public SheetCloser(Window w, Runnable closeHandler, Object oldBackgroundStyle) {
            this.w = w;
            this.closeHandler = closeHandler;
            this.oldBackgroundStyle = oldBackgroundStyle;
            w.addWindowListener(this);
            w.addHierarchyListener(this);
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (e.getChangeFlags() == 4L && !this.w.isVisible()) {
                this.completed();
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
            this.completed();
        }

        private void completed() {
            if (!this.hasClosed) {
                this.hasClosed = true;
                this.dispose();
                if (this.closeHandler != null) {
                    this.closeHandler.run();
                }
            }
        }

        public void dispose() {
            RootPaneContainer rpc;
            JRootPane rp;
            this.w.removeWindowListener(this);
            this.w.removeHierarchyListener(this);
            if (this.w instanceof RootPaneContainer && (rp = (rpc = (RootPaneContainer)((Object)this.w)).getRootPane()) != null) {
                rp.putClientProperty("Aqua.backgroundStyle", this.oldBackgroundStyle);
            }
        }
    }

    private static class FileChooserActionListener
    implements ActionListener {
        private JDialog d;
        int returnValue = -1;

        public FileChooserActionListener(JDialog d) {
            this.d = d;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String s = e.getActionCommand();
            if (s.equals("ApproveSelection")) {
                this.returnValue = 0;
                this.d.setVisible(false);
            } else if (s.equals("CancelSelection")) {
                this.returnValue = 1;
                this.d.setVisible(false);
            }
        }
    }
}

