/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaFocusRingManager;
import org.violetlib.aqua.AquaFullKeyboardFocusableHandler;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.geom.ExpandableOutline;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.SliderPainter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SliderLayoutConfiguration;

public class AquaSliderUI
extends BasicSliderUI
implements AquaUtilControlSize.Sizeable,
FocusRingOutlineProvider {
    final AquaUIPainter painter = AquaPainting.create();
    protected AquaUIPainter.Size sizeVariant = AquaUIPainter.Size.REGULAR;
    protected int fixedWidth;
    protected int fixedHeight;
    protected int leftTrackBuffer;
    protected int rightTrackBuffer;
    protected Color tickColor;
    private boolean oldRequestFocusEnabled;
    protected transient boolean fIsDragging = false;

    public static ComponentUI createUI(JComponent c) {
        return new AquaSliderUI((JSlider)c);
    }

    public AquaSliderUI(JSlider b) {
        super(b);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        LookAndFeel.installProperty(this.slider, "opaque", Boolean.FALSE);
        this.tickColor = UIManager.getColor("Slider.tickColor");
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider s) {
        return new TrackListener();
    }

    @Override
    protected void installDefaults(JSlider slider) {
        super.installDefaults(slider);
        this.oldRequestFocusEnabled = slider.isRequestFocusEnabled();
        slider.setRequestFocusEnabled(false);
    }

    @Override
    protected void uninstallDefaults(JSlider slider) {
        slider.setRequestFocusEnabled(this.oldRequestFocusEnabled);
        super.uninstallDefaults(slider);
    }

    @Override
    protected void installListeners(JSlider s) {
        super.installListeners(s);
        AquaFocusHandler.install(s);
        AquaUtilControlSize.addSizePropertyListener(s);
        AquaFullKeyboardFocusableHandler.addListener(s);
    }

    @Override
    protected void uninstallListeners(JSlider s) {
        AquaUtilControlSize.removeSizePropertyListener(s);
        AquaFocusHandler.uninstall(s);
        super.uninstallListeners(s);
        AquaFullKeyboardFocusableHandler.removeListener(s);
    }

    @Override
    public void applySizeFor(JComponent c, AquaUIPainter.Size size, boolean isDefaultSize) {
        this.sizeVariant = size;
        if (this.focusRect != null) {
            if (size == AquaUIPainter.Size.SMALL) {
                size = AquaUIPainter.Size.MINI;
            }
            AquaUtilControlSize.configureFontFromSize(c, size);
        }
    }

    protected void updateFixedDimension() {
        int tickSpacing;
        int valueRange = this.slider.getMaximum() - this.slider.getMinimum();
        int tickCount = 0;
        if (this.slider.getPaintTicks() && (tickSpacing = this.getTickSpacing()) > 0) {
            tickCount = valueRange / tickSpacing;
        }
        boolean isHorizontal = this.slider.getOrientation() == 0;
        AquaUIPainter.TickMarkPosition tickPosition = isHorizontal ? AquaUIPainter.TickMarkPosition.BELOW : AquaUIPainter.TickMarkPosition.RIGHT;
        AquaUIPainter.SliderWidget widget = this.getSliderWidget();
        SliderLayoutConfiguration sg = new SliderLayoutConfiguration(widget, this.sizeVariant, tickCount, tickPosition);
        LayoutInfo layoutInfo = this.painter.getLayoutInfo().getLayoutInfo(sg);
        this.fixedWidth = (int)Math.ceil(layoutInfo.getFixedVisualWidth());
        this.fixedHeight = (int)Math.ceil(layoutInfo.getFixedVisualHeight());
        if (isHorizontal) {
            if (this.fixedHeight == 0) {
                this.fixedHeight = 23;
            }
        } else if (this.fixedWidth == 0) {
            this.fixedWidth = 23;
        }
    }

    protected AquaUIPainter.SliderWidget getSliderWidget() {
        boolean isHorizontal = this.slider.getOrientation() == 0;
        boolean isInverted = this.drawInverted();
        return isHorizontal ? (isInverted ? AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT : AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL) : (isInverted ? AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN : AquaUIPainter.SliderWidget.SLIDER_VERTICAL);
    }

    @Override
    public Shape getFocusRingOutline(JComponent c) {
        SliderPainter p = this.getConfiguredPainter();
        Shape s = p.getThumbOutline();
        return ExpandableOutline.createTranslatedShape(s, this.trackRect.x, this.trackRect.y);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean trackIntersectsClip;
        this.recalculateIfInsetsChanged();
        Rectangle clip = g.getClipBounds();
        if (this.slider.getPaintTrack() && !(trackIntersectsClip = clip.intersects(this.trackRect))) {
            this.calculateGeometry();
        }
        SliderPainter p = this.getConfiguredPainter();
        p.paint(g, this.trackRect.x, this.trackRect.y);
        if (this.slider.getPaintLabels() && clip.intersects(this.labelRect)) {
            this.paintLabels(g);
        }
    }

    protected SliderPainter getConfiguredPainter() {
        this.painter.configure(this.trackRect.width, this.trackRect.height);
        SliderConfiguration sg = this.getConfiguration();
        return (SliderPainter)this.painter.getPainter(sg);
    }

    protected SliderConfiguration getConfiguration() {
        int tickSpacing;
        AquaUIPainter.State state = this.getState();
        int valueRange = this.slider.getMaximum() - this.slider.getMinimum();
        int tickCount = 0;
        if (this.slider.getPaintTicks() && valueRange > 0 && (tickSpacing = this.getTickSpacing()) > 0) {
            tickCount = valueRange / tickSpacing + 1;
        }
        double thumbPosition = valueRange > 0 ? (double)this.slider.getValue() / (double)valueRange : 0.0;
        AquaUIPainter.SliderWidget widget = this.getSliderWidget();
        AquaUIPainter.TickMarkPosition tickPosition = this.getTickMarkPosition();
        boolean isFocused = this.slider.hasFocus();
        return new SliderConfiguration(widget, this.sizeVariant, state, isFocused, thumbPosition, tickCount, tickPosition);
    }

    AquaUIPainter.TickMarkPosition getTickMarkPosition() {
        boolean isHorizontal;
        boolean isLeftToRight = this.slider.getComponentOrientation().isLeftToRight();
        boolean bl = isHorizontal = this.slider.getOrientation() == 0;
        if (isHorizontal) {
            return AquaUIPainter.TickMarkPosition.BELOW;
        }
        return isLeftToRight ? AquaUIPainter.TickMarkPosition.RIGHT : AquaUIPainter.TickMarkPosition.LEFT;
    }

    AquaUIPainter.State getState() {
        if (!this.slider.isEnabled()) {
            return AquaFocusHandler.isActive(this.slider) ? AquaUIPainter.State.DISABLED : AquaUIPainter.State.DISABLED_INACTIVE;
        }
        if (this.fIsDragging) {
            return AquaUIPainter.State.PRESSED;
        }
        if (!AquaFocusHandler.isActive(this.slider)) {
            return AquaUIPainter.State.INACTIVE;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    @Override
    public void paintTrack(Graphics g) {
    }

    @Override
    public void paintThumb(Graphics g) {
    }

    @Override
    public void paintTicks(Graphics g) {
    }

    @Override
    protected void calculateGeometry() {
        this.updateFixedDimension();
        super.calculateGeometry();
        AquaFocusRingManager.focusRingOutlineChanged(this.slider);
    }

    @Override
    protected int getTickLength() {
        return 0;
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        SliderPainter p = this.getConfiguredPainter();
        this.thumbRect.setBounds(AquaUtils.toRectangle(p.getThumbBounds()));
        AquaFocusRingManager.focusRingOutlineChanged(this.slider);
    }

    @Override
    protected void calculateThumbSize() {
        if (this.slider.getOrientation() == 0) {
            this.thumbRect.x = 0;
            this.thumbRect.y = 0;
            this.thumbRect.width = 20;
            this.thumbRect.height = this.fixedHeight > 0 ? this.fixedHeight : 23;
        } else {
            this.thumbRect.x = 0;
            this.thumbRect.y = 0;
            this.thumbRect.width = this.fixedWidth > 0 ? this.fixedWidth : 23;
            this.thumbRect.height = 20;
        }
    }

    @Override
    protected void calculateTrackRect() {
        if (this.slider.getOrientation() == 0) {
            int centerSpacing = this.thumbRect.height;
            if (this.slider.getPaintTicks()) {
                centerSpacing += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                centerSpacing += this.getHeightOfTallestLabel();
            }
            this.trackRect.x = this.contentRect.x + this.leftTrackBuffer;
            this.trackRect.y = this.contentRect.y + (this.contentRect.height - centerSpacing - 1) / 2;
            this.trackRect.width = this.contentRect.width - this.leftTrackBuffer - this.rightTrackBuffer;
            this.trackRect.height = this.thumbRect.height;
        } else {
            int centerSpacing = this.thumbRect.width;
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                if (this.slider.getPaintTicks()) {
                    centerSpacing += this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    centerSpacing += this.getWidthOfWidestLabel();
                }
            } else {
                if (this.slider.getPaintTicks()) {
                    centerSpacing -= this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    centerSpacing -= this.getWidthOfWidestLabel();
                }
            }
            this.trackRect.x = this.contentRect.x + (this.contentRect.width - centerSpacing - 1) / 2;
            this.trackRect.y = this.contentRect.y + this.leftTrackBuffer;
            this.trackRect.width = this.thumbRect.width;
            this.trackRect.height = this.contentRect.height - this.leftTrackBuffer - this.rightTrackBuffer;
        }
    }

    @Override
    protected void calculateTrackBuffer() {
        this.leftTrackBuffer = 0;
        this.rightTrackBuffer = 0;
        if (this.slider.getPaintLabels() && this.slider.getLabelTable() != null) {
            Rectangle rightBounds;
            this.trackRect.width = this.contentRect.width;
            this.trackRect.height = this.contentRect.height;
            SliderPainter p = this.getConfiguredPainter();
            int lowValue = this.getLowestValue();
            int highValue = this.getHighestValue();
            double lowThumbPosition = this.toThumbPosition(lowValue);
            double highThumbPosition = this.toThumbPosition(highValue);
            Component lowLabel = (Component)this.slider.getLabelTable().get(lowValue);
            Rectangle lowBounds = AquaUtils.toRectangle(p.getLabelBounds(lowThumbPosition, lowLabel.getSize()));
            Component highLabel = (Component)this.slider.getLabelTable().get(highValue);
            Rectangle highBounds = AquaUtils.toRectangle(p.getLabelBounds(highThumbPosition, highLabel.getSize()));
            boolean isInverted = this.drawInverted();
            boolean isHorizontal = this.slider.getOrientation() == 0;
            Rectangle leftBounds = isHorizontal ^ isInverted ? lowBounds : highBounds;
            Rectangle rectangle = rightBounds = isHorizontal ^ isInverted ? highBounds : lowBounds;
            if (isHorizontal) {
                this.leftTrackBuffer = Math.max(this.leftTrackBuffer, -leftBounds.x);
                this.rightTrackBuffer = Math.max(this.rightTrackBuffer, rightBounds.x + rightBounds.width - this.trackRect.width);
            } else {
                this.leftTrackBuffer = Math.max(this.leftTrackBuffer, -leftBounds.y);
                this.rightTrackBuffer = Math.max(this.rightTrackBuffer, rightBounds.y + rightBounds.height - this.trackRect.height);
            }
        }
        this.trackBuffer = Math.max(this.leftTrackBuffer, this.rightTrackBuffer);
        boolean lockBuffers = true;
        if (lockBuffers) {
            this.leftTrackBuffer = this.trackBuffer;
            this.rightTrackBuffer = this.trackBuffer;
        }
    }

    protected double toThumbPosition(int value) {
        int minimum = this.slider.getMinimum();
        int maximum = this.slider.getMaximum();
        double range = maximum - minimum;
        if (range > 0.0) {
            return (double)minimum + (double)value / range;
        }
        return 0.0;
    }

    @Override
    protected int getWidthOfWidestLabel() {
        int w = super.getWidthOfWidestLabel();
        return w > 0 ? w + 2 : 0;
    }

    @Override
    protected int getHeightOfTallestLabel() {
        int h = super.getHeightOfTallestLabel();
        return h > 0 ? h + 2 : 0;
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        return new Dimension(190, 21);
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        return new Dimension(21, 190);
    }

    @Override
    public void setThumbLocation(int x, int y) {
        this.thumbRect.setLocation(x, y);
        this.slider.repaint();
        AquaFocusRingManager.focusRingOutlineChanged(this.slider);
    }

    @Override
    protected ChangeListener createChangeListener(JSlider s) {
        return new StateChangeListener();
    }

    protected void updateSliderFromLocation(int x, int y) {
        SliderPainter p = this.getConfiguredPainter();
        double thumbPosition = p.getThumbPosition(x - this.trackRect.x, y - this.trackRect.y);
        double range = this.slider.getMaximum() - this.slider.getMinimum();
        int value = (int)((double)this.slider.getMinimum() + thumbPosition * range);
        this.slider.setValue(value);
        p = this.getConfiguredPainter();
        this.thumbRect.setBounds(AquaUtils.toRectangle(p.getThumbBounds()));
        this.slider.repaint();
        AquaFocusRingManager.focusRingOutlineChanged(this.slider);
    }

    @Override
    public void paintLabels(Graphics g) {
        double range = this.slider.getMaximum() - this.slider.getMinimum();
        if (range <= 0.0) {
            return;
        }
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary != null) {
            SliderPainter p = this.getConfiguredPainter();
            Enumeration keys = dictionary.keys();
            int minValue = this.slider.getMinimum();
            int maxValue = this.slider.getMaximum();
            boolean enabled = this.slider.isEnabled();
            while (keys.hasMoreElements()) {
                Integer key = (Integer)keys.nextElement();
                int value = key;
                if (value < minValue || value > maxValue) continue;
                JComponent label = (JComponent)dictionary.get(key);
                label.setEnabled(enabled);
                if (label instanceof JLabel) {
                    Icon icon;
                    Icon icon2 = icon = label.isEnabled() ? ((JLabel)label).getIcon() : ((JLabel)label).getDisabledIcon();
                    if (icon instanceof ImageIcon) {
                        Toolkit.getDefaultToolkit().checkImage(((ImageIcon)icon).getImage(), -1, -1, this.slider);
                    }
                }
                double thumbPosition = (double)(value - this.slider.getMinimum()) / range;
                Dimension labelSize = label.getPreferredSize();
                Rectangle labelBounds = AquaUtils.toRectangle(p.getLabelBounds(thumbPosition, labelSize));
                g.translate(this.trackRect.x + labelBounds.x, this.trackRect.y + labelBounds.y);
                label.paint(g);
                g.translate(-(this.trackRect.x + labelBounds.x), -(this.trackRect.y + labelBounds.y));
            }
        }
    }

    @Override
    protected void paintHorizontalLabel(Graphics g, int value, Component label) {
        double range = this.slider.getMaximum() - this.slider.getMinimum();
        if (range > 0.0) {
            double thumbPosition = (double)(value - this.slider.getMinimum()) / range;
            Dimension labelSize = label.getPreferredSize();
            SliderPainter p = this.getConfiguredPainter();
            Rectangle labelBounds = AquaUtils.toRectangle(p.getLabelBounds(thumbPosition, labelSize));
            g.translate(this.trackRect.x + labelBounds.x, this.trackRect.y + labelBounds.y - this.labelRect.y);
            label.paint(g);
            g.translate(-(this.trackRect.x + labelBounds.x), -(this.trackRect.y + labelBounds.y - this.labelRect.y));
        }
    }

    @Override
    protected void paintVerticalLabel(Graphics g, int value, Component label) {
        double range = this.slider.getMaximum() - this.slider.getMinimum();
        if (range > 0.0) {
            double thumbPosition = (double)(value - this.slider.getMinimum()) / range;
            Dimension labelSize = label.getPreferredSize();
            SliderPainter p = this.getConfiguredPainter();
            Rectangle labelBounds = AquaUtils.toRectangle(p.getLabelBounds(thumbPosition, labelSize));
            g.translate(this.trackRect.x + labelBounds.x - this.labelRect.x, this.trackRect.y + labelBounds.y);
            label.paint(g);
            g.translate(-(this.trackRect.x + labelBounds.x - this.labelRect.x), -(this.trackRect.y + labelBounds.y));
        }
    }

    protected int getTickSpacing() {
        int majorTickSpacing = this.slider.getMajorTickSpacing();
        int minorTickSpacing = this.slider.getMinorTickSpacing();
        int result = minorTickSpacing > 0 ? minorTickSpacing : (majorTickSpacing > 0 ? majorTickSpacing : 0);
        return result;
    }

    class TrackListener
    extends BasicSliderUI.TrackListener {
        protected transient int offset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;

        TrackListener() {
            super(AquaSliderUI.this);
            this.currentMouseX = -1;
            this.currentMouseY = -1;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!AquaSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = -1;
            this.currentMouseY = -1;
            this.offset = 0;
            AquaSliderUI.this.scrollTimer.stop();
            if (AquaSliderUI.this.slider.getSnapToTicks()) {
                AquaSliderUI.this.fIsDragging = false;
                AquaSliderUI.this.slider.setValueIsAdjusting(false);
            } else {
                AquaSliderUI.this.slider.setValueIsAdjusting(false);
                AquaSliderUI.this.fIsDragging = false;
            }
            AquaSliderUI.this.slider.repaint();
            AquaFocusRingManager.focusRingOutlineChanged(AquaSliderUI.this.slider);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!AquaSliderUI.this.slider.isEnabled()) {
                return;
            }
            AquaSliderUI.this.calculateGeometry();
            boolean firstClick = this.currentMouseX == -1 && this.currentMouseY == -1;
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (AquaSliderUI.this.slider.isRequestFocusEnabled()) {
                AquaSliderUI.this.slider.requestFocus();
            }
            boolean isMouseEventInThumb = AquaSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY);
            if (!firstClick || !isMouseEventInThumb) {
                AquaSliderUI.this.slider.setValueIsAdjusting(true);
                AquaSliderUI.this.updateSliderFromLocation(this.currentMouseX, this.currentMouseY);
                AquaSliderUI.this.slider.setValueIsAdjusting(false);
                isMouseEventInThumb = true;
            }
            if (isMouseEventInThumb) {
                switch (AquaSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((AquaSliderUI)AquaSliderUI.this).thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((AquaSliderUI)AquaSliderUI.this).thumbRect.x;
                    }
                }
                AquaSliderUI.this.fIsDragging = true;
                AquaSliderUI.this.slider.repaint();
                return;
            }
            AquaSliderUI.this.fIsDragging = false;
        }

        @Override
        public boolean shouldScroll(int direction) {
            Rectangle r = AquaSliderUI.this.thumbRect;
            if (AquaSliderUI.this.slider.getOrientation() == 1 ? ((AquaSliderUI.this.drawInverted() ? direction < 0 : direction > 0) ? r.y + r.height <= this.currentMouseY : r.y >= this.currentMouseY) : ((AquaSliderUI.this.drawInverted() ? direction < 0 : direction > 0) ? r.x + r.width >= this.currentMouseX : r.x <= this.currentMouseX)) {
                return false;
            }
            if (direction > 0 && AquaSliderUI.this.slider.getValue() + AquaSliderUI.this.slider.getExtent() >= AquaSliderUI.this.slider.getMaximum()) {
                return false;
            }
            return direction >= 0 || AquaSliderUI.this.slider.getValue() > AquaSliderUI.this.slider.getMinimum();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!AquaSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (!AquaSliderUI.this.fIsDragging) {
                return;
            }
            AquaSliderUI.this.slider.setValueIsAdjusting(true);
            AquaSliderUI.this.updateSliderFromLocation(this.currentMouseX, this.currentMouseY);
            if (AquaSliderUI.this.slider.getSnapToTicks()) {
                AquaSliderUI.this.calculateThumbLocation();
                AquaSliderUI.this.setThumbLocation(((AquaSliderUI)AquaSliderUI.this).thumbRect.x, ((AquaSliderUI)AquaSliderUI.this).thumbRect.y);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    protected class StateChangeListener
    implements ChangeListener {
        protected StateChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (AquaSliderUI.this.fIsDragging) {
                return;
            }
            AquaSliderUI.this.calculateThumbLocation();
            AquaSliderUI.this.slider.repaint();
            AquaFocusRingManager.focusRingOutlineChanged(AquaSliderUI.this.slider);
        }
    }
}

