/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaSplitPaneUI;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;

public class AquaSplitPaneDivider
extends BasicSplitPaneDivider {
    final AquaUIPainter painter = AquaPainting.create();
    protected final AquaSplitPaneUI ui;
    static final AquaUtils.LazyKeyedSingleton<Integer, Image> directionArrows = new AquaUtils.LazyKeyedSingleton<Integer, Image>(){

        @Override
        protected Image getInstance(Integer direction) {
            Image arrowImage = AquaImageFactory.getArrowImageForDirection(direction);
            int h = arrowImage.getHeight(null) * 5 / 7;
            int w = arrowImage.getWidth(null) * 5 / 7;
            return AquaImageFactory.generateLightenedImage(arrowImage.getScaledInstance(w, h, 4), 50);
        }
    };

    public AquaSplitPaneDivider(AquaSplitPaneUI ui) {
        super(ui);
        this.ui = ui;
        this.setLayout(new DividerLayout());
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.splitPane) {
            String propName = e.getPropertyName();
            if ("enabled".equals(propName)) {
                boolean enabled = this.splitPane.isEnabled();
                if (this.leftButton != null) {
                    this.leftButton.setEnabled(enabled);
                }
                if (this.rightButton != null) {
                    this.rightButton.setEnabled(enabled);
                }
            } else if ("orientation".equals(propName)) {
                if (this.rightButton != null) {
                    this.remove(this.rightButton);
                    this.rightButton = null;
                }
                if (this.leftButton != null) {
                    this.remove(this.leftButton);
                    this.leftButton = null;
                }
                this.oneTouchExpandableChanged();
            }
        }
        super.propertyChange(e);
    }

    protected int getMinDividerSize() {
        int size = this.ui.getFixedDividerSize();
        return size > 0 ? size : 2;
    }

    protected int getMaxDividerSize() {
        int size = this.ui.getFixedDividerSize();
        return size > 0 ? size : 11;
    }

    public int getDividerExtension() {
        return this.ui.getDividerExtension();
    }

    @Override
    public void paint(Graphics g) {
        int diff;
        Dimension size = this.getSize();
        int x = 0;
        int y = 0;
        boolean isVerticalDivider = this.splitPane.getOrientation() == 1;
        int minSize = this.getMinDividerSize();
        int maxSize = this.getMaxDividerSize();
        boolean doPaint = true;
        if (isVerticalDivider) {
            if (size.width > maxSize) {
                diff = size.width - maxSize;
                x = diff / 2;
                size.width = maxSize;
            }
            if (size.width < minSize) {
                doPaint = false;
            }
        } else {
            if (size.height > maxSize) {
                diff = size.height - maxSize;
                y = diff / 2;
                size.height = maxSize;
            }
            if (size.height < minSize) {
                doPaint = false;
            }
        }
        if (doPaint) {
            AquaUIPainter.DividerWidget w = this.ui.getWidget();
            AquaUIPainter.State state = this.getState();
            AquaUIPainter.Orientation orientation = isVerticalDivider ? AquaUIPainter.Orientation.VERTICAL : AquaUIPainter.Orientation.HORIZONTAL;
            this.painter.configure(size.width, size.height);
            SplitPaneDividerConfiguration dg = new SplitPaneDividerConfiguration(w, state, orientation, 0);
            this.painter.getPainter(dg).paint(g, x, y);
        } else {
            Color c = UIManager.getColor("SplitPane.dividerColor");
            if (c != null) {
                g.setColor(c);
                g.fillRect(x, y, size.width, size.height);
            }
        }
        super.paint(g);
    }

    protected AquaUIPainter.State getState() {
        return this.splitPane.isEnabled() ? AquaUIPainter.State.ACTIVE : AquaUIPainter.State.DISABLED;
    }

    @Override
    protected void dragDividerTo(int location) {
        ((AquaSplitPaneUI)this.splitPaneUI).dragDividerTo(location += this.getDividerExtension());
    }

    @Override
    protected void finishDraggingTo(int location) {
        ((AquaSplitPaneUI)this.splitPaneUI).finishDraggingTo(location += this.getDividerExtension());
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        return AquaSplitPaneDivider.createButtonForDirection(this.getDirection(true));
    }

    @Override
    protected JButton createRightOneTouchButton() {
        return AquaSplitPaneDivider.createButtonForDirection(this.getDirection(false));
    }

    static JButton createButtonForDirection(int direction) {
        JButton button = new JButton(new ImageIcon(directionArrows.get(direction)));
        button.setCursor(Cursor.getPredefinedCursor(0));
        button.setFocusPainted(false);
        button.setRequestFocusEnabled(false);
        button.setFocusable(false);
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        return button;
    }

    int getDirection(boolean isLeft) {
        boolean isVerticalDivider;
        boolean bl = isVerticalDivider = this.splitPane.getOrientation() == 1;
        if (isVerticalDivider) {
            return isLeft ? 7 : 3;
        }
        return isLeft ? 1 : 5;
    }

    protected class DividerLayout
    extends BasicSplitPaneDivider.DividerLayout {
        protected DividerLayout() {
            super(AquaSplitPaneDivider.this);
        }

        @Override
        public void layoutContainer(Container c) {
            boolean isVerticalDivider;
            int maxSize = AquaSplitPaneDivider.this.getMaxDividerSize();
            Dimension size = AquaSplitPaneDivider.this.getSize();
            if (AquaSplitPaneDivider.this.leftButton == null || AquaSplitPaneDivider.this.rightButton == null || c != AquaSplitPaneDivider.this) {
                return;
            }
            if (!AquaSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                AquaSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                AquaSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                return;
            }
            Icon leftIcon = AquaSplitPaneDivider.this.leftButton.getIcon();
            Icon rightIcon = AquaSplitPaneDivider.this.rightButton.getIcon();
            int buttonWidth = Math.max(leftIcon.getIconWidth(), rightIcon.getIconWidth());
            int buttonHeight = Math.max(leftIcon.getIconHeight(), rightIcon.getIconHeight());
            boolean bl = isVerticalDivider = AquaSplitPaneDivider.this.splitPane.getOrientation() == 1;
            if (isVerticalDivider) {
                if (buttonWidth > size.width || buttonWidth > maxSize) {
                    AquaSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    AquaSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                    return;
                }
                int diff = size.width - buttonWidth;
                int xPosition = diff / 2;
                int yPosition = buttonHeight + 2;
                AquaSplitPaneDivider.this.rightButton.setBounds(xPosition, yPosition, buttonWidth, buttonHeight);
                AquaSplitPaneDivider.this.leftButton.setBounds(xPosition, yPosition -= buttonHeight + 2, buttonWidth, buttonHeight);
            } else {
                if (buttonHeight > size.height || buttonHeight > maxSize) {
                    AquaSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    AquaSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                    return;
                }
                int diff = size.height - buttonHeight;
                int yPosition = diff / 2;
                int xPosition = buttonWidth + 2;
                AquaSplitPaneDivider.this.rightButton.setBounds(xPosition, yPosition, buttonWidth, buttonHeight);
                AquaSplitPaneDivider.this.leftButton.setBounds(xPosition -= buttonWidth + 2, yPosition, buttonWidth, buttonHeight);
            }
        }
    }
}

