/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager2;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaSplitPaneDivider;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SplitPaneDividerLayoutConfiguration;

public class AquaSplitPaneUI
extends BasicSplitPaneUI
implements MouseListener,
ContainerListener,
PropertyChangeListener {
    static final String DIVIDER_PAINTER_KEY = "JSplitPane.dividerPainter";
    public static final String SPLIT_PANE_STYLE_KEY = "JSplitPane.style";
    public static final String QUAQUA_SPLIT_PANE_STYLE_KEY = "Quaqua.SplitPane.style";
    final AquaUIPainter painter = AquaPainting.create();
    protected static SplitPaneStyle defaultStyle = SplitPaneStyle.THIN;
    protected SplitPaneStyle style = defaultStyle;
    private boolean isReorderingComponents;
    private boolean initialDividerUpdatePerformed;
    private boolean ignoreDividerLocationChange;
    private boolean isInLayout;

    public static ComponentUI createUI(JComponent x) {
        return new AquaSplitPaneUI();
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        return new AquaSplitPaneDivider(this);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.splitPane.setOneTouchExpandable(false);
        SplitPaneStyle specifiedStyle = this.getClientSpecifiedStyle();
        if (specifiedStyle != null) {
            this.style = specifiedStyle;
        }
        this.updateDividerSize();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.splitPane.addPropertyChangeListener(DIVIDER_PAINTER_KEY, this);
        this.splitPane.addPropertyChangeListener(SPLIT_PANE_STYLE_KEY, this);
        this.splitPane.addPropertyChangeListener(QUAQUA_SPLIT_PANE_STYLE_KEY, this);
        this.splitPane.addContainerListener(this);
    }

    @Override
    protected void uninstallListeners() {
        this.splitPane.removeContainerListener(this);
        this.splitPane.removePropertyChangeListener(DIVIDER_PAINTER_KEY, this);
        this.splitPane.removePropertyChangeListener(SPLIT_PANE_STYLE_KEY, this);
        this.splitPane.removePropertyChangeListener(QUAQUA_SPLIT_PANE_STYLE_KEY, this);
        super.uninstallListeners();
    }

    protected void updateStyle() {
        SplitPaneStyle newStyle = this.getClientSpecifiedStyle();
        if (newStyle == null) {
            newStyle = defaultStyle;
        }
        if (this.style != newStyle) {
            this.style = newStyle;
            this.updateDividerSize();
            this.divider.repaint();
        }
    }

    protected void updateDividerSize() {
        int size = this.getFixedDividerSize();
        if (size > 0) {
            LookAndFeel.installProperty(this.splitPane, "dividerSize", size);
            this.divider.setDividerSize(this.splitPane.getDividerSize());
            this.dividerSize = this.divider.getDividerSize();
        }
    }

    public AquaUIPainter.DividerWidget getWidget() {
        switch (this.style) {
            case PANE_SPLITTER: {
                return AquaUIPainter.DividerWidget.PANE_SPLITTER;
            }
            case THICK: {
                return AquaUIPainter.DividerWidget.THICK_DIVIDER;
            }
        }
        return AquaUIPainter.DividerWidget.THIN_DIVIDER;
    }

    public int getFixedDividerSize() {
        boolean isVerticalDivider = this.splitPane.getOrientation() == 1;
        AquaUIPainter.DividerWidget w = this.getWidget();
        AquaUIPainter.Orientation o = isVerticalDivider ? AquaUIPainter.Orientation.VERTICAL : AquaUIPainter.Orientation.HORIZONTAL;
        SplitPaneDividerLayoutConfiguration g = new SplitPaneDividerLayoutConfiguration(w, o, 0);
        LayoutInfo layoutInfo = this.painter.getLayoutInfo().getLayoutInfo(g);
        return (int)(isVerticalDivider ? layoutInfo.getFixedVisualWidth() : layoutInfo.getFixedVisualHeight());
    }

    public int getDividerExtension() {
        AquaUIPainter.DividerWidget w = this.getWidget();
        if (w == AquaUIPainter.DividerWidget.THIN_DIVIDER) {
            return 2;
        }
        return 0;
    }

    protected SplitPaneStyle getClientSpecifiedStyle() {
        Object o = this.splitPane.getClientProperty(SPLIT_PANE_STYLE_KEY);
        if (o != null) {
            if (o instanceof String) {
                String s = (String)o;
                if (s.equals("thin")) {
                    return SplitPaneStyle.THIN;
                }
                if (s.equals("thick")) {
                    return SplitPaneStyle.THICK;
                }
                if (s.equals("paneSplitter")) {
                    return SplitPaneStyle.PANE_SPLITTER;
                }
            }
        } else {
            o = this.splitPane.getClientProperty(QUAQUA_SPLIT_PANE_STYLE_KEY);
            if (o instanceof String) {
                String s = (String)o;
                if (s.equals("bar")) {
                    return SplitPaneStyle.PANE_SPLITTER;
                }
                if (s.equals("thumb")) {
                    return SplitPaneStyle.THICK;
                }
            }
        }
        return null;
    }

    protected boolean isStyleProperty(String prop) {
        return AquaUtils.isProperty(prop, SPLIT_PANE_STYLE_KEY, QUAQUA_SPLIT_PANE_STYLE_KEY);
    }

    @Override
    public boolean isContinuousLayout() {
        return true;
    }

    @Override
    public Component getNonContinuousLayoutDivider() {
        return null;
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this.ensureComponentOrder();
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureComponentOrder() {
        if (!this.isReorderingComponents) {
            this.isReorderingComponents = true;
            try {
                Component leftC = this.splitPane.getLeftComponent();
                Component rightC = this.splitPane.getRightComponent();
                int lastLocation = this.splitPane.getDividerLocation();
                if (leftC != null) {
                    this.splitPane.setLeftComponent(null);
                }
                if (rightC != null) {
                    this.splitPane.setRightComponent(null);
                }
                this.splitPane.remove(this.divider);
                this.splitPane.add((Component)this.divider, "divider");
                this.splitPane.setLeftComponent(leftC);
                this.splitPane.setRightComponent(rightC);
                this.splitPane.setDividerLocation(lastLocation);
            }
            finally {
                this.isReorderingComponents = false;
            }
        }
    }

    @Override
    protected void resetLayoutManager() {
        super.resetLayoutManager();
        LayoutManager2 manager = (LayoutManager2)this.splitPane.getLayout();
        MyLayoutManager myLayoutManager = new MyLayoutManager(manager);
        this.splitPane.setLayout(myLayoutManager);
    }

    @Override
    public void setDividerLocation(JSplitPane jc, int location) {
        if (!this.ignoreDividerLocationChange) {
            super.setDividerLocation(jc, location);
        }
    }

    protected void updateDividerBounds() {
        if (this.divider != null) {
            this.initialDividerUpdatePerformed = true;
            int extension = this.getDividerExtension();
            if (extension > 0) {
                int x = this.divider.getX();
                int y = this.divider.getY();
                int w = this.divider.getWidth();
                int h = this.divider.getHeight();
                if (this.splitPane.getOrientation() == 1) {
                    this.divider.setBounds(x - extension, y, w + 2 * extension, h);
                } else {
                    this.divider.setBounds(x, y - extension, w, h + 2 * extension);
                }
            }
        }
    }

    @Override
    public int getDividerLocation(JSplitPane jc) {
        int extension;
        int n = extension = this.isInLayout ? 0 : this.getDividerExtension();
        if (this.splitPane.getOrientation() == 1) {
            return this.divider.getLocation().x + extension;
        }
        return this.divider.getLocation().y + extension;
    }

    @Override
    public void dragDividerTo(int location) {
        super.dragDividerTo(location);
    }

    @Override
    public void finishDraggingTo(int location) {
        super.finishDraggingTo(location);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            AquaUtils.fillRect(g, c, 2);
        }
        this.paint(g, c);
    }

    @Override
    public void paint(Graphics g, JComponent jc) {
        if (!this.initialDividerUpdatePerformed) {
            this.updateDividerBounds();
            this.ignoreDividerLocationChange = true;
            this.splitPane.setDividerLocation(this.getDividerLocation(this.splitPane));
            this.ignoreDividerLocationChange = false;
        }
        super.paint(g, jc);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() < 2) {
            return;
        }
        if (!this.splitPane.isOneTouchExpandable()) {
            return;
        }
        double resizeWeight = this.splitPane.getResizeWeight();
        int minLocation = this.splitPane.getMinimumDividerLocation();
        int maxLocation = this.splitPane.getMaximumDividerLocation();
        int divLocation = this.splitPane.getDividerLocation();
        int lastDivLocation = this.splitPane.getLastDividerLocation();
        if (divLocation >= maxLocation - 5) {
            this.splitPane.setDividerLocation(lastDivLocation);
            return;
        }
        if (divLocation < minLocation + 5) {
            this.splitPane.setDividerLocation(lastDivLocation);
            return;
        }
        if (resizeWeight > 0.5) {
            this.splitPane.setDividerLocation(0);
        } else {
            this.splitPane.setDividerLocation(maxLocation);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop != null) {
            if (prop.equals(DIVIDER_PAINTER_KEY)) {
                Object value = evt.getNewValue();
                if (value instanceof Border) {
                    this.divider.setBorder((Border)value);
                } else {
                    this.divider.setBorder(null);
                }
            } else if (this.isStyleProperty(prop)) {
                this.updateStyle();
            }
        }
    }

    protected class MyLayoutManager
    implements LayoutManager2 {
        LayoutManager2 delegate;

        public MyLayoutManager(LayoutManager2 delegate) {
            this.delegate = delegate;
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            this.delegate.addLayoutComponent(comp, constraints);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return this.delegate.maximumLayoutSize(target);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return this.delegate.getLayoutAlignmentX(target);
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return this.delegate.getLayoutAlignmentY(target);
        }

        @Override
        public void invalidateLayout(Container target) {
            this.delegate.invalidateLayout(target);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.delegate.addLayoutComponent(name, comp);
        }

        @Override
        public void layoutContainer(Container parent) {
            AquaSplitPaneUI.this.isInLayout = true;
            this.delegate.layoutContainer(parent);
            AquaSplitPaneUI.this.isInLayout = false;
            Dimension containerSize = parent.getSize();
            if (containerSize.height <= 0 || containerSize.width <= 0) {
                return;
            }
            AquaSplitPaneUI.this.updateDividerBounds();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.delegate.minimumLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.delegate.preferredLayoutSize(parent);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.delegate.removeLayoutComponent(comp);
        }
    }

    public static enum SplitPaneStyle {
        THIN,
        THICK,
        PANE_SPLITTER;

    }
}

