/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;
import org.violetlib.aqua.AquaButtonExtendedTypes;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaFullKeyboardFocusableHandler;
import org.violetlib.aqua.AquaGroupBorder;
import org.violetlib.aqua.AquaIcon;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaSegmentedButtonBorder;
import org.violetlib.aqua.AquaTabbedPaneCopyFromBasicUI;
import org.violetlib.aqua.AquaTabbedPaneTabState;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonLayoutConfiguration;

public class AquaTabbedPaneUI
extends AquaTabbedPaneCopyFromBasicUI
implements AquaUtilControlSize.Sizeable,
FocusRingOutlineProvider {
    private static final int kSmallTabHeight = 20;
    private static final int kLargeTabHeight = 23;
    private static final int kMaxIconSize = 16;
    private static final double kNinetyDegrees = 1.5707963267948966;
    protected AquaUIPainter.SegmentedButtonWidget buttonWidget = AquaUIPainter.SegmentedButtonWidget.BUTTON_TAB;
    protected final Insets currentContentDrawingInsets = new Insets(0, 0, 0, 0);
    protected final Insets currentContentBorderInsets = new Insets(0, 0, 0, 0);
    protected final Insets contentDrawingInsets = new Insets(0, 0, 0, 0);
    protected int pressedTab = -3;
    protected boolean popupSelectionChanged;
    protected Boolean isDefaultFocusReceiver = null;
    protected boolean hasAvoidedFirstFocus = false;
    protected final AquaTabbedPaneTabState visibleTabState = new AquaTabbedPaneTabState(this);
    protected final AquaUIPainter painter = AquaPainting.create();
    protected AquaUIPainter.Size sizeVariant = AquaUIPainter.Size.REGULAR;
    protected int fixedTabHeight = 0;
    protected int maxIconSize = 0;
    protected Insets onlyTabInsets;
    protected Insets leftTabInsets;
    protected Insets rightTabInsets;
    protected Insets middleTabInsets;
    final Rectangle fContentRect = new Rectangle();
    final Rectangle fIconRect = new Rectangle();
    final Rectangle fTextRect = new Rectangle();

    public static ComponentUI createUI(JComponent c) {
        return new AquaTabbedPaneUI();
    }

    @Override
    public Shape getFocusRingOutline(JComponent c) {
        int selectedIndex = this.tabPane.getSelectedIndex();
        if (selectedIndex >= 0 && selectedIndex < this.rects.length) {
            Rectangle bounds = this.rects[selectedIndex];
            return this.createFocusRingOutline(selectedIndex, bounds);
        }
        return null;
    }

    protected Shape createFocusRingOutline(int tabIndex, Rectangle bounds) {
        int tabPlacement = this.tabPane.getTabPlacement();
        boolean isVertical = tabPlacement == 2 || tabPlacement == 4;
        int x = bounds.x;
        int y = bounds.y;
        int width = isVertical ? bounds.height : bounds.width;
        int height = isVertical ? bounds.width : bounds.height;
        SegmentedButtonLayoutConfiguration lg = this.getTabLayoutConfiguration(tabIndex);
        this.painter.configure(width, height);
        Shape outline = this.painter.getOutline(lg);
        AffineTransform tr = new AffineTransform();
        if (isVertical) {
            tr.translate(x + height, y);
            tr.rotate(1.5707963267948966);
        } else {
            tr.translate(x, y);
        }
        return tr.createTransformedShape(outline);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this.mouseListener != null) {
            this.tabPane.addMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
        }
        AquaUtilControlSize.addSizePropertyListener(this.tabPane);
        AquaFullKeyboardFocusableHandler.addListener(this.tabPane);
    }

    @Override
    protected void uninstallListeners() {
        if (this.mouseListener != null) {
            this.tabPane.removeMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
        }
        AquaUtilControlSize.removeSizePropertyListener(this.tabPane);
        AquaFullKeyboardFocusableHandler.removeListener(this.tabPane);
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        Boolean b;
        super.installDefaults();
        if (this.tabPane.getFont() instanceof UIResource && (b = (Boolean)UIManager.get("TabbedPane.useSmallLayout")) != null && b == Boolean.TRUE) {
            this.tabPane.setFont(UIManager.getFont("TabbedPane.smallFont"));
            this.sizeVariant = AquaUIPainter.Size.SMALL;
        }
        this.updateLayoutParameters();
        this.contentDrawingInsets.set(0, 10, 10, 10);
        LookAndFeel.installProperty(this.tabPane, "opaque", false);
    }

    @Override
    public void applySizeFor(JComponent c, AquaUIPainter.Size size, boolean isDefaultSize) {
        if (size != this.sizeVariant) {
            this.sizeVariant = size;
            AquaUtilControlSize.configureFontFromSize(c, size);
            this.updateLayoutParameters();
            c.revalidate();
            c.repaint();
        }
    }

    protected void updateLayoutParameters() {
        SegmentedButtonLayoutConfiguration g = new SegmentedButtonLayoutConfiguration(this.buttonWidget, this.sizeVariant, AquaUIPainter.Position.FIRST);
        LayoutInfo layoutInfo = this.painter.getLayoutInfo().getLayoutInfo(g);
        this.fixedTabHeight = (int)layoutInfo.getFixedVisualHeight();
        this.onlyTabInsets = this.getTabInsets(AquaUIPainter.Position.ONLY);
        this.leftTabInsets = this.getTabInsets(AquaUIPainter.Position.FIRST);
        this.rightTabInsets = this.getTabInsets(AquaUIPainter.Position.LAST);
        this.middleTabInsets = this.getTabInsets(AquaUIPainter.Position.MIDDLE);
        int delta = this.onlyTabInsets.top + this.onlyTabInsets.bottom + 1;
        if (delta % 1 == 1) {
            ++delta;
        }
        this.maxIconSize = this.fixedTabHeight - delta;
    }

    protected Insets getTabInsets(AquaUIPainter.Position pos) {
        SegmentedButtonLayoutConfiguration g = new SegmentedButtonLayoutConfiguration(this.buttonWidget, this.sizeVariant, pos);
        Insetter s = this.painter.getLayoutInfo().getSegmentedButtonLabelInsets(g);
        Insets n = s.asInsets();
        if (n == null) {
            n = new Insets(3, 0, 3, 0);
        }
        AquaButtonExtendedTypes.WidgetInfo info = AquaButtonExtendedTypes.getTabWidgetInfo(this.sizeVariant, pos);
        int margin = info.getMargin();
        return new Insets(n.top, n.left + margin, n.bottom, n.right + margin);
    }

    @Override
    protected void assureRectsCreated(int tabCount) {
        this.visibleTabState.init(tabCount);
        super.assureRectsCreated(tabCount);
    }

    @Override
    protected void uninstallDefaults() {
        this.contentDrawingInsets.set(0, 0, 0, 0);
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new TabbedPanePropertyChangeHandler();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new AquaTruncatingTabbedPaneLayout();
    }

    protected boolean shouldRepaintSelectedTabOnMouseDown() {
        return false;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            AquaUtils.fillRect(g, c, 2);
        }
        this.paint(g, c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean isLeftToRight;
        int tabPlacement = this.tabPane.getTabPlacement();
        int selectedIndex = this.tabPane.getSelectedIndex();
        this.paintContentBorder(g, tabPlacement, selectedIndex);
        this.ensureCurrentLayout();
        Rectangle clipRect = g.getClipBounds();
        boolean active = this.tabPane.isEnabled();
        boolean frameActive = AquaFocusHandler.isActive(this.tabPane);
        boolean bl = isLeftToRight = (this.tabPane.getComponentOrientation().isLeftToRight() || tabPlacement == 2) && tabPlacement != 4;
        if (this.visibleTabState.needsScrollTabs()) {
            this.paintScrollingTabs(g, clipRect, tabPlacement, selectedIndex, active, frameActive, isLeftToRight);
            return;
        }
        this.paintAllTabs(g, clipRect, tabPlacement, selectedIndex, active, frameActive, isLeftToRight);
    }

    protected void paintAllTabs(Graphics g, Rectangle clipRect, int tabPlacement, int selectedIndex, boolean active, boolean frameActive, boolean isLeftToRight) {
        boolean drawSelectedLast = false;
        for (int i = 0; i < this.rects.length; ++i) {
            if (i == selectedIndex) {
                drawSelectedLast = true;
                continue;
            }
            if (!this.rects[i].intersects(clipRect)) continue;
            this.paintTabNormal(g, tabPlacement, i, active, frameActive, isLeftToRight);
        }
        if (drawSelectedLast && this.rects[selectedIndex].intersects(clipRect)) {
            this.paintTabNormal(g, tabPlacement, selectedIndex, active, frameActive, isLeftToRight);
        }
    }

    protected void paintScrollingTabs(Graphics g, Rectangle clipRect, int tabPlacement, int selectedIndex, boolean active, boolean frameActive, boolean isLeftToRight) {
        for (int i = 0; i < this.visibleTabState.getTotal(); ++i) {
            int realIndex = this.visibleTabState.getIndex(i);
            if (realIndex == selectedIndex || !this.rects[realIndex].intersects(clipRect)) continue;
            this.paintTabNormal(g, tabPlacement, realIndex, active, frameActive, isLeftToRight);
        }
        Rectangle leftScrollTabRect = this.visibleTabState.getLeftScrollTabRect();
        if (this.visibleTabState.needsLeftScrollTab() && leftScrollTabRect.intersects(clipRect)) {
            this.paintTabNormalFromRect(g, tabPlacement, leftScrollTabRect, -2, this.fIconRect, this.fTextRect, this.visibleTabState.needsLeftScrollTab(), frameActive, isLeftToRight);
        }
        Rectangle rightScrollTabRect = this.visibleTabState.getRightScrollTabRect();
        if (this.visibleTabState.needsRightScrollTab() && rightScrollTabRect.intersects(clipRect)) {
            this.paintTabNormalFromRect(g, tabPlacement, rightScrollTabRect, -1, this.fIconRect, this.fTextRect, this.visibleTabState.needsRightScrollTab(), frameActive, isLeftToRight);
        }
        if (selectedIndex >= 0) {
            this.paintTabNormal(g, tabPlacement, selectedIndex, active, frameActive, isLeftToRight);
        }
    }

    private static boolean isScrollTabIndex(int index) {
        return index == -1 || index == -2;
    }

    protected static void transposeRect(Rectangle r) {
        int temp = r.y;
        temp = r.width;
        r.width = r.height;
        r.height = temp;
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = tabIndex >= 0 ? this.rects[tabIndex] : this.visibleTabState.getRightScrollTabRect();
        int nudge = 0;
        return nudge;
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    protected Icon getIconForScrollTab(int tabPlacement, int tabIndex, boolean enabled) {
        int direction;
        boolean shouldFlip;
        boolean bl = shouldFlip = !AquaUtils.isLeftToRight(this.tabPane);
        if (tabPlacement == 4) {
            shouldFlip = false;
        }
        if (tabPlacement == 2) {
            shouldFlip = true;
        }
        int n = direction = tabIndex == -1 ? 3 : 7;
        if (shouldFlip) {
            if (direction == 3) {
                direction = 7;
            } else if (direction == 7) {
                direction = 3;
            }
        }
        Image image = AquaImageFactory.getArrowImageForDirection(direction);
        assert (image != null);
        if (!enabled) {
            image = AquaImageFactory.generateDisabledLightImage(image);
        }
        if (this.sizeVariant == AquaUIPainter.Size.MINI) {
            int w = (int)((double)image.getWidth(null) * 0.8);
            int h = (int)((double)image.getHeight(null) * 0.8);
            image = image.getScaledInstance(w, h, 4);
        }
        return new ImageIcon(image);
    }

    protected void paintTabNormal(Graphics g, int tabPlacement, int tabIndex, boolean active, boolean frameActive, boolean isLeftToRight) {
        this.paintTabNormalFromRect(g, tabPlacement, this.rects[tabIndex], tabIndex, this.fIconRect, this.fTextRect, active, frameActive, isLeftToRight);
    }

    protected void paintTabNormalFromRect(Graphics g, int tabPlacement, Rectangle tabRect, int nonRectIndex, Rectangle iconRect, Rectangle textRect, boolean active, boolean frameActive, boolean isLeftToRight) {
        boolean isVertical;
        int selectedIndex = this.tabPane.getSelectedIndex();
        boolean isSelected = selectedIndex == nonRectIndex;
        AquaUIPainter.Direction direction = this.getDirection();
        boolean bl = isVertical = direction == AquaUIPainter.Direction.LEFT || direction == AquaUIPainter.Direction.RIGHT;
        if (isVertical) {
            Graphics2D gg = AquaUtils.toGraphics2D(g);
            if (gg == null) {
                return;
            }
            gg = (Graphics2D)gg.create();
            if (tabPlacement == 2) {
                gg.translate(0, tabRect.height);
            } else {
                gg.translate(tabRect.width, 0);
            }
            double rotateAmount = tabPlacement == 2 ? -1.5707963267948966 : 1.5707963267948966;
            gg.transform(AffineTransform.getRotateInstance(rotateAmount, tabRect.x, tabRect.y));
            AquaTabbedPaneUI.transposeRect(this.fContentRect);
            AquaTabbedPaneUI.transposeRect(tabRect);
            g = gg;
        }
        this.paintTabBackground(g, tabPlacement, tabRect, isSelected, frameActive, isLeftToRight, nonRectIndex);
        Insets labelInsets = this.getTabInsets(tabPlacement, nonRectIndex);
        this.fContentRect.setBounds(tabRect.x + labelInsets.left, tabRect.y + labelInsets.top, tabRect.width - labelInsets.left - labelInsets.right, tabRect.height - labelInsets.top - labelInsets.bottom);
        this.paintContents(g, tabPlacement, nonRectIndex, tabRect, iconRect, textRect, isSelected, frameActive);
        if (isVertical) {
            g.dispose();
            AquaTabbedPaneUI.transposeRect(tabRect);
        }
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, Rectangle tabRect, boolean isSelected, boolean frameActive, boolean isLeftToRight, int nonRectIndex) {
        this.painter.configure(tabRect.width, tabRect.height);
        SegmentedButtonConfiguration bg = this.getConfiguration(isSelected, frameActive, isLeftToRight, nonRectIndex);
        Painter p = this.painter.getPainter(bg);
        p.paint(g, tabRect.x, tabRect.y);
    }

    protected SegmentedButtonConfiguration getConfiguration(boolean isSelected, boolean frameActive, boolean isLeftToRight, int nonRectIndex) {
        AquaUIPainter.Direction direction;
        boolean last;
        int tabCount = this.tabPane.getTabCount();
        boolean needsLeftScrollTab = this.visibleTabState.needsLeftScrollTab();
        boolean needsRightScrollTab = this.visibleTabState.needsRightScrollTab();
        boolean first = nonRectIndex == 0;
        boolean bl = last = nonRectIndex == tabCount - 1;
        if (needsLeftScrollTab || needsRightScrollTab) {
            if (nonRectIndex == -1) {
                first = false;
                last = true;
            } else if (nonRectIndex == -2) {
                first = true;
                last = false;
            } else {
                if (needsLeftScrollTab) {
                    first = false;
                }
                if (needsRightScrollTab) {
                    last = false;
                }
            }
        }
        if ((direction = this.getDirection()) == AquaUIPainter.Direction.LEFT || direction == AquaUIPainter.Direction.RIGHT) {
            boolean tempSwap = last;
            last = first;
            first = tempSwap;
        }
        AquaUIPainter.State state = this.getState(nonRectIndex, frameActive, isSelected);
        boolean showSelected = isSelected || state == AquaUIPainter.State.INACTIVE && frameActive;
        boolean showLeftNeighborSelected = false;
        boolean showRightNeighborSelected = false;
        AquaUIPainter.Position segmentPosition = AquaTabbedPaneUI.getSegmentPosition(first, last, isLeftToRight);
        int selectedIndex = this.tabPane.getSelectedIndex();
        boolean segmentTrailingSeparator = this.getSegmentTrailingSeparator(nonRectIndex, selectedIndex, isLeftToRight);
        boolean segmentLeadingSeparator = this.getSegmentLeadingSeparator(nonRectIndex, selectedIndex, isLeftToRight);
        boolean isFocused = this.tabPane.hasFocus() && isSelected;
        SegmentedButtonConfiguration.DividerState leftState = AquaSegmentedButtonBorder.getDividerState(segmentLeadingSeparator, showLeftNeighborSelected);
        SegmentedButtonConfiguration.DividerState rightState = AquaSegmentedButtonBorder.getDividerState(segmentTrailingSeparator, showRightNeighborSelected);
        return new SegmentedButtonConfiguration(this.buttonWidget, this.sizeVariant, state, showSelected, isFocused, AquaUIPainter.Direction.UP, segmentPosition, leftState, rightState);
    }

    protected void paintContents(Graphics g, int tabPlacement, int tabIndex, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected, boolean frameActive) {
        Icon icon;
        String title;
        if (AquaTabbedPaneUI.isScrollTabIndex(tabIndex)) {
            title = null;
            icon = this.getIconForScrollTab(tabPlacement, tabIndex, this.tabPane.isEnabled());
        } else {
            Component component = this.getTabComponentAt(tabIndex);
            if (component != null) {
                return;
            }
            title = this.tabPane.getTitleAt(tabIndex);
            icon = this.getIconForTab(tabIndex);
        }
        Shape temp = g.getClip();
        g.clipRect(this.fContentRect.x, this.fContentRect.y, this.fContentRect.width, this.fContentRect.height);
        Font font = this.tabPane.getFont();
        FontMetrics metrics = g.getFontMetrics(font);
        this.layoutLabel(tabPlacement, metrics, tabIndex < 0 ? 0 : tabIndex, title, icon, this.fContentRect, iconRect, textRect, false);
        if (!(g instanceof Graphics2D)) {
            g.setClip(temp);
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        if (tabIndex >= 0) {
            this.paintTitle(g2d, font, metrics, textRect, tabIndex, title, frameActive);
        }
        if (icon != null) {
            this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        }
        g.setClip(temp);
    }

    protected void paintTitle(Graphics2D g2d, Font font, FontMetrics metrics, Rectangle textRect, int tabIndex, String title, boolean frameActive) {
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g2d, textRect);
            return;
        }
        if (title == null) {
            return;
        }
        Color color = this.tabPane.getForegroundAt(tabIndex);
        if (color instanceof UIResource) {
            g2d.setColor(this.getTabTextColor(tabIndex, frameActive));
        } else {
            g2d.setColor(color);
        }
        g2d.setFont(font);
        AquaUtils.drawString(this.tabPane, g2d, title, textRect.x, textRect.y + metrics.getAscent());
    }

    protected Color getTabTextColor(int tabIndex, boolean frameActive) {
        String base = !this.tabPane.isEnabledAt(tabIndex) ? "Disabled" : (!frameActive ? "Inactive" : (this.isPressedAt(tabIndex) ? "Pressed" : "Normal"));
        String prefix = this.tabPane.getSelectedIndex() == tabIndex ? "selected" : "nonSelected";
        String property = "TabbedPane." + prefix + "TabTitle" + base + "Color";
        return UIManager.getColor(property);
    }

    protected boolean isPressedAt(int index) {
        return false;
    }

    protected AquaUIPainter.Direction getDirection() {
        switch (this.tabPane.getTabPlacement()) {
            case 3: {
                return AquaUIPainter.Direction.DOWN;
            }
            case 2: {
                return AquaUIPainter.Direction.LEFT;
            }
            case 4: {
                return AquaUIPainter.Direction.RIGHT;
            }
        }
        return AquaUIPainter.Direction.UP;
    }

    protected static AquaUIPainter.Position getSegmentPosition(boolean first, boolean last, boolean isLeftToRight) {
        if (first && last) {
            return AquaUIPainter.Position.ONLY;
        }
        if (first) {
            return isLeftToRight ? AquaUIPainter.Position.FIRST : AquaUIPainter.Position.LAST;
        }
        if (last) {
            return isLeftToRight ? AquaUIPainter.Position.LAST : AquaUIPainter.Position.FIRST;
        }
        return AquaUIPainter.Position.MIDDLE;
    }

    protected boolean getSegmentTrailingSeparator(int index, int selectedIndex, boolean isLeftToRight) {
        return true;
    }

    protected boolean getSegmentLeadingSeparator(int index, int selectedIndex, boolean isLeftToRight) {
        return false;
    }

    protected boolean isTabBeforeSelectedTab(int index, int selectedIndex, boolean isLeftToRight) {
        if (index == -2 && this.visibleTabState.getIndex(0) == selectedIndex) {
            return true;
        }
        int indexBeforeSelectedIndex = isLeftToRight ? selectedIndex - 1 : selectedIndex + 1;
        return index == indexBeforeSelectedIndex;
    }

    protected AquaUIPainter.State getState(int index, boolean frameActive, boolean isSelected) {
        if (!frameActive) {
            return AquaUIPainter.State.INACTIVE;
        }
        if (!this.tabPane.isEnabled()) {
            return AquaUIPainter.State.DISABLED;
        }
        if (isSelected) {
            return AquaUIPainter.State.ACTIVE;
        }
        if (this.pressedTab == index) {
            return AquaUIPainter.State.PRESSED;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        Insets draw = this.getContentDrawingInsets(tabPlacement);
        AquaTabbedPaneUI.rotateInsets(this.contentBorderInsets, this.currentContentBorderInsets, tabPlacement);
        this.currentContentBorderInsets.left += draw.left;
        this.currentContentBorderInsets.right += draw.right;
        this.currentContentBorderInsets.top += draw.top;
        this.currentContentBorderInsets.bottom += draw.bottom;
        return this.currentContentBorderInsets;
    }

    protected static void rotateInsets(Insets topInsets, Insets targetInsets, int targetPlacement) {
        switch (targetPlacement) {
            case 2: {
                targetInsets.top = topInsets.right;
                targetInsets.left = topInsets.top;
                targetInsets.bottom = topInsets.left;
                targetInsets.right = topInsets.bottom;
                break;
            }
            case 3: {
                targetInsets.top = topInsets.bottom;
                targetInsets.left = topInsets.left;
                targetInsets.bottom = topInsets.top;
                targetInsets.right = topInsets.right;
                break;
            }
            case 4: {
                targetInsets.top = topInsets.left;
                targetInsets.left = topInsets.bottom;
                targetInsets.bottom = topInsets.right;
                targetInsets.right = topInsets.top;
                break;
            }
            default: {
                targetInsets.top = topInsets.top;
                targetInsets.left = topInsets.left;
                targetInsets.bottom = topInsets.bottom;
                targetInsets.right = topInsets.right;
            }
        }
    }

    protected Insets getContentDrawingInsets(int tabPlacement) {
        AquaTabbedPaneUI.rotateInsets(this.contentDrawingInsets, this.currentContentDrawingInsets, tabPlacement);
        return this.currentContentDrawingInsets;
    }

    @Override
    protected Icon getIconForTab(int tabIndex) {
        final Icon mainIcon = super.getIconForTab(tabIndex);
        if (mainIcon == null) {
            return null;
        }
        int iconHeight = mainIcon.getIconHeight();
        if (iconHeight <= this.maxIconSize) {
            return mainIcon;
        }
        float ratio = (float)this.maxIconSize / (float)iconHeight;
        int iconWidth = mainIcon.getIconWidth();
        return new AquaIcon.CachingScalingIcon((int)((float)iconWidth * ratio), this.maxIconSize){

            @Override
            Image createImage() {
                return AquaIcon.getImageForIcon(mainIcon);
            }
        };
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        int tabBorderInset = this.fixedTabHeight / 2;
        tabBorderInset -= 5;
        switch (tabPlacement) {
            case 1: {
                y += tabBorderInset;
                h -= tabBorderInset;
                break;
            }
            case 3: {
                h -= tabBorderInset;
                break;
            }
            case 2: {
                x += tabBorderInset;
                w -= tabBorderInset;
                break;
            }
            case 4: {
                w -= tabBorderInset;
            }
        }
        if (this.tabPane.isOpaque()) {
            g.setColor(this.tabPane.getBackground());
            g.fillRect(0, 0, width, height);
        }
        AquaGroupBorder.getTabbedPaneGroupBorder().paintBorder(this.tabPane, g, x, y, w, h);
    }

    protected void repaintContentBorderEdge() {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int tabPlacement = this.tabPane.getTabPlacement();
        Insets localContentBorderInsets = this.getContentBorderInsets(tabPlacement);
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                w = localContentBorderInsets.left;
                break;
            }
            case 4: {
                w = localContentBorderInsets.right;
                break;
            }
            case 3: {
                h = localContentBorderInsets.bottom;
                break;
            }
            default: {
                y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                h = localContentBorderInsets.top;
            }
        }
        this.tabPane.repaint(x, y, w, h);
    }

    public boolean isTabVisible(int index) {
        if (index == -1 || index == -2) {
            return true;
        }
        for (int i = 0; i < this.visibleTabState.getTotal(); ++i) {
            if (this.visibleTabState.getIndex(i) != index) continue;
            return true;
        }
        return false;
    }

    protected SegmentedButtonLayoutConfiguration getTabLayoutConfiguration(int tabIndex) {
        int tabCount = this.tabPane.getTabCount();
        boolean isLeftToRight = this.tabPane.getComponentOrientation().isLeftToRight();
        AquaUIPainter.Position position = tabCount < 2 ? AquaUIPainter.Position.ONLY : (tabIndex == 0 ? (isLeftToRight ? AquaUIPainter.Position.FIRST : AquaUIPainter.Position.LAST) : (tabIndex == tabCount - 1 ? (isLeftToRight ? AquaUIPainter.Position.LAST : AquaUIPainter.Position.FIRST) : AquaUIPainter.Position.MIDDLE));
        return new SegmentedButtonLayoutConfiguration(this.buttonWidget, this.sizeVariant, position);
    }

    @Override
    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        int tabCount = this.tabPane.getTabCount();
        boolean isLeftToRight = this.tabPane.getComponentOrientation().isLeftToRight();
        AquaUIPainter.Position position = tabCount < 2 ? AquaUIPainter.Position.ONLY : (tabIndex == 0 ? (isLeftToRight ? AquaUIPainter.Position.FIRST : AquaUIPainter.Position.LAST) : (tabIndex == tabCount - 1 ? (isLeftToRight ? AquaUIPainter.Position.LAST : AquaUIPainter.Position.FIRST) : AquaUIPainter.Position.MIDDLE));
        switch (position) {
            case ONLY: {
                return this.onlyTabInsets;
            }
            case FIRST: {
                return this.leftTabInsets;
            }
            case LAST: {
                return this.rightTabInsets;
            }
            case MIDDLE: {
                return this.middleTabInsets;
            }
        }
        return new Insets(3, 10, 3, 10);
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        if (this.visibleTabState.needsScrollTabs() && (this.visibleTabState.isBefore(i) || this.visibleTabState.isAfter(i))) {
            return null;
        }
        return super.getTabBounds(pane, i);
    }

    @Override
    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        this.ensureCurrentLayout();
        Point p = new Point(x, y);
        if (this.visibleTabState.needsScrollTabs()) {
            for (int i = 0; i < this.visibleTabState.getTotal(); ++i) {
                int realOffset = this.visibleTabState.getIndex(i);
                if (!this.rects[realOffset].contains(p.x, p.y)) continue;
                return realOffset;
            }
            if (this.visibleTabState.getRightScrollTabRect().contains(p.x, p.y)) {
                return -1;
            }
        } else {
            int tabCount = this.tabPane.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                if (!this.rects[i].contains(p.x, p.y)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        return this.fixedTabHeight;
    }

    @Override
    protected boolean shouldRotateTabRuns(int tabPlacement) {
        return false;
    }

    @Override
    protected ChangeListener createChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!AquaTabbedPaneUI.this.isTabVisible(AquaTabbedPaneUI.this.tabPane.getSelectedIndex())) {
                    AquaTabbedPaneUI.this.popupSelectionChanged = true;
                }
                AquaTabbedPaneUI.this.tabPane.revalidate();
                AquaTabbedPaneUI.this.tabPane.repaint();
            }
        };
    }

    protected class AquaTruncatingTabbedPaneLayout
    extends AquaTabbedPaneCopyFromBasicUI.TabbedPaneLayout {
        protected AquaTruncatingTabbedPaneLayout() {
        }

        @Override
        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            if (tabPlacement == 2 || tabPlacement == 4) {
                return super.preferredTabAreaHeight(tabPlacement, height);
            }
            return super.preferredTabAreaWidth(tabPlacement, height);
        }

        @Override
        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            if (tabPlacement == 2 || tabPlacement == 4) {
                return super.preferredTabAreaWidth(tabPlacement, width);
            }
            return super.preferredTabAreaHeight(tabPlacement, width);
        }

        @Override
        protected void calculateTabRects(int tabPlacement, int tabCount) {
            if (tabCount <= 0) {
                return;
            }
            this.superCalculateTabRects(tabPlacement, tabCount);
            if (AquaTabbedPaneUI.this.rects.length <= 0) {
                return;
            }
            AquaTabbedPaneUI.this.visibleTabState.alignRectsRunFor(AquaTabbedPaneUI.this.rects, AquaTabbedPaneUI.this.tabPane.getSize(), tabPlacement, AquaUtils.isLeftToRight(AquaTabbedPaneUI.this.tabPane));
        }

        @Override
        protected void padTabRun(int tabPlacement, int start, int end, int max) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                super.padTabRun(tabPlacement, start, end, max);
                return;
            }
            Rectangle lastRect = AquaTabbedPaneUI.this.rects[end];
            int runHeight = lastRect.y + lastRect.height - AquaTabbedPaneUI.this.rects[start].y;
            int deltaHeight = max - (lastRect.y + lastRect.height);
            float factor = (float)deltaHeight / (float)runHeight;
            for (int i = start; i <= end; ++i) {
                Rectangle pastRect = AquaTabbedPaneUI.this.rects[i];
                if (i > start) {
                    pastRect.y = AquaTabbedPaneUI.this.rects[i - 1].y + AquaTabbedPaneUI.this.rects[i - 1].height;
                }
                pastRect.height += Math.round((float)pastRect.height * factor);
            }
            lastRect.height = max - lastRect.y;
        }

        protected synchronized void superCalculateTabRects(int tabPlacement, int tabCount) {
            int returnAt;
            int y;
            int x;
            Dimension size = AquaTabbedPaneUI.this.tabPane.getSize();
            Insets insets = AquaTabbedPaneUI.this.tabPane.getInsets();
            Insets localTabAreaInsets = AquaTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            switch (tabPlacement) {
                case 2: {
                    AquaTabbedPaneUI.this.maxTabWidth = AquaTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + localTabAreaInsets.left;
                    y = insets.top + localTabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + localTabAreaInsets.bottom);
                    break;
                }
                case 4: {
                    AquaTabbedPaneUI.this.maxTabWidth = AquaTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = size.width - insets.right - localTabAreaInsets.right - AquaTabbedPaneUI.this.maxTabWidth - 1;
                    y = insets.top + localTabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + localTabAreaInsets.bottom);
                    break;
                }
                case 3: {
                    AquaTabbedPaneUI.this.maxTabHeight = AquaTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + localTabAreaInsets.left;
                    y = size.height - insets.bottom - localTabAreaInsets.bottom - AquaTabbedPaneUI.this.maxTabHeight;
                    returnAt = size.width - (insets.right + localTabAreaInsets.right);
                    break;
                }
                default: {
                    AquaTabbedPaneUI.this.maxTabHeight = AquaTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + localTabAreaInsets.left;
                    y = insets.top + localTabAreaInsets.top;
                    returnAt = size.width - (insets.right + localTabAreaInsets.right);
                }
            }
            AquaTabbedPaneUI.this.tabRunOverlay = AquaTabbedPaneUI.this.getTabRunOverlay(tabPlacement);
            AquaTabbedPaneUI.this.runCount = 0;
            AquaTabbedPaneUI.this.selectedRun = 0;
            if (tabCount == 0) {
                return;
            }
            FontMetrics metrics = AquaTabbedPaneUI.this.getFontMetrics();
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            int selectedIndex = AquaTabbedPaneUI.this.tabPane.getSelectedIndex();
            AquaTabbedPaneUI.this.visibleTabState.setNeedsScrollers(false);
            for (int i = 0; i < tabCount; ++i) {
                Rectangle rect = AquaTabbedPaneUI.this.rects[i];
                if (verticalTabRuns) {
                    this.calculateVerticalTabRunRect(rect, metrics, tabPlacement, returnAt, i, x, y);
                    if (rect.y + rect.height <= returnAt) continue;
                    AquaTabbedPaneUI.this.visibleTabState.setNeedsScrollers(true);
                    continue;
                }
                this.calculateHorizontalTabRunRect(rect, metrics, tabPlacement, returnAt, i, x, y);
                if (rect.x + rect.width <= returnAt) continue;
                AquaTabbedPaneUI.this.visibleTabState.setNeedsScrollers(true);
            }
            AquaTabbedPaneUI.this.visibleTabState.relayoutForScrolling(AquaTabbedPaneUI.this.rects, x, y, returnAt, selectedIndex, verticalTabRuns, tabCount, AquaUtils.isLeftToRight(AquaTabbedPaneUI.this.tabPane));
            if (!AquaUtils.isLeftToRight(AquaTabbedPaneUI.this.tabPane) && !verticalTabRuns) {
                int rightMargin = size.width - (insets.right + localTabAreaInsets.right);
                for (int i = 0; i < tabCount; ++i) {
                    AquaTabbedPaneUI.this.rects[i].x = rightMargin - AquaTabbedPaneUI.this.rects[i].x - AquaTabbedPaneUI.this.rects[i].width;
                }
            }
        }

        private void calculateHorizontalTabRunRect(Rectangle rect, FontMetrics metrics, int tabPlacement, int returnAt, int i, int x, int y) {
            if (i > 0) {
                rect.x = AquaTabbedPaneUI.this.rects[i - 1].x + AquaTabbedPaneUI.this.rects[i - 1].width;
            } else {
                AquaTabbedPaneUI.this.tabRuns[0] = 0;
                AquaTabbedPaneUI.this.runCount = 1;
                AquaTabbedPaneUI.this.maxTabWidth = 0;
                rect.x = x;
            }
            rect.width = AquaTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
            AquaTabbedPaneUI.this.maxTabWidth = Math.max(AquaTabbedPaneUI.this.maxTabWidth, rect.width);
            rect.y = y;
            rect.height = AquaTabbedPaneUI.this.maxTabHeight;
        }

        private void calculateVerticalTabRunRect(Rectangle rect, FontMetrics metrics, int tabPlacement, int returnAt, int i, int x, int y) {
            if (i > 0) {
                rect.y = AquaTabbedPaneUI.this.rects[i - 1].y + AquaTabbedPaneUI.this.rects[i - 1].height;
            } else {
                AquaTabbedPaneUI.this.tabRuns[0] = 0;
                AquaTabbedPaneUI.this.runCount = 1;
                AquaTabbedPaneUI.this.maxTabHeight = 0;
                rect.y = y;
            }
            rect.height = AquaTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
            AquaTabbedPaneUI.this.maxTabHeight = Math.max(AquaTabbedPaneUI.this.maxTabHeight, rect.height);
            rect.x = x;
            rect.width = AquaTabbedPaneUI.this.maxTabWidth;
        }

        @Override
        protected void layoutTabComponents() {
            Container tabContainer = this.getTabContainer();
            if (tabContainer == null) {
                return;
            }
            int placement = AquaTabbedPaneUI.this.tabPane.getTabPlacement();
            Rectangle rect = new Rectangle();
            Point delta = new Point(-tabContainer.getX(), -tabContainer.getY());
            for (int i = 0; i < AquaTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                boolean isSelected;
                Component c = AquaTabbedPaneUI.this.getTabComponentAt(i);
                if (c == null) continue;
                AquaTabbedPaneUI.this.getTabBounds(i, rect);
                Insets insets = AquaTabbedPaneUI.this.getTabInsets(AquaTabbedPaneUI.this.tabPane.getTabPlacement(), i);
                boolean bl = isSelected = i == AquaTabbedPaneUI.this.tabPane.getSelectedIndex();
                if (placement == 1 || placement == 3) {
                    rect.x += insets.left + delta.x + AquaTabbedPaneUI.this.getTabLabelShiftX(placement, i, isSelected);
                    rect.y += insets.top + delta.y + AquaTabbedPaneUI.this.getTabLabelShiftY(placement, i, isSelected);
                    rect.width -= insets.left + insets.right;
                    rect.height -= insets.top + insets.bottom - 1;
                } else {
                    rect.x += insets.top + delta.x + AquaTabbedPaneUI.this.getTabLabelShiftY(placement, i, isSelected);
                    rect.y += insets.left + delta.y + AquaTabbedPaneUI.this.getTabLabelShiftX(placement, i, isSelected);
                    rect.width -= insets.top + insets.bottom - 1;
                    rect.height -= insets.left + insets.right;
                }
                c.setBounds(rect);
            }
        }
    }

    public class MouseHandler
    extends MouseInputAdapter
    implements ActionListener {
        protected int trackingTab = -3;
        protected Timer popupTimer = new Timer(500, this);

        public MouseHandler() {
            this.popupTimer.setRepeats(false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            if (!pane.isEnabled()) {
                this.trackingTab = -3;
                return;
            }
            Point p = e.getPoint();
            this.trackingTab = this.getCurrentTab(pane, p);
            if (this.trackingTab == -3 || !AquaTabbedPaneUI.this.shouldRepaintSelectedTabOnMouseDown() && this.trackingTab == pane.getSelectedIndex()) {
                this.trackingTab = -3;
                return;
            }
            if (this.trackingTab < 0 && this.trackingTab > -3) {
                this.popupTimer.start();
            }
            AquaTabbedPaneUI.this.pressedTab = this.trackingTab;
            this.repaint(pane, AquaTabbedPaneUI.this.pressedTab);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.trackingTab < -2) {
                return;
            }
            JTabbedPane pane = (JTabbedPane)e.getSource();
            int currentTab = this.getCurrentTab(pane, e.getPoint());
            AquaTabbedPaneUI.this.pressedTab = currentTab != this.trackingTab ? -3 : this.trackingTab;
            if (this.trackingTab < 0 && this.trackingTab > -3) {
                this.popupTimer.start();
            }
            this.repaint(pane, this.trackingTab);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.trackingTab < -2) {
                return;
            }
            this.popupTimer.stop();
            JTabbedPane pane = (JTabbedPane)e.getSource();
            Point p = e.getPoint();
            int currentTab = this.getCurrentTab(pane, p);
            if (this.trackingTab == -1 && currentTab == -1) {
                pane.setSelectedIndex(pane.getSelectedIndex() + 1);
            }
            if (this.trackingTab == -2 && currentTab == -2) {
                pane.setSelectedIndex(pane.getSelectedIndex() - 1);
            }
            if (this.trackingTab >= 0 && currentTab == this.trackingTab) {
                pane.setSelectedIndex(this.trackingTab);
            }
            this.repaint(pane, this.trackingTab);
            AquaTabbedPaneUI.this.pressedTab = -3;
            this.trackingTab = -3;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.trackingTab != AquaTabbedPaneUI.this.pressedTab) {
                return;
            }
            if (this.trackingTab == -1) {
                this.showFullPopup(false);
                this.trackingTab = -3;
            }
            if (this.trackingTab == -2) {
                this.showFullPopup(true);
                this.trackingTab = -3;
            }
        }

        int getCurrentTab(JTabbedPane pane, Point p) {
            int tabIndex = AquaTabbedPaneUI.this.tabForCoordinate(pane, p.x, p.y);
            if (tabIndex >= 0 && pane.isEnabledAt(tabIndex)) {
                return tabIndex;
            }
            if (AquaTabbedPaneUI.this.visibleTabState.needsLeftScrollTab() && AquaTabbedPaneUI.this.visibleTabState.getLeftScrollTabRect().contains(p)) {
                return -2;
            }
            if (AquaTabbedPaneUI.this.visibleTabState.needsRightScrollTab() && AquaTabbedPaneUI.this.visibleTabState.getRightScrollTabRect().contains(p)) {
                return -1;
            }
            return -3;
        }

        void repaint(JTabbedPane pane, int tab) {
            switch (tab) {
                case -1: {
                    pane.repaint(AquaTabbedPaneUI.this.visibleTabState.getRightScrollTabRect());
                    return;
                }
                case -2: {
                    pane.repaint(AquaTabbedPaneUI.this.visibleTabState.getLeftScrollTabRect());
                    return;
                }
            }
            if (this.trackingTab >= 0) {
                pane.repaint(AquaTabbedPaneUI.this.rects[this.trackingTab]);
            }
        }

        void showFullPopup(boolean firstTab) {
            JPopupMenu popup = new JPopupMenu();
            for (int i = 0; i < AquaTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                if (!(firstTab ? AquaTabbedPaneUI.this.visibleTabState.isBefore(i) : AquaTabbedPaneUI.this.visibleTabState.isAfter(i))) continue;
                popup.add(this.createMenuItem(i));
            }
            if (firstTab) {
                Rectangle leftScrollTabRect = AquaTabbedPaneUI.this.visibleTabState.getLeftScrollTabRect();
                Dimension popupRect = popup.getPreferredSize();
                popup.show(AquaTabbedPaneUI.this.tabPane, leftScrollTabRect.x - popupRect.width, leftScrollTabRect.y + 7);
            } else {
                Rectangle rightScrollTabRect = AquaTabbedPaneUI.this.visibleTabState.getRightScrollTabRect();
                popup.show(AquaTabbedPaneUI.this.tabPane, rightScrollTabRect.x + rightScrollTabRect.width, rightScrollTabRect.y + 7);
            }
            popup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    AquaTabbedPaneUI.this.pressedTab = -3;
                    AquaTabbedPaneUI.this.tabPane.repaint(AquaTabbedPaneUI.this.visibleTabState.getLeftScrollTabRect());
                    AquaTabbedPaneUI.this.tabPane.repaint(AquaTabbedPaneUI.this.visibleTabState.getRightScrollTabRect());
                }
            });
        }

        JMenuItem createMenuItem(int i) {
            JMenuItem tmp;
            final Component component = AquaTabbedPaneUI.this.getTabComponentAt(i);
            JMenuItem menuItem = component == null ? new JMenuItem(AquaTabbedPaneUI.this.tabPane.getTitleAt(i), AquaTabbedPaneUI.this.tabPane.getIconAt(i)) : (tmp = new JMenuItem(){

                @Override
                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    Dimension size = component.getSize();
                    component.setSize(this.getSize());
                    component.validate();
                    component.paint(g);
                    component.setSize(size);
                }

                @Override
                public Dimension getPreferredSize() {
                    return component.getPreferredSize();
                }
            });
            Color background = AquaTabbedPaneUI.this.tabPane.getBackgroundAt(i);
            if (!(background instanceof UIResource)) {
                menuItem.setBackground(background);
            }
            menuItem.setForeground(AquaTabbedPaneUI.this.tabPane.getForegroundAt(i));
            if (!AquaTabbedPaneUI.this.tabPane.isEnabledAt(i)) {
                menuItem.setEnabled(false);
            }
            final int fOffset = i;
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    boolean visible = AquaTabbedPaneUI.this.isTabVisible(fOffset);
                    AquaTabbedPaneUI.this.tabPane.setSelectedIndex(fOffset);
                    if (!visible) {
                        AquaTabbedPaneUI.this.popupSelectionChanged = true;
                        AquaTabbedPaneUI.this.tabPane.invalidate();
                        AquaTabbedPaneUI.this.tabPane.repaint();
                    }
                }
            });
            return menuItem;
        }
    }

    protected class FocusHandler
    extends FocusAdapter {
        Rectangle sWorkingRect = new Rectangle();

        protected FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (this.isDefaultFocusReceiver(AquaTabbedPaneUI.this.tabPane) && !AquaTabbedPaneUI.this.hasAvoidedFirstFocus) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                AquaTabbedPaneUI.this.hasAvoidedFirstFocus = true;
            }
            this.adjustPaintingRectForFocusRing(e);
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.adjustPaintingRectForFocusRing(e);
        }

        void adjustPaintingRectForFocusRing(FocusEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            int tabCount = pane.getTabCount();
            int selectedIndex = pane.getSelectedIndex();
            if (selectedIndex != -1 && tabCount > 0 && tabCount == AquaTabbedPaneUI.this.rects.length) {
                this.sWorkingRect.setBounds(AquaTabbedPaneUI.this.rects[selectedIndex]);
                this.sWorkingRect.grow(4, 4);
                pane.repaint(this.sWorkingRect);
            }
        }

        boolean isDefaultFocusReceiver(JComponent component) {
            if (AquaTabbedPaneUI.this.isDefaultFocusReceiver == null) {
                Component defaultFocusReceiver = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy().getDefaultComponent(this.getTopLevelFocusCycleRootAncestor(component));
                AquaTabbedPaneUI.this.isDefaultFocusReceiver = new Boolean(defaultFocusReceiver != null && defaultFocusReceiver.equals(component));
            }
            return AquaTabbedPaneUI.this.isDefaultFocusReceiver;
        }

        Container getTopLevelFocusCycleRootAncestor(Container container) {
            Container ancestor;
            while ((ancestor = container.getFocusCycleRootAncestor()) != null) {
                container = ancestor;
            }
            return container;
        }
    }

    protected class TabbedPanePropertyChangeHandler
    extends AquaTabbedPaneCopyFromBasicUI.PropertyChangeHandler {
        protected TabbedPanePropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            JTabbedPane comp = (JTabbedPane)e.getSource();
            if ("componentOrientation".equals(prop)) {
                comp.revalidate();
                comp.repaint();
                super.propertyChange(e);
                return;
            }
            if (!"Frame.active".equals(prop)) {
                super.propertyChange(e);
                return;
            }
            comp.repaint();
            int selected = AquaTabbedPaneUI.this.tabPane.getSelectedIndex();
            Rectangle[] theRects = AquaTabbedPaneUI.this.rects;
            if (selected >= 0 && selected < theRects.length) {
                comp.repaint(theRects[selected]);
            }
            AquaTabbedPaneUI.this.repaintContentBorderEdge();
        }
    }
}

