/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.border.AbstractBorder;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderLayoutConfiguration;

public class AquaTableHeaderBorder
extends AbstractBorder {
    private Insets editorInsetsLTR;
    private Insets editorInsetsRTL;
    private Insetter arrowInsetsLTR;
    private Insetter arrowInsetsRTL;
    protected final AquaUIPainter painter = AquaPainting.create();
    protected AquaUIPainter.ColumnSortArrowDirection sortArrowDirection = AquaUIPainter.ColumnSortArrowDirection.NONE;
    protected JTable owner;

    protected static AquaTableHeaderBorder getListHeaderBorder() {
        return new AquaTableHeaderBorder();
    }

    protected AquaTableHeaderBorder() {
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        JComponent jc = (JComponent)c;
        this.painter.configure(width + 1, height);
        Configuration tg = this.getConfiguration(jc);
        this.painter.getPainter(tg).paint(g, x - 1, y);
    }

    protected Configuration getConfiguration(JComponent jc) {
        AquaUIPainter.State state = this.getState(jc);
        boolean isFocused = jc.hasFocus();
        AquaUIPainter.UILayoutDirection ld = AquaUtils.getLayoutDirection(this.owner);
        return new TableColumnHeaderConfiguration(state, this.sortArrowDirection, false, isFocused, ld);
    }

    protected AquaUIPainter.State getState(JComponent jc) {
        if (!jc.isEnabled()) {
            return AquaUIPainter.State.DISABLED;
        }
        JRootPane rootPane = jc.getRootPane();
        if (rootPane == null) {
            return AquaUIPainter.State.ACTIVE;
        }
        if (!AquaFocusHandler.isActive(rootPane)) {
            return AquaUIPainter.State.INACTIVE;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        this.configureInsets();
        return AquaUtils.isLeftToRight(this.owner) ? this.editorInsetsLTR : this.editorInsetsRTL;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        Insets s = this.getBorderInsets(c);
        insets.left = s.left;
        insets.top = s.top;
        insets.right = s.right;
        insets.bottom = s.bottom;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public void setSortArrowDirection(AquaUIPainter.ColumnSortArrowDirection d) {
        this.sortArrowDirection = d;
    }

    public void setOwner(JTable t) {
        this.owner = t;
    }

    private void configureInsets() {
        if (this.editorInsetsLTR != null) {
            return;
        }
        AquaUILayoutInfo layout = this.painter.getLayoutInfo();
        this.editorInsetsLTR = layout.getTableColumnHeaderLabelInsets(new TableColumnHeaderLayoutConfiguration(AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT, true)).asInsets();
        this.editorInsetsRTL = layout.getTableColumnHeaderLabelInsets(new TableColumnHeaderLayoutConfiguration(AquaUIPainter.UILayoutDirection.RIGHT_TO_LEFT, true)).asInsets();
        this.arrowInsetsLTR = layout.getTableColumnHeaderSortArrowInsets(new TableColumnHeaderLayoutConfiguration(AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT, true));
        this.arrowInsetsRTL = layout.getTableColumnHeaderSortArrowInsets(new TableColumnHeaderLayoutConfiguration(AquaUIPainter.UILayoutDirection.RIGHT_TO_LEFT, true));
    }
}

