/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.util.List;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import org.violetlib.aqua.AquaTableHeaderBorder;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaTableHeaderCellRenderer
extends DefaultTableCellRenderer
implements UIResource {
    public AquaTableHeaderCellRenderer() {
        this.setHorizontalAlignment(10);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean isPaintingForPrint = false;
        AquaUIPainter.ColumnSortArrowDirection sortDirection = AquaUIPainter.ColumnSortArrowDirection.NONE;
        if (table != null) {
            SortOrder sortOrder;
            JTableHeader header = table.getTableHeader();
            if (header != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
                isPaintingForPrint = header.isPaintingForPrint();
            }
            if (!isPaintingForPrint && table.getRowSorter() != null && (sortOrder = AquaTableHeaderCellRenderer.getColumnSortOrder(table, column)) != null) {
                switch (sortOrder) {
                    case ASCENDING: {
                        sortDirection = AquaUIPainter.ColumnSortArrowDirection.UP;
                        break;
                    }
                    case DESCENDING: {
                        sortDirection = AquaUIPainter.ColumnSortArrowDirection.DOWN;
                    }
                }
            }
        }
        this.setText(value == null ? "" : value.toString());
        AquaTableHeaderBorder cellBorder = AquaTableHeaderBorder.getListHeaderBorder();
        cellBorder.setOwner(table);
        cellBorder.setSortArrowDirection(sortDirection);
        this.setBorder(cellBorder);
        return this;
    }

    public static SortOrder getColumnSortOrder(JTable table, int column) {
        SortOrder rv = null;
        if (table == null || table.getRowSorter() == null) {
            return rv;
        }
        List<RowSorter.SortKey> sortKeys = table.getRowSorter().getSortKeys();
        if (sortKeys.size() > 0 && sortKeys.get(0).getColumn() == table.convertColumnIndexToModel(column)) {
            rv = sortKeys.get(0).getSortOrder();
        }
        return rv;
    }
}

