/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.violetlib.aqua.AquaTableHeaderCellRenderer;

public class AquaTableHeaderUI
extends BasicTableHeaderUI {
    protected int borderHeight;
    protected Color borderColor;
    private TableCellRenderer prevRenderer = null;

    public static ComponentUI createUI(JComponent c) {
        return new AquaTableHeaderUI();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.borderHeight = UIManager.getInt("TableHeader.borderHeight");
        this.borderColor = UIManager.getColor("TableHeader.borderColor");
        this.prevRenderer = this.header.getDefaultRenderer();
        if (this.prevRenderer instanceof UIResource) {
            this.header.setDefaultRenderer(new AquaTableHeaderCellRenderer());
        }
    }

    @Override
    public void uninstallDefaults() {
        if (this.header.getDefaultRenderer() instanceof AquaTableHeaderCellRenderer) {
            this.header.setDefaultRenderer(this.prevRenderer);
        }
        super.uninstallDefaults();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        g.setColor(this.borderColor);
        g.fillRect(0, c.getHeight() - this.borderHeight, c.getWidth(), this.borderHeight);
    }

    private int getHeaderHeightAqua() {
        int height = 0;
        boolean accomodatedDefault = false;
        TableColumnModel columnModel = this.header.getColumnModel();
        for (int column = 0; column < columnModel.getColumnCount(); ++column) {
            TableColumn aColumn = columnModel.getColumn(column);
            if (aColumn.getHeaderRenderer() == null && accomodatedDefault) continue;
            Component comp = this.getHeaderRendererAqua(column);
            int rendererHeight = comp.getPreferredSize().height;
            height = Math.max(height, rendererHeight);
            if (rendererHeight <= 4) continue;
            accomodatedDefault = true;
        }
        return height + this.borderHeight;
    }

    private Component getHeaderRendererAqua(int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        return renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
    }

    private Dimension createHeaderSizeAqua(long width) {
        if (width > Integer.MAX_VALUE) {
            width = Integer.MAX_VALUE;
        }
        return new Dimension((int)width, this.getHeaderHeightAqua());
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMinWidth();
        }
        return this.createHeaderSizeAqua(width);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createHeaderSizeAqua(width);
    }
}

