/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.CellRendererPane;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BasicTableUIPainter;
import org.violetlib.aqua.SelectionRepaintable;

public class AquaTableUI
extends BasicTableUI
implements SelectionRepaintable {
    public static final String TABLE_STYLE_KEY = "JTable.style";
    public static final String QUAQUA_TABLE_STYLE_KEY = "Quaqua.Table.style";
    protected final PropertyChangeListener propertyChangeListener = new TablePropertyChangeListener();
    protected final ListSelectionListener selectionListener = new SelectionListener();
    protected TableCellRenderer originalBooleanRenderer;
    protected AquaTablePainter painter;

    public static ComponentUI createUI(JComponent c) {
        return new AquaTableUI();
    }

    public static boolean isStriped(JTable table) {
        String value = AquaTableUI.getStyleProperty(table);
        return value != null && value.equals("striped");
    }

    protected boolean isStyleProperty(String prop) {
        return AquaUtils.isProperty(prop, TABLE_STYLE_KEY, QUAQUA_TABLE_STYLE_KEY);
    }

    protected static String getStyleProperty(JTable table) {
        return AquaUtils.getProperty(table, TABLE_STYLE_KEY, QUAQUA_TABLE_STYLE_KEY);
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.painter = new AquaTablePainter(this.table, this.rendererPane);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.painter = null;
        super.uninstallUI(c);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.table.putClientProperty("terminateEditOnFocusLost", true);
        this.table.putClientProperty("JComponent.isCellContainer", true);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        LookAndFeel.installProperty(this.table, "rowHeight", 19);
        this.originalBooleanRenderer = this.installRendererIfPossible(Boolean.class, new AquaBooleanRenderer());
    }

    @Override
    protected void uninstallDefaults() {
        TableCellRenderer booleanRenderer = this.table.getDefaultRenderer(Boolean.class);
        if (booleanRenderer instanceof AquaBooleanRenderer) {
            this.table.setDefaultRenderer(Boolean.class, this.originalBooleanRenderer);
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.table.addPropertyChangeListener(this.propertyChangeListener);
        this.updateSelectionListener(null);
    }

    @Override
    protected void uninstallListeners() {
        this.table.getSelectionModel().removeListSelectionListener(this.selectionListener);
        this.table.removePropertyChangeListener(this.propertyChangeListener);
        super.uninstallListeners();
    }

    @Override
    protected KeyListener createKeyListener() {
        KeyListener base = super.createKeyListener();
        return new AquaTableKeyHandler(base);
    }

    protected void updateSelectionListener(ListSelectionModel old) {
        if (old != null) {
            old.removeListSelectionListener(this.selectionListener);
        }
        this.table.getSelectionModel().addListSelectionListener(this.selectionListener);
    }

    @Override
    public void repaintSelection() {
        AquaFocusHandler.swapSelectionColors("Table", this.table, (Object)this.tableHasFocus());
        this.table.repaint();
    }

    protected boolean tableHasFocus() {
        if (this.table.isEditing()) {
            return AquaFocusHandler.isActive(this.table);
        }
        return AquaFocusHandler.hasFocus(this.table);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint(g, c);
        }
    }

    protected TableCellRenderer installRendererIfPossible(Class<?> objectClass, TableCellRenderer renderer) {
        TableCellRenderer currentRenderer = this.table.getDefaultRenderer(objectClass);
        if (currentRenderer instanceof UIResource) {
            this.table.setDefaultRenderer(objectClass, renderer);
        }
        return currentRenderer;
    }

    protected class AquaBooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        public AquaBooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(false);
            this.setOpaque(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForeground(table.getForeground());
            }
            this.setBackground(new Color(0, 0, 0, 0));
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }
    }

    protected class AquaTablePainter
    extends BasicTableUIPainter {
        protected final Color[] stripes;
        protected boolean tableHasFocus;
        protected boolean isStriped;
        protected Color selectedBackground;
        protected Color selectedForeground;

        public AquaTablePainter(JTable table, CellRendererPane rendererPane) {
            super(table, rendererPane);
            this.stripes = new Color[]{UIManager.getColor("Table.evenRowBackground"), UIManager.getColor("Table.oddRowBackground")};
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            this.tableHasFocus = AquaTableUI.this.tableHasFocus();
            this.selectedBackground = this.table.getSelectionBackground();
            this.selectedForeground = this.table.getSelectionForeground();
            this.isStriped = AquaTableUI.isStriped(this.table);
            boolean isSelection = this.table.getSelectedRowCount() > 0 && this.table.getRowSelectionAllowed() || this.table.getSelectedColumnCount() > 0 && this.table.getColumnSelectionAllowed();
            Rectangle clip = g.getClipBounds();
            Rectangle bounds = this.table.getBounds();
            bounds.y = 0;
            bounds.x = 0;
            if (!bounds.intersects(clip)) {
                return;
            }
            boolean ltr = this.table.getComponentOrientation().isLeftToRight();
            Point upperLeft = clip.getLocation();
            Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
            int rMin = this.table.rowAtPoint(upperLeft);
            int rMax = this.table.rowAtPoint(lowerRight);
            boolean extendVerticalGrid = false;
            if (rMin == -1) {
                rMin = 0;
            }
            if (rMax == -1) {
                rMax = this.table.getRowCount() - 1;
                extendVerticalGrid = true;
            }
            int cMin = this.table.columnAtPoint(ltr ? upperLeft : lowerRight);
            int cMax = this.table.columnAtPoint(ltr ? lowerRight : upperLeft);
            boolean extendHorizontalGrid = false;
            if (cMin == -1) {
                cMin = 0;
            }
            if (cMax == -1) {
                cMax = this.table.getColumnCount() - 1;
                extendHorizontalGrid = true;
            }
            if (this.isStriped || isSelection) {
                this.paintBackground(g, rMin, rMax, cMin, cMax);
            }
            this.paintGrid(g, rMin, rMax, cMin, cMax, extendVerticalGrid, extendHorizontalGrid);
            this.paintCells(g, rMin, rMax, cMin, cMax);
        }

        protected void paintBackground(Graphics g, int rMin, int rMax, int cMin, int cMax) {
            int rowHeight;
            int clipTop;
            Color bg;
            Rectangle clip = g.getClipBounds();
            boolean isRowSelection = this.table.getSelectedRowCount() > 0 && this.table.getRowSelectionAllowed() && !this.table.getColumnSelectionAllowed();
            boolean isColumnSelection = this.table.getSelectedColumnCount() > 0 && this.table.getColumnSelectionAllowed() && !this.table.getRowSelectionAllowed();
            int nextRowY = 0;
            for (int row = rMin; row <= rMax; ++row) {
                boolean isSelected;
                Rectangle cellRect = this.table.getCellRect(row, cMin, true);
                boolean bl = isSelected = isRowSelection && this.table.isRowSelected(row);
                Color color = isSelected ? this.selectedBackground : (bg = this.isStriped ? this.stripes[row % 2] : null);
                if (bg == null) {
                    bg = this.table.getBackground();
                }
                g.setColor(bg);
                g.fillRect(clip.x, cellRect.y, clip.width, cellRect.height);
                nextRowY = cellRect.y + cellRect.height;
            }
            if (this.isStriped && nextRowY < (clipTop = clip.y + clip.height) && (rowHeight = this.table.getRowHeight()) > 0) {
                int row = rMax + 1;
                while (nextRowY < clipTop) {
                    bg = this.stripes[row % 2];
                    g.setColor(bg);
                    g.fillRect(clip.x, nextRowY, clip.width, rowHeight);
                    ++row;
                    nextRowY += rowHeight;
                }
            }
        }

        protected void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax, boolean xVertical, boolean xHorizontal) {
            block10: {
                g.setColor(this.table.getGridColor());
                Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
                Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
                Rectangle damagedArea = minCell.union(maxCell);
                if (this.table.getShowHorizontalLines()) {
                    int row;
                    int y;
                    if (xHorizontal) {
                        Rectangle clip = g.getClipBounds();
                        y = damagedArea.y;
                        for (row = rMin; row <= rMax; ++row) {
                            g.fillRect(clip.x, (y += this.table.getRowHeight(row)) - 1, clip.width, 1);
                        }
                    } else {
                        int tableWidth = damagedArea.x + damagedArea.width;
                        y = damagedArea.y;
                        for (row = rMin; row <= rMax; ++row) {
                            g.fillRect(damagedArea.x, (y += this.table.getRowHeight(row)) - 1, tableWidth, 1);
                        }
                    }
                }
                if (!this.table.getShowVerticalLines()) break block10;
                TableColumnModel cm = this.table.getColumnModel();
                int tableHeight = damagedArea.y + damagedArea.height;
                if (xVertical) {
                    Rectangle clip = g.getClipBounds();
                    tableHeight = clip.y + clip.height;
                }
                if (this.table.getComponentOrientation().isLeftToRight()) {
                    int x = damagedArea.x;
                    for (int column = cMin; column <= cMax; ++column) {
                        int w = cm.getColumn(column).getWidth();
                        g.fillRect((x += w) - 1, 0, 1, tableHeight);
                    }
                } else {
                    int x = damagedArea.x;
                    for (int column = cMax; column >= cMin; --column) {
                        int w = cm.getColumn(column).getWidth();
                        g.fillRect((x += w) - 1, 0, 1, tableHeight);
                    }
                }
            }
        }

        @Override
        protected void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
            if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
                Component component = this.table.getEditorComponent();
                component.setBounds(cellRect);
                component.validate();
            } else {
                TableCellRenderer renderer = this.table.getCellRenderer(row, column);
                Component component = this.table.prepareRenderer(renderer, row, column);
                Color bc = this.getOverrideCellBackground(row, column);
                if (bc != null) {
                    component.setBackground(bc);
                }
                this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
                bc = component.getBackground();
                if (bc instanceof UIResource) {
                    component.setBackground(null);
                }
            }
        }

        protected Color getOverrideCellBackground(int row, int column) {
            if (!this.isStriped) {
                return null;
            }
            if (this.table.isCellSelected(row, column)) {
                return null;
            }
            JTable.DropLocation dropLocation = this.table.getDropLocation();
            if (dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == row && dropLocation.getColumn() == column) {
                return null;
            }
            return this.stripes[row % 2];
        }

        @Override
        protected void paintDraggedArea(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance) {
            int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
            Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
            Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
            Rectangle vacatedColumnRect = minCell.union(maxCell);
            g.setColor(this.table.getParent().getBackground());
            g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
            vacatedColumnRect.x += distance;
            this.paintDraggedAreaBackground(g, vacatedColumnRect, rMin, rMax);
            if (this.table.getShowVerticalLines()) {
                g.setColor(this.table.getGridColor());
                int x1 = vacatedColumnRect.x;
                int y1 = vacatedColumnRect.y;
                int x2 = x1 + vacatedColumnRect.width - 1;
                int y2 = y1 + vacatedColumnRect.height - 1;
                g.drawLine(x1 - 1, y1, x1 - 1, y2);
                g.drawLine(x2, y1, x2, y2);
            }
            for (int row = rMin; row <= rMax; ++row) {
                Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
                r.x += distance;
                this.paintCell(g, r, row, draggedColumnIndex);
                if (!this.table.getShowHorizontalLines()) continue;
                g.setColor(this.table.getGridColor());
                Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
                rcr.x += distance;
                int x1 = rcr.x;
                int y1 = rcr.y;
                int x2 = x1 + rcr.width - 1;
                int y2 = y1 + rcr.height - 1;
                g.drawLine(x1, y2, x2, y2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintDraggedAreaBackground(Graphics g, Rectangle columnRect, int rMin, int rMax) {
            if (this.isStriped) {
                Graphics gg = g.create();
                try {
                    gg.clipRect(columnRect.x, columnRect.y, columnRect.width, columnRect.height);
                    this.paintBackground(gg, rMin, rMax, 0, this.table.getColumnCount() - 1);
                }
                finally {
                    gg.dispose();
                }
            } else {
                g.setColor(this.table.getBackground());
                g.fillRect(columnRect.x, columnRect.y, columnRect.width, columnRect.height);
            }
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        protected SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (AquaTableUI.this.table.getRowCount() <= 0 || AquaTableUI.this.table.getColumnCount() <= 0) {
                return;
            }
            int firstIndex = this.limit(e.getFirstIndex(), 0, AquaTableUI.this.table.getRowCount() - 1);
            int lastIndex = this.limit(e.getLastIndex(), 0, AquaTableUI.this.table.getRowCount() - 1);
            Rectangle firstRowRect = AquaTableUI.this.table.getCellRect(firstIndex, 0, true);
            Rectangle lastRowRect = AquaTableUI.this.table.getCellRect(lastIndex, 0, true);
            Rectangle dirtyRegion = new Rectangle(firstRowRect.x, firstRowRect.y, AquaTableUI.this.table.getWidth(), lastRowRect.y + lastRowRect.height);
            AquaTableUI.this.table.repaint(dirtyRegion);
        }

        protected int limit(int i, int a, int b) {
            return Math.min(b, Math.max(i, a));
        }
    }

    protected class AquaTableKeyHandler
    implements KeyListener {
        protected KeyListener base;

        public AquaTableKeyHandler(KeyListener base) {
            this.base = base;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 157) {
                e.consume();
            } else if (this.base != null) {
                this.base.keyPressed(e);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (this.base != null) {
                this.base.keyReleased(e);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (this.base != null) {
                this.base.keyTyped(e);
            }
        }
    }

    public class MouseInputHandler
    extends BasicTableUI.MouseInputHandler {
        public MouseInputHandler() {
            super(AquaTableUI.this);
        }
    }

    protected class TablePropertyChangeListener
    implements PropertyChangeListener {
        protected TablePropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            String pn = ev.getPropertyName();
            if (pn != null) {
                if (pn.equals("Frame.active") || pn.equals("enabled")) {
                    AquaTableUI.this.repaintSelection();
                    return;
                }
                if (pn.equals("selectionModel")) {
                    ListSelectionModel old = (ListSelectionModel)ev.getOldValue();
                    AquaTableUI.this.updateSelectionListener(old);
                }
                if (AquaTableUI.this.isStyleProperty(pn)) {
                    AquaTableUI.this.table.repaint();
                }
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            AquaTableUI.this.repaintSelection();
        }

        @Override
        public void focusLost(FocusEvent e) {
            AquaTableUI.this.repaintSelection();
        }
    }
}

