/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.text.JTextComponent;
import org.violetlib.aqua.AquaBorder;
import org.violetlib.aqua.AquaCellEditorPolicy;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.Border2D;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.jnr.Insets2D;
import org.violetlib.jnr.Insets2DUIResource;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.TextFieldConfiguration;
import org.violetlib.jnr.aqua.TextFieldLayoutConfiguration;

public class AquaTextFieldBorder
extends AquaBorder
implements FocusRingOutlineProvider,
Border2D {
    protected static final AquaUtils.RecyclableSingleton<AquaTextFieldBorder> instance = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaTextFieldBorder>(AquaTextFieldBorder.class);

    public static AquaTextFieldBorder getTextFieldBorder() {
        return instance.get();
    }

    public AquaTextFieldBorder() {
    }

    public AquaTextFieldBorder(AquaTextFieldBorder other) {
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
    }

    public void paintBackground(JComponent c, Graphics g) {
        if (c instanceof JTextComponent) {
            JTextComponent tc = (JTextComponent)c;
            int width = tc.getWidth();
            int height = tc.getHeight();
            g.setColor(tc.getBackground());
            if (tc.isOpaque()) {
                g.fillRect(0, 0, width, height);
                return;
            }
            Painter p = this.getConfiguredPainter(tc);
            p.paint(g, 0.0f, 0.0f);
        }
    }

    public LayoutInfo getLayoutInfo(JTextComponent tc) {
        TextFieldLayoutConfiguration g = this.getLayoutConfiguration(tc);
        return this.painter.getLayoutInfo().getLayoutInfo(g);
    }

    @Override
    public Shape getFocusRingOutline(JComponent c) {
        if (c instanceof JTextComponent) {
            JTextComponent tc = (JTextComponent)c;
            TextFieldLayoutConfiguration g = this.getLayoutConfiguration(tc);
            this.painter.configure(tc.getWidth(), tc.getHeight());
            return this.painter.getOutline(g);
        }
        return null;
    }

    public int getTextMargin(JTextComponent tc) {
        if (AquaCellEditorPolicy.getInstance().isCellEditor(tc)) {
            return 1;
        }
        AquaUIPainter.TextFieldWidget widget = this.getWidget(tc);
        int target = widget == AquaUIPainter.TextFieldWidget.TEXT_FIELD_ROUND ? 11 : 3;
        Insets s = this.getBorderInsets(tc);
        int averageInset = (s.left + s.right) / 2;
        return Math.max(0, target - averageInset);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (c instanceof JTextComponent) {
            Insets2D n;
            JTextComponent tc = (JTextComponent)c;
            if (AquaCellEditorPolicy.getInstance().isCellEditor(tc)) {
                return new InsetsUIResource(0, 0, 0, 0);
            }
            Insetter s = this.getTextInsets(tc);
            if (s != null && (n = s.asInsets2D()) != null) {
                int left = (int)Math.ceil(n.getLeft());
                int right = (int)Math.ceil(n.getRight());
                int top = (int)Math.floor(n.getTop());
                int bottom = (int)Math.ceil(n.getBottom());
                return new InsetsUIResource(top, left, bottom, right);
            }
        }
        return new InsetsUIResource(3, 3, 3, 3);
    }

    @Override
    public Insets2D getBorderInsets2D(Component c) {
        if (c instanceof JTextComponent) {
            Insets2D n;
            JTextComponent tc = (JTextComponent)c;
            if (AquaCellEditorPolicy.getInstance().isCellEditor(tc)) {
                return new Insets2D(0.0f, 0.0f, 0.0f, 0.0f);
            }
            Insetter s = this.getTextInsets(tc);
            if (s != null && (n = s.asInsets2D()) != null) {
                return new Insets2DUIResource(n);
            }
        }
        return new Insets2DUIResource(3.0f, 3.0f, 3.0f, 3.0f);
    }

    public Insetter getTextInsets(JTextComponent tc) {
        TextFieldLayoutConfiguration g = this.getLayoutConfiguration(tc);
        return this.painter.getLayoutInfo().getTextFieldTextInsets(g);
    }

    public int getExtraHeight(JTextComponent tc) {
        TextFieldLayoutConfiguration g = this.getLayoutConfiguration(tc);
        AquaUIPainter.TextFieldWidget widget = g.getWidget();
        switch (widget) {
            case TEXT_FIELD: 
            case TEXT_FIELD_ROUND: {
                return 3;
            }
        }
        return 0;
    }

    protected Painter getConfiguredPainter(JTextComponent tc) {
        int width = tc.getWidth();
        int height = tc.getHeight();
        this.painter.configure(width, height);
        TextFieldConfiguration tg = this.getConfiguration(tc);
        return this.painter.getPainter(tg);
    }

    protected TextFieldLayoutConfiguration getLayoutConfiguration(JTextComponent tc) {
        AquaUIPainter.TextFieldWidget widget = this.getWidget(tc);
        AquaUIPainter.Size size = AquaUtilControlSize.getUserSizeFrom(tc);
        AquaUIPainter.UILayoutDirection ld = AquaUtils.getLayoutDirection(tc);
        return new TextFieldLayoutConfiguration(widget, size, ld);
    }

    protected TextFieldConfiguration getConfiguration(JTextComponent tc) {
        AquaUIPainter.TextFieldWidget widget = this.getWidget(tc);
        AquaUIPainter.Size size = AquaUtilControlSize.getUserSizeFrom(tc);
        AquaUIPainter.State state = this.getStateFor(tc);
        boolean isFocused = AquaUIPainter.State.ACTIVE == state && tc.hasFocus();
        AquaUIPainter.UILayoutDirection ld = AquaUtils.getLayoutDirection(tc);
        return new TextFieldConfiguration(widget, size, state, isFocused, ld);
    }

    protected AquaUIPainter.TextFieldWidget getWidget(JTextComponent tc) {
        Object o = tc.getClientProperty("JTextField.style");
        if ("round".equals(o)) {
            return AquaTextFieldBorder.isOnToolbar(tc) ? AquaUIPainter.TextFieldWidget.TEXT_FIELD_ROUND_TOOLBAR : AquaUIPainter.TextFieldWidget.TEXT_FIELD_ROUND;
        }
        if (AquaTextFieldBorder.isOnToolbar(tc)) {
            return AquaUIPainter.TextFieldWidget.TEXT_FIELD_ROUND_TOOLBAR;
        }
        return AquaUIPainter.TextFieldWidget.TEXT_FIELD;
    }

    public static boolean isOnToolbar(JTextComponent tc) {
        for (Container parent = tc.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JToolBar)) continue;
            return true;
        }
        return false;
    }

    protected AquaUIPainter.State getStateFor(JTextComponent tc) {
        if (!AquaFocusHandler.isActive(tc)) {
            return AquaUIPainter.State.INACTIVE;
        }
        if (!tc.isEnabled()) {
            return AquaUIPainter.State.DISABLED;
        }
        if (!tc.isEditable()) {
            return AquaUIPainter.State.DISABLED;
        }
        return AquaUIPainter.State.ACTIVE;
    }
}

