/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaTextFieldBorder;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.TextFieldLayoutConfiguration;

public class AquaTextFieldSearch {
    private static final String FIND_POPUP_KEY = "JTextField.Search.FindPopup";
    private static final String FIND_ACTION_KEY = "JTextField.Search.FindAction";
    private static final String CANCEL_ACTION_KEY = "JTextField.Search.CancelAction";
    private static final String PROMPT_KEY = "JTextField.Search.Prompt";
    protected static final AquaUtils.RecyclableSingleton<SearchFieldBorder> instance = new AquaUtils.RecyclableSingletonFromDefaultConstructor<SearchFieldBorder>(SearchFieldBorder.class);

    protected static boolean hasPopupMenu(JTextComponent c) {
        return c.getClientProperty(FIND_POPUP_KEY) instanceof JPopupMenu;
    }

    public static SearchFieldBorder getSearchTextFieldBorder() {
        return instance.get();
    }

    protected static void installSearchField(JTextComponent c) {
        AquaTextFieldSearch.uninstallSearchField(c);
        SearchFieldBorder border = AquaTextFieldSearch.getSearchTextFieldBorder();
        c.setBorder(border);
        c.setLayout(border.getCustomLayout());
        c.add((Component)AquaTextFieldSearch.getFindButton(c), "West");
        c.add((Component)AquaTextFieldSearch.getCancelButton(c), "East");
        c.add(AquaTextFieldSearch.getPromptLabel(c), "Center");
    }

    protected static void uninstallSearchField(JTextComponent c) {
        if (c.getBorder() instanceof SearchFieldBorder) {
            c.setBorder(UIManager.getBorder("TextField.border"));
            c.removeAll();
        }
    }

    protected static AquaUIPainter.State getState(JButton b) {
        if (!AquaFocusHandler.isActive(b)) {
            return AquaUIPainter.State.INACTIVE;
        }
        if (b.getModel().isPressed()) {
            return AquaUIPainter.State.PRESSED;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    protected static JButton createButton(final JTextComponent c, Object icon) {
        JButton b = new JButton();
        b.setBorderPainted(false);
        b.setFocusable(false);
        b.setCursor(new Cursor(0));
        b.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                c.requestFocusInWindow();
            }
        });
        return b;
    }

    protected static JButton getFindButton(final JTextComponent c) {
        final JButton b = AquaTextFieldSearch.createButton(c, null);
        b.setName("find");
        final Object findPopup = c.getClientProperty(FIND_POPUP_KEY);
        if (findPopup instanceof JPopupMenu) {
            b.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ((JPopupMenu)findPopup).show(b, 8, b.getHeight() - 2);
                    c.requestFocusInWindow();
                    c.repaint();
                }
            });
        }
        b.addActionListener(new FindAction(c));
        return b;
    }

    private static Component getPromptLabel(final JTextComponent c) {
        final JLabel label = new JLabel();
        label.setForeground(UIManager.getColor("TextField.inactiveForeground"));
        label.setFont(null);
        c.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AquaTextFieldSearch.updatePromptLabel(label, c);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AquaTextFieldSearch.updatePromptLabel(label, c);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AquaTextFieldSearch.updatePromptLabel(label, c);
            }
        });
        c.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AquaTextFieldSearch.updatePromptLabel(label, c);
            }

            @Override
            public void focusLost(FocusEvent e) {
                AquaTextFieldSearch.updatePromptLabel(label, c);
            }
        });
        AquaTextFieldSearch.updatePromptLabel(label, c);
        return label;
    }

    static void updatePromptLabel(final JLabel label, final JTextComponent text) {
        if (SwingUtilities.isEventDispatchThread()) {
            AquaTextFieldSearch.updatePromptLabelOnEDT(label, text);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AquaTextFieldSearch.updatePromptLabelOnEDT(label, text);
                }
            });
        }
    }

    static void updatePromptLabelOnEDT(JLabel label, JTextComponent text) {
        Object prompt;
        String promptText = " ";
        if ("".equals(text.getText()) && (prompt = text.getClientProperty(PROMPT_KEY)) != null) {
            promptText = prompt.toString();
        }
        label.setText(promptText);
    }

    protected static JButton getCancelButton(final JTextComponent c) {
        final JButton b = AquaTextFieldSearch.createButton(c, null);
        b.setName("cancel");
        b.addActionListener(new CancelAction(c));
        c.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AquaTextFieldSearch.updateCancelIcon(b, c);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AquaTextFieldSearch.updateCancelIcon(b, c);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AquaTextFieldSearch.updateCancelIcon(b, c);
            }
        });
        AquaTextFieldSearch.updateCancelIcon(b, c);
        return b;
    }

    static void updateCancelIcon(final JButton button, final JTextComponent text) {
        if (SwingUtilities.isEventDispatchThread()) {
            AquaTextFieldSearch.updateCancelIconOnEDT(button, text);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AquaTextFieldSearch.updateCancelIconOnEDT(button, text);
                }
            });
        }
    }

    static void updateCancelIconOnEDT(JButton button, JTextComponent text) {
        button.setVisible(!"".equals(text.getText()));
    }

    static class SearchFieldBorder
    extends AquaTextFieldBorder
    implements AquaUtils.JComponentPainter {
        protected boolean reallyPaintBorder;
        protected boolean doingLayout;

        public SearchFieldBorder() {
        }

        public SearchFieldBorder(SearchFieldBorder other) {
            super(other);
        }

        @Override
        public void paint(JComponent c, Graphics g, int x, int y, int w, int h) {
            this.reallyPaintBorder = true;
            this.paintBorder(c, g, x, y, w, h);
            this.reallyPaintBorder = false;
        }

        @Override
        protected AquaUIPainter.TextFieldWidget getWidget(JTextComponent tc) {
            boolean hasCancelButton;
            boolean hasFocus = AquaFocusHandler.hasFocus(tc);
            String text = tc.getText();
            boolean hasMenu = AquaTextFieldSearch.hasPopupMenu(tc) && hasFocus;
            boolean bl = hasCancelButton = !text.isEmpty();
            if (!hasCancelButton && OSXSystemProperties.OSVersion < 1011) {
                hasCancelButton = hasFocus;
            }
            boolean isToolbar = SearchFieldBorder.isOnToolbar(tc);
            return !hasCancelButton ? (hasMenu ? (isToolbar ? AquaUIPainter.TextFieldWidget.TEXT_FIELD_SEARCH_WITH_MENU_TOOLBAR : AquaUIPainter.TextFieldWidget.TEXT_FIELD_SEARCH_WITH_MENU) : (isToolbar ? AquaUIPainter.TextFieldWidget.TEXT_FIELD_SEARCH_TOOLBAR : AquaUIPainter.TextFieldWidget.TEXT_FIELD_SEARCH)) : (hasMenu ? (isToolbar ? AquaUIPainter.TextFieldWidget.TEXT_FIELD_SEARCH_WITH_MENU_AND_CANCEL_TOOLBAR : AquaUIPainter.TextFieldWidget.TEXT_FIELD_SEARCH_WITH_MENU_AND_CANCEL) : (isToolbar ? AquaUIPainter.TextFieldWidget.TEXT_FIELD_SEARCH_WITH_CANCEL_TOOLBAR : AquaUIPainter.TextFieldWidget.TEXT_FIELD_SEARCH_WITH_CANCEL));
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (this.doingLayout) {
                return new Insets(0, 0, 0, 0);
            }
            return super.getBorderInsets(c);
        }

        @Override
        public int getTextMargin(JTextComponent tc) {
            return 0;
        }

        protected LayoutManager getCustomLayout() {
            return new SearchFieldLayoutManager();
        }

        class SearchFieldLayoutManager
        implements LayoutManager {
            private JTextComponent tc;
            private Component findButton;
            private Component cancelButton;
            private Component promptLabel;

            SearchFieldLayoutManager() {
            }

            @Override
            public void addLayoutComponent(String name, Component comp) {
                String n = comp.getName();
                if ("find".equals(n)) {
                    this.findButton = comp;
                    this.tc = (JTextComponent)comp.getParent();
                } else if ("cancel".equals(n)) {
                    this.cancelButton = comp;
                    this.tc = (JTextComponent)comp.getParent();
                } else if (comp instanceof JLabel) {
                    this.tc = (JTextComponent)comp.getParent();
                    this.promptLabel = comp;
                }
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return null;
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return null;
            }

            @Override
            public void layoutContainer(Container parent) {
                if (this.tc != null) {
                    Rectangle buttonBounds;
                    Insetter s;
                    Rectangle bounds = new Rectangle(0, 0, this.tc.getWidth(), this.tc.getHeight());
                    AquaUIPainter.TextFieldWidget widget = SearchFieldBorder.this.getWidget(this.tc);
                    AquaUIPainter.Size sz = AquaUtilControlSize.getUserSizeFrom(this.tc);
                    AquaUIPainter.UILayoutDirection ld = AquaUtils.getLayoutDirection(this.tc);
                    TextFieldLayoutConfiguration g = new TextFieldLayoutConfiguration(widget, sz, ld);
                    if (this.findButton != null) {
                        s = SearchFieldBorder.this.painter.getLayoutInfo().getSearchButtonInsets(g);
                        if (s != null) {
                            buttonBounds = s.applyToBounds(bounds);
                            this.findButton.setBounds(buttonBounds);
                        } else {
                            this.findButton.setBounds(0, 0, 0, 0);
                        }
                    }
                    if (this.cancelButton != null) {
                        s = SearchFieldBorder.this.painter.getLayoutInfo().getCancelButtonInsets(g);
                        if (s != null) {
                            buttonBounds = s.applyToBounds(bounds);
                            this.cancelButton.setBounds(buttonBounds);
                        } else {
                            this.cancelButton.setBounds(0, 0, 0, 0);
                        }
                    }
                    if (this.promptLabel != null) {
                        s = SearchFieldBorder.this.painter.getLayoutInfo().getTextFieldTextInsets(g);
                        Rectangle textBounds = s.applyToBounds(bounds);
                        this.promptLabel.setBounds(textBounds);
                    }
                }
            }
        }
    }

    private static class CancelAction
    implements ActionListener {
        private final JTextComponent tc;

        public CancelAction(JTextComponent tc) {
            this.tc = tc;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object cancelAction = this.tc.getClientProperty(AquaTextFieldSearch.CANCEL_ACTION_KEY);
            if (cancelAction instanceof ActionListener) {
                ActionListener al = (ActionListener)cancelAction;
                al.actionPerformed(e);
            }
            this.tc.setText("");
        }
    }

    private static class FindAction
    implements ActionListener {
        private final JTextComponent tc;

        public FindAction(JTextComponent tc) {
            this.tc = tc;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField tf;
            Action a;
            Object findAction = this.tc.getClientProperty(AquaTextFieldSearch.FIND_ACTION_KEY);
            if (findAction instanceof ActionListener) {
                ActionListener al = (ActionListener)findAction;
                al.actionPerformed(e);
            } else if (this.tc instanceof JTextField && (a = (tf = (JTextField)this.tc).getAction()) != null) {
                a.actionPerformed(e);
            }
        }
    }
}

