/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.violetlib.aqua.AquaCaret;
import org.violetlib.aqua.AquaCellEditorPolicy;
import org.violetlib.aqua.AquaFieldView;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaHighlighter;
import org.violetlib.aqua.AquaKeyBindings;
import org.violetlib.aqua.AquaMarginView;
import org.violetlib.aqua.AquaTextFieldBorder;
import org.violetlib.aqua.AquaTextFieldSearch;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.Border2D;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.jnr.Insets2D;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;

public class AquaTextFieldUI
extends BasicTextFieldUI
implements FocusRingOutlineProvider {
    public static final String TEXT_FIELD_STYLE_KEY = "JTextField.style";
    public static final String TEXT_FIELD_VARIANT_KEY = "JTextField.variant";
    public static final String QUAQUA_TEXT_FIELD_STYLE_KEY = "Quaqua.TextField.style";
    protected AquaUtils.JComponentPainter delegate;
    protected AquaFocusHandler handler;
    protected PropertyChangeListener propertyChangeListener;
    protected HierarchyListener hierarchyListener;
    protected JTextComponent editor;
    protected View topView;
    boolean oldDragState = false;

    public static ComponentUI createUI(JComponent c) {
        return new AquaTextFieldUI();
    }

    @Override
    public void installUI(JComponent c) {
        if (c instanceof JTextComponent) {
            this.editor = (JTextComponent)c;
            super.installUI(c);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.editor = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.handler = new AquaTextFieldFocusHandler();
        this.editor.addFocusListener(this.handler);
        this.editor.addPropertyChangeListener(this.handler);
        this.propertyChangeListener = new AquaPropertyChangeHandler();
        this.editor.addPropertyChangeListener(this.propertyChangeListener);
        this.hierarchyListener = new AquaHierarchyListener();
        this.editor.addHierarchyListener(this.hierarchyListener);
        LookAndFeel.installProperty(this.editor, "opaque", UIManager.getBoolean(this.getPropertyPrefix() + "opaque"));
        AquaUtilControlSize.addSizePropertyListener(this.editor);
    }

    @Override
    protected void uninstallListeners() {
        AquaUtilControlSize.removeSizePropertyListener(this.editor);
        this.editor.removeFocusListener(this.handler);
        this.editor.removePropertyChangeListener(this.handler);
        this.editor.removePropertyChangeListener(this.propertyChangeListener);
        this.editor.removeHierarchyListener(this.hierarchyListener);
        this.handler = null;
        super.uninstallListeners();
    }

    public void updateStyle() {
        if (this.wantsToBeASearchField()) {
            AquaTextFieldSearch.installSearchField(this.editor);
        } else {
            AquaTextFieldSearch.uninstallSearchField(this.editor);
        }
        if (this.topView instanceof AquaMarginView) {
            AquaMarginView v = (AquaMarginView)this.topView;
            int textMargin = this.getTextMargin();
            v.setMargin(textMargin);
        }
        this.editor.revalidate();
        this.editor.repaint();
    }

    protected boolean wantsToBeASearchField() {
        String style = this.getStyleProperty();
        return "search".equals(style);
    }

    protected boolean isStyleProperty(String prop) {
        return AquaUtils.isProperty(prop, TEXT_FIELD_STYLE_KEY, TEXT_FIELD_VARIANT_KEY, QUAQUA_TEXT_FIELD_STYLE_KEY);
    }

    protected String getStyleProperty() {
        return AquaUtils.getProperty(this.editor, TEXT_FIELD_STYLE_KEY, TEXT_FIELD_VARIANT_KEY, QUAQUA_TEXT_FIELD_STYLE_KEY);
    }

    @Override
    protected void installDefaults() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.oldDragState = this.editor.getDragEnabled();
            this.editor.setDragEnabled(true);
        }
        super.installDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (!GraphicsEnvironment.isHeadless()) {
            this.getComponent().setDragEnabled(this.oldDragState);
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        AquaKeyBindings.instance().setDefaultAction(this.getKeymapName());
    }

    @Override
    public final View create(Element elem) {
        this.topView = this.createView(elem);
        return this.topView;
    }

    private View createView(Element elem) {
        View base = this.createBasicView(elem);
        int textMargin = this.getTextMargin();
        if (textMargin > 0 && base instanceof FieldView) {
            return new AquaMarginView(base, textMargin);
        }
        return base;
    }

    protected View createBasicView(Element elem) {
        View view = super.create(elem);
        Class<?> c = view.getClass();
        if (c == FieldView.class) {
            return new AquaFieldView(elem);
        }
        return view;
    }

    public int getTextMargin() {
        Border b = this.editor.getBorder();
        if (b instanceof AquaTextFieldBorder) {
            AquaTextFieldBorder bb = (AquaTextFieldBorder)b;
            return bb.getTextMargin(this.editor);
        }
        return 0;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getLayoutSize(LayoutOption.MAXIMUM);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getLayoutSize(LayoutOption.PREFERRED);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getLayoutSize(LayoutOption.MINIMUM);
    }

    protected Dimension getLayoutSize(LayoutOption opt) {
        Dimension size = this.getLayoutSizeFromText(opt);
        Border b = this.editor.getBorder();
        if (b instanceof AquaTextFieldBorder) {
            AquaTextFieldBorder tb = (AquaTextFieldBorder)b;
            LayoutInfo info = tb.getLayoutInfo(this.editor);
            int width = (int)Math.max((float)size.width, info.getMinimumVisualWidth());
            int height = (int)Math.max((float)size.height, info.getMinimumVisualHeight());
            return new Dimension(width, height);
        }
        return size;
    }

    protected Dimension getLayoutSizeFromText(LayoutOption opt) {
        AquaTextFieldBorder tb;
        Insetter insets;
        Dimension td = this.getTextSize(opt);
        int textWidth = td.width;
        int textHeight = td.height;
        Border b = this.editor.getBorder();
        if (b instanceof AquaTextFieldBorder && (insets = (tb = (AquaTextFieldBorder)b).getTextInsets(this.editor)) != null) {
            int extraHeight = opt != LayoutOption.MINIMUM ? tb.getExtraHeight(this.editor) : 0;
            Dimension size = insets.expand(new Dimension(textWidth, textHeight + extraHeight));
            return size;
        }
        Insets insets2 = this.editor.getInsets();
        return new Dimension(textWidth + insets2.left + insets2.right, textHeight + insets2.top + insets2.bottom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension getTextSize(LayoutOption opt) {
        Dimension d = new Dimension();
        if (this.topView != null) {
            Document doc = this.editor.getDocument();
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readLock();
            }
            if (opt == LayoutOption.PREFERRED) {
                Dimension size = this.editor.getSize();
                if (size.width == 0 && size.height == 0) {
                    this.topView.setSize(2.1474836E9f, 2.1474836E9f);
                } else {
                    Insets s = this.editor.getInsets();
                    if (size.width > s.left + s.right && size.height > s.top + s.bottom) {
                        this.topView.setSize(size.width - s.left - s.right, size.height - s.top - s.bottom);
                    }
                }
            }
            try {
                float width = 0.0f;
                float height = 0.0f;
                switch (opt) {
                    case MINIMUM: {
                        width = this.topView.getMinimumSpan(0);
                        height = this.topView.getMinimumSpan(1);
                        break;
                    }
                    case PREFERRED: {
                        width = this.topView.getPreferredSpan(0);
                        height = this.topView.getPreferredSpan(1);
                        break;
                    }
                    case MAXIMUM: {
                        width = this.topView.getMaximumSpan(0);
                        height = this.topView.getMaximumSpan(1);
                    }
                }
                d.width = (int)Math.min(100000.0f, width + 1.0f);
                d.height = (int)Math.min(100000.0f, height);
            }
            finally {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).readUnlock();
                }
            }
        }
        return d;
    }

    @Override
    public Shape getFocusRingOutline(JComponent c) {
        Border b = c.getBorder();
        if (b instanceof FocusRingOutlineProvider) {
            FocusRingOutlineProvider p = (FocusRingOutlineProvider)((Object)b);
            return p.getFocusRingOutline(c);
        }
        return new Rectangle(0, 0, c.getWidth(), c.getHeight());
    }

    @Override
    protected void paintSafely(Graphics g) {
        float floor;
        float top;
        Border2D ab;
        Insets2D n;
        Border b;
        this.paintBackgroundSafely(g);
        if (g instanceof Graphics2D && (b = this.editor.getBorder()) instanceof Border2D && (n = (ab = (Border2D)((Object)b)).getBorderInsets2D(this.editor)) != null && (top = n.getTop()) - (floor = (float)Math.floor(top)) > 0.001f) {
            Graphics2D gg = (Graphics2D)g.create();
            gg.translate(0.0, top - floor);
            super.paintSafely(gg);
            gg.dispose();
            return;
        }
        super.paintSafely(g);
    }

    protected void paintBackgroundSafely(Graphics g) {
        int width = this.editor.getWidth();
        int height = this.editor.getHeight();
        if (this.delegate != null) {
            this.delegate.paint(this.editor, g, 0, 0, width, height);
            return;
        }
        boolean isOpaque = this.editor.isOpaque();
        Border b = this.editor.getBorder();
        if (!(b instanceof AquaTextFieldBorder)) {
            if (!isOpaque && AquaUtils.hasOpaqueBeenExplicitlySet(this.editor)) {
                return;
            }
            g.setColor(this.editor.getBackground());
            g.fillRect(0, 0, width, height);
            return;
        }
        AquaTextFieldBorder tb = (AquaTextFieldBorder)b;
        tb.paintBackground(this.editor, g);
    }

    @Override
    protected void paintBackground(Graphics g) {
    }

    @Override
    protected Caret createCaret() {
        Window owningWindow = SwingUtilities.getWindowAncestor(this.editor);
        return new AquaCaret(owningWindow, this.editor);
    }

    @Override
    protected Highlighter createHighlighter() {
        return new AquaHighlighter();
    }

    protected void setPaintingDelegate(AquaUtils.JComponentPainter delegate) {
        this.delegate = delegate;
    }

    protected static enum LayoutOption {
        MINIMUM,
        PREFERRED,
        MAXIMUM;

    }

    protected class AquaHierarchyListener
    implements HierarchyListener {
        protected AquaHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 1L) != 0L) {
                AquaTextFieldUI.this.updateStyle();
            }
        }
    }

    protected class AquaPropertyChangeHandler
    implements PropertyChangeListener {
        protected AquaPropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (AquaTextFieldUI.this.isStyleProperty(prop) || AquaCellEditorPolicy.isCellEditorProperty(prop)) {
                AquaTextFieldUI.this.updateStyle();
            } else if ("Frame.active".equals(prop)) {
                AquaTextFieldUI.this.editor.repaint();
            }
        }
    }

    protected class AquaTextFieldFocusHandler
    extends AquaFocusHandler {
        protected AquaTextFieldFocusHandler() {
        }

        @Override
        public void focusLost(FocusEvent ev) {
            Caret c;
            super.focusLost(ev);
            if (!ev.isTemporary() && (c = AquaTextFieldUI.this.editor.getCaret()) != null) {
                c.setDot(0);
            }
        }
    }
}

