/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PasswordView;
import javax.swing.text.View;
import org.violetlib.aqua.AquaTextFieldUI;
import org.violetlib.aqua.AquaUtils;

public class AquaTextPasswordFieldUI
extends AquaTextFieldUI {
    static final AquaUtils.RecyclableSingleton<CapsLockSymbolPainter> capsLockPainter = new AquaUtils.RecyclableSingletonFromDefaultConstructor<CapsLockSymbolPainter>(CapsLockSymbolPainter.class);

    static CapsLockSymbolPainter getCapsLockPainter() {
        return capsLockPainter.get();
    }

    public static ComponentUI createUI(JComponent c) {
        return new AquaTextPasswordFieldUI();
    }

    @Override
    protected String getPropertyPrefix() {
        return "PasswordField";
    }

    @Override
    protected View createBasicView(Element elem) {
        return new AquaPasswordView(elem);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.getComponent().addKeyListener(AquaTextPasswordFieldUI.getCapsLockPainter());
    }

    @Override
    protected void uninstallListeners() {
        this.getComponent().removeKeyListener(AquaTextPasswordFieldUI.getCapsLockPainter());
        super.uninstallListeners();
    }

    @Override
    protected void paintBackgroundSafely(Graphics g) {
        super.paintBackgroundSafely(g);
        JTextComponent component = this.getComponent();
        if (component == null) {
            return;
        }
        if (!component.isFocusOwner()) {
            return;
        }
        boolean capsLockDown = Toolkit.getDefaultToolkit().getLockingKeyState(20);
        if (!capsLockDown) {
            return;
        }
        Rectangle bounds = component.getBounds();
        AquaTextPasswordFieldUI.getCapsLockPainter().paintBorder(component, g, bounds.x, bounds.y, bounds.width, bounds.height);
    }

    static class CapsLockSymbolPainter
    extends KeyAdapter
    implements Border,
    UIResource {
        protected Shape capsLockShape;

        CapsLockSymbolPainter() {
        }

        protected Shape getCapsLockShape() {
            if (this.capsLockShape != null) {
                return this.capsLockShape;
            }
            RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.5, 0.5, 16.0, 16.0, 8.0, 8.0);
            GeneralPath shape = new GeneralPath(rect);
            shape.setWindingRule(0);
            shape.moveTo(8.5, 2.0);
            shape.lineTo(4.0, 7.0);
            shape.lineTo(6.25, 7.0);
            shape.lineTo(6.25, 10.25);
            shape.lineTo(10.75, 10.25);
            shape.lineTo(10.75, 7.0);
            shape.lineTo(13.0, 7.0);
            shape.lineTo(8.5, 2.0);
            shape.moveTo(10.75, 12.0);
            shape.lineTo(6.25, 12.0);
            shape.lineTo(6.25, 14.25);
            shape.lineTo(10.75, 14.25);
            shape.lineTo(10.75, 12.0);
            this.capsLockShape = shape;
            return this.capsLockShape;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g = g.create(width - 23, height / 2 - 8, 18, 18);
            g.setColor(UIManager.getColor("PasswordField.capsLockIconColor"));
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g).fill(this.getCapsLockShape());
            g.dispose();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.update(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.update(e);
        }

        void update(KeyEvent e) {
            if (20 != e.getKeyCode()) {
                return;
            }
            e.getComponent().repaint();
        }
    }

    protected class AquaPasswordView
    extends PasswordView {
        public AquaPasswordView(Element elem) {
            super(elem);
            this.setupDefaultEchoCharacter();
        }

        protected void setupDefaultEchoCharacter() {
            Character echoChar = (Character)UIManager.getDefaults().get(AquaTextPasswordFieldUI.this.getPropertyPrefix() + ".echoChar");
            if (echoChar != null) {
                LookAndFeel.installProperty(AquaTextPasswordFieldUI.this.getComponent(), "echoChar", echoChar);
            }
        }
    }
}

